/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.search.RepositorySearchAction;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultViewTopComponent;
import org.netbeans.modules.search.SearchEngine;
import org.netbeans.modules.search.SearchPanel;
import org.netbeans.modules.search.SearchTask;
import org.openide.actions.FindAction;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

public class SearchPerformer
implements ActionPerformer {
    private static WeakReference resultViewWRef = new WeakReference<Object>(null);
    private static SearchPerformer searchPerformer;
    private Lookup.Result result;
    static /* synthetic */ Class class$org$openidex$search$SearchType;

    private SearchPerformer() {
    }

    static synchronized SearchPerformer getDefault() {
        if (searchPerformer == null) {
            searchPerformer = new SearchPerformer();
        }
        return searchPerformer;
    }

    private Lookup.Result getSearchTypes() {
        if (this.result == null) {
            this.result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openidex$search$SearchType == null ? (class$org$openidex$search$SearchType = SearchPerformer.class$("org.openidex.search.SearchType")) : class$org$openidex$search$SearchType));
        }
        return this.result;
    }

    private List getTypes(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return Collections.EMPTY_LIST;
        }
        Iterator it = this.getSearchTypes().allInstances().iterator();
        if (!it.hasNext()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<SearchType> result = new ArrayList<SearchType>(5);
        do {
            SearchType searchType;
            if (!(searchType = (SearchType)it.next()).enabled(nodes) || result.contains(searchType)) continue;
            result.add(searchType);
        } while (it.hasNext());
        return result;
    }

    public boolean enabled(Node[] nodes) {
        Iterator it = this.getSearchTypes().allInstances().iterator();
        while (it.hasNext()) {
            SearchType searchType = (SearchType)it.next();
            if (!searchType.enabled(nodes)) continue;
            return true;
        }
        return false;
    }

    private void performAction(Node[] nodes) {
        List searchTypeList = this.getTypes(nodes);
        if (searchTypeList.isEmpty()) {
            return;
        }
        ArrayList<Object> clonedSearchTypeList = new ArrayList<Object>(searchTypeList.size());
        Iterator it = searchTypeList.iterator();
        while (it.hasNext()) {
            clonedSearchTypeList.add(((SearchType)it.next()).clone());
        }
        SearchPanel searchPanel = new SearchPanel(clonedSearchTypeList);
        searchPanel.showDialog();
        if (searchPanel.getReturnStatus() == 1) {
            SearchType[] customizedSearchTypes = searchPanel.getCustomizedSearchTypes();
            ResultModel resultModel = this.performSearch(nodes, customizedSearchTypes, clonedSearchTypeList);
            ResultViewTopComponent resultWindow = (ResultViewTopComponent)resultViewWRef.get();
            if (resultWindow == null) {
                resultWindow = new ResultViewTopComponent(resultModel);
                resultViewWRef = new WeakReference<ResultViewTopComponent>(resultWindow);
            } else {
                resultWindow.setModel(resultModel);
            }
            Workspace w = WindowManager.getDefault().getCurrentWorkspace();
            Mode m = w.findMode((TopComponent)resultWindow);
            if (m == null) {
                m = w.createMode("Search Results", ((Component)((Object)resultWindow)).getName(), null);
            }
            m.dockInto((TopComponent)resultWindow);
            resultWindow.open();
            resultWindow.requestFocus();
        }
    }

    private ResultModel performSearch(Node[] nodes, SearchType[] customizedSearchTypes, List searchTypeList) {
        SearchEngine searchEngine = new SearchEngine();
        SearchGroup[] groups = SearchGroup.createSearchGroups((SearchType[])customizedSearchTypes);
        SearchGroup searchGroup = null;
        if (groups.length > 0) {
            searchGroup = groups[0];
        }
        ResultModel resultModel = new ResultModel(searchTypeList, searchGroup);
        SearchTask task = searchEngine.search(nodes, searchGroup, resultModel);
        resultModel.setTask(task);
        return resultModel;
    }

    public void performAction(SystemAction action) {
        if (action instanceof RepositorySearchAction) {
            RepositorySearchAction repositoryAction = (RepositorySearchAction)action;
            this.performAction(repositoryAction.getNodes());
        } else if (action instanceof FindAction) {
            this.performAction(TopComponent.getRegistry().getCurrentNodes());
        } else if (Boolean.getBoolean("netbeans.debug.exceptions")) {
            throw new RuntimeException("Should not occure.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

