/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.search.SearchCriterion;
import org.openide.ErrorManager;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openidex.search.SearchType;

public class SearchProjectSettings
extends SystemOption {
    private static final long serialVersionUID = 6955446757377175182L;
    public static final String PROP_CRITERIA = "search criteria";
    private static SearchCriterion[] searchCriteria;
    static /* synthetic */ Class class$org$netbeans$modules$search$SearchProjectSettings;
    static /* synthetic */ Class class$org$openidex$search$SearchType;

    public String displayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchProjectSettings == null ? (class$org$netbeans$modules$search$SearchProjectSettings = SearchProjectSettings.class$("org.netbeans.modules.search.SearchProjectSettings")) : class$org$netbeans$modules$search$SearchProjectSettings)).getString("TEXT_Search_settings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$search$SearchProjectSettings == null ? (class$org$netbeans$modules$search$SearchProjectSettings = SearchProjectSettings.class$("org.netbeans.modules.search.SearchProjectSettings")) : class$org$netbeans$modules$search$SearchProjectSettings);
    }

    public boolean isGlobal() {
        return false;
    }

    private void importOldSettings() {
        ArrayList<SearchCriterion> oldCriteria = new ArrayList<SearchCriterion>();
        Collection instances = Lookup.getDefault().lookup(new Lookup.Template(class$org$openidex$search$SearchType == null ? (class$org$openidex$search$SearchType = SearchProjectSettings.class$("org.openidex.search.SearchType")) : class$org$openidex$search$SearchType)).allInstances();
        Iterator i = instances.iterator();
        while (i.hasNext()) {
            SearchType instance = (SearchType)i.next();
            if (!instance.isValid()) continue;
            try {
                oldCriteria.add(new SearchCriterion(instance));
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
            }
        }
        if (oldCriteria.isEmpty()) {
            searchCriteria = new SearchCriterion[0];
        } else {
            searchCriteria = new SearchCriterion[oldCriteria.size()];
            oldCriteria.toArray(searchCriteria);
        }
    }

    public SearchCriterion[] getSearchCriteria() {
        if (searchCriteria == null) {
            this.importOldSettings();
        }
        return searchCriteria;
    }

    public void setSearchCriteria(SearchCriterion[] criteria) {
        if (criteria == null) {
            criteria = new SearchCriterion[]{};
        }
        SearchCriterion[] old = searchCriteria;
        searchCriteria = criteria;
        this.firePropertyChange(PROP_CRITERIA, old, searchCriteria);
    }

    static final SearchProjectSettings getInstance() {
        return (SearchProjectSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$search$SearchProjectSettings == null ? (class$org$netbeans$modules$search$SearchProjectSettings = SearchProjectSettings.class$("org.netbeans.modules.search.SearchProjectSettings")) : class$org$netbeans$modules$search$SearchProjectSettings), (boolean)true);
    }

    void addSearchCriterion(SearchCriterion c) {
        if (searchCriteria == null) {
            searchCriteria = new SearchCriterion[1];
            SearchProjectSettings.searchCriteria[0] = c;
            this.firePropertyChange(PROP_CRITERIA, null, searchCriteria);
        } else {
            SearchCriterion[] old = searchCriteria;
            searchCriteria = new SearchCriterion[old.length + 1];
            System.arraycopy(old, 0, searchCriteria, 0, old.length);
            SearchProjectSettings.searchCriteria[old.length] = c;
            this.firePropertyChange(PROP_CRITERIA, old, searchCriteria);
        }
    }

    boolean replaceSearchCriterion(String name, String className, SearchCriterion c) {
        if (searchCriteria == null) {
            return false;
        }
        int i = 0;
        while (i < searchCriteria.length) {
            SearchCriterion candidate = searchCriteria[i];
            if (candidate.name.equals(name) && candidate.searchTypeClassName.equals(className)) {
                SearchProjectSettings.searchCriteria[i] = c;
                this.markSearchCriteriaChanged();
                return true;
            }
            ++i;
        }
        return false;
    }

    void markSearchCriteriaChanged() {
        this.firePropertyChange(PROP_CRITERIA, null, null);
    }

    Map sortCriteriaBySearchType() {
        SearchCriterion[] allCriteria = this.getSearchCriteria();
        if (allCriteria == null || allCriteria.length == 0) {
            return null;
        }
        HashMap<String, ArrayList<SearchCriterion>> map = new HashMap<String, ArrayList<SearchCriterion>>(6, 0.75f);
        int i = 0;
        while (i < allCriteria.length) {
            ArrayList<SearchCriterion> criteria;
            SearchCriterion c = allCriteria[i];
            String className = c.searchTypeClassName;
            Object o = map.get(className);
            if (o == null) {
                criteria = new ArrayList<SearchCriterion>(4);
                criteria.add(c);
                map.put(className, criteria);
            } else {
                criteria = (ArrayList<SearchCriterion>)o;
                criteria.add(c);
            }
            ++i;
        }
        return map;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

