/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.search.SearchCriterion;
import org.netbeans.modules.search.SearchProjectSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openidex.search.SearchType;

public class SearchTypePanel
extends JPanel
implements PropertyChangeListener {
    public static final String PROP_CUSTOMIZED = "customized";
    private static final String MODIFICATOR_SUFFIX = " *";
    private boolean customized;
    private SearchType searchType;
    private BeanInfo beanInfo;
    private Customizer customizer;
    private Component customizerComponent;
    private SearchCriterion[] savedCriteria;
    private String lastSavedName;
    private JPanel customizerPanel;
    private JButton restoreButton;
    private JButton saveButton;
    private JCheckBox applyCheckBox;
    static /* synthetic */ Class class$org$netbeans$modules$search$SearchTypePanel;

    public SearchTypePanel(SearchType searchType) {
        this.initComponents();
        this.initAccessibility();
        this.searchType = searchType;
        try {
            this.beanInfo = Utilities.getBeanInfo(this.searchType.getClass());
            if (this.hasCustomizer()) {
                this.customizer = this.getCustomizer();
                this.customizerComponent = (Component)((Object)this.customizer);
            } else {
                System.err.println("No customizer for " + this.searchType.getName() + ", skipping...");
            }
        }
        catch (IntrospectionException ie) {
            ErrorManager.getDefault().notify(1, (Throwable)ie);
        }
        this.customizer.setObject(this.searchType);
        this.searchType.addPropertyChangeListener((PropertyChangeListener)this);
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel));
        this.applyCheckBox.setText(bundle.getString("TEXT_BUTTON_APPLY"));
        this.applyCheckBox.setMnemonic(bundle.getString("TEXT_BUTTON_APPLY_MNEM").charAt(0));
        this.saveButton.setText(bundle.getString("TEXT_BUTTON_SAVE_AS"));
        this.saveButton.setMnemonic(bundle.getString("TEXT_BUTTON_SAVE_AS_MNEM").charAt(0));
        this.saveButton.setEnabled(false);
        this.restoreButton.setText(bundle.getString("TEXT_BUTTON_RESTORE"));
        this.restoreButton.setMnemonic(bundle.getString("TEXT_BUTTON_RESTORE_MNEM").charAt(0));
        this.restoreButton.setEnabled(false);
        this.customizerPanel.add(this.customizerComponent, "Center");
        this.setCustomized(this.searchType.isValid());
        this.setName(this.createName());
    }

    private void initAccessibility() {
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_DIALOG_DESC"));
        this.restoreButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_RESTORE"));
        this.saveButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_SAVE_AS"));
        this.applyCheckBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_APPLY"));
    }

    private void initComponents() {
        this.customizerPanel = new JPanel();
        this.applyCheckBox = new JCheckBox();
        this.saveButton = new JButton();
        this.restoreButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.customizerPanel.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.customizerPanel, gridBagConstraints);
        this.applyCheckBox.setText("jCheckBox2");
        this.applyCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchTypePanel.this.applyCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(17, 11, 0, 11);
        this.add((Component)this.applyCheckBox, gridBagConstraints);
        this.saveButton.setText("jButton3");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchTypePanel.this.saveButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 11, 0);
        this.add((Component)this.saveButton, gridBagConstraints);
        this.restoreButton.setText("jButton4");
        this.restoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchTypePanel.this.restoreButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(11, 11, 11, 11);
        this.add((Component)this.restoreButton, gridBagConstraints);
    }

    private void restoreButtonActionPerformed(ActionEvent evt) {
        this.restoreCriterion();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.saveCriterion();
    }

    private void applyCheckBoxActionPerformed(ActionEvent evt) {
        boolean selected = this.applyCheckBox.isSelected();
        this.setCustomized(selected);
        this.searchType.setValid(selected);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.searchType && "org.openidex.search.valid".equals(evt.getPropertyName())) {
            if (evt.getNewValue().equals(Boolean.FALSE)) {
                this.setCustomized(false);
                return;
            }
            this.setCustomized(true);
        }
    }

    private String createName() {
        String name = this.searchType.getName();
        if (this.customized) {
            return name + MODIFICATOR_SUFFIX;
        }
        return name;
    }

    private boolean hasCustomizer() {
        return this.beanInfo.getBeanDescriptor().getCustomizerClass() != null;
    }

    private Customizer getCustomizer() {
        Object o;
        if (this.customizer != null) {
            return this.customizer;
        }
        Class<?> clazz = this.beanInfo.getBeanDescriptor().getCustomizerClass();
        if (clazz == null) {
            return null;
        }
        try {
            o = clazz.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        if (!(o instanceof Component) || !(o instanceof Customizer)) {
            return null;
        }
        return (Customizer)o;
    }

    public Component getComponent() {
        return this.customizerComponent;
    }

    private void setCustomized(boolean cust) {
        this.customized = cust;
        this.saveButton.setEnabled(this.customized);
        this.applyCheckBox.setSelected(this.customized);
        this.setName(this.createName());
        this.firePropertyChange(PROP_CUSTOMIZED, !cust, cust);
    }

    public boolean isCustomized() {
        return this.customized;
    }

    private void saveCriterion() {
        String name;
        block2: {
            block1: {
                JPanel pane = new JPanel();
                pane.setLayout(new BorderLayout(12, 0));
                ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel));
                JLabel nameLab = new JLabel(bundle.getString("TEXT_LABEL_NAME"));
                nameLab.setDisplayedMnemonic(bundle.getString("TEXT_LABEL_NAME_MNEM").charAt(0));
                pane.add((Component)nameLab, "West");
                pane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_SaveAsPanel"));
                JTextField textField = this.lastSavedName != null ? new JTextField(this.lastSavedName, 20) : new JTextField(20);
                textField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_LABEL_SELECT"));
                nameLab.setLabelFor(textField);
                pane.add((Component)textField, "Center");
                pane.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
                DialogDescriptor desc = new DialogDescriptor((Object)pane, bundle.getString("TEXT_LABEL_SAVE_CRITERION"));
                Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
                do {
                    dialog.show();
                    if (!desc.getValue().equals(NotifyDescriptor.OK_OPTION)) break block1;
                } while ((name = textField.getText()).length() <= 0);
                break block2;
            }
            return;
        }
        this.saveCriterion(name);
        this.lastSavedName = name;
    }

    private void saveCriterion(String name) {
        SearchCriterion toSave;
        SearchType copy = (SearchType)this.searchType.clone();
        copy.setName(name);
        try {
            toSave = new SearchCriterion(copy);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
            return;
        }
        String className = toSave.searchTypeClassName;
        boolean found = false;
        if (this.savedCriteria != null) {
            int i = 0;
            while (i < this.savedCriteria.length) {
                if (this.savedCriteria[i].name.equals(name) && this.savedCriteria[i].searchTypeClassName.equals(className)) {
                    found = true;
                    SearchProjectSettings.getInstance().replaceSearchCriterion(name, className, toSave);
                    this.savedCriteria[i] = toSave;
                    break;
                }
                ++i;
            }
        }
        if (!found) {
            SearchProjectSettings.getInstance().addSearchCriterion(toSave);
            this.addSavedCriteria(Collections.singleton(toSave));
        }
    }

    private void restoreCriterion() {
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout(12, 0));
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel));
        pane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_RestorePanel"));
        JLabel resLabel = new JLabel(bundle.getString("TEXT_LABEL_SELECT"));
        resLabel.setDisplayedMnemonic(bundle.getString("TEXT_LABEL_SELECT_MNEM").charAt(0));
        pane.add((Component)resLabel, "West");
        JComboBox<SearchCriterion> combo = new JComboBox<SearchCriterion>(this.savedCriteria);
        Dimension dim = combo.getPreferredSize();
        dim.width = 160;
        combo.setPreferredSize(dim);
        resLabel.setLabelFor(combo);
        pane.add(combo, "Center");
        pane.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        DialogDescriptor desc = new DialogDescriptor((Object)pane, bundle.getString("TEXT_LABEL_RESTORE_CRITERION"));
        DialogDisplayer.getDefault().createDialog(desc).show();
        if (desc.getValue().equals(NotifyDescriptor.OK_OPTION)) {
            SearchCriterion c = (SearchCriterion)combo.getSelectedItem();
            this.restoreCriterion(c);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void restoreCriterion(SearchCriterion c) {
        block11: {
            ois = null;
            try {
                ois = new ObjectInputStream(new ByteArrayInputStream(c.criterionData));
                searchType = (SearchType)ois.readObject();
                var6_4 = null;
                ** if (ois == null) goto lbl-1000
            }
            catch (Throwable var5_11) {
                var6_6 = null;
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                }
                throw var5_11;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    ois.close();
                }
                catch (IOException ex2) {}
            }
lbl-1000:
            // 2 sources

            {
                break block11;
                catch (Exception ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                    var6_5 = null;
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException ex2) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
        }
        this.restoreSearchType(searchType);
    }

    private void restoreSearchType(SearchType searchType) {
        this.searchType.removePropertyChangeListener((PropertyChangeListener)this);
        this.searchType = (SearchType)searchType.clone();
        this.getCustomizer().setObject(this.searchType);
        this.searchType.addPropertyChangeListener((PropertyChangeListener)this);
        this.setCustomized(true);
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public boolean equals(Object obj) {
        try {
            return this.searchType.getClass().equals(((SearchTypePanel)obj).getSearchType().getClass());
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public HelpCtx getHelpCtx() {
        return this.searchType.getHelpCtx();
    }

    void addSavedCriteria(Collection criteria) {
        if (criteria.isEmpty()) {
            return;
        }
        SearchCriterion[] newCriteria = new SearchCriterion[criteria.size()];
        criteria.toArray(newCriteria);
        if (this.savedCriteria == null) {
            this.savedCriteria = newCriteria;
            this.restoreButton.setEnabled(true);
        } else {
            SearchCriterion[] oldCriteria = this.savedCriteria;
            this.savedCriteria = new SearchCriterion[oldCriteria.length + newCriteria.length];
            System.arraycopy(oldCriteria, 0, this.savedCriteria, 0, oldCriteria.length);
            System.arraycopy(newCriteria, 0, this.savedCriteria, oldCriteria.length, newCriteria.length);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

