/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.beans.FeatureDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.modules.search.types.TextDetail;
import org.netbeans.modules.search.types.TextType;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class FullTextType
extends TextType {
    private static final long serialVersionUID = 1L;
    private transient Map detailsMap;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$search$types$FullTextType;

    public Object clone() {
        FullTextType fullTextType = (FullTextType)((Object)super.clone());
        if (fullTextType.detailsMap == null) {
            fullTextType.detailsMap = new HashMap(20);
        }
        fullTextType.detailsMap.clear();
        return fullTextType;
    }

    private Map getDetailsMap() {
        if (this.detailsMap != null) {
            return this.detailsMap;
        }
        FullTextType fullTextType = this;
        synchronized (fullTextType) {
            if (this.detailsMap == null) {
                this.detailsMap = new HashMap(20);
            }
        }
        return this.detailsMap;
    }

    public boolean testDataObject(DataObject dobj) {
        try {
            String line = "";
            boolean hit = false;
            FileObject fo = dobj.getPrimaryFile();
            if (fo == null) {
                return false;
            }
            InputStream is = fo.getInputStream();
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(is));
            Object detail = null;
            ArrayList<TextDetail> txtDetails = new ArrayList<TextDetail>(5);
            while ((line = reader.readLine()) != null) {
                if (this.matchString != null) {
                    int lineNum = reader.getLineNumber();
                    int markLen = this.matchString.length();
                    String stringToSearch = this.caseSensitive ? line : line.toUpperCase();
                    int i = this.matchString(stringToSearch, 0);
                    while (i >= 0) {
                        TextDetail det = new TextDetail(dobj);
                        det.setLine(lineNum);
                        det.setColumn(i + 1);
                        det.setLineText(line);
                        det.setMarkLength(markLen);
                        txtDetails.add(det);
                        i = this.matchString(stringToSearch, i + 1);
                    }
                    continue;
                }
                if (!this.matchRE(line)) continue;
                TextDetail det = new TextDetail(dobj);
                det.setLine(reader.getLineNumber());
                det.setLineText(line);
                txtDetails.add(det);
            }
            if (txtDetails.isEmpty()) {
                return false;
            }
            this.getDetailsMap().put(dobj, txtDetails);
            return true;
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
            return false;
        }
    }

    public Node[] getDetails(Object resultObject) {
        List details = (List)this.getDetailsMap().get(resultObject);
        if (details == null) {
            return null;
        }
        ArrayList<DetailNode> detailNodes = new ArrayList<DetailNode>(details.size());
        Iterator it = details.iterator();
        while (it.hasNext()) {
            TextDetail txtDetail = (TextDetail)it.next();
            DetailNode detailNode = new DetailNode(txtDetail);
            detailNodes.add(detailNode);
        }
        return detailNodes.toArray(new Node[detailNodes.size()]);
    }

    public Node[] getDetails(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = FullTextType.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        if (dataObject == null) {
            return null;
        }
        return this.getDetails(dataObject);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = FullTextType.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ShowDetailAction
    extends NodeAction {
        static /* synthetic */ Class class$org$netbeans$modules$search$types$FullTextType;
        static /* synthetic */ Class class$org$netbeans$modules$search$types$FullTextType$ShowDetailAction;

        private ShowDetailAction() {
        }

        public String getName() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = ShowDetailAction.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType)).getString("LBL_ShowDetailAction");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$search$types$FullTextType$ShowDetailAction == null ? (class$org$netbeans$modules$search$types$FullTextType$ShowDetailAction = ShowDetailAction.class$("org.netbeans.modules.search.types.FullTextType$ShowDetailAction")) : class$org$netbeans$modules$search$types$FullTextType$ShowDetailAction);
        }

        protected boolean enable(Node[] activatedNodes) {
            if (activatedNodes == null || activatedNodes.length == 0) {
                return false;
            }
            return activatedNodes[0] instanceof DetailNode;
        }

        protected void performAction(Node[] activatedNodes) {
            if (activatedNodes == null || activatedNodes.length == 0) {
                return;
            }
            if (activatedNodes[0] instanceof DetailNode) {
                ((DetailNode)activatedNodes[0]).showDetail();
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class GotoDetailAction
    extends NodeAction {
        static /* synthetic */ Class class$org$netbeans$modules$search$types$FullTextType;
        static /* synthetic */ Class class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction;

        private GotoDetailAction() {
        }

        public String getName() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = GotoDetailAction.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType)).getString("LBL_GotoDetailAction");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction == null ? (class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction = GotoDetailAction.class$("org.netbeans.modules.search.types.FullTextType$GotoDetailAction")) : class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction);
        }

        protected boolean enable(Node[] activatedNodes) {
            return activatedNodes != null && activatedNodes.length != 0 && activatedNodes[0] instanceof DetailNode;
        }

        protected void performAction(Node[] activatedNodes) {
            if (this.enable(activatedNodes)) {
                ((DetailNode)activatedNodes[0]).gotoDetail();
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class DetailNode
    extends AbstractNode
    implements OutputListener {
        private TextDetail txtDetail;
        static /* synthetic */ Class class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction;
        static /* synthetic */ Class class$org$netbeans$modules$search$types$FullTextType$ShowDetailAction;
        static /* synthetic */ Class class$org$netbeans$modules$search$types$FullTextType;

        public DetailNode(TextDetail txtDetail) {
            super(Children.LEAF);
            this.txtDetail = txtDetail;
            this.setDefaultAction(SystemAction.get((Class)(class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction == null ? (class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction = DetailNode.class$("org.netbeans.modules.search.types.FullTextType$GotoDetailAction")) : class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction)));
            this.setShortDescription(DetailNode.getShortDesc(txtDetail));
            ((FeatureDescriptor)((Object)this)).setValue("output line", DetailNode.getFullDesc(txtDetail));
        }

        protected SystemAction[] createActions() {
            return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction == null ? (class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction = DetailNode.class$("org.netbeans.modules.search.types.FullTextType$GotoDetailAction")) : class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction)), SystemAction.get((Class)(class$org$netbeans$modules$search$types$FullTextType$ShowDetailAction == null ? (class$org$netbeans$modules$search$types$FullTextType$ShowDetailAction = DetailNode.class$("org.netbeans.modules.search.types.FullTextType$ShowDetailAction")) : class$org$netbeans$modules$search$types$FullTextType$ShowDetailAction))};
        }

        public String getName() {
            return DetailNode.getName(this.txtDetail);
        }

        private void gotoDetail() {
            this.txtDetail.showDetail(2);
        }

        private void showDetail() {
            this.txtDetail.showDetail(1);
        }

        public void outputLineSelected(OutputEvent evt) {
            this.txtDetail.showDetail(1);
        }

        public void outputLineAction(OutputEvent evt) {
            this.txtDetail.showDetail(2);
        }

        public void outputLineCleared(OutputEvent evt) {
            this.txtDetail.showDetail(3);
        }

        private static String getName(TextDetail det) {
            int line = det.getLine();
            int col = det.getColumn();
            ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = DetailNode.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType));
            if (col > 0) {
                return MessageFormat.format(bundle.getString("TEXT_DETAIL_FMT_NAME1"), Integer.toString(line), Integer.toString(col));
            }
            return MessageFormat.format(bundle.getString("TEXT_DETAIL_FMT_NAME2"), Integer.toString(line));
        }

        private static String getShortDesc(TextDetail det) {
            int line = det.getLine();
            int col = det.getColumn();
            if (col > 0) {
                return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = DetailNode.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType)).getString("TEXT_DETAIL_FMT_SHORT1"), Integer.toString(line), Integer.toString(col));
            }
            return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = DetailNode.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType)).getString("TEXT_DETAIL_FMT_SHORT2"), Integer.toString(line));
        }

        private static String getFullDesc(TextDetail det) {
            String filename = det.getDataObject().getPrimaryFile().getNameExt();
            String lineText = det.getLineText().trim();
            int line = det.getLine();
            int col = det.getColumn();
            if (col > 0) {
                return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = DetailNode.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType)).getString("TEXT_DETAIL_FMT_FULL1"), lineText, filename, Integer.toString(line), Integer.toString(col));
            }
            return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = DetailNode.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType)).getString("TEXT_DETAIL_FMT_FULL2"), lineText, filename, Integer.toString(line));
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

