/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.netbeans.modules.search.types.DataObjectType;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;

public class ModificationDateType
extends DataObjectType {
    private static final long serialVersionUID = 4L;
    private Date matchBefore;
    private Date matchAfter;
    private Short days;
    static /* synthetic */ Class class$org$netbeans$modules$search$types$ModificationDateType;

    public boolean testDataObject(DataObject dobj) {
        boolean hit;
        FileObject fo = dobj.getPrimaryFile();
        if (fo == null) {
            return false;
        }
        Date date = fo.lastModified();
        boolean bl = hit = this.testDays(date) && this.testAfter(date) && this.testBefore(date);
        return hit;
    }

    private boolean testAfter(Date date) {
        if (this.matchAfter == null) {
            return true;
        }
        return date.compareTo(this.matchAfter) >= 0;
    }

    private boolean testBefore(Date date) {
        if (this.matchBefore == null) {
            return true;
        }
        return date.compareTo(this.matchBefore) <= 0;
    }

    private boolean testDays(Date date) {
        if (this.days == null) {
            return true;
        }
        return System.currentTimeMillis() - date.getTime() < (long)this.days.shortValue() * 1000L * 60L * 60L * 24L;
    }

    public Date getMatchBeforeAsDate() {
        return new FormattedDate(this.matchBefore);
    }

    public String getMatchBefore() {
        if (this.matchBefore == null) {
            return "";
        }
        return this.getMatchBeforeAsDate().toString();
    }

    public void setMatchBefore(String before) {
        try {
            this.setMatchBeforeImpl(before);
            this.setValid(this.matchBefore != null);
        }
        catch (IllegalArgumentException ex) {
            this.setValid(false);
            throw ex;
        }
    }

    private void setMatchBeforeImpl(String matchBefore) {
        if (matchBefore == null) {
            throw new IllegalArgumentException();
        }
        if (matchBefore.equals("")) {
            this.setMatchBeforeByDate(null);
            return;
        }
        try {
            this.setMatchBeforeByDate(new FormattedDate(matchBefore));
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException();
        }
    }

    public void setMatchBeforeByDate(Date matchBefore) {
        if (matchBefore != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(matchBefore);
            cal.set(11, cal.getActualMaximum(11));
            cal.set(12, cal.getActualMaximum(12));
            cal.set(13, cal.getActualMaximum(13));
            cal.set(14, cal.getActualMaximum(14));
            matchBefore = cal.getTime();
        }
        Date old = this.matchBefore;
        this.matchBefore = matchBefore;
        this.days = null;
    }

    public Date getMatchAfterAsDate() {
        return new FormattedDate(this.matchAfter);
    }

    public String getMatchAfter() {
        if (this.matchAfter == null) {
            return "";
        }
        return this.getMatchAfterAsDate().toString();
    }

    public void setMatchAfter(String after) {
        try {
            this.setMatchAfterImpl(after);
            this.setValid(this.matchAfter != null);
        }
        catch (IllegalArgumentException ex) {
            this.setValid(false);
            throw ex;
        }
    }

    private void setMatchAfterImpl(String matchAfter) {
        if (matchAfter == null) {
            throw new IllegalArgumentException();
        }
        if (matchAfter.equals("")) {
            this.setMatchAfterByDate(null);
            return;
        }
        try {
            this.setMatchAfterByDate(new FormattedDate(matchAfter));
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException();
        }
    }

    public void setMatchAfterByDate(Date matchAfter) {
        if (matchAfter != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(matchAfter);
            cal.set(11, cal.getActualMinimum(11));
            cal.set(12, cal.getActualMinimum(12));
            cal.set(13, cal.getActualMinimum(13));
            cal.set(14, cal.getActualMinimum(14));
            matchAfter = cal.getTime();
        }
        Date old = this.matchAfter;
        this.matchAfter = matchAfter;
        this.days = null;
    }

    public Short getDaysAsShort() {
        return this.days;
    }

    public String getDays() {
        if (this.days == null) {
            return "";
        }
        return this.days.toString();
    }

    public void setDays(String days) {
        try {
            this.setDaysImpl(days);
            this.setValid(this.days != null);
        }
        catch (IllegalArgumentException ex) {
            this.setValid(false);
            throw ex;
        }
    }

    private void setDaysImpl(String days) {
        if ("".equals(days)) {
            this.setDaysByShort(null);
            return;
        }
        try {
            DecimalFormat format = new DecimalFormat();
            this.setDaysByShort(new Short(format.parse(days).shortValue()));
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException();
        }
    }

    private void setDaysByShort(Short days) {
        Short old = this.days;
        this.days = days;
        this.matchAfter = null;
        this.matchBefore = null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$search$types$ModificationDateType == null ? (class$org$netbeans$modules$search$types$ModificationDateType = ModificationDateType.class$("org.netbeans.modules.search.types.ModificationDateType")) : class$org$netbeans$modules$search$types$ModificationDateType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class FormattedDate
    extends Date {
        private static DateFormat format;
        private transient boolean isNull = true;

        public FormattedDate(Date date) {
            super(date == null ? new Date().getTime() : date.getTime());
            this.isNull = date == null;
        }

        public FormattedDate(String date) throws ParseException {
            super(format.parse(date).getTime());
            this.isNull = date == null;
        }

        public String toString() {
            return format.format(this);
        }

        public boolean equals(Object obj) {
            if (obj == null && this.isNull) {
                return true;
            }
            return super.equals(obj);
        }

        static {
            new SimpleDateFormat();
            format = DateFormat.getDateInstance();
        }
    }
}

