/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.search.types.DataObjectType;

public abstract class TextType
extends DataObjectType {
    private static final long serialVersionUID = 3L;
    protected String matchString;
    protected transient String ciMatchString;
    protected boolean caseSensitive;
    protected boolean wholeWords;
    private static final String WORD_SEPARATORS = " \t,;.:+-*/\\()[]{}<>=&|\"'`~!?@#%^\n\r";
    protected transient RE re;
    protected String reString;

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (!this.caseSensitive && this.matchString != null) {
            this.ciMatchString = this.matchString.toUpperCase();
        }
        if (this.reString != null) {
            this.setRe(this.reString);
        }
    }

    protected boolean match(String text) {
        return this.matchString(text, 0) >= 0 && this.matchRE(text);
    }

    protected boolean matchRE(String line) {
        if (this.re == null) {
            return true;
        }
        return this.re.match(line);
    }

    protected int matchString(String text, int fromIndex) {
        if (this.matchString == null) {
            return 0;
        }
        int index = text.indexOf(this.caseSensitive ? this.matchString : this.ciMatchString, fromIndex);
        if (this.wholeWords && index >= 0) {
            if (index > 0 && WORD_SEPARATORS.indexOf(text.charAt(index - 1)) < 0) {
                index = -1;
            } else {
                int matchLen = this.matchString.length();
                if (index + matchLen < text.length() && WORD_SEPARATORS.indexOf(text.charAt(index + matchLen)) < 0) {
                    index = -1;
                }
            }
        }
        return index;
    }

    public String getMatchString() {
        if (this.matchString == null) {
            return "";
        }
        return this.matchString;
    }

    public void setMatchString(String matchString) {
        if (matchString == null) {
            this.setValid(false);
            throw new IllegalArgumentException();
        }
        if (matchString.equals("")) {
            matchString = null;
        }
        String old = this.matchString;
        this.matchString = matchString;
        if (!this.caseSensitive && matchString != null) {
            this.ciMatchString = matchString.toUpperCase();
        }
        this.re = null;
        this.reString = null;
        this.setValid(matchString != null);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        if (!caseSensitive && this.matchString != null) {
            this.ciMatchString = this.matchString.toUpperCase();
        }
    }

    public boolean getWholeWords() {
        return this.wholeWords;
    }

    public void setWholeWords(boolean wholeWords) {
        boolean old = this.wholeWords;
        this.wholeWords = wholeWords;
    }

    public String getRe() {
        if (this.reString == null) {
            return "";
        }
        return this.reString;
    }

    public void setRe(String re) {
        this.setReImpl(re);
    }

    private void setReImpl(String exp) {
        if (exp == null) {
            this.setValid(false);
            throw new IllegalArgumentException();
        }
        String old = this.reString;
        if ("".equals(exp)) {
            this.reString = null;
            exp = null;
            this.matchString = null;
            this.setValid(false);
            return;
        }
        try {
            this.re = new RE(exp);
            this.reString = exp;
            this.matchString = null;
            this.setValid(true);
        }
        catch (RESyntaxException ex) {
            this.setValid(false);
            throw new IllegalArgumentException();
        }
    }
}

