/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.url;

import java.beans.FeatureDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

public final class BookmarksNode
extends DataFolder.FolderNode {
    private static final Node.PropertySet[] NO_PROPERTIES = new Node.PropertySet[0];
    private static ResourceBundle bundle;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$url$BookmarksNode;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$ReorderAction;
    static /* synthetic */ Class class$org$openide$actions$NewAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$openide$nodes$Index;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public BookmarksNode() {
        this(DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("Bookmarks")));
    }

    private BookmarksNode(DataFolder folder) {
        super(folder, (Children)new BookmarksFolderChildren(folder));
        this.setIconBase("org/netbeans/modules/url/bookmarks");
        this.setName(super.getDisplayName(), false);
    }

    public String getDisplayName() {
        return Actions.cutAmpersand((String)super.getDisplayName());
    }

    protected Sheet createSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set sheetSet = Sheet.createPropertiesSet();
        sheetSet.put(this.createNameProperty());
        sheet.put(sheetSet);
        return sheet;
    }

    private Node.Property createNameProperty() {
        return new PropertySupport.ReadWrite("name", class$java$lang$String == null ? (class$java$lang$String = BookmarksNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getBundle((Class)(class$org$netbeans$modules$url$BookmarksNode == null ? (class$org$netbeans$modules$url$BookmarksNode = BookmarksNode.class$("org.netbeans.modules.url.BookmarksNode")) : class$org$netbeans$modules$url$BookmarksNode)).getString("PROP_Name"), NbBundle.getBundle((Class)(class$org$netbeans$modules$url$BookmarksNode == null ? (class$org$netbeans$modules$url$BookmarksNode = BookmarksNode.class$("org.netbeans.modules.url.BookmarksNode")) : class$org$netbeans$modules$url$BookmarksNode)).getString("PROP_NameShortDescription")){

            public Object getValue() {
                return ((FeatureDescriptor)((Object)BookmarksNode.this)).getName();
            }

            public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                if (!(val instanceof String)) {
                    throw new IllegalArgumentException();
                }
                try {
                    BookmarksNode.this.getDataObject().rename((String)val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean canWrite() {
                return BookmarksNode.this.canRename();
            }
        };
    }

    public boolean canRename() {
        if (this.getDataObject() == DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("Bookmarks"))) {
            return false;
        }
        return super.canRename();
    }

    public String getShortDescription() {
        return BookmarksNode.getBundle().getString("CTL_Bookmarks_hint");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$url$BookmarksNode == null ? (class$org$netbeans$modules$url$BookmarksNode = BookmarksNode.class$("org.netbeans.modules.url.BookmarksNode")) : class$org$netbeans$modules$url$BookmarksNode);
    }

    public NewType[] getNewTypes() {
        return new NewType[]{new NewBookmarkType(), new NewFolderType(), new NewSeparatorType()};
    }

    protected SystemAction[] createActions() {
        ArrayList<SystemAction> list = new ArrayList<SystemAction>();
        list.add(SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = BookmarksNode.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)));
        list.add(null);
        list.add(SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = BookmarksNode.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)));
        list.add(null);
        list.add(SystemAction.get((Class)(class$org$openide$actions$ReorderAction == null ? (class$org$openide$actions$ReorderAction = BookmarksNode.class$("org.openide.actions.ReorderAction")) : class$org$openide$actions$ReorderAction)));
        list.add(null);
        list.add(SystemAction.get((Class)(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = BookmarksNode.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction)));
        Node parent = this.getParentNode();
        if (parent != null && parent instanceof BookmarksNode) {
            list.add(SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = BookmarksNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)));
        }
        list.add(null);
        list.add(SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = BookmarksNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)));
        return list.toArray(new SystemAction[list.size()]);
    }

    public boolean canDestroy() {
        Node parent = this.getParentNode();
        return parent != null && parent instanceof BookmarksNode;
    }

    public boolean canCut() {
        return this.canDestroy();
    }

    public Node.Cookie getCookie(Class type) {
        DataFolder dataObj;
        if ((class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = BookmarksNode.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index).isAssignableFrom(type) && (dataObj = (DataFolder)super.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = BookmarksNode.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder)) != null) {
            return new BookmarksIndex(dataObj, this, (BookmarksFolderChildren)this.getChildren());
        }
        return super.getCookie(type);
    }

    private static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$url$BookmarksNode == null ? (class$org$netbeans$modules$url$BookmarksNode = BookmarksNode.class$("org.netbeans.modules.url.BookmarksNode")) : class$org$netbeans$modules$url$BookmarksNode));
        }
        return bundle;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class BookmarksIndex
    extends DataFolder.Index {
        BookmarksFolderChildren children;

        BookmarksIndex(DataFolder df, BookmarksNode node, BookmarksFolderChildren children) {
            super(df, (Node)node);
            this.children = children;
        }

        public int getNodesCount() {
            return this.children.getNodesCount();
        }

        public Node[] getNodes() {
            return this.children.getNodes();
        }
    }

    private static final class BookmarksFolderChildren
    extends FilterNode.Children {
        static /* synthetic */ Class class$org$openide$loaders$DataFolder;
        static /* synthetic */ Class class$org$netbeans$modules$url$URLDataObject;
        static /* synthetic */ Class class$org$netbeans$modules$url$BookmarksNode$BookmarksIndex;
        static /* synthetic */ Class class$org$openide$cookies$InstanceCookie$Of;
        static /* synthetic */ Class class$javax$swing$JSeparator;

        public BookmarksFolderChildren(DataFolder folder) {
            super(folder.getNodeDelegate());
        }

        protected Node copyNode(Node node) {
            DataFolder df = (DataFolder)node.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = BookmarksFolderChildren.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
            if (df != null) {
                return new BookmarksNode(df);
            }
            return node.cloneNode();
        }

        protected Node[] createNodes(Object key) {
            Node[] nodes = super.createNodes(key);
            ArrayList<Node> filteredNodes = new ArrayList<Node>();
            int i = 0;
            while (i < nodes.length) {
                if (nodes[i].getCookie(class$org$netbeans$modules$url$URLDataObject == null ? BookmarksFolderChildren.class$("org.netbeans.modules.url.URLDataObject") : class$org$netbeans$modules$url$URLDataObject) != null || nodes[i].getCookie(class$org$netbeans$modules$url$BookmarksNode$BookmarksIndex == null ? BookmarksFolderChildren.class$("org.netbeans.modules.url.BookmarksNode$BookmarksIndex") : class$org$netbeans$modules$url$BookmarksNode$BookmarksIndex) != null) {
                    filteredNodes.add(nodes[i]);
                } else {
                    InstanceCookie.Of ic = (InstanceCookie.Of)nodes[i].getCookie(class$org$openide$cookies$InstanceCookie$Of == null ? BookmarksFolderChildren.class$("org.openide.cookies.InstanceCookie$Of") : class$org$openide$cookies$InstanceCookie$Of);
                    if (ic != null && ic.instanceOf(class$javax$swing$JSeparator == null ? BookmarksFolderChildren.class$("javax.swing.JSeparator") : class$javax$swing$JSeparator)) {
                        filteredNodes.add(nodes[i]);
                    }
                }
                ++i;
            }
            return filteredNodes.toArray(new Node[filteredNodes.size()]);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class NewSeparatorType
    extends NewType {
        static /* synthetic */ Class class$org$openide$loaders$DataFolder;
        static /* synthetic */ Class class$javax$swing$JSeparator;

        private NewSeparatorType() {
        }

        public String getName() {
            return BookmarksNode.getBundle().getString("LBL_Separator");
        }

        public void create() throws IOException {
            try {
                DataFolder dataFolder = (DataFolder)BookmarksNode.this.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = NewSeparatorType.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                FileObject folder = dataFolder.getPrimaryFile();
                String fileName = "[" + (class$javax$swing$JSeparator == null ? (class$javax$swing$JSeparator = NewSeparatorType.class$("javax.swing.JSeparator")) : class$javax$swing$JSeparator).getName().replace('.', '-') + "]";
                FileObject separatorFile = folder.getFileObject(fileName, "instance");
                if (separatorFile == null) {
                    folder.createData(fileName, "instance");
                } else {
                    DataObject separatorDataObject = DataObject.find((FileObject)separatorFile);
                    if (separatorDataObject != null) {
                        separatorDataObject.copy(dataFolder);
                    }
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class NewFolderType
    extends NewType {
        static /* synthetic */ Class class$org$openide$loaders$DataFolder;

        private NewFolderType() {
        }

        public String getName() {
            return BookmarksNode.getBundle().getString("CTL_NewFolder");
        }

        public void create() throws IOException {
            NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(BookmarksNode.getBundle().getString("CTL_NewFolderName"), BookmarksNode.getBundle().getString("CTL_NewFolderTitle"));
            input.setInputText(BookmarksNode.getBundle().getString("CTL_NewFolderValue"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)input) == NotifyDescriptor.OK_OPTION) {
                String folderName;
                DataFolder dataObj = (DataFolder)BookmarksNode.this.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = NewFolderType.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                FileObject folder = dataObj.getPrimaryFile();
                if (folder.getFileObject(folderName = input.getInputText()) != null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(BookmarksNode.getBundle().getString("FMT_FolderExists"), folderName), 1));
                } else {
                    folder.createFolder(folderName);
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class NewBookmarkType
    extends NewType {
        static /* synthetic */ Class class$org$openide$loaders$DataFolder;

        private NewBookmarkType() {
        }

        public String getName() {
            return BookmarksNode.getBundle().getString("CTL_NewBookmark");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void create() throws IOException {
            FileLock lock;
            block7: {
                NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(BookmarksNode.getBundle().getString("CTL_NewBookmarkName"), BookmarksNode.getBundle().getString("CTL_NewBookmarkNameTitle"));
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)input) != NotifyDescriptor.OK_OPTION) return;
                String bookmarkName = input.getInputText();
                input = new NotifyDescriptor.InputLine(BookmarksNode.getBundle().getString("CTL_NewBookmarkURL"), BookmarksNode.getBundle().getString("CTL_NewBookmarkURLTitle"));
                input.setInputText(BookmarksNode.getBundle().getString("CTL_NewBookmarkValue"));
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)input) != NotifyDescriptor.OK_OPTION) return;
                DataFolder dataObj = (DataFolder)BookmarksNode.this.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = NewBookmarkType.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                FileObject folder = dataObj.getPrimaryFile();
                String bookmarkText = input.getInputText();
                String freeName = FileUtil.findFreeFileName((FileObject)folder, (String)bookmarkName, (String)"url");
                FileObject fo = folder.createData(freeName, "url");
                lock = null;
                OutputStream os = null;
                try {
                    try {
                        lock = fo.lock();
                        os = fo.getOutputStream(lock);
                        os.write(bookmarkText.getBytes());
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                        Object var12_11 = null;
                        if (os != null) {
                            os.close();
                        }
                        if (lock == null) return;
                        lock.releaseLock();
                        return;
                    }
                    Object var12_10 = null;
                    if (os == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    if (os != null) {
                        os.close();
                    }
                    if (lock == null) throw throwable;
                    lock.releaseLock();
                    throw throwable;
                }
                os.close();
            }
            if (lock == null) return;
            lock.releaseLock();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

