/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.url;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.EditCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.Presenter;

public class URLDataObject
extends MultiDataObject
implements EditCookie,
OpenCookie,
InstanceCookie {
    private static final String PROP_URL = "url";
    static final long serialVersionUID = 6829522922370124627L;
    static /* synthetic */ Class class$org$netbeans$modules$url$URLDataObject;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$netbeans$modules$url$URLDataObject$URLPresenter;

    public URLDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        this.getCookieSet().add((Node.Cookie)this);
    }

    /*
     * Unable to fully structure code
     */
    String getURLString() {
        block16: {
            urlFile = this.getPrimaryFile();
            if (!urlFile.isValid()) {
                return null;
            }
            urlString = "";
            is = null;
            try {
                is = urlFile.getInputStream();
                urlString = new BufferedReader(new InputStreamReader(is)).readLine();
                var8_4 = null;
                ** if (is == null) goto lbl-1000
            }
            catch (Throwable var7_16) {
                var8_7 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
                throw var7_16;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    is.close();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block16;
                catch (FileNotFoundException fne) {
                    ErrorManager.getDefault().notify(16, (Throwable)fne);
                    var5_13 = null;
                    var8_5 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            ErrorManager.getDefault().notify(1, (Throwable)e);
                        }
                    }
                    return var5_13;
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(16, (Throwable)ioe);
                    var6_15 = null;
                    var8_6 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            ErrorManager.getDefault().notify(1, (Throwable)e);
                        }
                    }
                    return var6_15;
                }
            }
        }
        if (urlString == null) {
            urlString = "";
        }
        return urlString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setURLString(String newUrlString) {
        FileObject urlFile = this.getPrimaryFile();
        if (!urlFile.isValid()) {
            return;
        }
        FileLock lock = null;
        try {
            try {
                lock = urlFile.lock();
                OutputStream os = urlFile.getOutputStream(lock);
                os.write(newUrlString.getBytes());
                os.close();
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(16, (Throwable)ioe);
                Object var6_7 = null;
                if (lock == null) return;
                lock.releaseLock();
                return;
            }
            Object var6_6 = null;
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (lock == null) throw throwable;
            lock.releaseLock();
            throw throwable;
        }
        lock.releaseLock();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLDataObject.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject);
    }

    protected Node createNodeDelegate() {
        return new URLNode((DataObject)this);
    }

    public void open() {
        String urlString = this.getURLString();
        if (urlString == null) {
            return;
        }
        URL url = URLDataObject.getURLFromString(urlString);
        if (url == null) {
            return;
        }
        HtmlBrowser.URLDisplayer.getDefault().showURL(url);
    }

    public void openInNewWindow() {
        String urlString = this.getURLString();
        if (urlString == null) {
            return;
        }
        URL url = URLDataObject.getURLFromString(urlString);
        if (url == null) {
            return;
        }
        HtmlBrowser.Factory fact = null;
        try {
            ClassLoader clzL = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = URLDataObject.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            Class<?> clz = Class.forName("org.netbeans.core.IDESettings", true, clzL);
            SharedClassObject settings = SharedClassObject.findObject(clz, (boolean)true);
            Method m = clz.getMethod("getWWWBrowser", new Class[0]);
            Object o = m.invoke((Object)settings, new Object[0]);
            if (o instanceof HtmlBrowser.Factory) {
                fact = (HtmlBrowser.Factory)o;
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        HtmlBrowser.BrowserComponent htmlViewer = new HtmlBrowser.BrowserComponent(fact, true, true);
        htmlViewer.setURL(url);
        htmlViewer.open();
        htmlViewer.requestFocus();
    }

    private static URL getURLFromString(String urlString) {
        URL url;
        block5: {
            url = null;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException mue1) {
                try {
                    url = new URL("http://" + urlString);
                }
                catch (MalformedURLException mue2) {
                    if (urlString.length() > 50) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getBundle((Class)(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLDataObject.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject)).getString("MSG_MalformedURLError"), 0));
                        break block5;
                    }
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLDataObject.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject)).getString("MSG_FMT_MalformedURLError"), urlString), 0));
                }
            }
        }
        return url;
    }

    public void edit() {
        String urlString = this.getURLString();
        if (urlString == null) {
            return;
        }
        NotifyDescriptor.InputLine urlLine = new NotifyDescriptor.InputLine(NbBundle.getBundle((Class)(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLDataObject.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject)).getString("CTL_URL"), NbBundle.getBundle((Class)(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLDataObject.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject)).getString("CTL_EditURL"));
        urlLine.setInputText(urlString);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)urlLine);
        if (urlLine.getValue() == NotifyDescriptor.OK_OPTION) {
            this.setURLString(urlLine.getInputText());
        }
    }

    public String instanceName() {
        return this.getName();
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        return class$org$netbeans$modules$url$URLDataObject$URLPresenter == null ? (class$org$netbeans$modules$url$URLDataObject$URLPresenter = URLDataObject.class$("org.netbeans.modules.url.URLDataObject$URLPresenter")) : class$org$netbeans$modules$url$URLDataObject$URLPresenter;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        return this.createURLPresenter();
    }

    URLPresenter createURLPresenter() {
        return new URLPresenter((DataObject)this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class URLNode
    extends DataNode {
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$org$netbeans$modules$url$URLDataObject;

        public URLNode(DataObject dataObject) {
            super(dataObject, Children.LEAF);
            this.setIconBase("org/netbeans/modules/url/urlObject");
            this.setName(super.getDisplayName(), false);
        }

        public String getDisplayName() {
            return Actions.cutAmpersand((String)super.getDisplayName());
        }

        protected Sheet createSheet() {
            Sheet sheet = super.createSheet();
            Sheet.Set sheetSet = sheet.get("properties");
            sheetSet.remove("name");
            sheetSet.put(this.createNameProperty());
            sheetSet.put(this.createURLStringProperty());
            return sheet;
        }

        private Node.Property createNameProperty() {
            return new PropertySupport.ReadWrite(this, "name", class$java$lang$String == null ? (class$java$lang$String = URLNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getBundle((Class)(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLNode.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject)).getString("PROP_Name"), NbBundle.getBundle((Class)(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLNode.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject)).getString("PROP_NameShortDescription")){
                private final /* synthetic */ URLNode this$0;
                {
                    this.this$0 = this$0;
                }

                public Object getValue() {
                    return ((FeatureDescriptor)((Object)this.this$0)).getName();
                }

                public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    if (!this.canWrite()) {
                        throw new IllegalAccessException();
                    }
                    if (!(val instanceof String)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        this.this$0.getDataObject().rename((String)val);
                    }
                    catch (IOException ex) {
                        throw new InvocationTargetException(ex);
                    }
                }

                public boolean canWrite() {
                    return this.this$0.getDataObject().isRenameAllowed();
                }
            };
        }

        private Node.Property createURLStringProperty() {
            PropertySupport.ReadWrite urlStringProperty = new PropertySupport.ReadWrite(this, URLDataObject.PROP_URL, class$java$lang$String == null ? (class$java$lang$String = URLNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getBundle((Class)(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLNode.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject)).getString("PROP_URLDisplayName"), NbBundle.getBundle((Class)(class$org$netbeans$modules$url$URLDataObject == null ? (class$org$netbeans$modules$url$URLDataObject = URLNode.class$("org.netbeans.modules.url.URLDataObject")) : class$org$netbeans$modules$url$URLDataObject)).getString("PROP_URLShortDescription")){
                private final /* synthetic */ URLNode this$0;
                {
                    this.this$0 = this$0;
                }

                public Object getValue() {
                    return ((URLDataObject)this.this$0.getDataObject()).getURLString();
                }

                public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    if (!this.canWrite()) {
                        throw new IllegalAccessException();
                    }
                    if (!(val instanceof String)) {
                        throw new IllegalArgumentException();
                    }
                    ((URLDataObject)this.this$0.getDataObject()).setURLString((String)val);
                }
            };
            urlStringProperty.setPreferred(true);
            return urlStringProperty;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class SimpleNodeButtonBridge
    implements ActionListener,
    PropertyChangeListener {
        private final DataObject dataObject;
        private final AbstractButton button;
        static /* synthetic */ Class class$org$openide$cookies$OpenCookie;

        public SimpleNodeButtonBridge(DataObject dataObject, AbstractButton button) {
            this.dataObject = dataObject;
            this.button = button;
            this.updateText();
            Image defaultImage = Utilities.loadImage((String)"org/netbeans/modules/url/urlObject.gif");
            try {
                this.button.setIcon(new ImageIcon(this.dataObject.getPrimaryFile().getFileSystem().getStatus().annotateIcon(defaultImage, 1, dataObject.files())));
            }
            catch (FileStateInvalidException fsie) {
                this.button.setIcon(new ImageIcon(defaultImage));
            }
            HelpCtx.setHelpIDString((JComponent)button, (String)dataObject.getHelpCtx().getHelpID());
            button.addActionListener(this);
            this.dataObject.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)this.dataObject));
        }

        public void actionPerformed(ActionEvent evt) {
            OpenCookie open = (OpenCookie)this.dataObject.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = SimpleNodeButtonBridge.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
            if (open != null) {
                open.open();
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("name".equals(evt.getPropertyName())) {
                this.updateText();
            }
        }

        private void updateText() {
            String text = this.dataObject.getName();
            try {
                text = this.dataObject.getPrimaryFile().getFileSystem().getStatus().annotateName(text, this.dataObject.files());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            Actions.setMenuText((AbstractButton)this.button, (String)text, (boolean)true);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class URLToolbarButton
    extends JButton {
        public URLToolbarButton(DataObject dataObject) {
            new SimpleNodeButtonBridge(dataObject, this);
        }
    }

    private static class URLMenuItem
    extends JMenuItem {
        public URLMenuItem(DataObject dataObject) {
            new SimpleNodeButtonBridge(dataObject, this);
        }
    }

    private static class URLPresenter
    implements Presenter.Menu,
    Presenter.Toolbar,
    Presenter.Popup {
        private DataObject dataObject;

        public URLPresenter(DataObject dataObject) {
            this.dataObject = dataObject;
        }

        public JMenuItem getMenuPresenter() {
            return new URLMenuItem(this.dataObject);
        }

        public JMenuItem getPopupPresenter() {
            return new URLMenuItem(this.dataObject);
        }

        public Component getToolbarPresenter() {
            return new URLToolbarButton(this.dataObject);
        }
    }
}

