/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.text.MessageFormat;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Common {
    public static final int NONE = 0;
    public static final int MASK_USER = 65535;
    public static int USE_DEFAULT_VALUES = 1;
    public static int NO_DEFAULT_VALUES = 2;
    public static final int MASK_SEQUENCE = 15;
    public static final int SEQUENCE_AND = 1;
    public static final int SEQUENCE_OR = 2;
    public static final int MASK_INSTANCE = 240;
    public static final int TYPE_0_1 = 16;
    public static final int TYPE_1 = 32;
    public static final int TYPE_0_N = 48;
    public static final int TYPE_1_N = 64;
    public static final int MASK_TYPE = 65280;
    public static final int TYPE_STRING = 256;
    public static final int TYPE_BEAN = 512;
    public static final int TYPE_BOOLEAN = 768;
    public static final int TYPE_BYTE = 1024;
    public static final int TYPE_CHAR = 1280;
    public static final int TYPE_SHORT = 1536;
    public static final int TYPE_INT = 1792;
    public static final int TYPE_LONG = 2048;
    public static final int TYPE_FLOAT = 2304;
    public static final int TYPE_DOUBLE = 2560;
    public static final int TYPE_COMMENT = 3840;
    public static final int MASK_PROP = 983040;
    public static final int TYPE_KEY = 65536;
    public static final int TYPE_SHOULD_NOT_BE_EMPTY = 131072;
    public static final int TYPE_VETOABLE = 0x100000;
    public static final int COMMENT = 1;
    public static final int ELEMENT = 2;
    public static final int ATTLIST = 3;
    public static final String DTD_STRING = "#PCDATA";
    public static final String DTD_EMPTY = "EMPTY";
    static final String CLASS_STRING = "String";
    static final String CLASS_BOOLEAN = "Boolean";
    private static String rbName = "org.netbeans.modules.schema2beans.Bundle";
    static /* synthetic */ Class class$org$netbeans$modules$schema2beans$Common;

    public static boolean isSequenceOr(int type) {
        return (type & 0xF) == 2;
    }

    public static boolean isArray(int type) {
        int t = type & 0xF0;
        return t == 48 || t == 64;
    }

    public static boolean isBean(int type) {
        return (type & 0xFF00) == 512;
    }

    public static boolean isString(int type) {
        return (type & 0xFF00) == 256;
    }

    public static boolean isBoolean(int type) {
        return (type & 0xFF00) == 768;
    }

    public static boolean isKey(int type) {
        return (type & 0x10000) == 65536;
    }

    public static boolean shouldNotBeEmpty(int type) {
        return (type & 0x20000) == 131072;
    }

    public static boolean isVetoable(int type) {
        return (type & 0x100000) == 0x100000;
    }

    public static boolean isScalar(int type) {
        switch (type & 0xFF00) {
            case 256: 
            case 512: 
            case 3840: {
                return false;
            }
            case 768: 
            case 1024: 
            case 1280: 
            case 1536: 
            case 1792: 
            case 2048: 
            case 2304: 
            case 2560: {
                return true;
            }
        }
        throw new IllegalArgumentException(Common.getMessage("UnknownType_msg", new Integer(type)));
    }

    public static String wrapperGetMethod(int type) {
        switch (type & 0xFF00) {
            case 768: {
                return "booleanValue";
            }
            case 1024: {
                return "byteValue";
            }
            case 1280: {
                return "charValue";
            }
            case 1536: {
                return "shortValue";
            }
            case 1792: {
                return "intValue";
            }
            case 2048: {
                return "longValue";
            }
            case 2304: {
                return "floatValue";
            }
            case 2560: {
                return "doubleValue";
            }
        }
        throw new IllegalArgumentException(Common.getMessage("UnknownType_msg", new Integer(type)));
    }

    public static String wrapperClass(int type) {
        switch (type & 0xFF00) {
            case 768: {
                return CLASS_BOOLEAN;
            }
            case 1024: {
                return "Byte";
            }
            case 1280: {
                return "Character";
            }
            case 1536: {
                return "Short";
            }
            case 1792: {
                return "Integer";
            }
            case 2048: {
                return "Long";
            }
            case 2304: {
                return "Float";
            }
            case 2560: {
                return "Double";
            }
        }
        throw new IllegalArgumentException(Common.getMessage("UnknownType_msg", new Integer(type)));
    }

    public static int wrapperToType(String wrapper) {
        if (wrapper == null) {
            return 0;
        }
        String s = wrapper.trim();
        if (s.endsWith("boolean")) {
            return 768;
        }
        if (s.endsWith("byte")) {
            return 1024;
        }
        if (s.endsWith("char")) {
            return 1280;
        }
        if (s.endsWith("short")) {
            return 1536;
        }
        if (s.endsWith("int")) {
            return 1792;
        }
        if (s.endsWith("long")) {
            return 2048;
        }
        if (s.endsWith("float")) {
            return 2304;
        }
        if (s.endsWith("double")) {
            return 2560;
        }
        if (s.equals(CLASS_STRING) || s.equals("java.lang.String")) {
            return 256;
        }
        return 0;
    }

    public static String scalarType(int type) {
        switch (type & 0xFF00) {
            case 768: {
                return "boolean";
            }
            case 1024: {
                return "byte";
            }
            case 1280: {
                return "char";
            }
            case 1536: {
                return "short";
            }
            case 1792: {
                return "int";
            }
            case 2048: {
                return "long";
            }
            case 2304: {
                return "float";
            }
            case 2560: {
                return "double";
            }
        }
        throw new IllegalArgumentException(Common.getMessage("UnknownType_msg", new Integer(type)));
    }

    public static String typeToString(int type) {
        switch (type & 0xFF00) {
            case 256: {
                return "TYPE_STRING";
            }
            case 3840: {
                return "TYPE_COMMENT";
            }
            case 512: {
                return "TYPE_BEAN";
            }
            case 768: {
                return "TYPE_BOOLEAN";
            }
            case 1024: {
                return "TYPE_BYTE";
            }
            case 1280: {
                return "TYPE_CHAR";
            }
            case 1536: {
                return "TYPE_SHORT";
            }
            case 1792: {
                return "TYPE_INT";
            }
            case 2048: {
                return "TYPE_LONG";
            }
            case 2304: {
                return "TYPE_FLOAT";
            }
            case 2560: {
                return "TYPE_DOUBLE";
            }
        }
        throw new IllegalArgumentException(Common.getMessage("UnknownType_msg", new Integer(type)));
    }

    public static String dumpHex(String v) {
        String s;
        if (v != null) {
            s = "hex[ ";
            byte[] b = v.getBytes();
            int i = 0;
            while (i < b.length) {
                s = s + Integer.toHexString(b[i]) + " ";
                ++i;
            }
            s = s + "]";
        } else {
            s = "<null>";
        }
        return s;
    }

    public static String constName(String name) {
        return name.replace('-', '_').toUpperCase();
    }

    public static String convertName(String name) {
        return Common.convertName(name, true);
    }

    public static String convertNameInstance(String name) {
        return Common.convertName(name, false);
    }

    private static String convertName(String name, boolean up) {
        StringBuffer n = new StringBuffer();
        boolean keepCase = false;
        StringCharacterIterator ci = new StringCharacterIterator(name);
        char c = ci.first();
        while (c != '\uffff') {
            if (Character.isLowerCase(c)) {
                keepCase = true;
                break;
            }
            c = ci.next();
        }
        c = ci.first();
        while (c != '\uffff') {
            if (c == '-' || c == '_' || !Character.isJavaIdentifierPart(c)) {
                up = true;
            } else {
                if (up) {
                    c = Character.toUpperCase(c);
                } else if (!keepCase) {
                    c = Character.toLowerCase(c);
                }
                n.append(c);
                up = false;
            }
            c = ci.next();
        }
        return n.toString();
    }

    public static Object getComparableObject(Object obj) {
        Object ret = obj;
        if (obj instanceof String) {
            String s = (String)obj;
            ret = s.trim();
        }
        return ret;
    }

    public static Object defaultScalarValue(int type) {
        switch (type & 0xFF00) {
            case 256: {
                return "";
            }
            case 3840: {
                return "";
            }
            case 768: {
                return Boolean.FALSE;
            }
            case 1024: {
                return new Byte(0);
            }
            case 1280: {
                return new Character('\u0000');
            }
            case 1536: {
                return new Short(0);
            }
            case 1792: {
                return new Integer(0);
            }
            case 2048: {
                return new Long(0L);
            }
            case 2304: {
                return new Float(0.0);
            }
            case 2560: {
                return new Double(0.0);
            }
        }
        throw new IllegalArgumentException(Common.getMessage("UnknownType_msg", new Integer(type)));
    }

    public static String getMessage(String key) {
        return Common.getMessage(key, null);
    }

    public static String getMessage(String key, Object p1) {
        return Common.getMessage(key, new Object[]{p1});
    }

    public static String getMessage(String key, int p1) {
        return Common.getMessage(key, new Object[]{new Integer(p1)});
    }

    public static String getMessage(String key, Object p1, Object p2) {
        return Common.getMessage(key, new Object[]{p1, p2});
    }

    public static String getMessage(String key, Object p1, Object p2, Object p3) {
        return Common.getMessage(key, new Object[]{p1, p2, p3});
    }

    public static String getMessage(String key, Object[] args) {
        ResourceBundle rb = null;
        if (rb == null) {
            try {
                rb = ResourceBundle.getBundle(rbName, Locale.getDefault(), (class$org$netbeans$modules$schema2beans$Common == null ? (class$org$netbeans$modules$schema2beans$Common = Common.class$("org.netbeans.modules.schema2beans.Common")) : class$org$netbeans$modules$schema2beans$Common).getClassLoader());
            }
            catch (MissingResourceException e) {
                System.err.println("Couldn't find the bundle " + rbName + " for the locale " + Locale.getDefault());
            }
        }
        if (rb != null) {
            if (args != null) {
                return MessageFormat.format(rb.getString(key), args);
            }
            return rb.getString(key);
        }
        String p = " ";
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                p = args[i] != null ? p + args[i].toString() + " " : p + "null ";
                ++i;
            }
        }
        return key + p;
    }

    static String instanceToString(int instance) {
        switch (instance) {
            case 16: {
                return "optional";
            }
            case 48: {
                return "an array, possibly empty";
            }
            case 64: {
                return "an array containing at least one element";
            }
        }
        return "mandatory";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

