/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JavaBeansUtil {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    private JavaBeansUtil() {
    }

    public static void writeBeanProperty(Object obj, Writer out, String propertyName) throws IOException, IntrospectionException {
        XmlBeanWriter beanOut = new XmlBeanWriter(out);
        JavaBeansUtil.writeBeanProperty(obj, beanOut, propertyName);
    }

    public static void writeBeanProperty(Object obj, BeanWriter out, String propertyName) throws IOException, IntrospectionException {
        JavaBeansUtil.writeBeanProperty(obj, out, new HashMap(), propertyName);
    }

    public static void writeBeanProperty(Object obj, BeanWriter out, Map skipChildren, String propertyName) throws IOException, IntrospectionException {
        if (obj == null) {
            return;
        }
        out.beginPropertyName(propertyName);
        if (!JavaBeansUtil.isJavaBeanType(obj.getClass())) {
            out.writeLeafObject(obj);
        } else {
            out.beginInnerNode();
            JavaBeansUtil.writeBean(obj, out, skipChildren);
            out.endInnerNode();
        }
        out.endPropertyName(propertyName);
    }

    public static void writeBean(Object obj, Writer out) throws IOException, IntrospectionException {
        XmlBeanWriter beanOut = new XmlBeanWriter(out);
        JavaBeansUtil.writeBean(obj, beanOut);
    }

    public static void writeBean(Object obj, BeanWriter out) throws IOException, IntrospectionException {
        JavaBeansUtil.writeBean(obj, out, new HashMap());
    }

    public static void writeBean(Object obj, BeanWriter out, Map skipChildren) throws IOException, IntrospectionException {
        if (obj == null) {
            return;
        }
        if (skipChildren.containsKey(obj)) {
            return;
        }
        skipChildren.put(obj, null);
        Class<?> objCls = obj.getClass();
        BeanInfo bi = Introspector.getBeanInfo(objCls);
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        int i = 0;
        while (i < pds.length) {
            PropertyDescriptor pd = pds[i];
            Method reader = pd.getReadMethod();
            if (reader != null) {
                Class<?> propertyType = pd.getPropertyType();
                String propertyName = pd.getName();
                Class<?> declaringClass = reader.getDeclaringClass();
                if (!declaringClass.equals(class$java$lang$Object == null ? JavaBeansUtil.class$("java.lang.Object") : class$java$lang$Object) && propertyType != null) {
                    Object childObj = null;
                    try {
                        childObj = reader.invoke(obj, null);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    if (childObj != null) {
                        if (childObj instanceof Collection) {
                            Iterator it = ((Collection)childObj).iterator();
                            while (it.hasNext()) {
                                Object childElement = it.next();
                                JavaBeansUtil.writeBeanProperty(childElement, out, skipChildren, propertyName);
                            }
                        } else if (childObj.getClass().isArray()) {
                            int size = Array.getLength(childObj);
                            int j = 0;
                            while (j < size) {
                                Object childElement = Array.get(childObj, j);
                                JavaBeansUtil.writeBeanProperty(childElement, out, skipChildren, propertyName);
                                ++j;
                            }
                        } else {
                            JavaBeansUtil.writeBeanProperty(childObj, out, skipChildren, propertyName);
                        }
                    }
                }
            }
            ++i;
        }
        skipChildren.remove(obj);
    }

    public static Object readBean(Class cls, InputStream in) throws ParserConfigurationException, SAXException, IOException, IntrospectionException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor construct = cls.getConstructor(new Class[0]);
        Object newValue = construct.newInstance(new Object[0]);
        JavaBeansUtil.readBean(newValue, in);
        return newValue;
    }

    public static void readBean(Object obj, InputStream in) throws ParserConfigurationException, SAXException, IOException, IntrospectionException {
        JavaBeansUtil.readBean(obj, new InputSource(in), false, null, null);
    }

    public static void readBeanNoEntityResolver(Object obj, InputStream in) throws ParserConfigurationException, SAXException, IOException, IntrospectionException {
        JavaBeansUtil.readBean(obj, new InputSource(in), false, new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                ByteArrayInputStream bin = new ByteArrayInputStream(new byte[0]);
                return new InputSource(bin);
            }
        }, null);
    }

    public static void readBean(Object obj, InputSource in, boolean validate, EntityResolver er, ErrorHandler eh) throws ParserConfigurationException, SAXException, IOException, IntrospectionException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(validate);
        DocumentBuilder db = dbf.newDocumentBuilder();
        if (er != null) {
            db.setEntityResolver(er);
        }
        if (eh != null) {
            db.setErrorHandler(eh);
        }
        Document doc = db.parse(in);
        JavaBeansUtil.readBean(obj, doc);
    }

    public static Object readBean(Class cls, Document document) throws IntrospectionException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor construct = cls.getConstructor(new Class[0]);
        Object newValue = construct.newInstance(new Object[0]);
        JavaBeansUtil.readBean(newValue, document);
        return newValue;
    }

    public static void readBean(Object obj, Document document) throws IntrospectionException {
        JavaBeansUtil.readBean(obj, document.getDocumentElement());
    }

    public static void readBean(Object obj, Node node) throws IntrospectionException {
        Class<?> propertyType;
        if (obj == null) {
            return;
        }
        int errorCount = 0;
        Class<?> objCls = obj.getClass();
        BeanInfo bi = Introspector.getBeanInfo(objCls);
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        HashMap<String, Method> propertyWriters = new HashMap<String, Method>();
        HashMap propertyTypes = new HashMap();
        int i = 0;
        while (i < pds.length) {
            PropertyDescriptor pd = pds[i];
            Method writer = pd.getWriteMethod();
            if (writer != null) {
                Class<?> propertyType2 = pd.getPropertyType();
                String propertyName = pd.getName();
                Class<?> declaringClass = writer.getDeclaringClass();
                if (declaringClass != null && !declaringClass.equals(class$java$lang$Object == null ? JavaBeansUtil.class$("java.lang.Object") : class$java$lang$Object) && propertyType2 != null) {
                    propertyWriters.put(propertyName, writer);
                    propertyTypes.put(propertyName, propertyType2);
                }
            }
            ++i;
        }
        HashMap<String, Object> propertiesNewValues = new HashMap<String, Object>();
        if (node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            int i2 = 0;
            while (i2 < attrs.getLength()) {
                Attr attr = (Attr)attrs.item(i2);
                String attrName = attr.getName();
                if (!(propertyWriters.containsKey(attrName) || propertyWriters.containsKey(attrName = Common.convertName(attrName)) || propertyWriters.containsKey(attrName = Introspector.decapitalize(attrName)))) {
                    ++errorCount;
                    System.out.println("Found attribute and did not find property in Java Bean: " + attr.getName());
                } else {
                    Object newValue = JavaBeansUtil.convertValue((Class)propertyTypes.get(attrName), attr.getValue());
                    propertiesNewValues.put(attrName, newValue);
                }
                ++i2;
            }
        }
        NodeList children = node.getChildNodes();
        int i3 = 0;
        int size = children.getLength();
        while (i3 < size) {
            Node childNode = children.item(i3);
            if (childNode instanceof Element) {
                String childNodeName;
                String string = childNodeName = childNode.getLocalName() == null ? childNode.getNodeName().intern() : childNode.getLocalName().intern();
                if (!(propertyWriters.containsKey(childNodeName) || propertyWriters.containsKey(childNodeName = Common.convertName(childNodeName)) || propertyWriters.containsKey(childNodeName = Introspector.decapitalize(childNodeName)))) {
                    ++errorCount;
                    System.out.println("Found element and did not find property in Java Bean: " + childNode.getNodeName());
                } else {
                    propertyType = (Class)propertyTypes.get(childNodeName);
                    Object newValue = null;
                    if (JavaBeansUtil.isJavaBeanType(propertyType)) {
                        Class<?> propertyTypeOnce = propertyType;
                        if (propertyType.isArray()) {
                            propertyTypeOnce = propertyType.getComponentType();
                        }
                        try {
                            Constructor<?> construct = propertyTypeOnce.getConstructor(new Class[0]);
                            newValue = construct.newInstance(new Object[0]);
                            JavaBeansUtil.readBean(newValue, childNode);
                        }
                        catch (NoSuchMethodException e) {
                            e.printStackTrace();
                            ++errorCount;
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                            ++errorCount;
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                            ++errorCount;
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                            ++errorCount;
                        }
                    } else {
                        String nodeValue = childNode.getFirstChild() == null ? "" : childNode.getFirstChild().getNodeValue();
                        Class<?> typeOfNewValue = propertyType;
                        if (propertyType.isArray()) {
                            typeOfNewValue = propertyType.getComponentType();
                        }
                        newValue = JavaBeansUtil.convertValue(typeOfNewValue, nodeValue);
                    }
                    if (propertyType.isArray()) {
                        ArrayList<Object> values = (ArrayList<Object>)propertiesNewValues.get(childNodeName);
                        if (values == null) {
                            values = new ArrayList<Object>();
                            propertiesNewValues.put(childNodeName, values);
                        }
                        values.add(newValue);
                    } else {
                        propertiesNewValues.put(childNodeName, newValue);
                    }
                }
            }
            ++i3;
        }
        Iterator it = propertiesNewValues.keySet().iterator();
        while (it.hasNext()) {
            Object newValue;
            String propertyName = (String)it.next();
            propertyType = (Class<?>)propertyTypes.get(propertyName);
            Method writer = (Method)propertyWriters.get(propertyName);
            if (propertyType.isArray()) {
                List values = (List)propertiesNewValues.get(propertyName);
                newValue = Array.newInstance(propertyType.getComponentType(), values.size());
                int i4 = 0;
                while (i4 < values.size()) {
                    Array.set(newValue, i4, values.get(i4));
                    ++i4;
                }
            } else {
                newValue = propertiesNewValues.get(propertyName);
            }
            try {
                writer.invoke(obj, newValue);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                ++errorCount;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                ++errorCount;
            }
        }
    }

    public static void copyBean(Object src, Object dest) throws IntrospectionException {
        JavaBeansUtil.copyBean(src, dest, Collections.EMPTY_MAP);
    }

    public static void copyBean(Object src, Object dest, Map nameMapping) throws IntrospectionException {
        if (src == null) {
            return;
        }
        Class<?> srcCls = src.getClass();
        BeanInfo bi = Introspector.getBeanInfo(srcCls);
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        HashMap<String, Method> propertyReaders = new HashMap<String, Method>();
        HashMap propertyTypes = new HashMap();
        int i = 0;
        while (i < pds.length) {
            PropertyDescriptor pd = pds[i];
            Method reader = pd.getReadMethod();
            if (reader != null) {
                Class<?> propertyType = pd.getPropertyType();
                String propertyName = pd.getName();
                Class<?> declaringClass = reader.getDeclaringClass();
                if (declaringClass != null && !declaringClass.equals(class$java$lang$Object == null ? JavaBeansUtil.class$("java.lang.Object") : class$java$lang$Object) && propertyType != null) {
                    if (nameMapping.containsKey(propertyName)) {
                        propertyName = (String)nameMapping.get(propertyName);
                    }
                    propertyReaders.put(propertyName, reader);
                    propertyTypes.put(propertyName, propertyType);
                }
            }
            ++i;
        }
        Class<?> destCls = dest.getClass();
        bi = Introspector.getBeanInfo(destCls);
        pds = bi.getPropertyDescriptors();
        int i2 = 0;
        while (i2 < pds.length) {
            PropertyDescriptor pd = pds[i2];
            Method writer = pd.getWriteMethod();
            if (writer != null) {
                Class<?> propertyType = pd.getPropertyType();
                String propertyName = pd.getName();
                Class<?> declaringClass = writer.getDeclaringClass();
                if (declaringClass != null && !declaringClass.equals(class$java$lang$Object == null ? JavaBeansUtil.class$("java.lang.Object") : class$java$lang$Object) && propertyType != null && propertyReaders.containsKey(propertyName)) {
                    try {
                        Method reader = (Method)propertyReaders.get(propertyName);
                        Object srcValue = reader.invoke(src, null);
                        if (JavaBeansUtil.isJavaBeanType(propertyType)) {
                            Class<?> propertyTypeOnce = propertyType;
                            int size = 1;
                            Object destValue = null;
                            if (propertyType.isArray()) {
                                propertyTypeOnce = propertyType.getComponentType();
                                size = Array.getLength(srcValue);
                                destValue = Array.newInstance(propertyTypeOnce, size);
                            }
                            int index = 0;
                            while (index < size) {
                                Object srcValueOnce;
                                Constructor<?> construct = propertyTypeOnce.getConstructor(new Class[0]);
                                Object destValueOnce = construct.newInstance(new Object[0]);
                                if (propertyType.isArray()) {
                                    Array.set(destValue, index, destValueOnce);
                                    srcValueOnce = Array.get(srcValue, index);
                                } else {
                                    destValue = destValueOnce;
                                    srcValueOnce = srcValue;
                                }
                                JavaBeansUtil.copyBean(srcValueOnce, destValueOnce, nameMapping);
                                ++index;
                            }
                            writer.invoke(dest, destValue);
                        } else if (propertyType.isAssignableFrom((Class)propertyTypes.get(propertyName))) {
                            writer.invoke(dest, srcValue);
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i2;
        }
    }

    public static boolean isJavaBeanType(Class type) {
        if (type.isArray()) {
            return JavaBeansUtil.isJavaBeanType(type.getComponentType());
        }
        String typeName = type.getName().intern();
        return typeName != "java.lang.String" && typeName != "java.lang.Integer" && typeName != "int" && typeName != "java.lang.Character" && typeName != "char" && typeName != "java.lang.Long" && typeName != "long" && typeName != "java.lang.Float" && typeName != "float" && typeName != "java.lang.Double" && typeName != "double" && typeName != "java.lang.Boolean" && typeName != "boolean" && typeName != "java.lang.Short" && typeName != "short" && typeName != "java.lang.Byte" && typeName != "byte" && typeName != "java.math.BigDecimal" && typeName != "java.math.BigInteger" && typeName != "java.lang.Object" && typeName != "java.util.Calendar" && typeName != "java.util.Date" && typeName != "java.util.GregorianCalendar" && typeName != "javax.xml.namespace.QName" && typeName != "java.net.URL" && typeName != "java.net.URI";
    }

    public static Object convertValue(Class type, String value) {
        String typeName = type.getName().intern();
        if (typeName == "java.lang.String") {
            return value;
        }
        if (typeName == "java.lang.Boolean" || typeName == "boolean") {
            return Boolean.valueOf(value);
        }
        if (typeName == "java.lang.Integer" || typeName == "int") {
            return Integer.valueOf(value);
        }
        if (typeName == "java.lang.Long" || typeName == "long") {
            return Long.valueOf(value);
        }
        if (typeName == "java.lang.Float" || typeName == "float") {
            return Float.valueOf(value);
        }
        if (typeName == "java.lang.Double" || typeName == "double") {
            return Double.valueOf(value);
        }
        if (typeName == "java.lang.Byte" || typeName == "byte") {
            return Byte.valueOf(value);
        }
        if (typeName == "java.lang.Short" || typeName == "short") {
            return Short.valueOf(value);
        }
        if (typeName == "java.lang.Character" || typeName == "char") {
            return new Character(value.charAt(0));
        }
        if (typeName == "java.net.URL") {
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        if (typeName == "java.math.BigDecimal") {
            return new BigDecimal(value);
        }
        if (typeName == "java.math.BigInteger") {
            return new BigInteger(value);
        }
        if (typeName == "java.util.Calendar") {
            TimeZone tz = TimeZone.getDefault();
            Calendar cal = Calendar.getInstance(tz);
            Date date = null;
            String[] possibleFormats = new String[]{"yyyy-MM-dd'T'HH:mm:ss.S", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd"};
            ParsePosition pos = null;
            int formatNum = 0;
            while (formatNum < possibleFormats.length) {
                pos = new ParsePosition(0);
                SimpleDateFormat formatter = new SimpleDateFormat(possibleFormats[formatNum]);
                formatter.setCalendar(cal);
                date = formatter.parse(value, pos);
                if (date != null) break;
                ++formatNum;
            }
            if (date == null) {
                throw new RuntimeException(Common.getMessage("MSG_BadParse", value));
            }
            cal.setTime(date);
            return cal;
        }
        Constructor c = null;
        try {
            Class[] cc = new Class[]{class$java$lang$String == null ? (class$java$lang$String = JavaBeansUtil.class$("java.lang.String")) : class$java$lang$String};
            c = type.getDeclaredConstructor(cc);
            Object[] p = new Object[]{value};
            return c.newInstance(p);
        }
        catch (NoSuchMethodException me) {
            me.printStackTrace();
            throw new RuntimeException(me.getMessage());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void genReadType(Writer out, String typeName) throws IOException {
        if ((typeName = typeName.intern()) == "java.util.Calendar") {
            out.write("public static java.util.Calendar stringToCalendar(String value) throws java.text.ParseException {\n");
            out.write("java.util.TimeZone tz = java.util.TimeZone.getDefault();\n");
            out.write("java.util.Calendar cal = java.util.Calendar.getInstance(tz);\n");
            out.write("java.util.Date date = null;\n");
            out.write("String[] possibleFormats = {\"yyyy-MM-dd'T'HH:mm:ss.S\", \"yyyy-MM-dd'T'HH:mm:ss\", \"yyyy-MM-dd\"};\t// NOI18N\n");
            out.write("java.text.ParsePosition pos = null;\n");
            out.write("for (int formatNum = 0; formatNum < possibleFormats.length; ++formatNum) {\n");
            out.write("pos = new java.text.ParsePosition(0);\n");
            out.write("java.text.SimpleDateFormat formatter = new java.text.SimpleDateFormat(possibleFormats[formatNum]);\n");
            out.write("formatter.setCalendar(cal);\n");
            out.write("date = formatter.parse(value, pos);\n");
            out.write("if (date != null) {\n");
            out.write("break;\n");
            out.write("}\n");
            out.write("}\n");
            out.write("if (date == null) {\n");
            out.write("throw new java.text.ParseException(\"Bad time/date parse of \"+value, pos.getErrorIndex());\n");
            out.write("}\n");
            out.write("int len = value.length();\n");
            out.write("if (pos.getIndex() < len) {\n");
            out.write("if (value.charAt(pos.getIndex()) == 'Z') {\n");
            out.write("// The Timezone is UTC\n");
            out.write("tz = java.util.TimeZone.getTimeZone(\"GMT\");\n");
            out.write("cal.setTimeZone(tz);\n");
            out.write("} else {\n");
            out.write("tz = java.util.TimeZone.getTimeZone(\"GMT\"+value.substring(pos.getIndex(), len));\n");
            out.write("cal.setTimeZone(tz);\n");
            out.write("}\n");
            out.write("}\n");
            out.write("cal.setTime(date);\n");
            out.write("return cal;\n");
            out.write("}\n");
        }
    }

    public static void genWriteType(Writer out, String typeName) throws IOException {
        if ((typeName = typeName.intern()) == "java.util.Calendar") {
            out.write("public static String calendarToString(java.util.Calendar cal) {\n");
            out.write("java.util.Date date = cal.getTime();\n");
            out.write("java.text.SimpleDateFormat formatter;\n");
            out.write("if (cal.get(java.util.Calendar.HOUR) == 0 && cal.get(java.util.Calendar.MINUTE) == 0 && cal.get(java.util.Calendar.SECOND) == 0) {\n");
            out.write("formatter = new java.text.SimpleDateFormat(\"yyyy-MM-dd\");\t// NOI18N\n");
            out.write("} else if (cal.get(java.util.Calendar.MILLISECOND) == 0) {\n");
            out.write("formatter = new java.text.SimpleDateFormat(\"yyyy-MM-dd'T'HH:mm:ss\");\t// NOI18N\n");
            out.write("} else {\n");
            out.write("formatter = new java.text.SimpleDateFormat(\"yyyy-MM-dd'T'HH:mm:ss.S\");\t// NOI18N\n");
            out.write("}\n");
            out.write("String result = formatter.format(date);\n");
            out.write("if (java.util.TimeZone.getDefault().hasSameRules(cal.getTimeZone())) {\n");
            out.write("return result;\n");
            out.write("}\n");
            out.write("int offset = cal.getTimeZone().getOffset(0);\n");
            out.write("if (offset == 0) {\n");
            out.write("return result+\"Z\";\n");
            out.write("}\n");
            out.write("int seconds = offset / 1000;\n");
            out.write("if (seconds > 0) {\n");
            out.write("result += \"+\";\n");
            out.write("} else {\n");
            out.write("seconds = -1 * seconds;\n");
            out.write("result += \"-\";\n");
            out.write("}\n");
            out.write("int hours = seconds / 3600;\n");
            out.write("if (hours < 10) {\n");
            out.write("result += \"0\";\n");
            out.write("}\n");
            out.write("result += hours + \":\";\n");
            out.write("int minutes = (seconds / 60) % 60;\n");
            out.write("if (minutes < 10) {\n");
            out.write("result += \"0\";\n");
            out.write("}\n");
            out.write("result += minutes;\n");
            out.write("return result;\n");
            out.write("}\n");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class HtmlBeanWriter
    extends IndentingBeanWriter
    implements BeanWriter {
        protected Writer out;

        public HtmlBeanWriter(Writer out) {
            this.out = out;
        }

        public HtmlBeanWriter(Writer out, String indentBy) {
            super(indentBy);
            this.out = out;
        }

        public HtmlBeanWriter(Writer out, String indent, String indentBy) {
            super(indent, indentBy);
            this.out = out;
        }

        public void beginPropertyName(String propertyName) throws IOException {
            this.out.write(this.indent);
            this.out.write("<tr>");
            this.out.write("<th>" + propertyName + "</th>");
        }

        public void endPropertyName(String propertyName) throws IOException {
            this.out.write("</tr>");
            this.out.write("\n");
        }

        public void writeLeafObject(Object obj) throws IOException {
            this.out.write("<td>");
            XMLUtil.printXML(this.out, obj.toString(), false);
            this.out.write("</td>");
        }

        public void beginInnerNode() throws IOException {
            super.beginInnerNode();
            this.out.write("<td><table width=\"100%\" border=\"1\">");
            this.out.write("\n");
        }

        public void endInnerNode() throws IOException {
            super.endInnerNode();
            this.out.write(this.indent);
            this.out.write("</table></td>");
        }
    }

    public static class XmlBeanWriter
    extends IndentingBeanWriter
    implements BeanWriter {
        protected Writer out;

        public XmlBeanWriter(Writer out) {
            this.out = out;
        }

        public XmlBeanWriter(Writer out, String indentBy) {
            super(indentBy);
            this.out = out;
        }

        public XmlBeanWriter(Writer out, String indent, String indentBy) {
            super(indent, indentBy);
            this.out = out;
        }

        public void beginPropertyName(String propertyName) throws IOException {
            this.out.write(this.indent);
            this.out.write("<" + propertyName + ">");
        }

        public void endPropertyName(String propertyName) throws IOException {
            this.out.write("</" + propertyName + ">\n");
        }

        public void writeLeafObject(Object obj) throws IOException {
            XMLUtil.printXML(this.out, obj.toString(), false);
        }

        public void beginInnerNode() throws IOException {
            super.beginInnerNode();
            this.out.write("\n");
        }

        public void endInnerNode() throws IOException {
            super.endInnerNode();
            this.out.write(this.indent);
        }
    }

    public static abstract class IndentingBeanWriter
    implements BeanWriter {
        protected String indentBy;
        protected String indent;
        protected int indentLevel = 0;
        protected List indentions;

        public IndentingBeanWriter() {
            this("", "\t");
        }

        public IndentingBeanWriter(String indentBy) {
            this("", indentBy);
        }

        public IndentingBeanWriter(String indent, String indentBy) {
            this.indent = indent;
            this.indentBy = indentBy;
            this.indentions = new ArrayList();
            this.indentions.add(indent);
        }

        public void beginInnerNode() throws IOException {
            ++this.indentLevel;
            int indentionsSize = this.indentions.size();
            if (indentionsSize <= this.indentLevel) {
                this.indent = (String)this.indentions.get(indentionsSize - 1);
                do {
                    this.indent = this.indent + this.indentBy;
                    this.indentions.add(this.indent);
                } while (++indentionsSize <= this.indentLevel);
            } else {
                this.indent = (String)this.indentions.get(this.indentLevel);
            }
        }

        public void endInnerNode() throws IOException {
            --this.indentLevel;
            this.indent = (String)this.indentions.get(this.indentLevel);
        }

        public abstract void writeLeafObject(Object var1) throws IOException;

        public abstract void endPropertyName(String var1) throws IOException;

        public abstract void beginPropertyName(String var1) throws IOException;
    }

    public static interface BeanWriter {
        public void beginPropertyName(String var1) throws IOException;

        public void endPropertyName(String var1) throws IOException;

        public void writeLeafObject(Object var1) throws IOException;

        public void beginInnerNode() throws IOException;

        public void endInnerNode() throws IOException;
    }
}

