/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DataListRestriction;
import org.netbeans.modules.schema2beans.DocDefHandler;
import org.netbeans.modules.schema2beans.GenBeans;
import org.netbeans.modules.schema2beans.GeneralParser;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansNestedException;
import org.netbeans.modules.schema2beans.SchemaParser;
import org.netbeans.modules.schema2beans.SchemaRep;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLSchemaParser
extends GeneralParser
implements SchemaParser {
    private DocDefHandler handler;
    private boolean debug;
    private GenBeans.Config config = null;
    private Stack parentTypes = new Stack();
    private String lastDefinedType = null;
    private boolean lastDefinedExternalType = true;
    SchemaRep schema;
    static /* synthetic */ Class class$org$netbeans$modules$schema2beans$SchemaRep$Restriction;
    static /* synthetic */ Class class$org$netbeans$modules$schema2beans$SchemaRep$SimpleType;
    static /* synthetic */ Class class$org$netbeans$modules$schema2beans$SchemaRep$SimpleContent;
    static /* synthetic */ Class class$org$netbeans$modules$schema2beans$SchemaRep$Documentation;
    static /* synthetic */ Class class$org$netbeans$modules$schema2beans$SchemaRep$AppInfo;
    static /* synthetic */ Class class$org$netbeans$modules$schema2beans$SchemaRep$TextNode;

    public XMLSchemaParser(GenBeans.Config config, DocDefHandler handler) {
        this.config = config;
        this.filename = config.filename;
        this.schemaIn = config.fileIn;
        this.handler = handler;
        this.debug = config.getTraceParse();
    }

    public void process() throws IOException, Schema2BeansException {
        this.startupReader();
        try {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setIgnoringComments(true);
                dbf.setIgnoringElementContentWhitespace(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document xmlSchema = db.parse(new InputSource(this.reader));
                this.schema = new SchemaRep(xmlSchema, this.getReaderURI());
                SchemaRep.debug = this.debug;
            }
            catch (ParserConfigurationException e) {
                throw new Schema2BeansNestedException(Common.getMessage("MSG_FailedToParse", this.filename), e);
            }
            catch (SAXException e) {
                throw new Schema2BeansNestedException(Common.getMessage("MSG_FailedToParse", this.filename), e);
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.shutdownReader();
            throw throwable;
        }
        this.shutdownReader();
        if (this.debug) {
            PrintWriter pw = new PrintWriter(this.config.messageOut);
            this.schema.writeXMLSchemaStandalone(pw);
            pw.flush();
        }
        this.schema.optimize();
        this.handler.startDocument(this.config.docroot);
        this.process(this.schema.getRootElement());
        this.handler.endDocument();
    }

    protected void process(SchemaRep.ElementExpr ee) throws Schema2BeansException {
        if (ee instanceof SchemaRep.Element) {
            this.processElement((SchemaRep.Element)ee);
        } else if (ee instanceof SchemaRep.ComplexType) {
            this.processComplexType((SchemaRep.ComplexType)ee);
        } else if (ee instanceof SchemaRep.SimpleType) {
            this.processSimpleType((SchemaRep.SimpleType)ee);
        } else if (ee instanceof SchemaRep.Restriction) {
            this.processRestriction((SchemaRep.Restriction)ee);
        } else if (ee instanceof SchemaRep.SchemaNode) {
            this.processSchemaNode((SchemaRep.SchemaNode)ee);
        } else if (ee instanceof SchemaRep.ElementInformationItem) {
            if (!this.parentTypes.empty()) {
                this.handler.addExtraDataNode((String)this.parentTypes.peek(), ee);
            }
        } else if (!(ee instanceof SchemaRep.RestrictionType)) {
            if (ee instanceof SchemaRep.ModelGroup) {
                this.processModelGroup((SchemaRep.ModelGroup)ee);
            } else if (ee instanceof SchemaRep.Annotation) {
                this.processAnnotation((SchemaRep.Annotation)ee);
            } else if (ee instanceof SchemaRep.Extension) {
                this.processExtension((SchemaRep.Extension)ee);
            } else if (ee instanceof SchemaRep.ContainsSubElements) {
                this.processContainsSubElements((SchemaRep.ContainsSubElements)ee);
            } else {
                this.config.messageOut.println("XMLSchemaPraser.process: Hit unknown ElementExpr: " + ee);
            }
        }
    }

    protected void processContainsSubElements(SchemaRep.ContainsSubElements cse) throws Schema2BeansException {
        Iterator it = cse.subElementsIterator();
        while (it.hasNext()) {
            SchemaRep.ElementExpr childee = (SchemaRep.ElementExpr)it.next();
            this.process(childee);
        }
    }

    protected void processElement(SchemaRep.Element el) throws Schema2BeansException {
        String javaType;
        SchemaRep.ElementExpr schemaTypeDef;
        boolean definedInSubElements;
        this.setLastDefined("{http://www.w3.org/2001/XMLSchema}boolean", true);
        String name = el.getElementName();
        SchemaRep.Restriction restrict = null;
        boolean externalType = false;
        String schemaType = el.getRef() == null ? el.getXMLSchemaType() : (name = el.getRef());
        if (this.debug) {
            this.config.messageOut.println("processElement (start: elementName=" + name);
        }
        if (name == null) {
            this.config.messageOut.println("WARNING: elementName is null.");
        }
        if (schemaType == null) {
            definedInSubElements = true;
            schemaType = name;
        } else {
            definedInSubElements = false;
        }
        String fullSchemaType = this.schema.resolveNamespace(schemaType);
        String defaultValue = el.getDefault();
        if (this.debug) {
            this.config.messageOut.println("processElement: name=" + name + " schemaType=" + schemaType + " fullSchemaType=" + fullSchemaType + " definedInSubElements=" + definedInSubElements);
        }
        if (!definedInSubElements) {
            SchemaRep.ContainsSubElements cse;
            String foundDefault;
            schemaTypeDef = this.schema.getSchemaTypeDef(schemaType);
            if (schemaTypeDef instanceof SchemaRep.ContainsSubElements && (foundDefault = this.lookForDefault(restrict = this.lookForRestriction(cse = (SchemaRep.ContainsSubElements)schemaTypeDef))) != null) {
                defaultValue = foundDefault;
            }
            javaType = null;
            if (schemaTypeDef instanceof SchemaRep.HasJavaTypeName) {
                javaType = ((SchemaRep.HasJavaTypeName)((Object)schemaTypeDef)).getJavaTypeName();
            }
            this.handler.element(el.getFullContentName(), fullSchemaType, name, XMLSchemaParser.getInstanceValue(el.getMinOccurs(), el.getMaxOccurs()), externalType, defaultValue);
            if (javaType != null) {
                this.handler.javaType(el.getFullContentName(), fullSchemaType, javaType);
                if (this.parentTypes.isEmpty()) {
                    String mySchemaType = this.schema.resolveNamespace(name);
                    this.handler.javaType(el.getFullContentName(), mySchemaType, javaType);
                }
            }
        } else {
            restrict = this.lookForRestriction(el);
        }
        this.parentTypes.push(fullSchemaType);
        this.processContainsSubElements(el);
        this.parentTypes.pop();
        if (definedInSubElements) {
            if (!this.parentTypes.isEmpty()) {
                String foundDefault;
                if (restrict != null && (foundDefault = this.lookForDefault(restrict)) != null) {
                    defaultValue = foundDefault;
                }
                this.handler.element(el.getFullContentName(), this.lastDefinedType, name, XMLSchemaParser.getInstanceValue(el.getMinOccurs(), el.getMaxOccurs()), this.lastDefinedExternalType, defaultValue);
            }
            if ((schemaTypeDef = this.schema.getSchemaTypeDefResolvedNamespace(this.lastDefinedType)) instanceof SchemaRep.HasJavaTypeName && (javaType = ((SchemaRep.HasJavaTypeName)((Object)schemaTypeDef)).getJavaTypeName()) != null) {
                this.handler.javaType(el.getFullContentName(), this.lastDefinedType, javaType);
            }
        }
        if (restrict != null) {
            Iterator it = restrict.subElementsIterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof SchemaRep.RestrictionType)) continue;
                this.handler.addExtraDataCurLink(o);
            }
        }
        if (!"1".equals(el.getMaxOccurs()) && !"unbounded".equals(el.getMaxOccurs())) {
            this.handler.addExtraDataCurLink(new MaxOccursRestriction(el.getMaxOccurs()));
        }
        if (!"1".equals(el.getMinOccurs()) && !"0".equals(el.getMinOccurs())) {
            this.handler.addExtraDataCurLink(new MinOccursRestriction(el.getMinOccurs()));
        }
        if (this.debug) {
            this.config.messageOut.println("processElement finish): elementName=" + name);
        }
    }

    protected SchemaRep.Restriction lookForRestriction(SchemaRep.ContainsSubElements schemaTypeDef) {
        if (schemaTypeDef instanceof SchemaRep.SimpleType || schemaTypeDef instanceof SchemaRep.SimpleContent) {
            return (SchemaRep.Restriction)schemaTypeDef.findSubElement(class$org$netbeans$modules$schema2beans$SchemaRep$Restriction == null ? (class$org$netbeans$modules$schema2beans$SchemaRep$Restriction = XMLSchemaParser.class$("org.netbeans.modules.schema2beans.SchemaRep$Restriction")) : class$org$netbeans$modules$schema2beans$SchemaRep$Restriction);
        }
        if (schemaTypeDef instanceof SchemaRep.Element) {
            return this.lookForRestriction((SchemaRep.ContainsSubElements)schemaTypeDef.findSubElement(class$org$netbeans$modules$schema2beans$SchemaRep$SimpleType == null ? (class$org$netbeans$modules$schema2beans$SchemaRep$SimpleType = XMLSchemaParser.class$("org.netbeans.modules.schema2beans.SchemaRep$SimpleType")) : class$org$netbeans$modules$schema2beans$SchemaRep$SimpleType));
        }
        if (schemaTypeDef instanceof SchemaRep.ComplexType) {
            return this.lookForRestriction((SchemaRep.ContainsSubElements)schemaTypeDef.findSubElement(class$org$netbeans$modules$schema2beans$SchemaRep$SimpleContent == null ? (class$org$netbeans$modules$schema2beans$SchemaRep$SimpleContent = XMLSchemaParser.class$("org.netbeans.modules.schema2beans.SchemaRep$SimpleContent")) : class$org$netbeans$modules$schema2beans$SchemaRep$SimpleContent));
        }
        return null;
    }

    protected void processComplexType(SchemaRep.ComplexType el) throws Schema2BeansException {
        String name = el.getTypeName();
        if (this.debug) {
            this.config.messageOut.println("processComplexType: el=" + el);
        }
        if (name == null) {
            if (this.debug) {
                this.config.messageOut.println("Found unnamed complexType.");
            }
            if (!this.parentTypes.isEmpty()) {
                name = (String)this.parentTypes.peek();
            }
            if (name == null) {
                name = el.getFullContentName();
            }
        } else {
            name = this.schema.resolveNamespace(name);
        }
        this.parentTypes.push(name);
        this.handler.startElement(el.getFullContentName(), name, 2);
        Iterator it = el.subElementsIterator();
        while (it.hasNext()) {
            SchemaRep.ElementExpr childee = (SchemaRep.ElementExpr)it.next();
            if (childee instanceof SchemaRep.ModelGroup) {
                this.processModelGroup((SchemaRep.ModelGroup)childee);
                continue;
            }
            if (childee instanceof SchemaRep.Attribute) {
                this.processAttribute(name, (SchemaRep.Attribute)childee);
                continue;
            }
            if (childee instanceof SchemaRep.AttributeGroup) {
                this.processAttributeGroup(name, (SchemaRep.AttributeGroup)childee);
                continue;
            }
            if (childee instanceof SchemaRep.SimpleContent) {
                this.processSimpleContent((SchemaRep.SimpleContent)childee);
                continue;
            }
            if (childee instanceof SchemaRep.Annotation) {
                this.processAnnotation((SchemaRep.Annotation)childee);
                continue;
            }
            if (childee instanceof SchemaRep.ComplexContent) {
                this.processComplexContent((SchemaRep.ComplexContent)childee);
                continue;
            }
            this.config.messageOut.println("processComplexType: Unfamiliar subelement: " + childee);
        }
        this.handler.endElement();
        this.parentTypes.pop();
        this.setLastDefined(name, false);
    }

    protected void processComplexContent(SchemaRep.ComplexContent el) throws Schema2BeansException {
        Iterator it = el.subElementsIterator();
        while (it.hasNext()) {
            SchemaRep.ElementExpr childee = (SchemaRep.ElementExpr)it.next();
            if (childee instanceof SchemaRep.Extension) {
                this.processExtension((SchemaRep.Extension)childee);
                continue;
            }
            if (childee instanceof SchemaRep.Restriction) {
                this.processRestriction((SchemaRep.Restriction)childee);
                continue;
            }
            if (childee instanceof SchemaRep.Annotation) {
                this.processAnnotation((SchemaRep.Annotation)childee);
                continue;
            }
            this.config.messageOut.println("processComplexContent: Unfamiliar subelement: " + childee);
        }
    }

    protected void processSimpleContent(SchemaRep.SimpleContent el) throws Schema2BeansException {
        this.processContainsSubElements(el);
    }

    protected void processExtension(SchemaRep.Extension el) throws Schema2BeansException {
        String javaType;
        String name = (String)this.parentTypes.peek();
        String base = el.getBase();
        SchemaRep.ElementExpr baseDef = this.schema.getSchemaTypeDef(base);
        if (baseDef instanceof SchemaRep.ContainsSubElements) {
            this.processContainsSubElements((SchemaRep.ContainsSubElements)baseDef);
        }
        if ((javaType = el.getJavaTypeName()) != null) {
            if (this.debug) {
                this.config.messageOut.println("Setting javatype of " + name + " to " + javaType);
            }
            this.handler.javaType(name, name, javaType);
        }
        Iterator it = el.subElementsIterator();
        while (it.hasNext()) {
            SchemaRep.ElementExpr childee = (SchemaRep.ElementExpr)it.next();
            if (childee instanceof SchemaRep.Attribute) {
                this.processAttribute(name, (SchemaRep.Attribute)childee);
                continue;
            }
            this.process(childee);
        }
    }

    protected void processModelGroup(SchemaRep.ModelGroup group) throws Schema2BeansException {
        if (this.debug) {
            this.config.messageOut.println("processModelGroup: group=" + group);
        }
        if (group instanceof SchemaRep.Group) {
            SchemaRep.Group grp = (SchemaRep.Group)group;
            if (grp.getRef() == null) {
                return;
            }
            SchemaRep.Group referredGroup = grp.getRefGroup();
            if (referredGroup == null) {
                this.config.messageOut.println(Common.getMessage("MSG_UnableToFind", "group", grp.getRef()));
            } else {
                this.processContainsSubElements(referredGroup);
            }
            return;
        }
        char separator = ' ';
        if (group instanceof SchemaRep.Sequence) {
            separator = ',';
        } else if (group instanceof SchemaRep.Choice) {
            separator = '|';
        }
        int groupInstance = XMLSchemaParser.getInstanceValue(group.getMinOccurs(), group.getMaxOccurs());
        this.handler.startGroupElements();
        boolean first = true;
        Iterator it = group.subElementsIterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                this.handler.character(separator);
            }
            SchemaRep.ElementExpr childee = (SchemaRep.ElementExpr)it.next();
            if (childee instanceof SchemaRep.Element) {
                this.processElement((SchemaRep.Element)childee);
                continue;
            }
            if (childee instanceof SchemaRep.ModelGroup) {
                this.processModelGroup((SchemaRep.ModelGroup)childee);
                continue;
            }
            if (childee instanceof SchemaRep.Annotation) continue;
            this.config.messageOut.println("processModelGroup: Unfamiliar subelement: " + childee);
        }
        this.handler.endGroupElements(groupInstance);
    }

    protected void processSimpleType(SchemaRep.SimpleType el) throws Schema2BeansException {
        if (this.debug) {
            this.config.messageOut.println("processSimpleType: el=" + el);
        }
        this.processContainsSubElements(el);
    }

    protected void processRestriction(SchemaRep.Restriction el) throws Schema2BeansException {
        this.setLastDefined(this.schema.resolveNamespace(el.getBase()), false);
        this.processContainsSubElements(el);
    }

    protected void processSchemaNode(SchemaRep.SchemaNode sn) throws Schema2BeansException {
        String tns = sn.getTargetNamespace();
        if (tns != null && !"".equals(tns)) {
            this.handler.setDefaultNamespace(tns);
        }
        this.processContainsSubElements(sn);
    }

    protected void setLastDefined(String typeName) {
        this.lastDefinedType = typeName;
        this.lastDefinedExternalType = false;
    }

    protected void setLastDefined(String typeName, boolean externalType) {
        this.lastDefinedType = typeName;
        this.lastDefinedExternalType = externalType;
    }

    protected void addTopAttributes(SchemaRep.Element parentElement, SchemaRep.Element el) {
        Iterator it = el.subElementsIterator();
        while (it.hasNext()) {
            SchemaRep.ElementExpr childee = (SchemaRep.ElementExpr)it.next();
            if (childee instanceof SchemaRep.Attribute || childee instanceof SchemaRep.AttributeGroup || !(childee instanceof SchemaRep.ComplexType)) continue;
            this.addTopAttributes(parentElement, (SchemaRep.ComplexType)childee);
        }
    }

    protected void addTopAttributes(SchemaRep.Element parentElement, SchemaRep.ComplexType el) {
        Iterator it = el.subElementsIterator();
        while (it.hasNext()) {
            SchemaRep.ElementExpr childee = (SchemaRep.ElementExpr)it.next();
            if (!(childee instanceof SchemaRep.Attribute) && !(childee instanceof SchemaRep.AttributeGroup)) continue;
        }
    }

    protected void processAttribute(String parentElement, SchemaRep.Attribute attr) {
        if (this.debug) {
            this.config.messageOut.println("processAttribute to " + parentElement + " attr=" + attr);
        }
        if (attr.getRef() != null) {
            SchemaRep.Attribute referredAttr = attr.getRefAttribute();
            if (referredAttr == null) {
                this.config.messageOut.println(Common.getMessage("MSG_UnableToFind", "attribute", attr.getRef()));
            } else {
                this.processAttribute(parentElement, referredAttr);
            }
            return;
        }
        String attributeName = attr.getAttributeName();
        boolean externalType = true;
        String attrType = attr.getJavaType();
        String schemaType = attr.getType();
        String defaultValue = attr.getDefaultValue();
        if (schemaType != null && defaultValue == null) {
            SchemaRep.ElementExpr ee = this.schema.getSchemaTypeDef(schemaType);
            if (ee instanceof SchemaRep.SimpleType) {
                SchemaRep.SimpleType st = (SchemaRep.SimpleType)ee;
                SchemaRep.Restriction restrict = (SchemaRep.Restriction)st.findSubElement("restriction");
                String foundDefault = this.lookForDefault(restrict);
                if (foundDefault != null) {
                    defaultValue = foundDefault;
                }
            } else {
                this.config.messageOut.println("Type for attribute " + attributeName + " is not simple enough: " + ee);
            }
        }
        int instance = defaultValue != null || attr.getFixed() != null || attr.isRequired() ? 32 : 16;
        this.handler.startElement(parentElement, parentElement, 3);
        this.handler.element(attr.getFullContentName(), attrType, attributeName, instance, externalType, defaultValue);
        this.handler.element("CDATA", instance);
        if (attr.getFixed() != null) {
            this.handler.element("#FIXED", instance);
            this.handler.element(attr.getFullContentName(), attrType, attr.getFixed(), instance, externalType, defaultValue);
        } else if (attr.isRequired()) {
            this.handler.element("#REQUIRED", instance);
        } else {
            this.handler.element("#IMPLIED", instance);
        }
        this.handler.javaType(attr.getFullContentName(), attr.getAttributeName(), attrType);
        this.handler.endElement();
    }

    protected String lookForDefault(SchemaRep.Restriction restrict) {
        if (restrict != null) {
            Iterator subelements = restrict.subElementsIterator();
            while (subelements.hasNext()) {
                Object rt = subelements.next();
                if (!(rt instanceof SchemaRep.Enumeration)) continue;
                String defaultValue = ((SchemaRep.Enumeration)rt).getValue();
                return defaultValue;
            }
        }
        return null;
    }

    protected void processAttributeGroup(String parentElement, SchemaRep.AttributeGroup attrGroup) {
        SchemaRep.AttributeGroup schemaTypeDef = (SchemaRep.AttributeGroup)this.schema.getSchemaTypeDef(attrGroup.getRef());
        if (this.debug) {
            this.config.messageOut.println("processAttributeGroup schemaTypeDef=" + schemaTypeDef);
        }
        if (schemaTypeDef == null) {
            throw new IllegalStateException("attributeGroup ref has reference to unknown name: " + attrGroup.getRef());
        }
        Iterator it = schemaTypeDef.subElementsIterator();
        while (it.hasNext()) {
            SchemaRep.ElementExpr childee = (SchemaRep.ElementExpr)it.next();
            if (childee instanceof SchemaRep.Attribute) {
                this.processAttribute(parentElement, (SchemaRep.Attribute)childee);
                continue;
            }
            if (!(childee instanceof SchemaRep.AttributeGroup)) continue;
            this.processAttributeGroup(parentElement, (SchemaRep.AttributeGroup)childee);
        }
    }

    protected void processAnnotation(SchemaRep.Annotation ann) throws Schema2BeansException {
        SchemaRep.AppInfo appInfo;
        SchemaRep.ElementExpr el;
        Iterator subelements;
        SchemaRep.Documentation doc = (SchemaRep.Documentation)ann.findSubElement(class$org$netbeans$modules$schema2beans$SchemaRep$Documentation == null ? (class$org$netbeans$modules$schema2beans$SchemaRep$Documentation = XMLSchemaParser.class$("org.netbeans.modules.schema2beans.SchemaRep$Documentation")) : class$org$netbeans$modules$schema2beans$SchemaRep$Documentation);
        String name = null;
        if (!this.parentTypes.isEmpty()) {
            name = (String)this.parentTypes.peek();
        }
        if (name == null) {
            return;
        }
        if (doc != null) {
            StringBuffer comment = new StringBuffer();
            subelements = doc.subElementsIterator();
            while (subelements.hasNext()) {
                el = (SchemaRep.ElementExpr)subelements.next();
                if (el instanceof SchemaRep.TextNode) {
                    comment.append(((SchemaRep.TextNode)el).getText());
                    continue;
                }
                if (!(el instanceof SchemaRep.AnyNode)) continue;
                ((SchemaRep.AnyNode)el).writeXMLSchema(comment, 0);
            }
            this.handler.setExtendedProperty(name, "comment", comment.toString());
        }
        if ((appInfo = (SchemaRep.AppInfo)ann.findSubElement(class$org$netbeans$modules$schema2beans$SchemaRep$AppInfo == null ? (class$org$netbeans$modules$schema2beans$SchemaRep$AppInfo = XMLSchemaParser.class$("org.netbeans.modules.schema2beans.SchemaRep$AppInfo")) : class$org$netbeans$modules$schema2beans$SchemaRep$AppInfo)) != null) {
            subelements = appInfo.subElementsIterator();
            while (subelements.hasNext()) {
                SchemaRep.TextNode value;
                el = (SchemaRep.ElementExpr)subelements.next();
                if (!(el instanceof SchemaRep.AnyNode)) continue;
                SchemaRep.AnyNode anyNode = (SchemaRep.AnyNode)el;
                if ("extends".equals(anyNode.getContentName())) {
                    value = (SchemaRep.TextNode)anyNode.findSubElement(class$org$netbeans$modules$schema2beans$SchemaRep$TextNode == null ? XMLSchemaParser.class$("org.netbeans.modules.schema2beans.SchemaRep$TextNode") : class$org$netbeans$modules$schema2beans$SchemaRep$TextNode);
                    if (value == null) continue;
                    this.handler.setExtendedProperty(name, "extends", value.getText());
                    continue;
                }
                if (!"implements".equals(anyNode.getContentName()) || (value = (SchemaRep.TextNode)anyNode.findSubElement(class$org$netbeans$modules$schema2beans$SchemaRep$TextNode == null ? XMLSchemaParser.class$("org.netbeans.modules.schema2beans.SchemaRep$TextNode") : class$org$netbeans$modules$schema2beans$SchemaRep$TextNode)) == null) continue;
                this.handler.setExtendedProperty(name, "implements", value.getText());
            }
        }
    }

    protected static int getInstanceValue(String minOccurs, String maxOccurs) {
        if (minOccurs == null) {
            minOccurs = "1";
        }
        if (maxOccurs == null) {
            maxOccurs = "1";
        }
        if (minOccurs.equals("0")) {
            if (maxOccurs.equals("1")) {
                return 16;
            }
            return 48;
        }
        if (maxOccurs.equals("1")) {
            return 32;
        }
        return 64;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MinOccursRestriction
    implements DataListRestriction {
        private String minOccurs;

        public MinOccursRestriction(String minOccurs) {
            this.minOccurs = minOccurs;
        }

        public void genRestriction(Writer out, String sizeExpr, String readMethod, String type, String failVar) throws IOException {
            out.write("if (" + sizeExpr + " < " + this.minOccurs + ") {\n");
            out.write(failVar + " = true;\n");
            out.write("}\n");
        }

        public String toString() {
            return "minOccurs (" + this.minOccurs + ")";
        }
    }

    public static class MaxOccursRestriction
    implements DataListRestriction {
        private String maxOccurs;

        public MaxOccursRestriction(String maxOccurs) {
            this.maxOccurs = maxOccurs;
        }

        public void genRestriction(Writer out, String sizeExpr, String readMethod, String type, String failVar) throws IOException {
            out.write("if (" + sizeExpr + " > " + this.maxOccurs + ") {\n");
            out.write(failVar + " = true;\n");
            out.write("}\n");
        }

        public String toString() {
            return "maxOccurs (" + this.maxOccurs + ")";
        }
    }
}

