/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.apache.tools.ant.module.loader.AntCompilerSupport;
import org.apache.tools.ant.module.run.AntExecutor;
import org.openide.ServiceType;
import org.openide.compiler.CompilerType;
import org.openide.execution.Executor;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileSystemCapability;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListener;

public class AntSettings
extends SystemOption
implements ChangeListener {
    public static final String PROP_VERBOSITY = "verbosity";
    public static final String PROP_PROPERTIES = "properties";
    public static final String PROP_SAVE_ALL = "saveAll";
    public static final String PROP_CUSTOM_DEFS = "customDefs";
    public static final String PROP_COMPILER = "compiler";
    public static final String PROP_EXECUTOR = "executor";
    public static final String PROP_REUSE_OUTPUT = "reuseOutput";
    public static final String PROP_ANT_VERSION = "antVersion";
    public static final String PROP_INPUT_HANDLER = "inputHandler";
    private static final String DEF_CLASS_PATH = "netbeans.class.path";
    private static final String DEF_BOOTCLASS_PATH = "netbeans.bootclass.path";
    private static final String DEF_LIBRARY_PATH = "netbeans.library.path";
    private static final String DEF_FILESYSTEMS_PATH = "netbeans.filesystems.path";
    private static final long serialVersionUID = -4457782585534082966L;
    static /* synthetic */ Class class$org$apache$tools$ant$module$run$AntExecutor;
    static /* synthetic */ Class class$org$apache$tools$ant$module$AntSettings;

    protected void initialize() {
        super.initialize();
        this.setVerbosity(2);
        Properties p = new Properties();
        p.setProperty("build.compiler.emacs", "true");
        p.setProperty("build.sysclasspath", "ignore");
        this.setProperties(p);
        this.setReuseOutput(false);
        this.setSaveAll(true);
        this.setCustomDefs(new IntrospectedInfo());
        this.setCompiler(AntCompilerSupport.NoCompiler.NO_COMPILER);
        Executor exec = Executor.find((Class)(class$org$apache$tools$ant$module$run$AntExecutor == null ? (class$org$apache$tools$ant$module$run$AntExecutor = AntSettings.class$("org.apache.tools.ant.module.run.AntExecutor")) : class$org$apache$tools$ant$module$run$AntExecutor));
        if (exec == null) {
            exec = new AntExecutor();
        }
        this.setExecutor(exec);
    }

    public String displayName() {
        return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$AntSettings == null ? (class$org$apache$tools$ant$module$AntSettings = AntSettings.class$("org.apache.tools.ant.module.AntSettings")) : class$org$apache$tools$ant$module$AntSettings), (String)"LBL_settings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.apache.tools.ant.module.settings");
    }

    public static AntSettings getDefault() {
        return (AntSettings)SharedClassObject.findObject((Class)(class$org$apache$tools$ant$module$AntSettings == null ? (class$org$apache$tools$ant$module$AntSettings = AntSettings.class$("org.apache.tools.ant.module.AntSettings")) : class$org$apache$tools$ant$module$AntSettings), (boolean)true);
    }

    public int getVerbosity() {
        return (Integer)this.getProperty(PROP_VERBOSITY);
    }

    public void setVerbosity(int v) {
        this.putProperty(PROP_VERBOSITY, new Integer(v), true);
    }

    public Properties getProperties() {
        HashMap m = (HashMap)this.getProperty(PROP_PROPERTIES);
        Properties p = new Properties();
        ((Hashtable)p).putAll(m);
        p.setProperty(DEF_CLASS_PATH, AntSettings.getClassPath(NbClassPath.createClassPath()));
        p.setProperty(DEF_BOOTCLASS_PATH, AntSettings.getClassPath(NbClassPath.createBootClassPath()));
        p.setProperty(DEF_LIBRARY_PATH, AntSettings.getClassPath(NbClassPath.createLibraryPath()));
        p.setProperty(DEF_FILESYSTEMS_PATH, AntSettings.getClassPath(NbClassPath.createRepositoryPath((FileSystemCapability)FileSystemCapability.EXECUTE)));
        return p;
    }

    private static String getClassPath(NbClassPath p) {
        String s = p.getClassPath();
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public void setProperties(Properties p) {
        HashMap<Object, Object> m = new HashMap<Object, Object>(p);
        m.remove(DEF_CLASS_PATH);
        m.remove(DEF_BOOTCLASS_PATH);
        m.remove(DEF_LIBRARY_PATH);
        m.remove(DEF_FILESYSTEMS_PATH);
        this.putProperty(PROP_PROPERTIES, m, true);
    }

    public boolean getSaveAll() {
        return (Boolean)this.getProperty(PROP_SAVE_ALL);
    }

    public void setSaveAll(boolean sa) {
        this.putProperty(PROP_SAVE_ALL, sa ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public IntrospectedInfo getCustomDefs() {
        return (IntrospectedInfo)this.getProperty(PROP_CUSTOM_DEFS);
    }

    public void setCustomDefs(IntrospectedInfo ii) {
        this.putProperty(PROP_CUSTOM_DEFS, ii, true);
        ii.addChangeListener(WeakListener.change((ChangeListener)this, (Object)ii));
    }

    public CompilerType getCompiler() {
        ServiceType.Handle compilerType = (ServiceType.Handle)this.getProperty(PROP_COMPILER);
        CompilerType c = (CompilerType)compilerType.getServiceType();
        if (c != null) {
            return c;
        }
        return AntCompilerSupport.NoCompiler.NO_COMPILER;
    }

    public void setCompiler(CompilerType ct) {
        this.putProperty(PROP_COMPILER, new ServiceType.Handle((ServiceType)ct), true);
    }

    public Executor getExecutor() {
        ServiceType.Handle serviceType = (ServiceType.Handle)this.getProperty(PROP_EXECUTOR);
        Executor e = (Executor)serviceType.getServiceType();
        if (e != null) {
            return e;
        }
        return new AntExecutor();
    }

    public void setExecutor(Executor ct) {
        this.putProperty(PROP_EXECUTOR, new ServiceType.Handle((ServiceType)ct), true);
    }

    public boolean getReuseOutput() {
        return (Boolean)this.getProperty(PROP_REUSE_OUTPUT);
    }

    public void setReuseOutput(boolean b) {
        this.putProperty(PROP_REUSE_OUTPUT, b ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public String getAntVersion() {
        String v = (String)this.getProperty(PROP_ANT_VERSION);
        if (v == null) {
            try {
                v = Main.getAntVersion();
            }
            catch (BuildException be) {
                AntModule.err.notify(1, (Throwable)be);
                v = NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$AntSettings == null ? (class$org$apache$tools$ant$module$AntSettings = AntSettings.class$("org.apache.tools.ant.module.AntSettings")) : class$org$apache$tools$ant$module$AntSettings), (String)"LBL_ant_version_unknown");
            }
            this.putProperty(PROP_ANT_VERSION, v, false);
        }
        return v;
    }

    public void stateChanged(ChangeEvent e) {
        this.firePropertyChange(PROP_CUSTOM_DEFS, null, null);
    }

    public String getInputHandler() {
        String str = (String)this.getProperty(PROP_INPUT_HANDLER);
        if (str == null) {
            str = "";
        }
        return str;
    }

    public void setInputHandler(String inputHandler) {
        this.putProperty(PROP_INPUT_HANDLER, inputHandler, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

