/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class DefinitionRegistry {
    private static final Map taskDefs = new HashMap();
    private static final Map typeDefs = new HashMap();
    private static final Map lDefs = new HashMap();
    private static Lookup.Result result;
    private final String name;
    private final Class clazz;
    private final String kind;
    static /* synthetic */ Class class$org$apache$tools$ant$Task;
    static /* synthetic */ Class class$org$apache$tools$ant$module$api$DefinitionRegistry;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public static void register(String name, Class taskClazz, boolean task) throws ClassCastException {
        Map defs;
        if (task && !(class$org$apache$tools$ant$Task == null ? (class$org$apache$tools$ant$Task = DefinitionRegistry.class$("org.apache.tools.ant.Task")) : class$org$apache$tools$ant$Task).isAssignableFrom(taskClazz)) {
            throw new ClassCastException("Not a subclass of org.apache.tools.ant.Task: " + taskClazz.getName());
        }
        AntModule.err.log("registering def: " + name + "=" + taskClazz.getName() + " (task=" + task + ")");
        Map map = defs = task ? taskDefs : typeDefs;
        synchronized (map) {
            defs.put(name, taskClazz);
        }
        IntrospectedInfo.getDefaults().register(name, taskClazz, task ? "task" : "type");
    }

    public static void unregister(String name, boolean task) {
        Map defs;
        AntModule.err.log("unregistering def: " + name + " (task=" + task + ")");
        Map map = defs = task ? taskDefs : typeDefs;
        synchronized (map) {
            defs.remove(name);
        }
        IntrospectedInfo.getDefaults().unregister(name, task ? "task" : "type");
    }

    public static Map getDefs(boolean task) {
        return DefinitionRegistry.getDefs(task ? "task" : "type");
    }

    public static Map getDefs(String kind) {
        HashMap toret;
        Map map;
        if (kind.equals("task")) {
            map = taskDefs;
            synchronized (map) {
                toret = new HashMap(taskDefs);
            }
        } else if (kind.equals("type")) {
            map = typeDefs;
            synchronized (map) {
                toret = new HashMap(typeDefs);
            }
        } else {
            toret = new HashMap();
        }
        DefinitionRegistry.initLookup();
        map = lDefs;
        synchronized (map) {
            Map added = (Map)lDefs.get(kind);
            if (added != null) {
                toret.putAll(added);
            }
        }
        if (AntModule.err.isLoggable(0)) {
            AntModule.err.log("DefinitionRegistry.getDefs: kind=" + kind + " defs=" + toret + " taskDefs=" + taskDefs + " typeDefs=" + typeDefs + " lDefs=" + lDefs);
        }
        return toret;
    }

    private static synchronized void initLookup() {
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(class$org$apache$tools$ant$module$api$DefinitionRegistry == null ? (class$org$apache$tools$ant$module$api$DefinitionRegistry = DefinitionRegistry.class$("org.apache.tools.ant.module.api.DefinitionRegistry")) : class$org$apache$tools$ant$module$api$DefinitionRegistry));
            Listener l = new Listener();
            result.addLookupListener((LookupListener)l);
            l.resultChanged(null);
            if (AntModule.err.isLoggable(0)) {
                AntModule.err.log("DefinitionRegistry.initLookup: lDefs=" + lDefs);
            }
        }
    }

    public static Set getKinds() {
        DefinitionRegistry.initLookup();
        HashSet<Object> s = new HashSet<Object>();
        Map map = lDefs;
        synchronized (map) {
            s.addAll(lDefs.keySet());
        }
        s.add("task");
        s.add("type");
        return s;
    }

    public DefinitionRegistry(String name, Class clazz, String kind) throws IllegalArgumentException {
        this.name = name;
        this.clazz = clazz;
        this.kind = kind;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        if (kind == null || !kind.equals("task") && !kind.equals("type")) {
            throw new IllegalArgumentException();
        }
    }

    public static DefinitionRegistry createDefinition(FileObject fo) throws Exception {
        String name = (String)fo.getAttribute("name");
        String classname = (String)fo.getAttribute("class");
        Class<?> clazz = Class.forName(classname, false, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = DefinitionRegistry.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader));
        String kind = (String)fo.getAttribute("kind");
        AntModule.err.log("DefinitionRegistry.createDefinition: name=" + name + " clazz=" + classname + " kind=" + kind);
        AntModule.err.log("DR class id: " + System.identityHashCode(class$org$apache$tools$ant$module$api$DefinitionRegistry == null ? (class$org$apache$tools$ant$module$api$DefinitionRegistry = DefinitionRegistry.class$("org.apache.tools.ant.module.api.DefinitionRegistry")) : class$org$apache$tools$ant$module$api$DefinitionRegistry));
        return new DefinitionRegistry(name, clazz, kind);
    }

    public final String getDefinitionName() {
        return this.name;
    }

    public final Class getDefinitionClass() {
        return this.clazz;
    }

    public final String getDefinitionKind() {
        return this.kind;
    }

    public String toString() {
        return "DefinitionRegistry[name=" + this.name + ",clazz=" + this.clazz.getName() + ",kind=" + this.kind + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Listener
    implements LookupListener {
        static /* synthetic */ Class class$org$apache$tools$ant$module$api$DefinitionRegistry;

        public Listener() {
            AntModule.err.log("DefinitionRegistry: creating " + this + " matching result: " + result + " DR class id: " + System.identityHashCode(class$org$apache$tools$ant$module$api$DefinitionRegistry == null ? (class$org$apache$tools$ant$module$api$DefinitionRegistry = Listener.class$("org.apache.tools.ant.module.api.DefinitionRegistry")) : class$org$apache$tools$ant$module$api$DefinitionRegistry));
        }

        public void resultChanged(LookupEvent ignore) {
            Collection alldefs = result.allInstances();
            if (AntModule.err.isLoggable(0)) {
                AntModule.err.log("All DefinitionRegistry's in lookup: " + alldefs);
                AntModule.err.log("Being queried by: " + this);
                AntModule.err.log("Result: " + result);
                AntModule.err.log("DR class id: " + System.identityHashCode(class$org$apache$tools$ant$module$api$DefinitionRegistry == null ? (class$org$apache$tools$ant$module$api$DefinitionRegistry = Listener.class$("org.apache.tools.ant.module.api.DefinitionRegistry")) : class$org$apache$tools$ant$module$api$DefinitionRegistry));
            }
            Iterator it = alldefs.iterator();
            Map map = lDefs;
            synchronized (map) {
                String kind;
                HashMap found = new HashMap();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof DefinitionRegistry)) {
                        AntModule.err.log("WARNING - got dead object in lookup result: " + o);
                        result.removeLookupListener((LookupListener)this);
                        result = null;
                        return;
                    }
                    DefinitionRegistry def = (DefinitionRegistry)o;
                    kind = def.getDefinitionKind();
                    String name = def.getDefinitionName();
                    HashSet<String> kindFound = (HashSet<String>)found.get(kind);
                    if (kindFound == null) {
                        kindFound = new HashSet<String>();
                        found.put(kind, kindFound);
                    }
                    if (kindFound.contains(name)) {
                        AntModule.err.log("Warning: duplicate defs found in lookup: kind=" + kind + " name=" + name);
                        continue;
                    }
                    kindFound.add(name);
                    HashMap<String, Class> lDefsKind = (HashMap<String, Class>)lDefs.get(kind);
                    if (lDefsKind == null) {
                        lDefsKind = new HashMap<String, Class>();
                        lDefs.put(kind, lDefsKind);
                    }
                    if (lDefsKind.containsKey(name)) continue;
                    Class clazz = def.getDefinitionClass();
                    lDefsKind.put(name, clazz);
                    if (!IntrospectedInfo.isDefaultsPrepared()) continue;
                    AntModule.err.log("Registering new def from lookup: name=" + name);
                    IntrospectedInfo.getDefaults().register(name, clazz, kind);
                }
                Iterator it2 = lDefs.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry entry = it2.next();
                    kind = (String)entry.getKey();
                    Map lDefsKind = (Map)entry.getValue();
                    Iterator it3 = lDefsKind.entrySet().iterator();
                    while (it3.hasNext()) {
                        Map.Entry entry2 = it3.next();
                        String name = (String)entry2.getKey();
                        Set kindFound = (Set)found.get(kind);
                        if (kindFound != null && kindFound.contains(name)) continue;
                        it3.remove();
                        if (!IntrospectedInfo.isDefaultsPrepared()) continue;
                        AntModule.err.log("Unregistering def from lookup: name=" + name);
                        IntrospectedInfo.getDefaults().unregister(name, kind);
                    }
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

