/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.DefinitionRegistry;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;

public final class IntrospectedInfo
implements Serializable {
    private static IntrospectedInfo defaults = null;
    private static boolean loadedDefaults = false;
    private static final long serialVersionUID = -2290064038236292995L;
    private Map clazzes = Collections.synchronizedMap(new HashMap());
    private Map namedefs = new HashMap();
    private transient Set listeners = new HashSet(5);
    private transient Set tonotify = new HashSet(5);
    private transient ChangeListener holder;
    private static IntrospectedInfo merged;
    static /* synthetic */ Class class$org$apache$tools$ant$module$api$IntrospectedInfo;
    static /* synthetic */ Class class$org$apache$tools$ant$Task;

    static synchronized boolean isDefaultsPrepared() {
        return loadedDefaults;
    }

    public static synchronized IntrospectedInfo getDefaults() {
        if (defaults != null) {
            return defaults;
        }
        AntModule.err.log("IntrospectedInfo.getDefaults: loading...");
        defaults = new IntrospectedInfo();
        ClassLoader cl = (class$org$apache$tools$ant$module$api$IntrospectedInfo == null ? (class$org$apache$tools$ant$module$api$IntrospectedInfo = IntrospectedInfo.class$("org.apache.tools.ant.module.api.IntrospectedInfo")) : class$org$apache$tools$ant$module$api$IntrospectedInfo).getClassLoader();
        InputStream taskDefaults = cl.getResourceAsStream("org/apache/tools/ant/taskdefs/defaults.properties");
        if (taskDefaults != null) {
            try {
                defaults.load(taskDefaults, true, cl);
            }
            catch (IOException ioe) {
                AntModule.err.log("Could not load default taskdefs");
                AntModule.err.notify((Throwable)ioe);
            }
        } else {
            AntModule.err.log("Could not open default taskdefs");
        }
        InputStream typeDefaults = cl.getResourceAsStream("org/apache/tools/ant/types/defaults.properties");
        if (typeDefaults != null) {
            try {
                defaults.load(typeDefaults, false, cl);
            }
            catch (IOException ioe) {
                AntModule.err.log("Could not load default typedefs");
                AntModule.err.notify((Throwable)ioe);
            }
        } else {
            AntModule.err.log("Could not open default typedefs");
        }
        Iterator kit = DefinitionRegistry.getKinds().iterator();
        while (kit.hasNext()) {
            String kind = (String)kit.next();
            Map m = DefinitionRegistry.getDefs(kind);
            if (m.size() <= 0) continue;
            AntModule.err.log("Introspecting " + m.size() + " ad-hoc defs (kind=" + kind + ")...");
            Iterator it = m.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                Class def = (Class)entry.getValue();
                defaults.register(name, def, kind);
            }
        }
        if (AntModule.err.isLoggable(0)) {
            AntModule.err.log("IntrospectedInfo.defaults=" + defaults);
        }
        loadedDefaults = true;
        return defaults;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.listeners = new HashSet(5);
        this.tonotify = new HashSet(5);
        ObjectInputStream.GetField fields = is.readFields();
        this.clazzes = (Map)fields.get("clazzes", null);
        this.namedefs = (Map)fields.get("namedefs", null);
        if (this.namedefs == null) {
            AntModule.err.log("#15739: reading old version of IntrospectedInfo");
            this.namedefs = new HashMap();
            Object tasks_ = fields.get("tasks", null);
            if (tasks_ == null) {
                throw new NullPointerException();
            }
            if (!(tasks_ instanceof Map)) {
                throw new ClassCastException(tasks_.toString());
            }
            this.namedefs.put("task", tasks_);
            Map types = (Map)fields.get("types", null);
            if (types == null) {
                throw new NullPointerException();
            }
            this.namedefs.put("type", types);
        }
        Iterator it = this.namedefs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            Map value = (Map)entry.getValue();
            Iterator it2 = value.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry2 = it2.next();
                String key2 = (String)entry2.getKey();
                String value2 = (String)entry2.getValue();
            }
        }
        Iterator it2 = this.clazzes.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry entry2 = it2.next();
            String key2 = (String)entry2.getKey();
            IntrospectedClass value2 = (IntrospectedClass)entry2.getValue();
        }
    }

    public void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    private void fireStateChanged() {
        Set set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                return;
            }
            if (this.tonotify.isEmpty()) {
                RequestProcessor.getDefault().post((Runnable)new ChangeTask());
            }
            this.tonotify.addAll(this.listeners);
        }
    }

    public Map getTaskdefs() {
        return this.getDefs("task");
    }

    public Map getTypedefs() {
        return this.getDefs("type");
    }

    public Map getDefs(String kind) {
        Map map = this.namedefs;
        synchronized (map) {
            Map m = (Map)this.namedefs.get(kind);
            if (m != null) {
                Map map2 = Collections.unmodifiableMap(m);
                return map2;
            }
            Map map3 = Collections.EMPTY_MAP;
            return map3;
        }
    }

    private IntrospectedClass getData(String clazz) throws IllegalArgumentException {
        IntrospectedClass data = (IntrospectedClass)this.clazzes.get(clazz);
        if (data == null) {
            throw new IllegalArgumentException();
        }
        return data;
    }

    public boolean isKnown(String clazz) {
        return this.clazzes.get(clazz) != null;
    }

    public boolean supportsText(String clazz) throws IllegalArgumentException {
        return this.getData((String)clazz).supportsText;
    }

    public Map getAttributes(String clazz) throws IllegalArgumentException {
        Map map = this.getData((String)clazz).attrs;
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(map);
    }

    public Map getElements(String clazz) throws IllegalArgumentException {
        Map map = this.getData((String)clazz).subs;
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(map);
    }

    private void load(InputStream is, boolean tasks, ClassLoader cl) throws IOException {
        Properties p = new Properties();
        try {
            p.load(is);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            is.close();
            throw throwable;
        }
        is.close();
        Iterator it = ((Hashtable)p).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            if (!tasks && name.equals("description")) {
                AntModule.err.log("Skipping pseudodef of <description>");
                continue;
            }
            String clazzname = (String)entry.getValue();
            try {
                Class<?> clazz = cl.loadClass(clazzname);
                this.register(name, clazz, tasks);
            }
            catch (ClassNotFoundException cnfe) {
                AntModule.err.log("IntrospectedInfo: skipping " + clazzname + ": " + cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                AntModule.err.log("IntrospectedInfo: skipping " + clazzname + ": " + ncdfe);
            }
            catch (LinkageError e) {
                IOException ioe = new IOException("Could not load class " + clazzname + ": " + e);
                AntModule.err.annotate((Throwable)e, (Throwable)e);
                throw ioe;
            }
        }
    }

    public synchronized void register(String name, Class clazz, boolean task) {
        this.register(name, clazz, task ? "task" : "type");
    }

    public synchronized void register(String name, Class clazz, String kind) {
        Map map = this.namedefs;
        synchronized (map) {
            HashMap<String, String> m = (HashMap<String, String>)this.namedefs.get(kind);
            if (m == null) {
                m = new HashMap<String, String>();
                this.namedefs.put(kind, m);
            }
            m.put(name, clazz.getName());
        }
        this.fireStateChanged();
        this.analyze(clazz);
    }

    public synchronized void unregister(String name, String kind) {
        Map map = this.namedefs;
        synchronized (map) {
            Map m = (Map)this.namedefs.get(kind);
            if (m != null) {
                m.remove(name);
            }
        }
        this.fireStateChanged();
    }

    private void analyze(Class clazz) {
        String n = clazz.getName();
        if (IntrospectedInfo.getDefaults().isKnown(n) || this.isKnown(n)) {
            return;
        }
        IntrospectedClass info = new IntrospectedClass();
        IntrospectionHelper helper = IntrospectionHelper.getHelper(clazz);
        info.supportsText = helper.supportsCharacters();
        Enumeration e = helper.getAttributes();
        if (e.hasMoreElements()) {
            info.attrs = new HashMap();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                try {
                    String type = helper.getAttributeType(name).getName();
                    if ((class$org$apache$tools$ant$Task == null ? IntrospectedInfo.class$("org.apache.tools.ant.Task") : class$org$apache$tools$ant$Task).isAssignableFrom(clazz) && (name.equals("location") && type.equals("org.apache.tools.ant.Location") || name.equals("taskname") && type.equals("java.lang.String") || name.equals("description") && type.equals("java.lang.String"))) continue;
                    info.attrs.put(name, type);
                }
                catch (RuntimeException re) {
                    AntModule.err.notify(1, (Throwable)re);
                }
            }
        } else {
            info.attrs = null;
        }
        HashSet<Class> nueClazzes = new HashSet<Class>();
        e = helper.getNestedElements();
        if (e.hasMoreElements()) {
            info.subs = new HashMap();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                try {
                    Class subclazz = helper.getElementType(name);
                    info.subs.put(name, subclazz.getName());
                    nueClazzes.add(subclazz);
                }
                catch (RuntimeException re) {
                    AntModule.err.notify(1, (Throwable)re);
                }
            }
        } else {
            info.subs = null;
        }
        this.clazzes.put(clazz.getName(), info);
        Iterator it = nueClazzes.iterator();
        while (it.hasNext()) {
            this.analyze((Class)it.next());
        }
        this.fireStateChanged();
    }

    public void scanProject(Project p) {
        this.scanMap(p.getTaskDefinitions(), "task");
        this.scanMap(p.getDataTypeDefinitions(), "type");
        AntModule.err.log("IntrospectedInfo.scanProject: p=" + p.getName() + "; this=" + this);
    }

    private void scanMap(Map m, String kind) {
        if (kind == null) {
            throw new IllegalArgumentException();
        }
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            Class clazz = (Class)entry.getValue();
            HashMap<String, String> registry = (HashMap<String, String>)this.namedefs.get(kind);
            if (registry == null) {
                registry = new HashMap<String, String>();
                this.namedefs.put(kind, registry);
            }
            IntrospectedInfo introspectedInfo = this;
            synchronized (introspectedInfo) {
                Map defaults = IntrospectedInfo.getDefaults().getDefs(kind);
                if (registry.get(name) == null && defaults.get(name) == null) {
                    registry.put(name, clazz.getName());
                }
                if (!IntrospectedInfo.getDefaults().isKnown(clazz.getName())) {
                    try {
                        this.analyze(clazz);
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        AntModule.err.log("Skipping " + clazz.getName() + ": " + ncdfe);
                    }
                    catch (LinkageError e) {
                        AntModule.err.annotate((Throwable)e, 1, "Cannot scan class " + clazz.getName(), null, null, null);
                        AntModule.err.notify(1, (Throwable)e);
                    }
                }
            }
        }
        this.fireStateChanged();
    }

    public String toString() {
        return "IntrospectedInfo[namedefs=" + this.namedefs + ",clazzes=" + this.clazzes + "]";
    }

    private static IntrospectedInfo merge(IntrospectedInfo[] proxied) {
        ChangeListener l;
        final IntrospectedInfo ii = new IntrospectedInfo();
        ii.holder = l = new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                IntrospectedInfo ii2 = (IntrospectedInfo)ev.getSource();
                ii.clazzes.putAll(ii2.clazzes);
                Iterator it = ii2.namedefs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    String kind = (String)e.getKey();
                    Map entries = (Map)e.getValue();
                    if (ii.namedefs.containsKey(kind)) {
                        ((Map)ii.namedefs.get(kind)).putAll(entries);
                        continue;
                    }
                    ii.namedefs.put(kind, new HashMap(entries));
                }
                ii.fireStateChanged();
            }
        };
        int i = 0;
        while (i < proxied.length) {
            proxied[i].addChangeListener(WeakListener.change((ChangeListener)l, (Object)proxied[i]));
            l.stateChanged(new ChangeEvent(proxied[i]));
            ++i;
        }
        return ii;
    }

    public static synchronized IntrospectedInfo getKnownInfo() {
        if (merged == null) {
            merged = IntrospectedInfo.merge(new IntrospectedInfo[]{IntrospectedInfo.getDefaults(), AntSettings.getDefault().getCustomDefs()});
        }
        return merged;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class IntrospectedClass
    implements Serializable {
        private static final long serialVersionUID = 4039297397834774403L;
        public boolean supportsText;
        public Map attrs;
        public Map subs;

        private IntrospectedClass() {
        }

        public String toString() {
            return "IntrospectedClass[text=" + this.supportsText + ",attrs=" + this.attrs + ",subs=" + this.subs + "]";
        }
    }

    private class ChangeTask
    implements Runnable {
        private ChangeTask() {
        }

        public void run() {
            ChangeListener[] listeners2;
            Set set = IntrospectedInfo.this.listeners;
            synchronized (set) {
                if (IntrospectedInfo.this.tonotify.isEmpty()) {
                    return;
                }
                listeners2 = IntrospectedInfo.this.tonotify.toArray(new ChangeListener[IntrospectedInfo.this.tonotify.size()]);
                IntrospectedInfo.this.tonotify.clear();
            }
            ChangeEvent ev = new ChangeEvent(IntrospectedInfo.this);
            int i = 0;
            while (i < listeners2.length) {
                listeners2[i].stateChanged(ev);
                ++i;
            }
        }
    }
}

