/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.nodes;

import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AllPermission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.ElementCookie;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.apache.tools.ant.module.api.IntrospectionCookie;
import org.apache.tools.ant.module.nodes.AntProjectNode;
import org.apache.tools.ant.module.nodes.AntProperty;
import org.apache.tools.ant.module.nodes.AntTaskNode;
import org.apache.tools.ant.module.nodes.ElementChildren;
import org.apache.tools.ant.module.nodes.ElementNode;
import org.apache.tools.ant.module.xml.ElementSupport;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Reference;
import org.openide.execution.NbClassLoader;
import org.openide.execution.NbClassPath;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.NewType;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DataTypeNode
extends ElementNode {
    private Map attrs;
    private Map subels;
    private Boolean supportsTextFlag;
    private String clazz;
    static /* synthetic */ Class class$org$apache$tools$ant$module$api$IntrospectionCookie;
    static /* synthetic */ Class class$org$apache$tools$ant$module$api$AntProjectCookie;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$tools$ant$types$EnumeratedAttribute;
    static /* synthetic */ Class class$org$apache$tools$ant$module$nodes$DataTypeNode;

    public DataTypeNode(Element el, String clazz) {
        this(el, DataTypeNode.computeChildren(el, clazz));
        this.clazz = clazz;
    }

    protected DataTypeNode(Element el, Children children) {
        super(el, children);
    }

    private static Children computeChildren(Element el, String clazz) {
        if (DataTypeNode.isEmpty(clazz)) {
            return Children.LEAF;
        }
        return new ElementChildren(el);
    }

    protected static boolean isEmpty(String clazz) {
        return DataTypeNode.isEmpty(clazz, IntrospectedInfo.getDefaults()) || DataTypeNode.isEmpty(clazz, AntSettings.getDefault().getCustomDefs());
    }

    private static boolean isEmpty(String clazz, IntrospectedInfo info) {
        if (info.isKnown(clazz)) {
            return info.getElements(clazz).isEmpty();
        }
        return false;
    }

    protected DataTypeNode(Element el) {
        super(el);
    }

    protected ElementCookie createElementCookie() {
        if (this.clazz != null) {
            return new ElementSupport.Introspection(this.el, this.clazz);
        }
        return new ElementSupport(this.el);
    }

    protected void initDisplay() {
        super.initDisplay();
        this.setIconBase("org/apache/tools/ant/module/resources/DataTypeIcon");
    }

    public HelpCtx getHelpCtx() {
        if (this.clazz != null) {
            HelpCtx help;
            Map.Entry entry;
            Map typedefs = IntrospectedInfo.getDefaults().getDefs("type");
            Iterator it = typedefs.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                if (!this.clazz.equals((String)entry.getValue()) || (help = AntTaskNode.helpFor((String)entry.getKey(), "type")) == null) continue;
                return help;
            }
            typedefs = AntSettings.getDefault().getCustomDefs().getDefs("type");
            it = typedefs.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                if (!this.clazz.equals((String)entry.getValue()) || (help = AntTaskNode.helpFor((String)entry.getKey(), "type")) == null) continue;
                return help;
            }
        }
        return new HelpCtx("org.apache.tools.ant.module.node-manip");
    }

    protected Map getAttrs() {
        DataTypeNode dataTypeNode = this;
        synchronized (dataTypeNode) {
            if (this.attrs != null) {
                Map map = this.attrs;
                return map;
            }
            this.updateStuff();
            Map map = this.attrs;
            return map;
        }
    }

    protected Map getSubels() {
        DataTypeNode dataTypeNode = this;
        synchronized (dataTypeNode) {
            if (this.subels != null) {
                Map map = this.subels;
                return map;
            }
            this.updateStuff();
            Map map = this.subels;
            return map;
        }
    }

    protected boolean supportsText() {
        DataTypeNode dataTypeNode = this;
        synchronized (dataTypeNode) {
            if (this.supportsTextFlag != null) {
                boolean bl = this.supportsTextFlag;
                return bl;
            }
            this.updateStuff();
            boolean bl = this.supportsTextFlag;
            return bl;
        }
    }

    private void updateStuff() {
        this.attrs = new HashMap();
        this.subels = new HashMap();
        this.supportsTextFlag = Boolean.FALSE;
        String name = this.el.getNodeName();
        IntrospectionCookie cookie = (IntrospectionCookie)this.getCookie(class$org$apache$tools$ant$module$api$IntrospectionCookie == null ? (class$org$apache$tools$ant$module$api$IntrospectionCookie = DataTypeNode.class$("org.apache.tools.ant.module.api.IntrospectionCookie")) : class$org$apache$tools$ant$module$api$IntrospectionCookie);
        if (cookie == null) {
            return;
        }
        String clazz = cookie.getClassName();
        IntrospectedInfo info = IntrospectedInfo.getDefaults();
        if (info.isKnown(clazz)) {
            this.attrs = info.getAttributes(clazz);
            this.subels = info.getElements(clazz);
            this.supportsTextFlag = info.supportsText(clazz) ? Boolean.TRUE : Boolean.FALSE;
        } else {
            info = AntSettings.getDefault().getCustomDefs();
            if (info.isKnown(clazz)) {
                this.attrs = info.getAttributes(clazz);
                this.subels = info.getElements(clazz);
                this.supportsTextFlag = info.supportsText(clazz) ? Boolean.TRUE : Boolean.FALSE;
            }
        }
    }

    protected void addProperties(Sheet.Set props) {
        Iterator it = this.getAttrs().entrySet().iterator();
        AntProjectCookie proj = (AntProjectCookie)this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = DataTypeNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie);
        while (it.hasNext()) {
            Class<?> clazz;
            Map.Entry entry = it.next();
            String attr = (String)entry.getKey();
            if (this.el.getAttribute(attr).indexOf("${") != -1) {
                props.put((Node.Property)new AntProperty(this.el, attr, proj));
                continue;
            }
            String clazzname = (String)entry.getValue();
            if (clazzname.equals("org.apache.tools.ant.types.Reference")) {
                props.put((Node.Property)new ReferenceProperty(attr));
                continue;
            }
            if (clazzname.equals("org.apache.tools.ant.types.Path")) {
                props.put((Node.Property)new PathProperty(attr));
                continue;
            }
            if (clazzname.equals("java.io.File")) {
                props.put((Node.Property)new FileProperty(attr));
                continue;
            }
            if (clazzname.equals("java.lang.String") && attr.equals("path") && (this.clazz.equals("org.apache.tools.ant.types.Path") || this.clazz.equals("org.apache.tools.ant.types.Path$PathElement"))) {
                props.put((Node.Property)new PathProperty(attr));
                continue;
            }
            if (clazzname.equals("boolean")) {
                clazz = Boolean.TYPE;
            } else if (clazzname.equals("char")) {
                clazz = Character.TYPE;
            } else if (clazzname.equals("byte")) {
                clazz = Byte.TYPE;
            } else if (clazzname.equals("short")) {
                clazz = Short.TYPE;
            } else if (clazzname.equals("int")) {
                clazz = Integer.TYPE;
            } else if (clazzname.equals("long")) {
                clazz = Long.TYPE;
            } else if (clazzname.equals("float")) {
                clazz = Float.TYPE;
            } else if (clazzname.equals("double")) {
                clazz = Double.TYPE;
            } else {
                try {
                    NbClassLoader l = new NbClassLoader();
                    Permissions perm = new Permissions();
                    perm.add(new AllPermission());
                    l.setDefaultPermissions((PermissionCollection)perm);
                    clazz = l.loadClass(clazzname);
                }
                catch (ClassNotFoundException cnfe) {
                    clazz = class$java$lang$String == null ? DataTypeNode.class$("java.lang.String") : class$java$lang$String;
                }
            }
            if ((class$org$apache$tools$ant$types$EnumeratedAttribute == null ? DataTypeNode.class$("org.apache.tools.ant.types.EnumeratedAttribute") : class$org$apache$tools$ant$types$EnumeratedAttribute).isAssignableFrom(clazz)) {
                props.put((Node.Property)new EnumeratedProperty(attr, clazz, proj));
                continue;
            }
            props.put((Node.Property)new DataProperty(attr, clazz));
        }
        AntProperty idProp = new AntProperty(this.el, "id", proj);
        ((FeatureDescriptor)((Object)idProp)).setDisplayName(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$DataTypeNode == null ? (class$org$apache$tools$ant$module$nodes$DataTypeNode = DataTypeNode.class$("org.apache.tools.ant.module.nodes.DataTypeNode")) : class$org$apache$tools$ant$module$nodes$DataTypeNode), (String)"PROP_data_id"));
        ((FeatureDescriptor)((Object)idProp)).setShortDescription(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$DataTypeNode == null ? (class$org$apache$tools$ant$module$nodes$DataTypeNode = DataTypeNode.class$("org.apache.tools.ant.module.nodes.DataTypeNode")) : class$org$apache$tools$ant$module$nodes$DataTypeNode), (String)"HINT_data_id"));
        props.put((Node.Property)idProp);
        if (this.supportsText()) {
            props.put((Node.Property)new TextProperty());
        }
    }

    protected boolean canPasteElement(Element el2) {
        return this.getSubels().containsKey(el2.getNodeName());
    }

    public NewType[] getNewTypes() {
        if (!AntProjectNode.isScriptReadOnly((AntProjectCookie)this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = DataTypeNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie))) {
            ArrayList names = new ArrayList(this.getSubels().keySet());
            Collections.sort(names);
            NewType[] types = new NewType[names.size()];
            int i = 0;
            while (i < types.length) {
                types[i] = new SubElementNewType((String)names.get(i));
                ++i;
            }
            return types;
        }
        return new NewType[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SubElementNewType
    extends NewType {
        private String name;

        public SubElementNewType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("org.apache.tools.ant.module.node-manip");
        }

        public void create() throws IOException {
            try {
                Element el2 = DataTypeNode.this.el.getOwnerDocument().createElement(this.name);
                ElementNode.appendWithIndent(DataTypeNode.this.el, el2);
            }
            catch (DOMException dome) {
                IOException ioe = new IOException();
                AntModule.err.annotate((Throwable)ioe, (Throwable)dome);
                throw ioe;
            }
        }
    }

    private class TextProperty
    extends PropertySupport.ReadWrite {
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$org$apache$tools$ant$module$nodes$DataTypeNode;
        static /* synthetic */ Class class$org$apache$tools$ant$module$api$AntProjectCookie;

        public TextProperty() {
            super("text", class$java$lang$String == null ? (class$java$lang$String = TextProperty.class$("java.lang.String")) : class$java$lang$String, NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$DataTypeNode == null ? (class$org$apache$tools$ant$module$nodes$DataTypeNode = TextProperty.class$("org.apache.tools.ant.module.nodes.DataTypeNode")) : class$org$apache$tools$ant$module$nodes$DataTypeNode), (String)"PROP_data_text"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$DataTypeNode == null ? (class$org$apache$tools$ant$module$nodes$DataTypeNode = TextProperty.class$("org.apache.tools.ant.module.nodes.DataTypeNode")) : class$org$apache$tools$ant$module$nodes$DataTypeNode), (String)"HINT_data_text"));
        }

        public Object getValue() {
            NodeList nl = DataTypeNode.this.el.getChildNodes();
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < nl.getLength()) {
                if (nl.item(i) instanceof Text) {
                    buf.append(((Text)nl.item(i)).getData());
                }
                ++i;
            }
            return buf.toString();
        }

        public void setValue(Object o) throws IllegalArgumentException, InvocationTargetException {
            if (!(o instanceof String)) {
                throw new IllegalArgumentException();
            }
            NodeList nl = DataTypeNode.this.el.getChildNodes();
            try {
                int i = 0;
                while (i < nl.getLength()) {
                    if (nl.item(i) instanceof Text) {
                        DataTypeNode.this.el.removeChild(nl.item(i));
                    }
                    ++i;
                }
                DataTypeNode.this.el.appendChild(DataTypeNode.this.el.getOwnerDocument().createCDATASection((String)o));
            }
            catch (DOMException dome) {
                throw new InvocationTargetException(dome);
            }
        }

        public boolean canWrite() {
            return !AntProjectNode.isScriptReadOnly((AntProjectCookie)DataTypeNode.this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = TextProperty.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie));
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class PathProperty
    extends PropertySupport.ReadWrite {
        static /* synthetic */ Class class$org$openide$execution$NbClassPath;
        static /* synthetic */ Class class$org$apache$tools$ant$module$api$AntProjectCookie;

        public PathProperty(String attr) {
            super(attr, class$org$openide$execution$NbClassPath == null ? (class$org$openide$execution$NbClassPath = PathProperty.class$("org.openide.execution.NbClassPath")) : class$org$openide$execution$NbClassPath, attr, attr);
            ((FeatureDescriptor)((Object)this)).setValue("helpID", "org.apache.tools.ant.module.nodes.DataTypeNode$PathProperty");
        }

        public Object getValue() {
            String path = DataTypeNode.this.el.getAttribute(((FeatureDescriptor)((Object)this)).getName());
            path = this.subst(path, File.separatorChar, '/');
            path = this.subst(path, File.separatorChar, '\\');
            path = this.substColonCarefully(path);
            path = this.subst(path, File.pathSeparatorChar, ';');
            return new NbClassPath(path);
        }

        private String substColonCarefully(String path) {
            if (File.pathSeparatorChar == ':') {
                return path;
            }
            StringBuffer toret = new StringBuffer(path);
            int i = 0;
            while (i < toret.length()) {
                if (toret.charAt(i) == ':' && (i <= 0 || !Character.isLetter(toret.charAt(i - 1)) || i != 1 && toret.charAt(i - 2) != ':' && toret.charAt(i - 2) != ';')) {
                    toret.setCharAt(i, File.pathSeparatorChar);
                }
                ++i;
            }
            return toret.toString();
        }

        private String subst(String path, char local, char generic) {
            if (local == generic) {
                return path;
            }
            return path.replace(generic, local);
        }

        public void setValue(Object o) throws IllegalArgumentException, InvocationTargetException {
            try {
                if (o == null) {
                    DataTypeNode.this.el.removeAttribute(((FeatureDescriptor)((Object)this)).getName());
                } else {
                    if (!(o instanceof NbClassPath)) {
                        throw new IllegalArgumentException();
                    }
                    String path = ((NbClassPath)o).getClassPath();
                    if (path.length() < 1) {
                        DataTypeNode.this.el.removeAttribute(((FeatureDescriptor)((Object)this)).getName());
                    } else {
                        if (path.startsWith("\"") && (path = path.substring(1)).endsWith("\"")) {
                            path = path.substring(0, path.length() - 1);
                        }
                        DataTypeNode.this.el.setAttribute(((FeatureDescriptor)((Object)this)).getName(), path);
                    }
                }
            }
            catch (DOMException dome) {
                throw new InvocationTargetException(dome);
            }
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void restoreDefaultValue() throws IllegalArgumentException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean canWrite() {
            return !AntProjectNode.isScriptReadOnly((AntProjectCookie)DataTypeNode.this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = PathProperty.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie));
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class FileProperty
    extends PropertySupport.ReadWrite {
        static /* synthetic */ Class class$java$io$File;
        static /* synthetic */ Class class$org$apache$tools$ant$module$api$AntProjectCookie;

        public FileProperty(String attr) {
            super(attr, class$java$io$File == null ? (class$java$io$File = FileProperty.class$("java.io.File")) : class$java$io$File, attr, attr);
        }

        public PropertyEditor getPropertyEditor() {
            AntProjectCookie cookie = (AntProjectCookie)DataTypeNode.this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = FileProperty.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie);
            if (cookie != null) {
                Element root = cookie.getProjectElement();
                File buildscript = cookie.getFile();
                if (root != null && buildscript != null) {
                    String bd = root.getAttribute("basedir");
                    File basedir = buildscript.getParentFile();
                    if (bd != null && !bd.equals(".")) {
                        File absbasedir = new File(bd);
                        basedir = absbasedir.isAbsolute() ? absbasedir : new File(basedir, bd);
                    }
                    AntModule.err.log("FileProperty: setting baseDir=" + basedir);
                    ((FeatureDescriptor)((Object)this)).setValue("baseDir", basedir);
                }
            }
            return super.getPropertyEditor();
        }

        public Object getValue() {
            String p = DataTypeNode.this.el.getAttribute(((FeatureDescriptor)((Object)this)).getName());
            if (p.equals("")) {
                return null;
            }
            if (p.equals(".")) {
                p = "";
            }
            return new File(p);
        }

        public void setValue(Object o) throws IllegalArgumentException, InvocationTargetException {
            try {
                if (o == null) {
                    DataTypeNode.this.el.removeAttribute(((FeatureDescriptor)((Object)this)).getName());
                } else {
                    if (!(o instanceof File)) {
                        throw new IllegalArgumentException();
                    }
                    String path = ((File)o).getPath();
                    if (path.equals("")) {
                        path = ".";
                    }
                    AntModule.err.log("FileProperty: set path=" + path);
                    DataTypeNode.this.el.setAttribute(((FeatureDescriptor)((Object)this)).getName(), path);
                }
            }
            catch (DOMException dome) {
                throw new InvocationTargetException(dome);
            }
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void restoreDefaultValue() throws IllegalArgumentException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean canWrite() {
            return !AntProjectNode.isScriptReadOnly((AntProjectCookie)DataTypeNode.this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = FileProperty.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie));
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class ReferenceEditor
    extends PropertyEditorSupport {
        private ReferenceEditor() {
        }

        public String getAsText() {
            return ((Reference)this.getValue()).getRefId();
        }

        public void setAsText(String s) {
            this.setValue(new Reference(s));
        }

        public String[] getTags() {
            TreeSet<String> tags = new TreeSet<String>();
            NodeList nl = DataTypeNode.this.el.getOwnerDocument().getElementsByTagName("*");
            int len = nl.getLength();
            int i = 0;
            while (i < len) {
                String rid;
                Attr id = ((Element)nl.item(i)).getAttributeNode("id");
                if (id != null && (rid = id.getValue()) != null && !rid.equals("")) {
                    tags.add(rid);
                }
                ++i;
            }
            return tags.toArray(new String[tags.size()]);
        }
    }

    private class ReferenceProperty
    extends PropertySupport.ReadWrite {
        static /* synthetic */ Class class$org$apache$tools$ant$types$Reference;
        static /* synthetic */ Class class$org$apache$tools$ant$module$nodes$DataTypeNode;
        static /* synthetic */ Class class$org$apache$tools$ant$module$api$AntProjectCookie;

        public ReferenceProperty(String attr) {
            super(attr, class$org$apache$tools$ant$types$Reference == null ? (class$org$apache$tools$ant$types$Reference = ReferenceProperty.class$("org.apache.tools.ant.types.Reference")) : class$org$apache$tools$ant$types$Reference, attr, NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$DataTypeNode == null ? (class$org$apache$tools$ant$module$nodes$DataTypeNode = ReferenceProperty.class$("org.apache.tools.ant.module.nodes.DataTypeNode")) : class$org$apache$tools$ant$module$nodes$DataTypeNode), (String)"HINT_data_refid"));
        }

        public Object getValue() {
            return new Reference(DataTypeNode.this.el.getAttribute(((FeatureDescriptor)((Object)this)).getName()));
        }

        public void setValue(Object o) throws IllegalArgumentException, InvocationTargetException {
            try {
                if (o == null) {
                    DataTypeNode.this.el.removeAttribute(((FeatureDescriptor)((Object)this)).getName());
                } else {
                    if (!(o instanceof Reference)) {
                        throw new IllegalArgumentException();
                    }
                    DataTypeNode.this.el.setAttribute(((FeatureDescriptor)((Object)this)).getName(), ((Reference)o).getRefId());
                }
            }
            catch (DOMException dome) {
                throw new InvocationTargetException(dome);
            }
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void restoreDefaultValue() throws IllegalArgumentException, InvocationTargetException {
            this.setValue(null);
        }

        public PropertyEditor getPropertyEditor() {
            return new ReferenceEditor();
        }

        public boolean canWrite() {
            return !AntProjectNode.isScriptReadOnly((AntProjectCookie)DataTypeNode.this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = ReferenceProperty.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie));
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class EnumeratedEditor
    extends PropertyEditorSupport {
        String[] tags;

        public EnumeratedEditor(Class clazz) {
            try {
                EnumeratedAttribute instance = (EnumeratedAttribute)clazz.newInstance();
                this.tags = instance.getValues();
            }
            catch (Exception e) {
                AntModule.err.notify(1, (Throwable)e);
                this.tags = new String[0];
            }
        }

        public String getAsText() {
            return (String)this.getValue();
        }

        public void setAsText(String v) {
            this.setValue(v);
        }

        public String[] getTags() {
            return this.tags;
        }
    }

    private class EnumeratedProperty
    extends AntProperty {
        private Class clazz;

        public EnumeratedProperty(String attr, Class clazz, AntProjectCookie proj) {
            super(DataTypeNode.this.el, attr, proj);
            this.clazz = clazz;
        }

        public PropertyEditor getPropertyEditor() {
            return new EnumeratedEditor(this.clazz);
        }
    }

    private class DataProperty
    extends PropertySupport.ReadWrite {
        private Constructor cons;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$org$apache$tools$ant$module$api$AntProjectCookie;

        public DataProperty(String attr, Class clazz) {
            super(attr, clazz, attr, attr);
            if (!clazz.isPrimitive()) {
                try {
                    this.cons = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = DataProperty.class$("java.lang.String")) : class$java$lang$String);
                }
                catch (NoSuchMethodException nsme) {
                    this.cons = null;
                }
            }
        }

        public Object getValue() {
            Class clazz = this.getValueType();
            String val = DataTypeNode.this.el.getAttribute(((FeatureDescriptor)((Object)this)).getName());
            try {
                if (clazz == Boolean.TYPE) {
                    return Project.toBoolean(val) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (clazz == Character.TYPE) {
                    return new Character(val.length() > 0 ? val.charAt(0) : (char)'\u0000');
                }
                if (clazz == Byte.TYPE) {
                    return new Byte(val);
                }
                if (clazz == Short.TYPE) {
                    return new Short(val);
                }
                if (clazz == Integer.TYPE) {
                    return new Integer(val);
                }
                if (clazz == Long.TYPE) {
                    return new Long(val);
                }
                if (clazz == Float.TYPE) {
                    return new Float(val);
                }
                if (clazz == Double.TYPE) {
                    return new Double(val);
                }
                if (this.cons == null) {
                    return null;
                }
                try {
                    return this.cons.newInstance(val);
                }
                catch (InvocationTargetException ite) {
                    if (ite.getTargetException() instanceof NumberFormatException) {
                        throw (NumberFormatException)ite.getTargetException();
                    }
                    AntModule.err.notify(1, (Throwable)ite);
                    return null;
                }
                catch (Exception e) {
                    AntModule.err.notify(1, (Throwable)e);
                    return null;
                }
            }
            catch (NumberFormatException nfe) {
                if (!val.equals("")) {
                    AntModule.err.notify(1, (Throwable)nfe);
                }
                return null;
            }
        }

        public void setValue(Object v) throws InvocationTargetException {
            try {
                String s;
                String string = s = v == null ? null : v.toString();
                if (s == null || s.equals("")) {
                    DataTypeNode.this.el.removeAttribute(((FeatureDescriptor)((Object)this)).getName());
                } else {
                    DataTypeNode.this.el.setAttribute(((FeatureDescriptor)((Object)this)).getName(), s);
                }
            }
            catch (DOMException dome) {
                throw new InvocationTargetException(dome);
            }
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void restoreDefaultValue() throws InvocationTargetException {
            this.setValue(null);
        }

        public boolean canWrite() {
            return !AntProjectNode.isScriptReadOnly((AntProjectCookie)DataTypeNode.this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = DataProperty.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie));
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

