/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.nodes;

import java.awt.datatransfer.Transferable;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.ElementCookie;
import org.apache.tools.ant.module.nodes.AntProjectNode;
import org.apache.tools.ant.module.nodes.AntProperty;
import org.apache.tools.ant.module.nodes.ElementChildren;
import org.apache.tools.ant.module.xml.ElementSupport;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class ElementNode
extends AbstractNode
implements EventListener,
Runnable,
NodeListener {
    protected Element el;
    private String error;
    private ElementCookie elCookie;
    private boolean attachedCookieListener = false;
    private static final int INDENT_STEP = 4;
    static /* synthetic */ Class class$org$apache$tools$ant$module$nodes$ElementNode;
    static /* synthetic */ Class class$org$apache$tools$ant$module$api$ElementCookie;
    static /* synthetic */ Class class$org$apache$tools$ant$module$api$IntrospectionCookie;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie;
    static /* synthetic */ Class class$org$openide$cookies$ExecCookie;
    static /* synthetic */ Class class$org$apache$tools$ant$module$api$AntProjectCookie;
    static /* synthetic */ Class class$org$openide$actions$OpenLocalExplorerAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$MoveUpAction;
    static /* synthetic */ Class class$org$openide$actions$MoveDownAction;
    static /* synthetic */ Class class$org$openide$actions$ReorderAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$NewAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    public ElementNode(Element el, String error) {
        this(el);
        if (error == null) {
            throw new NullPointerException();
        }
        this.error = error;
        this.initDisplay();
    }

    protected ElementNode(Element el) {
        this(el, (Children)new ElementChildren(el));
    }

    protected ElementNode(Element el, Children ch) {
        super(ch);
        this.el = el;
        this.initDisplay();
        if (el instanceof EventTarget) {
            ((EventTarget)((Object)el)).addEventListener("DOMSubtreeModified", this, false);
            ((EventTarget)((Object)el)).addEventListener("DOMAttrModified", this, false);
        } else {
            AntModule.err.log(16, "Element was not an EventTarget: " + el);
        }
        this.getCookieSet().add((Node.Cookie)new ElementNodeIndex((Node)this));
    }

    protected ElementCookie createElementCookie() {
        return new ElementSupport(this.el);
    }

    protected void initDisplay() {
        this.setNameSuper(ElementNode.semiUniqueName(this.el));
        this.setDisplayName(ElementNode.displayName(this.el));
        if (this.error != null) {
            AntModule.err.log("ElementNode.initDisplay: error=" + this.error);
            this.setShortDescription(this.error);
        } else {
            this.setShortDescription(ElementNode.fullText(this.el));
        }
        this.setIconBase("org/apache/tools/ant/module/resources/ElementIcon");
    }

    protected void setNameSuper(String n) {
        super.setName(n);
    }

    protected static String semiUniqueName(Element el) {
        Attr attr = el.getAttributeNode("id");
        if (attr != null) {
            return attr.getValue();
        }
        attr = el.getAttributeNode("name");
        if (attr != null) {
            return attr.getValue();
        }
        return el.getNodeName();
    }

    protected static String displayName(Element el) {
        Attr attr = el.getAttributeNode("name");
        if (attr != null) {
            return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$ElementNode == null ? (class$org$apache$tools$ant$module$nodes$ElementNode = ElementNode.class$("org.apache.tools.ant.module.nodes.ElementNode")) : class$org$apache$tools$ant$module$nodes$ElementNode), (String)"LBL_node_with_name", (Object)el.getNodeName(), (Object)attr.getValue());
        }
        return el.getNodeName();
    }

    protected static String fullText(Element el) {
        StringBuffer buf = new StringBuffer();
        buf.append('<');
        buf.append(el.getNodeName());
        NamedNodeMap attrs = el.getAttributes();
        int len = attrs.getLength();
        int i = 0;
        while (i < len) {
            Attr attr = (Attr)attrs.item(i);
            buf.append(' ');
            buf.append(attr.getName());
            buf.append('=');
            buf.append('\"');
            buf.append(attr.getValue());
            buf.append('\"');
            ++i;
        }
        if (el.getChildNodes().getLength() > len) {
            buf.append(">...</");
            buf.append(el.getNodeName());
            buf.append('>');
        } else {
            buf.append("/>");
        }
        return buf.toString();
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie supe = super.getCookie(clazz);
        if (supe != null) {
            return supe;
        }
        if ((class$org$apache$tools$ant$module$api$ElementCookie == null ? (class$org$apache$tools$ant$module$api$ElementCookie = ElementNode.class$("org.apache.tools.ant.module.api.ElementCookie")) : class$org$apache$tools$ant$module$api$ElementCookie).isAssignableFrom(clazz) || (class$org$apache$tools$ant$module$api$IntrospectionCookie == null ? (class$org$apache$tools$ant$module$api$IntrospectionCookie = ElementNode.class$("org.apache.tools.ant.module.api.IntrospectionCookie")) : class$org$apache$tools$ant$module$api$IntrospectionCookie).isAssignableFrom(clazz)) {
            if (this.elCookie == null) {
                ElementCookie cookie;
                this.elCookie = cookie = this.createElementCookie();
                RequestProcessor.postRequest((Runnable)new Runnable(){

                    public void run() {
                        ElementNode.super.getCookieSet().add((Node.Cookie)cookie);
                    }
                });
            }
            if (clazz.isInstance(this.elCookie)) {
                return this.elCookie;
            }
            return null;
        }
        if ((class$org$openide$cookies$CompilerCookie == null ? (class$org$openide$cookies$CompilerCookie = ElementNode.class$("org.openide.cookies.CompilerCookie")) : class$org$openide$cookies$CompilerCookie).isAssignableFrom(clazz) || (class$org$openide$cookies$ExecCookie == null ? (class$org$openide$cookies$ExecCookie = ElementNode.class$("org.openide.cookies.ExecCookie")) : class$org$openide$cookies$ExecCookie).isAssignableFrom(clazz)) {
            return null;
        }
        Node parent = this.getParentNode();
        if (parent != null) {
            if (!this.attachedCookieListener) {
                this.attachedCookieListener = true;
                parent.addNodeListener(WeakListener.node((NodeListener)this, (Object)parent));
            }
            return parent.getCookie(clazz);
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.apache.tools.ant.module.node-manip");
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set props = sheet.get("properties");
        if (props == null) {
            props = Sheet.createPropertiesSet();
            sheet.put(props);
        }
        this.addProperties(props);
        if (props.getProperties().length == 0) {
            sheet.remove(props.getName());
        }
        return sheet;
    }

    protected void addProperties(Sheet.Set props) {
        NamedNodeMap attrs = this.el.getAttributes();
        AntProjectCookie proj = (AntProjectCookie)this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = ElementNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie);
        int len = attrs.getLength();
        int i = 0;
        while (i < len) {
            props.put((Node.Property)new AntProperty(this.el, attrs.item(i).getNodeName(), proj));
            ++i;
        }
        props.put((Node.Property)new AntProperty(this.el, "id", proj));
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$OpenLocalExplorerAction == null ? (class$org$openide$actions$OpenLocalExplorerAction = ElementNode.class$("org.openide.actions.OpenLocalExplorerAction")) : class$org$openide$actions$OpenLocalExplorerAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = ElementNode.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = ElementNode.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ElementNode.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$MoveUpAction == null ? (class$org$openide$actions$MoveUpAction = ElementNode.class$("org.openide.actions.MoveUpAction")) : class$org$openide$actions$MoveUpAction)), SystemAction.get((Class)(class$org$openide$actions$MoveDownAction == null ? (class$org$openide$actions$MoveDownAction = ElementNode.class$("org.openide.actions.MoveDownAction")) : class$org$openide$actions$MoveDownAction)), SystemAction.get((Class)(class$org$openide$actions$ReorderAction == null ? (class$org$openide$actions$ReorderAction = ElementNode.class$("org.openide.actions.ReorderAction")) : class$org$openide$actions$ReorderAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = ElementNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = ElementNode.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)), null, SystemAction.get((Class)(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = ElementNode.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = ElementNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ElementNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ElementNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction));
    }

    public boolean canDestroy() {
        if (AntProjectNode.isScriptReadOnly((AntProjectCookie)this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = ElementNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie))) {
            return false;
        }
        org.w3c.dom.Node parent = this.el.getParentNode();
        if (parent == null) {
            return false;
        }
        short type = parent.getNodeType();
        boolean ok = type == 1;
        return ok;
    }

    public void destroy() throws IOException {
        ElementCookie cookie2;
        org.w3c.dom.Node parent = this.el.getParentNode();
        if (parent == null) {
            throw new IOException("Node had no DOM parent");
        }
        try {
            parent.removeChild(this.el);
            AntModule.err.log("ElementNode.destroy: el=" + this.el + " done");
        }
        catch (DOMException dome) {
            IOException ioe = new IOException();
            AntModule.err.annotate((Throwable)ioe, (Throwable)dome);
            throw ioe;
        }
        NodeList nue = parent.getChildNodes();
        int i = 0;
        while (i < nue.getLength()) {
            if (nue.item(i) == this.el) {
                throw new IOException("Node.removeChild did not work!");
            }
            ++i;
        }
        AntProjectCookie cookie = (AntProjectCookie)this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = ElementNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie);
        if (cookie != null && cookie.getDocument() != this.el.getOwnerDocument()) {
            throw new IOException("DOM mismatch");
        }
        Node parent2 = this.getParentNode();
        if (parent2 != null && (cookie2 = (ElementCookie)parent2.getCookie(class$org$apache$tools$ant$module$api$ElementCookie == null ? (class$org$apache$tools$ant$module$api$ElementCookie = ElementNode.class$("org.apache.tools.ant.module.api.ElementCookie")) : class$org$apache$tools$ant$module$api$ElementCookie)) != null && cookie2.getElement() != parent) {
            throw new IOException("I am not my father's son!");
        }
    }

    public boolean canRename() {
        if (AntProjectNode.isScriptReadOnly((AntProjectCookie)this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = ElementNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie))) {
            return false;
        }
        return this.el.getAttributeNode("id") != null || this.el.getAttributeNode("name") != null;
    }

    public void setName(String nue) throws IllegalArgumentException {
        block5: {
            if (((FeatureDescriptor)((Object)this)).getName().equals(nue)) {
                return;
            }
            try {
                Attr attr = this.el.getAttributeNode("id");
                if (attr != null) {
                    attr.setNodeValue(nue);
                    break block5;
                }
                attr = this.el.getAttributeNode("name");
                if (attr != null) {
                    attr.setNodeValue(nue);
                    break block5;
                }
                throw new IllegalArgumentException();
            }
            catch (DOMException dome) {
                IllegalArgumentException iae = new IllegalArgumentException();
                AntModule.err.annotate((Throwable)iae, (Throwable)dome);
                throw iae;
            }
        }
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return !AntProjectNode.isScriptReadOnly((AntProjectCookie)this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = ElementNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie));
    }

    static void appendWithIndent(Element parent, org.w3c.dom.Node child) throws DOMException {
        org.w3c.dom.Node doc = parent;
        int depth = -1;
        while (!(doc instanceof Document)) {
            doc = doc.getParentNode();
            ++depth;
        }
        String ws1 = parent.hasChildNodes() ? ElementNode.spaces(4) : "\n" + ElementNode.spaces((depth + 1) * 4);
        parent.appendChild(((Document)doc).createTextNode(ws1));
        parent.appendChild(child);
        parent.appendChild(((Document)doc).createTextNode("\n" + ElementNode.spaces(depth * 4)));
    }

    private static String spaces(int size) {
        char[] chars = new char[size];
        int i = 0;
        while (i < size) {
            chars[i] = 32;
            ++i;
        }
        return new String(chars);
    }

    protected void createPasteTypes(Transferable t, List l) {
        if (!AntProjectNode.isScriptReadOnly((AntProjectCookie)this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = ElementNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie))) {
            ElementCookie cookie = (ElementCookie)NodeTransfer.cookie((Transferable)t, (int)1, (Class)(class$org$apache$tools$ant$module$api$ElementCookie == null ? (class$org$apache$tools$ant$module$api$ElementCookie = ElementNode.class$("org.apache.tools.ant.module.api.ElementCookie")) : class$org$apache$tools$ant$module$api$ElementCookie));
            if (cookie != null && this.canPasteElement(cookie.getElement())) {
                l.add(new ElementPaste(this.el, cookie.getElement(), false));
            }
            if ((cookie = (ElementCookie)NodeTransfer.cookie((Transferable)t, (int)6, (Class)(class$org$apache$tools$ant$module$api$ElementCookie == null ? (class$org$apache$tools$ant$module$api$ElementCookie = ElementNode.class$("org.apache.tools.ant.module.api.ElementCookie")) : class$org$apache$tools$ant$module$api$ElementCookie))) != null && this.canPasteElement(cookie.getElement())) {
                l.add(new ElementPaste(this.el, cookie.getElement(), true));
            }
        }
    }

    protected boolean canPasteElement(Element el2) {
        return true;
    }

    public NewType[] getNewTypes() {
        return new NewType[0];
    }

    public void handleEvent(Event evt) {
        if (this.isRelevant(evt)) {
            RequestProcessor.postRequest((Runnable)this);
        }
    }

    public void run() {
        this.initDisplay();
        this.firePropertyChange(null, null, null);
    }

    protected boolean isRelevant(Event evt) {
        return evt.getTarget() == this.el;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if ("cookie".equals(ev.getPropertyName())) {
            this.fireCookieChange();
        }
    }

    public void childrenAdded(NodeMemberEvent ev) {
    }

    public void nodeDestroyed(NodeEvent ev) {
    }

    public void childrenRemoved(NodeMemberEvent ev) {
    }

    public void childrenReordered(NodeReorderEvent ev) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ElementNodeIndex
    extends Index.Support {
        protected Node indexNode;
        static /* synthetic */ Class class$org$apache$tools$ant$module$api$ElementCookie;

        public ElementNodeIndex(Node indexNode) {
            this.indexNode = indexNode;
        }

        public Node[] getNodes() {
            return this.indexNode.getChildren().getNodes();
        }

        public int getNodesCount() {
            return this.indexNode.getChildren().getNodesCount();
        }

        public int indexOf(Node node) {
            ElementCookie ec = (ElementCookie)node.getCookie(class$org$apache$tools$ant$module$api$ElementCookie == null ? (class$org$apache$tools$ant$module$api$ElementCookie = ElementNodeIndex.class$("org.apache.tools.ant.module.api.ElementCookie")) : class$org$apache$tools$ant$module$api$ElementCookie);
            if (ec == null) {
                return -1;
            }
            Element el = ec.getElement();
            if (el == null) {
                return -1;
            }
            Node[] nodes = this.getNodes();
            int i = 0;
            while (i < nodes.length) {
                ElementCookie ec2 = (ElementCookie)nodes[i].getCookie(class$org$apache$tools$ant$module$api$ElementCookie == null ? ElementNodeIndex.class$("org.apache.tools.ant.module.api.ElementCookie") : class$org$apache$tools$ant$module$api$ElementCookie);
                if (ec2 != null && ec2.getElement() == el) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        protected org.w3c.dom.Node getParentNode() {
            return ((ElementCookie)this.indexNode.getCookie(class$org$apache$tools$ant$module$api$ElementCookie == null ? (class$org$apache$tools$ant$module$api$ElementCookie = ElementNodeIndex.class$("org.apache.tools.ant.module.api.ElementCookie")) : class$org$apache$tools$ant$module$api$ElementCookie)).getElement();
        }

        public void reorder(int[] values) {
            Node[] nodes = this.getNodes();
            org.w3c.dom.Node parent = this.getParentNode();
            if (parent == null) {
                return;
            }
            LinkedList<Element> oldOrder = new LinkedList<Element>();
            int i = 0;
            while (i < values.length) {
                oldOrder.add(((ElementCookie)nodes[i].getCookie(class$org$apache$tools$ant$module$api$ElementCookie == null ? ElementNodeIndex.class$("org.apache.tools.ant.module.api.ElementCookie") : class$org$apache$tools$ant$module$api$ElementCookie)).getElement());
                ++i;
            }
            Element[] newOrder = new Element[values.length];
            int i2 = 0;
            while (i2 < values.length) {
                newOrder[values[i2]] = ((ElementCookie)nodes[i2].getCookie(class$org$apache$tools$ant$module$api$ElementCookie == null ? ElementNodeIndex.class$("org.apache.tools.ant.module.api.ElementCookie") : class$org$apache$tools$ant$module$api$ElementCookie)).getElement();
                ++i2;
            }
            int i3 = 0;
            while (i3 < newOrder.length) {
                Object oldElement = oldOrder.get(i3);
                if (oldElement != newOrder[i3]) {
                    this.exchangeElements(parent, (Element)oldElement, newOrder[i3]);
                    int oldIndex = oldOrder.indexOf(newOrder[i3]);
                    oldOrder.remove(oldElement);
                    oldOrder.remove(newOrder[i3]);
                    oldOrder.add(i3, newOrder[i3]);
                    oldOrder.add(oldIndex, (Element)oldElement);
                }
                ++i3;
            }
        }

        protected void exchangeElements(org.w3c.dom.Node parent, org.w3c.dom.Node firstChild, org.w3c.dom.Node secondChild) {
            org.w3c.dom.Node secondAfter = secondChild.getNextSibling();
            parent.replaceChild(secondChild, firstChild);
            if (secondAfter != null) {
                parent.insertBefore(firstChild, secondAfter);
            } else {
                parent.appendChild(firstChild);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class ElementPaste
    extends PasteType {
        private boolean cut;
        private Element el;
        private Element el2;

        public ElementPaste(Element el, Element el2, boolean cut) {
            this.el = el;
            this.el2 = el2;
            this.cut = cut;
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public String getDisplayName() {
            return ElementNode.fullText(this.el2);
        }

        public Transferable paste() throws IOException {
            try {
                boolean xdoc;
                boolean bl = xdoc = this.el.getOwnerDocument() != this.el2.getOwnerDocument();
                org.w3c.dom.Node toadd = xdoc ? this.el.getOwnerDocument().importNode(this.el2, true) : (this.cut ? this.el2 : this.el2.cloneNode(true));
                AntModule.err.log("ElementPaste: el=" + this.el + " el2=" + this.el2 + " toadd=" + toadd);
                if (this.cut && xdoc) {
                    this.el2.getParentNode().removeChild(this.el2);
                }
                ElementNode.appendWithIndent(this.el, toadd);
            }
            catch (DOMException dome) {
                IOException ioe = new IOException();
                AntModule.err.annotate((Throwable)ioe, (Throwable)dome);
                throw ioe;
            }
            return this.cut ? ExTransferable.EMPTY : null;
        }
    }
}

