/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.io.File;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class AntOutputParser {
    private static AntOutputParser antOutputParser;

    public static synchronized AntOutputParser getDefault() {
        if (antOutputParser == null) {
            antOutputParser = new AntOutputParser();
        }
        return antOutputParser;
    }

    private AntOutputParser() {
    }

    public Result parse(String line) {
        String message;
        boolean isFile = false;
        if (line.startsWith("file:///")) {
            line = line.substring(7);
            isFile = true;
        } else if (line.startsWith("file:")) {
            line = line.substring(5);
            isFile = true;
        }
        if (!isFile) {
            if (line.length() > 0 && line.charAt(0) == '/') {
                isFile = true;
            }
            if (line.length() > 2 && line.charAt(1) == ':' && line.charAt(2) == '\\') {
                isFile = true;
            }
        }
        if (!isFile) {
            return null;
        }
        int colon1 = line.indexOf(58);
        if (colon1 == -1) {
            return null;
        }
        String fileName = line.substring(0, colon1);
        FileObject fo = this.findFO(fileName);
        if (fo == null) {
            if ((colon1 = line.indexOf(58, colon1 + 1)) == -1) {
                return null;
            }
            fileName = line.substring(0, colon1);
            fo = this.findFO(fileName);
            if (fo == null) {
                return null;
            }
        }
        int line1 = -1;
        int col1 = -1;
        int line2 = -1;
        int col2 = -1;
        int start = colon1 + 1;
        int colon2 = line.indexOf(58, colon1 + 1);
        if (colon2 != -1) {
            try {
                line1 = Integer.parseInt(line.substring(colon1 + 1, colon2).trim()) - 1;
                start = colon2 + 1;
                int colon3 = line.indexOf(58, colon2 + 1);
                if (colon3 != -1) {
                    col1 = Integer.parseInt(line.substring(colon2 + 1, colon3).trim()) - 1;
                    start = colon3 + 1;
                    int colon4 = line.indexOf(58, colon3 + 1);
                    if (colon4 != -1) {
                        line2 = Integer.parseInt(line.substring(colon3 + 1, colon4).trim()) - 1;
                        start = colon4 + 1;
                        int colon5 = line.indexOf(58, colon4 + 1);
                        if (colon5 != -1) {
                            col2 = Integer.parseInt(line.substring(colon4 + 1, colon5).trim()) - 1;
                            if (col2 == col1) {
                                col2 = -1;
                            }
                            start = colon5 + 1;
                        }
                    }
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((message = line.substring(start).trim()).length() == 0) {
            message = null;
        }
        return new Result(fo, line1, col1, line2, col2, message);
    }

    private FileObject findFO(String name) {
        File f = new File(name);
        if (!f.exists()) {
            return null;
        }
        FileObject[] fo = FileUtil.fromFile((File)f);
        if (fo.length > 0) {
            return fo[0];
        }
        return null;
    }

    public static final class Result {
        private FileObject fo;
        private int line1;
        private int col1;
        private int line2;
        private int col2;
        private String message;

        public Result(FileObject fo, int line1, int col1, int line2, int col2, String message) {
            this.fo = fo;
            this.line1 = line1;
            this.col1 = col1;
            this.line2 = line2;
            this.col2 = col2;
            this.message = message;
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        public int getLineStart() {
            return this.line1;
        }

        public int getLineEnd() {
            return this.line2;
        }

        public int getColumnStart() {
            return this.col1;
        }

        public int getColumnEnd() {
            return this.col2;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

