/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.spi.AntOutputStream;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.WeakSet;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class OutputWriterOutputStream
extends AntOutputStream {
    private OutputWriter writer;
    private static final Set hyperlinks = new WeakSet();

    public OutputWriterOutputStream(OutputWriter writer) {
        this.writer = writer;
    }

    protected void handleClose() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    protected void writeLine(String line, FileObject file, int line1, int col1, int line2, int col2, String message) throws IOException {
        Hyperlink h = new Hyperlink(file, line1, col1, line2, col2, message);
        String fname = file.getPackageNameExt('/', '.');
        this.writer.println(this.formatMessage(fname, message, line1, col1, line2, col2), (OutputListener)h);
    }

    protected void writeLine(String line) throws IOException {
        this.writer.println(line);
    }

    public static void detachAllAnnotations() {
        Set set = hyperlinks;
        synchronized (set) {
            Iterator it = hyperlinks.iterator();
            while (it.hasNext()) {
                ((Hyperlink)it.next()).destroy();
            }
        }
    }

    private static final class Hyperlink
    extends Annotation
    implements OutputListener,
    PropertyChangeListener {
        private FileObject file;
        private int line1;
        private int col1;
        private int line2;
        private int col2;
        private String message;
        private boolean dead = false;
        static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

        Hyperlink(FileObject file, int line1, int col1, int line2, int col2, String message) {
            this.file = file;
            this.line1 = line1;
            this.col1 = col1;
            this.line2 = line2;
            this.col2 = col2;
            this.message = message;
            Set set = hyperlinks;
            synchronized (set) {
                hyperlinks.add(this);
            }
        }

        void destroy() {
            this.doDetach();
            this.dead = true;
        }

        public void outputLineAction(OutputEvent ev) {
            if (this.dead) {
                return;
            }
            if (!this.file.isValid()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (this.message != null) {
                StatusDisplayer.getDefault().setStatusText(this.message);
            }
            try {
                DataObject dob = DataObject.find((FileObject)this.file);
                EditorCookie ed = (EditorCookie)dob.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = Hyperlink.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                if (ed != null) {
                    if (this.line1 == -1) {
                        ed.open();
                    } else {
                        ed.openDocument();
                        AntModule.err.log("opened document for " + this.file);
                        Line l = ed.getLineSet().getOriginal(this.line1);
                        if (!l.isDeleted()) {
                            this.attachAsNeeded(l);
                            if (this.col1 == -1) {
                                l.show(2);
                            } else {
                                l.show(2, this.col1);
                            }
                        }
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify(16, (Throwable)donfe);
            }
            catch (IndexOutOfBoundsException iobe) {
                ErrorManager.getDefault().notify(16, (Throwable)iobe);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(16, (Throwable)ioe);
            }
        }

        public void outputLineSelected(OutputEvent ev) {
            if (this.dead) {
                return;
            }
            if (!this.file.isValid()) {
                return;
            }
            try {
                DataObject dob = DataObject.find((FileObject)this.file);
                EditorCookie ed = (EditorCookie)dob.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = Hyperlink.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                if (ed != null) {
                    Line l;
                    if (ed.getDocument() == null) {
                        AntModule.err.log("no document for " + this.file);
                        return;
                    }
                    AntModule.err.log("got document for " + this.file);
                    if (this.line1 != -1 && !(l = ed.getLineSet().getOriginal(this.line1)).isDeleted()) {
                        this.attachAsNeeded(l);
                        if (this.col1 == -1) {
                            l.show(0);
                        } else {
                            l.show(0, this.col1);
                        }
                    }
                }
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify(16, (Throwable)donfe);
            }
            catch (IndexOutOfBoundsException iobe) {
                ErrorManager.getDefault().notify(16, (Throwable)iobe);
            }
        }

        private synchronized void attachAsNeeded(Line l) {
            if (this.getAttachedAnnotatable() == null) {
                Line ann;
                boolean log = AntModule.err.isLoggable(0);
                String text = l.getText();
                if (log) {
                    AntModule.err.log("Attaching to line " + l.getDisplayName() + " text=`" + text + "' line1=" + this.line1 + " line2=" + this.line2 + " col1=" + this.col1 + " col2=" + this.col2);
                }
                if (text != null && (this.line2 == -1 || this.line1 == this.line2) && this.col1 != -1) {
                    int new_col1 = this.convertTabColumnsToCharacterColumns(text, this.col1, 8);
                    int new_col2 = this.convertTabColumnsToCharacterColumns(text, this.col2, 8);
                    if (log) {
                        AntModule.err.log("\tfits on one line");
                    }
                    if (new_col2 != -1 && new_col2 >= new_col1 && new_col2 < text.length()) {
                        if (log) {
                            AntModule.err.log("\tspecified section of the line");
                        }
                        ann = l.createPart(new_col1, new_col2 - new_col1 + 1);
                    } else if (new_col1 < text.length()) {
                        if (log) {
                            AntModule.err.log("\tspecified umn to end of line");
                        }
                        ann = l.createPart(new_col1, text.length() - new_col1 - 1);
                    } else {
                        if (log) {
                            AntModule.err.log("\tcolumn numbers are bogus");
                        }
                        ann = l;
                    }
                } else {
                    if (log) {
                        AntModule.err.log("\tmultiple lines, something wrong with line, or no column given");
                    }
                    ann = l;
                }
                this.attach((Annotatable)ann);
                Iterator it = hyperlinks.iterator();
                while (it.hasNext()) {
                    Hyperlink h = (Hyperlink)it.next();
                    if (h == this) continue;
                    h.doDetach();
                }
                ann.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private int convertTabColumnsToCharacterColumns(String text, int column, int tabSize) {
            char[] textChars = text.toCharArray();
            int jikes_column = 0;
            int i = 0;
            while (i < textChars.length && jikes_column < column) {
                jikes_column = textChars[i] == '\t' ? (jikes_column += tabSize - jikes_column % tabSize) : ++jikes_column;
                ++i;
            }
            return i;
        }

        private synchronized void doDetach() {
            Annotatable ann = this.getAttachedAnnotatable();
            if (ann != null) {
                if (AntModule.err.isLoggable(0)) {
                    AntModule.err.log("Detaching from " + ann + " `" + ann.getText() + "'");
                }
                ann.removePropertyChangeListener((PropertyChangeListener)this);
                this.detach();
            }
        }

        public void outputLineCleared(OutputEvent ev) {
            this.doDetach();
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (this.dead) {
                return;
            }
            String prop = ev.getPropertyName();
            if (prop == null || prop.equals("text") || prop.equals("deleted")) {
                if (AntModule.err.isLoggable(0)) {
                    AntModule.err.log("Received Annotatable property change: " + prop);
                }
                this.doDetach();
            }
        }

        public String getAnnotationType() {
            return "org-apache-tools-ant-module-error";
        }

        public String getShortDescription() {
            return this.message;
        }

        public String toString() {
            return "Hyperlink[" + this.file + ":" + this.line1 + ":" + this.col1 + ":" + this.line2 + ":" + this.col2 + "]";
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

