/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AllPermission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.DefinitionRegistry;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.apache.tools.ant.module.run.NBInputHandler;
import org.apache.tools.ant.module.run.NetBeansLogger;
import org.apache.tools.ant.module.run.OutputWriterOutputStream;
import org.openide.LifecycleManager;
import org.openide.actions.ExecuteAction;
import org.openide.awt.Actions;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbClassLoader;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;
import org.w3c.dom.Element;

public class TargetExecutor
implements Runnable {
    private AntProjectCookie pcookie;
    private InputOutput io;
    private OutputStream outputStream;
    private boolean ok = false;
    private int verbosity = AntSettings.getDefault().getVerbosity();
    private Properties properties = (Properties)((Hashtable)AntSettings.getDefault().getProperties()).clone();
    private List targetNames;
    private boolean switchWorkspace = false;
    private boolean workarounded = false;
    static /* synthetic */ Class class$org$apache$tools$ant$module$run$TargetExecutor;

    public TargetExecutor(AntProjectCookie pcookie, String[] targets) {
        this.pcookie = pcookie;
        this.targetNames = targets == null ? null : Arrays.asList(targets);
    }

    public void setVerbosity(int v) {
        this.verbosity = v;
    }

    public synchronized void setProperties(Properties p) {
        this.properties = (Properties)((Hashtable)p).clone();
    }

    public synchronized void addProperties(Properties p) {
        if (((Hashtable)p).isEmpty()) {
            return;
        }
        Properties old = this.properties;
        this.properties = new Properties();
        ((Hashtable)this.properties).putAll(old);
        ((Hashtable)this.properties).putAll(p);
    }

    public void setSwitchWorkspace(boolean sw) {
        this.switchWorkspace = sw;
    }

    public ExecutorTask execute() throws IOException {
        return this.execute((String)null);
    }

    ExecutorTask execute(String name) throws IOException {
        ExecutorTask task;
        if (name == null) {
            if (AntSettings.getDefault().getReuseOutput()) {
                name = NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$run$TargetExecutor == null ? (class$org$apache$tools$ant$module$run$TargetExecutor = TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor")) : class$org$apache$tools$ant$module$run$TargetExecutor), (String)"TITLE_output_reused");
            } else {
                Element projel = this.pcookie.getProjectElement();
                String projectName = projel != null ? Actions.cutAmpersand((String)projel.getAttribute("name")) : NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$run$TargetExecutor == null ? (class$org$apache$tools$ant$module$run$TargetExecutor = TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor")) : class$org$apache$tools$ant$module$run$TargetExecutor), (String)"LBL_unparseable_proj_name");
                String fileName = this.pcookie.getFileObject() != null ? DataObject.find((FileObject)this.pcookie.getFileObject()).getNodeDelegate().getDisplayName() : this.pcookie.getFile().getName();
                if (projectName.equals("")) {
                    projectName = fileName;
                }
                if (this.targetNames != null) {
                    StringBuffer targetList = new StringBuffer();
                    Iterator it = this.targetNames.iterator();
                    if (it.hasNext()) {
                        targetList.append((String)it.next());
                    }
                    while (it.hasNext()) {
                        targetList.append(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$run$TargetExecutor == null ? TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor") : class$org$apache$tools$ant$module$run$TargetExecutor), (String)"SEP_output_target"));
                        targetList.append((String)it.next());
                    }
                    name = NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$run$TargetExecutor == null ? (class$org$apache$tools$ant$module$run$TargetExecutor = TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor")) : class$org$apache$tools$ant$module$run$TargetExecutor), (String)"TITLE_output_target", (Object)projectName, (Object)fileName, (Object)targetList);
                } else {
                    name = NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$run$TargetExecutor == null ? (class$org$apache$tools$ant$module$run$TargetExecutor = TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor")) : class$org$apache$tools$ant$module$run$TargetExecutor), (String)"TITLE_output_notarget", (Object)projectName, (Object)fileName);
                }
            }
        }
        TargetExecutor targetExecutor = this;
        synchronized (targetExecutor) {
            if (this.switchWorkspace) {
                Mutex.EVENT.readAccess(new Mutex.Action(){

                    public Object run() {
                        Workspace w = WindowManager.getDefault().findWorkspace(ExecuteAction.getWorkspace());
                        if (w != null) {
                            w.activate();
                        }
                        return null;
                    }
                });
            }
            this.io = IOProvider.getDefault().getIO(name, false);
            this.io.getOut().reset();
            this.io.select();
            task = ExecutionEngine.getDefault().execute(name, (Runnable)this, InputOutput.NULL);
        }
        WrapperExecutorTask wrapper = new WrapperExecutorTask(task, this.io);
        RequestProcessor.getDefault().post((Runnable)((Object)wrapper));
        return wrapper;
    }

    public ExecutorTask execute(OutputStream outputStream) throws IOException {
        this.outputStream = outputStream;
        ExecutorTask task = ExecutionEngine.getDefault().execute(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$run$TargetExecutor == null ? (class$org$apache$tools$ant$module$run$TargetExecutor = TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor")) : class$org$apache$tools$ant$module$run$TargetExecutor), (String)"LABEL_execution_name"), (Runnable)this, InputOutput.NULL);
        return new WrapperExecutorTask(task, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        Project project;
        block24: {
            NetBeansLogger logger;
            if (this.outputStream == null) {
                this.io.setFocusTaken(true);
                this.io.setErrVisible(false);
                this.io.setErrSeparated(false);
            }
            if (AntSettings.getDefault().getSaveAll()) {
                LifecycleManager.getDefault().saveAll();
            }
            this.regexpLibraryWorkaroundForAnt151();
            project = null;
            PrintStream err = this.outputStream == null ? new PrintStream(new OutputWriterOutputStream(this.io.getErr())) : new PrintStream(this.outputStream);
            PrintStream out = err;
            try {
                Map.Entry entry;
                File buildFile = this.pcookie.getFile();
                if (buildFile == null) {
                    Class clazz;
                    if (class$org$apache$tools$ant$module$run$TargetExecutor == null) {
                        clazz = class$org$apache$tools$ant$module$run$TargetExecutor = TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor");
                        throw new BuildException(NbBundle.getMessage((Class)clazz, (String)"EXC_non_local_proj_file"));
                    }
                    clazz = class$org$apache$tools$ant$module$run$TargetExecutor;
                    throw new BuildException(NbBundle.getMessage((Class)clazz, (String)"EXC_non_local_proj_file"));
                }
                project = new Project();
                project.init();
                Iterator defs = DefinitionRegistry.getDefs("task").entrySet().iterator();
                while (true) {
                    if (!defs.hasNext()) break;
                    entry = defs.next();
                    project.addTaskDefinition((String)entry.getKey(), (Class)entry.getValue());
                }
                defs = DefinitionRegistry.getDefs("type").entrySet().iterator();
                while (true) {
                    if (!defs.hasNext()) break;
                    entry = defs.next();
                    project.addDataTypeDefinition((String)entry.getKey(), (Class)entry.getValue());
                }
                project.setUserProperty("ant.file", buildFile.getAbsolutePath());
                project.setUserProperty("ant.version", Main.getAntVersion());
                Iterator it = ((Hashtable)this.properties).entrySet().iterator();
                while (true) {
                    block25: {
                        if (it.hasNext()) break block25;
                    }
                    Map.Entry entry2 = it.next();
                    project.setUserProperty((String)entry2.getKey(), (String)entry2.getValue());
                }
                logger = new NetBeansLogger(this.outputStream == null);
                logger.setMessageOutputLevel(this.verbosity);
                logger.setOutputPrintStream(out);
                logger.setErrorPrintStream(err);
                project.addBuildListener(logger);
                ProjectHelper.configureProject(project, buildFile);
                String inputHandlerName = AntSettings.getDefault().getInputHandler();
                InputHandler inputHandler = null;
                if (inputHandlerName != null && inputHandlerName.length() > 0) {
                    try {
                        NbClassLoader l = new NbClassLoader();
                        Permissions perm = new Permissions();
                        perm.add(new AllPermission());
                        l.setDefaultPermissions((PermissionCollection)perm);
                        Class<?> clazz = Class.forName(inputHandlerName, true, (ClassLoader)l);
                        inputHandler = (InputHandler)clazz.newInstance();
                    }
                    catch (Exception ex) {
                        Class clazz;
                        if (class$org$apache$tools$ant$module$run$TargetExecutor == null) {
                            clazz = class$org$apache$tools$ant$module$run$TargetExecutor = TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor");
                            throw new BuildException(NbBundle.getMessage((Class)clazz, (String)"MSG_input_handler_exception", (Object)inputHandlerName), ex);
                        }
                        clazz = class$org$apache$tools$ant$module$run$TargetExecutor;
                        throw new BuildException(NbBundle.getMessage((Class)clazz, (String)"MSG_input_handler_exception", (Object)inputHandlerName), ex);
                    }
                }
                if (inputHandler == null) {
                    inputHandler = new NBInputHandler();
                }
                project.setInputHandler(inputHandler);
            }
            catch (BuildException be) {
                if (this.verbosity >= 3) {
                    be.printStackTrace(err);
                    return;
                }
                err.println(be);
                return;
            }
            logger.buildStarted(new BuildEvent(project));
            PrintStream sysout = System.out;
            PrintStream syserr = System.err;
            System.setOut(new PrintStream(new DemuxOutputStream(project, false)));
            System.setErr(new PrintStream(new DemuxOutputStream(project, true)));
            try {
                try {
                    Vector<String> targs;
                    if (this.targetNames != null) {
                        targs = new Vector(this.targetNames);
                    } else {
                        targs = new Vector<String>(1);
                        targs.add(project.getDefaultTarget());
                    }
                    project.executeTargets(targs);
                    logger.buildFinished(new BuildEvent(project));
                    this.ok = true;
                }
                catch (ThreadDeath td) {
                    if (this.outputStream == null) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$run$TargetExecutor == null ? (class$org$apache$tools$ant$module$run$TargetExecutor = TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor")) : class$org$apache$tools$ant$module$run$TargetExecutor), (String)"MSG_target_failed_status"));
                    }
                    Object var14_19 = null;
                    System.setOut(sysout);
                    System.setErr(syserr);
                    return;
                }
                catch (Exception e) {
                    BuildEvent ev = new BuildEvent(project);
                    ev.setException(e);
                    logger.buildFinished(ev);
                    Object var14_20 = null;
                    System.setOut(sysout);
                    System.setErr(syserr);
                    break block24;
                }
                catch (LinkageError e) {
                    BuildEvent ev = new BuildEvent(project);
                    ev.setException(e);
                    logger.buildFinished(ev);
                    Object var14_21 = null;
                    System.setOut(sysout);
                    System.setErr(syserr);
                    break block24;
                }
                Object var14_18 = null;
            }
            catch (Throwable throwable) {
                Object var14_22 = null;
                System.setOut(sysout);
                System.setErr(syserr);
                throw throwable;
            }
            System.setOut(sysout);
            System.setErr(syserr);
        }
        final Project p2 = project;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                IntrospectedInfo custom = AntSettings.getDefault().getCustomDefs();
                custom.scanProject(p2);
                FileObject script = TargetExecutor.this.pcookie.getFileObject();
                if (script != null) {
                    try {
                        FileSystem fs = script.getFileSystem();
                        fs.refresh(false);
                    }
                    catch (FileStateInvalidException e) {
                        AntModule.err.notify(16, (Throwable)e);
                    }
                }
            }
        }, 1000);
    }

    private void regexpLibraryWorkaroundForAnt151() {
        if (this.workarounded) {
            return;
        }
        this.workarounded = true;
        if (System.getProperty("ant.regexp.regexpimpl") != null) {
            return;
        }
        try {
            Class.forName("java.util.regex.Matcher");
            System.setProperty("ant.regexp.regexpimpl", "org.apache.tools.ant.util.regexp.Jdk14RegexpRegexp");
            return;
        }
        catch (Throwable t) {
            try {
                Class.forName("org.apache.oro.text.regex.Pattern");
                System.setProperty("ant.regexp.regexpimpl", "org.apache.tools.ant.util.regexp.JakartaOroRegexp");
                return;
            }
            catch (Throwable t2) {
                try {
                    Class.forName("org.apache.regexp.RE");
                    System.setProperty("ant.regexp.regexpimpl", "org.apache.tools.ant.util.regexp.JakartaRegexpRegexp");
                    return;
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WrapperRunnable
    implements Runnable {
        private ExecutorTask task;

        public WrapperRunnable(ExecutorTask task) {
            this.task = task;
        }

        public void run() {
            this.task.waitFinished();
        }
    }

    private class WrapperExecutorTask
    extends ExecutorTask {
        private ExecutorTask task;
        private InputOutput inputOutput;

        public WrapperExecutorTask(ExecutorTask task, InputOutput inputOutput) {
            super((Runnable)new WrapperRunnable(task));
            this.task = task;
            this.inputOutput = inputOutput;
        }

        public void stop() {
            this.task.stop();
        }

        public int result() {
            return this.task.result() + (TargetExecutor.this.ok ? 0 : 1);
        }

        public InputOutput getInputOutput() {
            return this.inputOutput;
        }
    }
}

