/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.spi;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.ant.module.run.AntOutputParser;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public abstract class AntOutputStream
extends OutputStream {
    private StringBuffer buffer = new StringBuffer(1000);
    private boolean hadFirst = false;
    private AntOutputParser antOutputParser = AntOutputParser.getDefault();
    static /* synthetic */ Class class$org$apache$tools$ant$module$spi$AntOutputStream;

    public final void close() throws IOException {
        this.flush();
        this.handleClose();
    }

    protected void handleClose() throws IOException {
    }

    public final void flush() throws IOException {
        this.flushLines(true);
    }

    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public final void write(byte[] b, int offset, int length) throws IOException {
        this.buffer.append(new String(b, offset, length));
        this.flushLines(false);
    }

    public final void write(int b) throws IOException {
        this.buffer.append((char)b);
        if ((char)b == '\n') {
            this.flushLines(false);
        }
    }

    private void flushLines(boolean flushEverything) throws IOException {
        block0: while (true) {
            int len = this.buffer.length();
            int i = 0;
            while (i < len) {
                if (this.buffer.charAt(i) == '\n') {
                    int end = i;
                    if (end > 0 && this.buffer.charAt(end - 1) == '\r') {
                        --end;
                    }
                    this.flushLine(this.buffer.substring(0, end));
                    this.buffer.delete(0, i + 1);
                    continue block0;
                }
                ++i;
            }
            break;
        }
        if (flushEverything) {
            this.flushLine(this.buffer.substring(0, this.buffer.length()));
            this.buffer.delete(0, this.buffer.length());
        }
    }

    private void flushLine(String l) throws IOException {
        AntOutputParser.Result r;
        if (!this.hadFirst) {
            this.hadFirst = true;
            if (l.trim().length() == 0) {
                return;
            }
        }
        if ((r = this.antOutputParser.parse(l)) == null) {
            this.writeLine(l);
        } else {
            this.writeLine(l, r.getFileObject(), r.getLineStart(), r.getColumnStart(), r.getLineEnd(), r.getColumnEnd(), r.getMessage());
        }
    }

    protected abstract void writeLine(String var1, FileObject var2, int var3, int var4, int var5, int var6, String var7) throws IOException;

    protected abstract void writeLine(String var1) throws IOException;

    protected String formatMessage(String fileName, String message, int line1, int col1, int line2, int col2) {
        String m = message != null ? message : NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$spi$AntOutputStream == null ? (class$org$apache$tools$ant$module$spi$AntOutputStream = AntOutputStream.class$("org.apache.tools.ant.module.spi.AntOutputStream")) : class$org$apache$tools$ant$module$spi$AntOutputStream), (String)"ERR_unknown");
        fileName = fileName.replace('\\', File.separatorChar);
        fileName = fileName.replace('/', File.separatorChar);
        if (line1 == -1) {
            return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$spi$AntOutputStream == null ? (class$org$apache$tools$ant$module$spi$AntOutputStream = AntOutputStream.class$("org.apache.tools.ant.module.spi.AntOutputStream")) : class$org$apache$tools$ant$module$spi$AntOutputStream), (String)"MSG_err", (Object)fileName, (Object)m);
        }
        if (col1 == -1) {
            return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$spi$AntOutputStream == null ? (class$org$apache$tools$ant$module$spi$AntOutputStream = AntOutputStream.class$("org.apache.tools.ant.module.spi.AntOutputStream")) : class$org$apache$tools$ant$module$spi$AntOutputStream), (String)"MSG_err_line", (Object)fileName, (Object)m, (Object)new Integer(line1 + 1));
        }
        if (line2 == -1 || col2 == -1 || line1 == line2 && col1 == col2) {
            return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$spi$AntOutputStream == null ? (class$org$apache$tools$ant$module$spi$AntOutputStream = AntOutputStream.class$("org.apache.tools.ant.module.spi.AntOutputStream")) : class$org$apache$tools$ant$module$spi$AntOutputStream), (String)"MSG_err_line_col", (Object[])new Object[]{fileName, m, new Integer(line1 + 1), new Integer(col1 + 1)});
        }
        if (line1 == line2) {
            return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$spi$AntOutputStream == null ? (class$org$apache$tools$ant$module$spi$AntOutputStream = AntOutputStream.class$("org.apache.tools.ant.module.spi.AntOutputStream")) : class$org$apache$tools$ant$module$spi$AntOutputStream), (String)"MSG_err_line_col_col", (Object[])new Object[]{fileName, m, new Integer(line1 + 1), new Integer(col1 + 1), new Integer(col2 + 1)});
        }
        return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$spi$AntOutputStream == null ? (class$org$apache$tools$ant$module$spi$AntOutputStream = AntOutputStream.class$("org.apache.tools.ant.module.spi.AntOutputStream")) : class$org$apache$tools$ant$module$spi$AntOutputStream), (String)"MSG_err_line_col_line_col", (Object[])new Object[]{fileName, m, new Integer(line1 + 1), new Integer(col1 + 1), new Integer(line2 + 1), new Integer(col2 + 1)});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

