/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.properties;

import java.awt.Component;
import java.awt.Dialog;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.nodes.AntProjectNode;
import org.apache.tools.ant.module.wizards.properties.PropertiesIterator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class PropertiesFileProperty
extends PropertySupport {
    public static final String ANT_FILE_EXT = "ant.properties";
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty;
    static /* synthetic */ Class class$org$apache$tools$ant$module$wizards$properties$AddPropertiesPanel;

    public PropertiesFileProperty(String displayName, String description) {
        super("propertiesFileProperty", class$java$util$Properties == null ? (class$java$util$Properties = PropertiesFileProperty.class$("java.util.Properties")) : class$java$util$Properties, displayName, description, true, true);
    }

    public abstract Element getElement();

    public abstract AntProjectCookie getAntProjectCookie();

    public boolean canWrite() {
        if (this.getElement() == null) {
            return false;
        }
        if (AntProjectNode.isScriptReadOnly(this.getAntProjectCookie())) {
            return false;
        }
        if (PropertiesFileProperty.findPropertyElement(this.getElement()) == null) {
            return true;
        }
        return PropertiesFileProperty.findPropertiesFile(this.getElement(), this.getAntProjectCookie()) != null;
    }

    public Object getValue() {
        return PropertiesFileProperty.loadProperties(this.getElement(), this.getAntProjectCookie());
    }

    public void setValue(Object val) {
        if (val instanceof Properties) {
            PropertiesFileProperty.storeProperties(this.getElement(), this.getAntProjectCookie(), (Properties)val);
        }
    }

    public PropertyEditor getPropertyEditor() {
        Element el2 = PropertiesFileProperty.findPropertyElement(this.getElement());
        if (el2 != null) {
            return super.getPropertyEditor();
        }
        ((FeatureDescriptor)((Object)this)).setValue("canEditAsText", Boolean.FALSE);
        return new PropertiesFileWizard();
    }

    protected abstract void firePropertiesFilePropertyChange();

    protected static Element findPropertyElement(Element el) {
        if (el == null) {
            return null;
        }
        NodeList nl = el.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Element child;
            String fileAttribute;
            Node n = nl.item(i);
            if (n.getNodeName().equals("property") && (fileAttribute = (child = (Element)n).getAttribute("file")).length() > 0 && fileAttribute.indexOf("${") < 0) {
                return child;
            }
            ++i;
        }
        return null;
    }

    protected static Object findPropertiesFile(Element el, AntProjectCookie proj) {
        if (el == null || proj == null) {
            return null;
        }
        Element property = PropertiesFileProperty.findPropertyElement(el);
        if (property != null) {
            String fileAttribute = property.getAttribute("file");
            if (proj.getFileObject() != null) {
                FileObject parent = proj.getFileObject().getParent();
                return parent.getFileObject(fileAttribute);
            }
            if (proj.getFile() != null) {
                File parent = proj.getFile().getParentFile();
                return new File(parent, fileAttribute);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void storeProperties(Element el, AntProjectCookie proj, Properties p) {
        if (el == null) return;
        if (proj == null) {
            return;
        }
        Object o = PropertiesFileProperty.findPropertiesFile(el, proj);
        if (o instanceof FileObject) {
            FileObject propFile = (FileObject)o;
            FileLock lock = null;
            try {
                lock = propFile.lock();
            }
            catch (IOException ioe) {
                AntModule.err.log("Could not lock File " + propFile);
            }
            if (lock == null) return;
            try {
                try {
                    BufferedOutputStream bos = new BufferedOutputStream(propFile.getOutputStream(lock));
                    p.store(bos, NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty == null ? (class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty = PropertiesFileProperty.class$("org.apache.tools.ant.module.wizards.properties.PropertiesFileProperty")) : class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty), (String)"ant_properties_file_header"));
                    bos.close();
                }
                catch (IOException ioe) {
                    AntModule.err.log("could not save to FileObject " + propFile);
                    Object var8_13 = null;
                    lock.releaseLock();
                    return;
                }
                Object var8_12 = null;
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                lock.releaseLock();
                throw throwable;
            }
            lock.releaseLock();
            return;
        }
        if (!(o instanceof File)) return;
        File propertiesFile = (File)o;
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(propertiesFile));
            p.store(bos, NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty == null ? (class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty = PropertiesFileProperty.class$("org.apache.tools.ant.module.wizards.properties.PropertiesFileProperty")) : class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty), (String)"ant_properties_file_header"));
            bos.close();
            return;
        }
        catch (IOException ioe) {
            AntModule.err.log("Could not save to File " + propertiesFile);
        }
    }

    static Properties loadProperties(Element el, AntProjectCookie proj) {
        if (el == null || proj == null) {
            return null;
        }
        Object o = PropertiesFileProperty.findPropertiesFile(el, proj);
        if (o instanceof FileObject) {
            FileObject propFile = (FileObject)o;
            Properties p = new Properties();
            try {
                BufferedInputStream bis = new BufferedInputStream(propFile.getInputStream());
                p.load(bis);
                bis.close();
                return p;
            }
            catch (IOException ioe) {
                AntModule.err.log("Could not read FileObject " + propFile);
            }
        } else if (o instanceof File) {
            File propertiesFile = (File)o;
            Properties p = new Properties();
            try {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(propertiesFile));
                p.load(bis);
                bis.close();
                return p;
            }
            catch (IOException ioe) {
                AntModule.err.log("Could not read File " + propertiesFile);
            }
        }
        return null;
    }

    static String createPropertiesHeaderString() {
        StringBuffer sb = new StringBuffer();
        sb.append("#");
        sb.append(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$properties$AddPropertiesPanel == null ? (class$org$apache$tools$ant$module$wizards$properties$AddPropertiesPanel = PropertiesFileProperty.class$("org.apache.tools.ant.module.wizards.properties.AddPropertiesPanel")) : class$org$apache$tools$ant$module$wizards$properties$AddPropertiesPanel), (String)"ant_properties_file_header"));
        sb.append("\n#");
        sb.append(new Date().toString());
        sb.append("\n");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PropertiesFileWizard
    extends PropertyEditorSupport
    implements PropertyChangeListener {
        WizardDescriptor wd;
        private final int INDENT_STEP = 4;
        static /* synthetic */ Class class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator;
        static /* synthetic */ Class class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty;

        PropertiesFileWizard() {
        }

        public Component getCustomEditor() {
            this.wd = new WizardDescriptor((WizardDescriptor.Iterator)new PropertiesIterator(PropertiesFileProperty.this.getElement(), PropertiesFileProperty.this.getAntProjectCookie()));
            this.wd.setTitle(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator == null ? (class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator = PropertiesFileWizard.class$("org.apache.tools.ant.module.wizards.properties.PropertiesIterator")) : class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator), (String)"TITLE_wizard_window"));
            this.wd.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
            this.wd.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
            this.wd.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
            this.wd.setTitleFormat(new MessageFormat(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty == null ? (class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty = PropertiesFileWizard.class$("org.apache.tools.ant.module.wizards.properties.PropertiesFileProperty")) : class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty), (String)"FMT_wizard_title")));
            this.wd.addPropertyChangeListener((PropertyChangeListener)this);
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wd);
            return d;
        }

        public String getAsText() {
            if (PropertiesFileProperty.this.getElement() == null) {
                return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator == null ? (class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator = PropertiesFileWizard.class$("org.apache.tools.ant.module.wizards.properties.PropertiesIterator")) : class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator), (String)"LBL_property_invalid_no_element");
            }
            if (PropertiesFileProperty.this.canWrite()) {
                return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator == null ? (class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator = PropertiesFileWizard.class$("org.apache.tools.ant.module.wizards.properties.PropertiesIterator")) : class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator), (String)"MSG_open_wizard");
            }
            return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator == null ? (class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator = PropertiesFileWizard.class$("org.apache.tools.ant.module.wizards.properties.PropertiesIterator")) : class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator), (String)"MSG_any_properties_defined");
        }

        public boolean supportsCustomEditor() {
            return PropertiesFileProperty.this.canWrite();
        }

        private void insertFirstWithIndent(Element parent, Node child) throws DOMException {
            Node doc = parent;
            int depth = -1;
            while (!(doc instanceof Document)) {
                doc = doc.getParentNode();
                ++depth;
            }
            Text current = ((Document)doc).createTextNode("\n" + this.spaces((depth + 1) * 4));
            Node before = parent.getFirstChild();
            if (before != null) {
                parent.insertBefore(current, before);
                parent.insertBefore(child, before);
            } else {
                parent.appendChild(current);
                parent.appendChild(child);
            }
        }

        private String spaces(int size) {
            char[] chars = new char[size];
            int i = 0;
            while (i < size) {
                chars[i] = 32;
                ++i;
            }
            return new String(chars);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void propertyChange(PropertyChangeEvent evt) {
            block14: {
                String fileName;
                block13: {
                    AntProjectCookie proj;
                    block15: {
                        if (evt.getNewValue() != NotifyDescriptor.OK_OPTION) break block14;
                        fileName = (String)this.wd.getProperty("wizdata.fileName");
                        proj = PropertiesFileProperty.this.getAntProjectCookie();
                        if (proj.getFileObject() == null) break block15;
                        FileObject parent = proj.getFileObject().getParent();
                        FileObject propFile = parent.getFileObject(fileName, PropertiesFileProperty.ANT_FILE_EXT);
                        if (propFile != null) break block13;
                        try {
                            propFile = parent.createData(fileName, PropertiesFileProperty.ANT_FILE_EXT);
                        }
                        catch (IOException ioe) {
                            return;
                        }
                        FileLock lock = null;
                        try {
                            lock = propFile.lock();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        if (lock != null) {
                            try {
                                try {
                                    String contents = (String)this.wd.getProperty("wizdata.contents");
                                    if (contents == null) {
                                        contents = PropertiesFileProperty.createPropertiesHeaderString();
                                    }
                                    BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(propFile.getOutputStream(lock)));
                                    bw.write(contents);
                                    bw.close();
                                }
                                catch (IOException ioe) {
                                    AntModule.err.log("IOException while writing properties file");
                                    Object var10_14 = null;
                                    lock.releaseLock();
                                    break block13;
                                }
                                Object var10_13 = null;
                            }
                            catch (Throwable throwable) {
                                Object var10_15 = null;
                                lock.releaseLock();
                                throw throwable;
                            }
                            lock.releaseLock();
                        }
                        break block13;
                    }
                    if (proj.getFile() == null) {
                        AntModule.err.log("Could not create Properties file, script FileObject missing");
                        return;
                    }
                }
                Element el = PropertiesFileProperty.this.getElement();
                try {
                    Element prop = el.getOwnerDocument().createElement("property");
                    prop.setAttribute("file", fileName + "." + PropertiesFileProperty.ANT_FILE_EXT);
                    this.insertFirstWithIndent(el, prop);
                }
                catch (DOMException d) {
                    AntModule.err.log("Error while creating property Element.");
                }
                PropertiesFileProperty.this.firePropertiesFilePropertyChange();
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

