/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.shortcut;

import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.wizards.shortcut.CustomizeScriptPanel;
import org.apache.tools.ant.module.wizards.shortcut.IntroPanel;
import org.apache.tools.ant.module.wizards.shortcut.SelectFolderPanel;
import org.apache.tools.ant.module.wizards.shortcut.SelectKeyboardShortcutPanel;
import org.apache.tools.ant.module.wizards.shortcut.SelectTargetPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ShortcutIterator
implements TemplateWizard.Iterator {
    public static final String PROP_CODE_NAME = "wizdata.codeName";
    public static final String PROP_CONTENTS = "wizdata.contents";
    public static final String PROP_SHOW_CUST = "wizdata.show.cust";
    public static final String PROP_SHOW_MENU = "wizdata.show.menu";
    public static final String PROP_SHOW_TOOL = "wizdata.show.tool";
    public static final String PROP_SHOW_PROJ = "wizdata.show.proj";
    public static final String PROP_SHOW_KEYB = "wizdata.show.keyb";
    public static final String PROP_FOLDER_MENU = "wizdata.folder.menu";
    public static final String PROP_FOLDER_TOOL = "wizdata.folder.tool";
    public static final String PROP_FOLDER_PROJ = "wizdata.folder.proj";
    public static final String PROP_STROKE = "wizdata.stroke";
    private static final long serialVersionUID = 47387529866399027L;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor.Panel[] currentPanels;
    private transient TemplateWizard wiz;
    private transient Set listeners = new HashSet(1);
    static /* synthetic */ Class class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator;

    protected WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new IntroPanel.IntroWizardPanel(), new SelectTargetPanel.SelectTargetWizardPanel(), new CustomizeScriptPanel.CustomizeScriptWizardPanel(), new SelectFolderPanel.SelectFolderWizardPanel(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_select_menu_to_add_to"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_TEXT_menu_locn"), DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("Menu")).getNodeDelegate(), false, true, PROP_FOLDER_MENU), new SelectFolderPanel.SelectFolderWizardPanel(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_select_toolbar"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_TEXT_toolbar_locn"), DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("Toolbars")).getNodeDelegate(), false, false, PROP_FOLDER_TOOL), new SelectFolderPanel.SelectFolderWizardPanel(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_select_proj_folder"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_TEXT_select_project_locn"), RepositoryNodeFactory.getDefault().repository(DataFilter.ALL), true, false, PROP_FOLDER_PROJ), new SelectKeyboardShortcutPanel.SelectKeyboardShortcutWizardPanel()};
    }

    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_choose_options"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_select_ant_target"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_cust_script"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_add_to_menu"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_add_to_toolbar"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_add_to_proj"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_make_keyboard_shortcut")};
    }

    private void dumpContents() {
        String[] keys = new String[]{PROP_CODE_NAME, PROP_CONTENTS, PROP_SHOW_CUST, PROP_SHOW_MENU, PROP_SHOW_TOOL, PROP_SHOW_PROJ, PROP_SHOW_KEYB, PROP_FOLDER_MENU, PROP_FOLDER_TOOL, PROP_FOLDER_PROJ, PROP_STROKE};
        System.err.println("TemplateWizard:");
        int i = 0;
        while (i < keys.length) {
            System.err.println("\t" + keys[i] + " = " + this.wiz.getProperty(keys[i]));
            ++i;
        }
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        if (this.showing(PROP_SHOW_KEYB)) {
            FileObject shortcutsFolder = Repository.getDefault().getDefaultFileSystem().findResource("Shortcuts");
            KeyStroke stroke = (KeyStroke)wiz.getProperty(PROP_STROKE);
            this.create(DataFolder.findFolder((FileObject)shortcutsFolder), Utilities.keyToString((KeyStroke)stroke));
        }
        if (this.showing(PROP_SHOW_MENU)) {
            this.create((DataFolder)wiz.getProperty(PROP_FOLDER_MENU), null);
        }
        if (this.showing(PROP_SHOW_TOOL)) {
            this.create((DataFolder)wiz.getProperty(PROP_FOLDER_TOOL), null);
        }
        if (this.showing(PROP_SHOW_PROJ)) {
            return Collections.singleton(this.create((DataFolder)wiz.getProperty(PROP_FOLDER_PROJ), null));
        }
        return Collections.EMPTY_SET;
    }

    private DataObject create(DataFolder f, String name) throws IOException {
        final String fname = name != null ? name : (String)this.wiz.getProperty(PROP_CODE_NAME);
        final String contents = (String)this.wiz.getProperty(PROP_CONTENTS);
        final FileObject folder = f.getPrimaryFile();
        final FileObject[] shortcut = new FileObject[1];
        folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                shortcut[0] = folder.createData(fname, "xml");
                FileLock lock = shortcut[0].lock();
                try {
                    OutputStream os = shortcut[0].getOutputStream(lock);
                    try {
                        os.write(contents.getBytes("UTF-8"));
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        os.close();
                        throw throwable;
                    }
                    os.close();
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    lock.releaseLock();
                    throw throwable;
                }
                lock.releaseLock();
            }
        });
        return DataObject.find((FileObject)shortcut[0]);
    }

    public void initialize(TemplateWizard wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        int i = 0;
        while (i < this.panels.length) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
            }
            ++i;
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    private boolean showing(String prop) {
        Boolean s = (Boolean)this.wiz.getProperty(prop);
        return s == null || s != false;
    }

    private boolean showing(int index) throws NoSuchElementException {
        switch (index) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return this.showing(PROP_SHOW_CUST);
            }
            case 3: {
                return this.showing(PROP_SHOW_MENU);
            }
            case 4: {
                return this.showing(PROP_SHOW_TOOL);
            }
            case 5: {
                return this.showing(PROP_SHOW_PROJ);
            }
            case 6: {
                return this.showing(PROP_SHOW_KEYB);
            }
        }
        throw new NoSuchElementException();
    }

    public boolean hasNext() {
        int i = this.index + 1;
        while (i < this.panels.length) {
            if (this.showing(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        ++this.index;
        while (!this.showing(this.index)) {
            ++this.index;
        }
        if (this.index == 1) {
            this.fireChangeEvent();
        }
    }

    public void previousPanel() {
        --this.index;
        while (!this.showing(this.index)) {
            --this.index;
        }
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new HashSet(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

