/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.xml;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class AntProjectSupport
implements AntProjectCookie.ParseStatus,
DocumentListener,
FileChangeListener,
EventListener,
Runnable,
ChangeListener {
    private File file;
    private FileObject fo;
    private String fsName = null;
    private String fileName = null;
    private transient org.w3c.dom.Document projDoc = null;
    private transient Throwable exception = null;
    private transient boolean parsed = false;
    private transient WeakReference styledDocRef = null;
    private transient Object parseLock;
    private transient boolean upToDate = false;
    private transient Set listeners;
    private transient EditorCookie editor = null;
    private static final long REPARSE_DELAY = 3000L;
    private static final Object expectingDocUpdates = new Object();
    private static final long serialVersionUID = 7366509989041657663L;
    private static boolean runFiringProcessor = false;
    private static final Map tofire = new HashMap();
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    public AntProjectSupport(FileObject fo) {
        this(fo, null);
    }

    public AntProjectSupport(File f) {
        this(AntProjectSupport.findFileObject(f), f);
    }

    private static FileObject findFileObject(File f) {
        FileObject[] fos = FileUtil.fromFile((File)f);
        if (fos.length > 0) {
            return fos[0];
        }
        return null;
    }

    private AntProjectSupport(FileObject fo, File f) {
        this.fo = fo;
        this.file = f;
        this.init();
    }

    private void init() {
        this.parseLock = new Object();
        this.listeners = new HashSet();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.fsName = null;
        this.fileName = null;
        in.defaultReadObject();
        this.init();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.updateFileObject();
        out.defaultWriteObject();
    }

    private synchronized EditorCookie getEditor() {
        FileObject fo = this.getFileObject();
        if (fo == null) {
            return null;
        }
        if (this.editor == null) {
            try {
                this.editor = (EditorCookie)DataObject.find((FileObject)fo).getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = AntProjectSupport.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                if (this.editor != null && this.editor instanceof CloneableEditorSupport) {
                    ((CloneableEditorSupport)this.editor).addChangeListener(WeakListener.change((ChangeListener)this, (Object)this.editor));
                }
            }
            catch (DataObjectNotFoundException donfe) {
                AntModule.err.notify(1, (Throwable)donfe);
            }
        }
        return this.editor;
    }

    public File getFile() {
        if (this.file != null) {
            return this.file;
        }
        FileObject fo = this.getFileObject();
        if (fo != null) {
            return FileUtil.toFile((FileObject)fo);
        }
        return null;
    }

    public FileObject getFileObject() {
        if (this.fo != null && !this.fo.isValid()) {
            if (this.fsName == null && this.fileName == null) {
                AntModule.err.log("AntProjectSupport fo=" + this.fo + " was not valid, clearing");
                this.fo = null;
                return this.fo;
            }
            this.resolveFileObject();
            if (this.fo != null && !this.fo.isValid()) {
                return null;
            }
        }
        return this.fo;
    }

    private void resolveFileObject() {
        Repository rep = Repository.getDefault();
        FileSystem fs = rep.findFileSystem(this.fsName);
        FileObject fobj = null;
        if (fs != null) {
            fobj = fs.findResource(this.fileName);
        }
        if (fobj == null) {
            fobj = rep.findResource(this.fileName);
        }
        if (fobj != null) {
            this.fo = fobj;
        }
    }

    private void updateFileObject() {
        this.fsName = null;
        this.fileName = null;
        if (this.fo == null) {
            return;
        }
        this.fileName = this.fo.getPackageNameExt('/', '.');
        try {
            this.fsName = this.fo.getFileSystem().getSystemName();
        }
        catch (FileStateInvalidException ex) {
            AntModule.err.notify(1, (Throwable)ex);
            this.fsName = null;
            this.fileName = null;
        }
    }

    public void setFile(File f) {
        this.file = f;
        this.fo = AntProjectSupport.findFileObject(f);
        this.invalidate();
    }

    public void setFileObject(FileObject fo) {
        this.fo = fo;
        this.file = null;
        this.invalidate();
        this.updateFileObject();
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public org.w3c.dom.Document getDocument() {
        if (this.parsed) {
            return this.projDoc;
        }
        Object object = this.parseLock;
        synchronized (object) {
            if (this.parsed) {
                org.w3c.dom.Document document = this.projDoc;
                return document;
            }
            this.parseDocument();
            org.w3c.dom.Document document = this.projDoc;
            return document;
        }
    }

    public Throwable getParseException() {
        if (this.parsed) {
            return this.exception;
        }
        Object object = this.parseLock;
        synchronized (object) {
            if (this.parsed) {
                Throwable throwable = this.exception;
                return throwable;
            }
            this.parseDocument();
            Throwable throwable = this.exception;
            return throwable;
        }
    }

    private void parseDocument() {
        block15: {
            FileObject fo = this.getFileObject();
            AntModule.err.log("AntProjectSupport.parseDocument: fo=" + fo);
            try {
                Reader rd;
                DOMParser parser = new DOMParser();
                parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
                EditorCookie editor = this.getEditor();
                File file = this.getFile();
                if (editor != null) {
                    StyledDocument doc = editor.openDocument();
                    rd = new DocumentReader(doc, fo);
                    if (this.styledDocRef != null && this.styledDocRef.get() != doc || this.styledDocRef == null) {
                        doc.addDocumentListener(this);
                        this.styledDocRef = new WeakReference<StyledDocument>(doc);
                    }
                } else if (fo != null) {
                    rd = new InputStreamReader(fo.getInputStream());
                    fo.addFileChangeListener((FileChangeListener)this);
                } else if (file != null) {
                    rd = new FileReader(file);
                } else {
                    this.exception = new NullPointerException();
                    return;
                }
                try {
                    InputSource in = new InputSource(rd);
                    if (file != null) {
                        try {
                            in.setSystemId(file.toURL().toString());
                        }
                        catch (MalformedURLException mfue) {
                            AntModule.err.notify(16, (Throwable)mfue);
                        }
                    }
                    parser.parse(in);
                    org.w3c.dom.Document doc = parser.getDocument();
                    if (editor != null) {
                        EventTarget targ = (EventTarget)((Object)doc);
                        targ.addEventListener("DOMSubtreeModified", this, false);
                        targ.addEventListener("DOMAttrModified", this, false);
                    }
                    this.projDoc = doc;
                    this.exception = null;
                    Object var10_11 = null;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    rd.close();
                    throw throwable;
                }
                rd.close();
                {
                }
            }
            catch (Exception e) {
                this.exception = e;
                if (this.exception instanceof SAXParseException) break block15;
                AntModule.err.annotate(this.exception, 0, "Strange parse error in " + this, null, null, null);
                AntModule.err.notify(1, this.exception);
            }
        }
        this.fireChangeEvent();
        this.parsed = true;
    }

    public Element getProjectElement() {
        org.w3c.dom.Document doc = this.getDocument();
        if (doc != null) {
            return doc.getDocumentElement();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AntProjectSupport)) {
            return false;
        }
        AntProjectSupport other = (AntProjectSupport)o;
        if (this.fo != null && other.fo != null) {
            return this.fo.equals(other.fo);
        }
        if (this.file != null && other.file != null) {
            return this.file.equals(other.file);
        }
        return false;
    }

    public int hashCode() {
        return 0x6CB1 ^ (this.fo == null ? (this.file == null ? 0 : this.file.hashCode()) : this.fo.hashCode());
    }

    public String toString() {
        FileObject fo = this.getFileObject();
        if (fo != null) {
            try {
                return DataObject.find((FileObject)fo).getNodeDelegate().getDisplayName();
            }
            catch (DataObjectNotFoundException donfe) {
                return fo.toString();
            }
        }
        if (this.file != null) {
            return this.file.getAbsolutePath();
        }
        return "<missing Ant script>";
    }

    private synchronized void regenerate() {
        block10: {
            FileObject fo = this.getFileObject();
            AntModule.err.log("AntProjectSupport.regenerate: fo=" + fo);
            if (this.projDoc == null) {
                throw new IllegalStateException();
            }
            try {
                EditorCookie editor = this.getEditor();
                if (editor == null) break block10;
                StyledDocument doc = editor.openDocument();
                JEditorPane[] panes = editor.getOpenedPanes();
                int[] carets = new int[panes == null ? 0 : panes.length];
                int i = 0;
                while (i < carets.length) {
                    carets[i] = panes[i].getCaretPosition();
                    ++i;
                }
                OutputFormat format = new OutputFormat(this.projDoc);
                format.setPreserveSpace(true);
                DocumentWriter wr = new DocumentWriter(doc, fo);
                try {
                    XMLSerializer ser = new XMLSerializer((Writer)wr, format);
                    ser.serialize(this.projDoc);
                    ((Writer)wr).write(10);
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    ((Writer)wr).close();
                    throw throwable;
                }
                ((Writer)wr).close();
                int i2 = 0;
                while (i2 < carets.length) {
                    if (carets[i2] < doc.getLength()) {
                        try {
                            panes[i2].setCaretPosition(carets[i2]);
                        }
                        catch (IllegalArgumentException iae) {
                            AntModule.err.notify(1, (Throwable)iae);
                        }
                    }
                    ++i2;
                }
                this.exception = null;
                this.parsed = true;
            }
            catch (IOException ioe) {
                this.exception = ioe;
            }
        }
        this.fireChangeEvent();
    }

    public void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    protected void fireChangeEvent() {
        Iterator it;
        AntModule.err.log("AntProjectSupport.fireChangeEvent: fo=" + this.fo);
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        RequestProcessor.postRequest((Runnable)new ChangeFirer(it, ev));
    }

    public void removeUpdate(DocumentEvent ev) {
        if (ev.getDocument().getProperty(expectingDocUpdates) == null) {
            this.invalidate();
        }
    }

    public void changedUpdate(DocumentEvent ev) {
    }

    public void insertUpdate(DocumentEvent ev) {
        if (ev.getDocument().getProperty(expectingDocUpdates) == null) {
            this.invalidate();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.invalidate();
    }

    public void fileDeleted(FileEvent p1) {
    }

    public void fileDataCreated(FileEvent p1) {
    }

    public void fileFolderCreated(FileEvent p1) {
    }

    public void fileRenamed(FileRenameEvent p1) {
    }

    public void fileAttributeChanged(FileAttributeEvent p1) {
    }

    public void handleEvent(Event ev) {
        AntModule.err.log("AntProjectSupport.handleEvent: fo=" + this.fo);
        AntModule.err.log("\tev=" + ev);
        AntModule.err.log("\tev.type=" + ev.getType());
        AntModule.err.log("\tev.target=" + ev.getTarget());
        if (this.exception != null || ev.getCurrentTarget() != this.projDoc) {
            AntModule.err.log(16, "AntProjectSupport.handleEvent on stale DOM tree");
            return;
        }
        this.upToDate = false;
        RequestProcessor.postRequest((Runnable)this);
    }

    public void run() {
        if (!this.upToDate) {
            this.upToDate = true;
            this.regenerate();
        }
    }

    public void fileChanged(FileEvent p1) {
        this.invalidate();
    }

    protected final void invalidate() {
        AntModule.err.log("AntProjectSupport.invalidate: fo=" + this.fo);
        this.parsed = false;
        Map map = tofire;
        synchronized (map) {
            if (!runFiringProcessor) {
                AntProjectSupport.startFiringProcessor();
            }
            if (tofire.put(this, new Date(System.currentTimeMillis() + 3000L)) == null) {
                tofire.notify();
            }
        }
    }

    public static void startFiringProcessor() {
        Map map = tofire;
        synchronized (map) {
            if (runFiringProcessor) {
                return;
            }
            runFiringProcessor = true;
            new FiringProcessor().start();
        }
    }

    public static void stopFiringProcessor() {
        Map map = tofire;
        synchronized (map) {
            if (!runFiringProcessor) {
                return;
            }
            runFiringProcessor = false;
            tofire.notify();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Object access$200() {
        return expectingDocUpdates;
    }

    private static final class FiringProcessor
    extends Thread {
        public FiringProcessor() {
            super("AntProjectSupport.FiringProcessor");
        }

        public void run() {
            Map map = tofire;
            synchronized (map) {
                Iterator<Object> it;
                HashSet tofirenow = new HashSet();
                while (runFiringProcessor) {
                    it = tofire.entrySet().iterator();
                    long next = Long.MAX_VALUE;
                    long now = System.currentTimeMillis();
                    while (it.hasNext()) {
                        Map.Entry entry = (Map.Entry)it.next();
                        Date d = (Date)entry.getValue();
                        long time = d.getTime();
                        if (time <= now) {
                            tofirenow.add(entry.getKey());
                            it.remove();
                            continue;
                        }
                        if (time >= next) continue;
                        next = time;
                    }
                    it = tofirenow.iterator();
                    while (it.hasNext()) {
                        ((AntProjectSupport)it.next()).fireChangeEvent();
                    }
                    tofirenow.clear();
                    try {
                        tofire.wait(next - now);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                it = tofire.keySet().iterator();
                while (it.hasNext()) {
                    ((AntProjectSupport)it.next()).fireChangeEvent();
                }
            }
        }
    }

    private static class DocumentWriter
    extends PipedWriter
    implements Runnable {
        private StyledDocument doc;
        private PipedReader rd;
        private Thread t;

        public DocumentWriter(StyledDocument doc, FileObject fo) throws IOException {
            this.doc = doc;
            this.rd = new PipedReader();
            this.connect(this.rd);
            this.t = new Thread((Runnable)this, "ant DocumentWriter: " + fo);
            this.t.start();
        }

        public void run() {
            try {
                NbDocument.runAtomicAsUser((StyledDocument)this.doc, (Runnable)new Runnable(this){
                    private final /* synthetic */ DocumentWriter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        block5: {
                            DocumentWriter.access$300(this.this$0).putProperty(AntProjectSupport.access$200(), Boolean.TRUE);
                            try {
                                try {
                                    DocumentWriter.access$300(this.this$0).remove(0, DocumentWriter.access$300(this.this$0).getLength());
                                    new DefaultEditorKit().read(DocumentWriter.access$400(this.this$0), (Document)DocumentWriter.access$300(this.this$0), 0);
                                }
                                catch (IOException e) {
                                    AntModule.err.notify(1, (Throwable)e);
                                    Object var4_2 = null;
                                    DocumentWriter.access$300(this.this$0).putProperty(AntProjectSupport.access$200(), null);
                                    break block5;
                                }
                                catch (BadLocationException e) {
                                    AntModule.err.notify(1, (Throwable)e);
                                    Object var4_3 = null;
                                    DocumentWriter.access$300(this.this$0).putProperty(AntProjectSupport.access$200(), null);
                                }
                                Object var4_1 = null;
                                DocumentWriter.access$300(this.this$0).putProperty(AntProjectSupport.access$200(), null);
                            }
                            catch (Throwable throwable) {
                                Object var4_4 = null;
                                DocumentWriter.access$300(this.this$0).putProperty(AntProjectSupport.access$200(), null);
                                throw throwable;
                            }
                        }
                    }
                });
            }
            catch (BadLocationException e) {
                AntModule.err.notify(1, (Throwable)e);
            }
        }

        public void close() throws IOException {
            super.close();
            try {
                this.t.join();
            }
            catch (InterruptedException ie) {
                IOException ioe = new IOException();
                AntModule.err.annotate((Throwable)ioe, (Throwable)ie);
                throw ioe;
            }
        }

        static /* synthetic */ StyledDocument access$300(DocumentWriter x0) {
            return x0.doc;
        }

        static /* synthetic */ PipedReader access$400(DocumentWriter x0) {
            return x0.rd;
        }
    }

    private static class DocumentReader
    extends PipedReader
    implements Runnable {
        private StyledDocument doc;
        private PipedWriter wr;

        public DocumentReader(StyledDocument doc, FileObject fo) throws IOException {
            this.doc = doc;
            this.wr = new PipedWriter();
            this.connect(this.wr);
            new Thread((Runnable)this, "ant DocumentReader: " + fo).start();
        }

        public void run() {
            try {
                this.doc.render(new Runnable(this){
                    private final /* synthetic */ DocumentReader this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        try {
                            new DefaultEditorKit().write(DocumentReader.access$000(this.this$0), (Document)DocumentReader.access$100(this.this$0), 0, DocumentReader.access$100(this.this$0).getLength());
                        }
                        catch (IOException e) {
                            AntModule.err.notify(1, (Throwable)e);
                        }
                        catch (BadLocationException e) {
                            AntModule.err.notify(1, (Throwable)e);
                        }
                    }
                });
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                try {
                    this.wr.close();
                }
                catch (IOException e) {
                    AntModule.err.notify(1, (Throwable)e);
                }
                throw throwable;
            }
            try {
                this.wr.close();
            }
            catch (IOException e) {
                AntModule.err.notify(1, (Throwable)e);
            }
        }

        static /* synthetic */ PipedWriter access$000(DocumentReader x0) {
            return x0.wr;
        }

        static /* synthetic */ StyledDocument access$100(DocumentReader x0) {
            return x0.doc;
        }
    }

    private static final class ChangeFirer
    implements Runnable {
        private final Iterator it;
        private final ChangeEvent ev;

        public ChangeFirer(Iterator it, ChangeEvent ev) {
            this.it = it;
            this.ev = ev;
        }

        public void run() {
            AntModule.err.log("AntProjectSupport.ChangeFirer.run");
            while (this.it.hasNext()) {
                ChangeListener l = (ChangeListener)this.it.next();
                try {
                    l.stateChanged(this.ev);
                }
                catch (RuntimeException re) {
                    AntModule.err.notify((Throwable)re);
                }
            }
        }
    }
}

