/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.xml;

import java.io.IOException;
import java.security.AllPermission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Map;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.ElementCookie;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.apache.tools.ant.module.api.IntrospectionCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.execution.NbClassLoader;
import org.w3c.dom.Element;

public class ElementSupport
implements ElementCookie {
    private final Element el;

    public ElementSupport(Element el) {
        this.el = el;
    }

    public Element getElement() {
        return this.el;
    }

    public static class Instance
    extends ElementSupport
    implements InstanceCookie {
        private Class clazz;
        private String clazzname;
        private ClassNotFoundException cnfe = null;
        private Map subels = null;

        public Instance(Element el, Class clazz) {
            super(el);
            this.clazz = clazz;
            this.clazzname = clazz.getName();
        }

        public Instance(Element el, String clazzname) {
            super(el);
            this.clazzname = clazzname;
        }

        public String toString() {
            return "ElementSupport.Instance[clazzname=" + this.clazzname + ",subels=" + this.subels + "]";
        }

        public String instanceName() {
            return this.getElement().getNodeName();
        }

        public Map getSubelements() throws IOException, ClassNotFoundException {
            if (this.subels != null) {
                return this.subels;
            }
            Instance instance = this;
            synchronized (instance) {
                if (this.subels != null) {
                    Map map = this.subels;
                    return map;
                }
                if (this.clazzname == null) {
                    this.instanceClass();
                }
                this.subels = IntrospectedInfo.getDefaults().isKnown(this.clazzname) ? IntrospectedInfo.getDefaults().getElements(this.clazzname) : (AntSettings.getDefault().getCustomDefs().isKnown(this.clazzname) ? AntSettings.getDefault().getCustomDefs().getElements(this.clazzname) : null);
                Map map = this.subels;
                return map;
            }
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            if (this.clazz != null) {
                return this.clazz;
            }
            if (this.cnfe != null) {
                throw this.cnfe;
            }
            Instance instance = this;
            synchronized (instance) {
                if (this.clazz != null) {
                    Class clazz = this.clazz;
                    return clazz;
                }
                if (this.cnfe != null) {
                    throw this.cnfe;
                }
                if (this.clazzname == null) {
                    throw new IOException("Must specify clazz or clazzname");
                }
                try {
                    NbClassLoader l = new NbClassLoader();
                    Permissions perm = new Permissions();
                    perm.add(new AllPermission());
                    l.setDefaultPermissions((PermissionCollection)perm);
                    Class<?> clazz = this.clazz = l.loadClass(this.clazzname);
                    return clazz;
                }
                catch (ClassNotFoundException cnfe) {
                    this.cnfe = cnfe;
                    throw cnfe;
                }
            }
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            throw new IOException("UNIMPLEMENTED");
        }
    }

    public static class Introspection
    extends ElementSupport
    implements IntrospectionCookie {
        private String clazzname;

        public Introspection(Element el, String clazz) {
            super(el);
            this.clazzname = clazz;
        }

        public String getClassName() {
            return this.clazzname;
        }
    }
}

