/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import org.openide.awt.Actions;

final class NbPopupMenuUI
extends BasicPopupMenuUI {
    NbPopupMenuUI() {
    }

    protected void installKeyboardActions() {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        this.popupMenu.registerKeyboardAction(new CancelAction(), ks, 2);
        ks = KeyStroke.getKeyStroke(40, 0);
        this.popupMenu.registerKeyboardAction(new SelectNextItemAction(), ks, 2);
        ks = KeyStroke.getKeyStroke(38, 0);
        this.popupMenu.registerKeyboardAction(new SelectPreviousItemAction(), ks, 2);
        ks = KeyStroke.getKeyStroke(39, 0);
        this.popupMenu.registerKeyboardAction(new SelectChildItemAction(), ks, 2);
        ks = KeyStroke.getKeyStroke(37, 0);
        this.popupMenu.registerKeyboardAction(new SelectParentItemAction(), ks, 2);
        ReturnAction retAction = new ReturnAction();
        ks = KeyStroke.getKeyStroke(10, 0);
        this.popupMenu.registerKeyboardAction(retAction, ks, 2);
        ks = KeyStroke.getKeyStroke(32, 0);
        this.popupMenu.registerKeyboardAction(retAction, ks, 2);
    }

    protected void uninstallKeyboardActions() {
        KeyStroke ks = KeyStroke.getKeyStroke('\u001b');
        this.popupMenu.unregisterKeyboardAction(ks);
        ks = KeyStroke.getKeyStroke(40, 0);
        this.popupMenu.unregisterKeyboardAction(ks);
        ks = KeyStroke.getKeyStroke(38, 0);
        this.popupMenu.unregisterKeyboardAction(ks);
        ks = KeyStroke.getKeyStroke(39, 0);
        this.popupMenu.unregisterKeyboardAction(ks);
        ks = KeyStroke.getKeyStroke(37, 0);
        this.popupMenu.unregisterKeyboardAction(ks);
        ks = KeyStroke.getKeyStroke(10, 0);
        this.popupMenu.unregisterKeyboardAction(ks);
        ks = KeyStroke.getKeyStroke(32, 0);
        this.popupMenu.unregisterKeyboardAction(ks);
    }

    static MenuElement nextEnabledChild(MenuElement[] e, int fromIndex) {
        int i = fromIndex;
        int c = e.length;
        while (i < c) {
            Component comp;
            if (e[i] != null && (comp = e[i].getComponent()) != null && comp.isEnabled()) {
                return e[i];
            }
            ++i;
        }
        return null;
    }

    static MenuElement previousEnabledChild(MenuElement[] e, int fromIndex) {
        int i = fromIndex;
        while (i >= 0) {
            Component comp;
            if (e[i] != null && (comp = e[i].getComponent()) != null && comp.isEnabled()) {
                return e[i];
            }
            --i;
        }
        return null;
    }

    static void changeTargetUI(JPopupMenu menu) {
        if (menu.getUI() instanceof NbPopupMenuUI) {
            return;
        }
        menu.setUI(new NbPopupMenuUI());
    }

    static final class SelectParentItemAction
    extends AbstractAction {
        SelectParentItemAction() {
        }

        public void actionPerformed(ActionEvent e) {
            MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
            if (path.length > 3) {
                if (path[path.length - 1].getComponent() instanceof JPopupMenu) {
                    MenuElement[] newPath = new MenuElement[path.length - 1];
                    System.arraycopy(path, 0, newPath, 0, newPath.length);
                    MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                } else {
                    MenuElement[] newPath = new MenuElement[path.length - 2];
                    System.arraycopy(path, 0, newPath, 0, newPath.length);
                    MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                }
            } else if (path.length > 2 && path[path.length - 1].getComponent() instanceof JPopupMenu) {
                MenuElement[] newPath = new MenuElement[path.length - 1];
                System.arraycopy(path, 0, newPath, 0, newPath.length);
                MenuSelectionManager.defaultManager().setSelectedPath(newPath);
            }
        }
    }

    static final class SelectChildItemAction
    extends AbstractAction {
        SelectChildItemAction() {
        }

        public void actionPerformed(ActionEvent e) {
            MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
            if (path.length > 0) {
                Component compo = path[path.length - 1].getComponent();
                boolean visiblePopup = false;
                if (compo instanceof JPopupMenu) {
                    if (path.length == 1) {
                        return;
                    }
                    compo = path[path.length - 2].getComponent();
                    visiblePopup = true;
                }
                if (compo.isEnabled() && compo instanceof JMenu && (!(compo instanceof Actions.SubMenu) || ((Actions.SubMenu)compo).getMenuComponentCount() > 1) && !((JMenu)compo).isTopLevelMenu()) {
                    JPopupMenu popup = ((JMenu)compo).getPopupMenu();
                    NbPopupMenuUI.changeTargetUI(popup);
                    MenuElement[] subElements = popup.getSubElements();
                    if (subElements.length > 0) {
                        int adder = visiblePopup ? 1 : 2;
                        int relativePopupIdx = visiblePopup ? 1 : 0;
                        MenuElement enabledChild = NbPopupMenuUI.nextEnabledChild(subElements, 0);
                        if (enabledChild != null) {
                            boolean setPopup;
                            Component c = enabledChild.getComponent();
                            boolean bl = setPopup = c instanceof JMenu && (!(c instanceof Actions.SubMenu) || ((Actions.SubMenu)c).getMenuComponentCount() > 1);
                            if (setPopup) {
                                ++adder;
                            }
                            MenuElement[] newPath = new MenuElement[path.length + adder];
                            System.arraycopy(path, 0, newPath, 0, path.length);
                            newPath[path.length - relativePopupIdx] = popup;
                            newPath[path.length + 1 - relativePopupIdx] = enabledChild;
                            if (setPopup) {
                                JMenu jmenu = (JMenu)enabledChild.getComponent();
                                newPath[newPath.length - 1] = jmenu.getPopupMenu();
                            }
                            MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                        }
                    }
                }
            }
        }
    }

    static final class SelectPreviousItemAction
    extends AbstractAction {
        SelectPreviousItemAction() {
        }

        public void actionPerformed(ActionEvent e) {
            MenuElement[] currentSelection = MenuSelectionManager.defaultManager().getSelectedPath();
            if (currentSelection.length > 1) {
                boolean visiblePopup = currentSelection[currentSelection.length - 1] instanceof JPopupMenu;
                int parentIdx = visiblePopup ? 3 : 2;
                int childIdx = visiblePopup ? 2 : 1;
                MenuElement parent = currentSelection[currentSelection.length - parentIdx];
                MenuElement[] childs = parent.getSubElements();
                int i = 0;
                int c = childs.length;
                while (i < c) {
                    if (childs[i] == currentSelection[currentSelection.length - childIdx]) {
                        MenuElement nextChild = NbPopupMenuUI.previousEnabledChild(childs, i - 1);
                        if (nextChild == null) {
                            nextChild = NbPopupMenuUI.previousEnabledChild(childs, childs.length - 1);
                        }
                        if (nextChild == null) break;
                        JMenu childMenu = null;
                        if (nextChild instanceof JMenu && (!(nextChild instanceof Actions.SubMenu) || ((Actions.SubMenu)nextChild).getMenuComponentCount() > 1)) {
                            childMenu = (JMenu)nextChild;
                        }
                        if (visiblePopup != (childMenu != null)) {
                            if (visiblePopup) {
                                MenuElement[] newSelection = new MenuElement[currentSelection.length - 1];
                                System.arraycopy(currentSelection, 0, newSelection, 0, newSelection.length - 1);
                                newSelection[newSelection.length - 1] = nextChild;
                                currentSelection = newSelection;
                            } else {
                                MenuElement[] newSelection = new MenuElement[currentSelection.length + 1];
                                System.arraycopy(currentSelection, 0, newSelection, 0, currentSelection.length);
                                newSelection[newSelection.length - 2] = childMenu;
                                JPopupMenu tmpPopup = childMenu.getPopupMenu();
                                newSelection[newSelection.length - 1] = tmpPopup;
                                NbPopupMenuUI.changeTargetUI(tmpPopup);
                                currentSelection = newSelection;
                            }
                        } else if (visiblePopup) {
                            currentSelection[currentSelection.length - 2] = nextChild;
                            JPopupMenu tmpPopup = childMenu.getPopupMenu();
                            currentSelection[currentSelection.length - 1] = tmpPopup;
                            NbPopupMenuUI.changeTargetUI(tmpPopup);
                        } else {
                            currentSelection[currentSelection.length - 1] = nextChild;
                        }
                        MenuSelectionManager.defaultManager().setSelectedPath(currentSelection);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    static final class SelectNextItemAction
    extends AbstractAction {
        SelectNextItemAction() {
        }

        public void actionPerformed(ActionEvent e) {
            MenuElement[] currentSelection = MenuSelectionManager.defaultManager().getSelectedPath();
            if (currentSelection.length > 1) {
                boolean visiblePopup = currentSelection[currentSelection.length - 1] instanceof JPopupMenu;
                int parentIdx = visiblePopup ? 3 : 2;
                int childIdx = visiblePopup ? 2 : 1;
                MenuElement parent = currentSelection[currentSelection.length - parentIdx];
                MenuElement[] childs = parent.getSubElements();
                int i = 0;
                int c = childs.length;
                while (i < c) {
                    if (childs[i] == currentSelection[currentSelection.length - childIdx]) {
                        MenuElement nextChild = NbPopupMenuUI.nextEnabledChild(childs, i + 1);
                        if (nextChild == null) {
                            nextChild = NbPopupMenuUI.nextEnabledChild(childs, 0);
                        }
                        if (nextChild == null) break;
                        JMenu childMenu = null;
                        if (nextChild instanceof JMenu && (!(nextChild instanceof Actions.SubMenu) || ((Actions.SubMenu)nextChild).getMenuComponentCount() > 1)) {
                            childMenu = (JMenu)nextChild;
                        }
                        if (visiblePopup != (childMenu != null)) {
                            if (visiblePopup) {
                                MenuElement[] newSelection = new MenuElement[currentSelection.length - 1];
                                System.arraycopy(currentSelection, 0, newSelection, 0, newSelection.length - 1);
                                newSelection[newSelection.length - 1] = nextChild;
                                currentSelection = newSelection;
                            } else {
                                MenuElement[] newSelection = new MenuElement[currentSelection.length + 1];
                                System.arraycopy(currentSelection, 0, newSelection, 0, currentSelection.length);
                                newSelection[newSelection.length - 2] = childMenu;
                                JPopupMenu tmpPopup = childMenu.getPopupMenu();
                                newSelection[newSelection.length - 1] = tmpPopup;
                                NbPopupMenuUI.changeTargetUI(tmpPopup);
                                currentSelection = newSelection;
                            }
                        } else if (visiblePopup) {
                            currentSelection[currentSelection.length - 2] = nextChild;
                            JPopupMenu tmpPopup = childMenu.getPopupMenu();
                            currentSelection[currentSelection.length - 1] = tmpPopup;
                            NbPopupMenuUI.changeTargetUI(tmpPopup);
                        } else {
                            currentSelection[currentSelection.length - 1] = nextChild;
                        }
                        MenuSelectionManager.defaultManager().setSelectedPath(currentSelection);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    static final class ReturnAction
    extends AbstractAction {
        ReturnAction() {
        }

        public void actionPerformed(ActionEvent e) {
            MenuElement lastElement;
            MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
            if (path.length > 0 && (lastElement = path[path.length - 1]) instanceof JMenuItem && (!(lastElement instanceof JMenu) || lastElement instanceof Actions.SubMenu && ((Actions.SubMenu)lastElement).getMenuComponentCount() <= 1)) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                ((JMenuItem)lastElement).doClick(0);
                ((JMenuItem)lastElement).setArmed(false);
            }
        }
    }

    static final class CancelAction
    extends AbstractAction {
        CancelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
            if (path[path.length - 1] instanceof JPopupMenu) {
                MenuElement[] newPath = new MenuElement[path.length - 1];
                System.arraycopy(path, 0, newPath, 0, path.length - 1);
                MenuSelectionManager.defaultManager().setSelectedPath(newPath);
            } else if (path.length > 2) {
                MenuElement[] newPath = new MenuElement[path.length - 2];
                System.arraycopy(path, 0, newPath, 0, path.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(newPath);
            } else {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }
}

