/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.NodeTableModel;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TableSheetCell;
import org.openide.explorer.view.TreeTableModelAdapter;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class TreeTable
extends JTable {
    private TreeTableCellRenderer tree;
    private NodeTableModel tableModel;
    private int treeColumnIndex = -1;
    private int lastRow = -1;
    private boolean canEdit;
    private boolean ignoreScrolling = false;
    private boolean ignoreClearSelection = false;
    private int positionX;
    private boolean treeHScrollingEnabled = true;
    private boolean needCalcRowHeight = true;
    static /* synthetic */ Class class$org$openide$explorer$view$TreeTableModelAdapter;
    static /* synthetic */ Class class$org$openide$nodes$Node$Property;
    static /* synthetic */ Class class$org$openide$explorer$view$TreeTable;

    public TreeTable(NodeTreeModel treeModel, NodeTableModel tableModel) {
        this.tree = new TreeTableCellRenderer(treeModel);
        this.tableModel = new TreeTableModelAdapter(this.tree, tableModel);
        NodeRenderer rend = NodeRenderer.sharedInstance();
        this.tree.setCellRenderer(rend);
        this.setModel(this.tableModel);
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.getTableHeader().setReorderingAllowed(false);
        this.setDefaultRenderer(class$org$openide$explorer$view$TreeTableModelAdapter == null ? (class$org$openide$explorer$view$TreeTableModelAdapter = TreeTable.class$("org.openide.explorer.view.TreeTableModelAdapter")) : class$org$openide$explorer$view$TreeTableModelAdapter, this.tree);
        this.setDefaultEditor(class$org$openide$explorer$view$TreeTableModelAdapter == null ? (class$org$openide$explorer$view$TreeTableModelAdapter = TreeTable.class$("org.openide.explorer.view.TreeTableModelAdapter")) : class$org$openide$explorer$view$TreeTableModelAdapter, new TreeTableCellEditor());
        TableSheetCell tableCell = new TableSheetCell(this.tableModel);
        tableCell.setFlat(true);
        this.setDefaultRenderer(class$org$openide$nodes$Node$Property == null ? (class$org$openide$nodes$Node$Property = TreeTable.class$("org.openide.nodes.Node$Property")) : class$org$openide$nodes$Node$Property, tableCell);
        this.setDefaultEditor(class$org$openide$nodes$Node$Property == null ? (class$org$openide$nodes$Node$Property = TreeTable.class$("org.openide.nodes.Node$Property")) : class$org$openide$nodes$Node$Property, tableCell);
        this.getTableHeader().setDefaultRenderer(tableCell);
        this.getActionMap().put("selectNextColumn", new TreeTableAction(this.tree.getActionMap().get("selectChild"), this.getActionMap().get("selectNextColumn")));
        this.getActionMap().put("selectPreviousColumn", new TreeTableAction(this.tree.getActionMap().get("selectParent"), this.getActionMap().get("selectPreviousColumn")));
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle(class$org$openide$explorer$view$TreeTable == null ? (class$org$openide$explorer$view$TreeTable = TreeTable.class$("org.openide.explorer.view.TreeTable")) : class$org$openide$explorer$view$TreeTable).getString("ACSN_TreeTable"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(class$org$openide$explorer$view$TreeTable == null ? (class$org$openide$explorer$view$TreeTable = TreeTable.class$("org.openide.explorer.view.TreeTable")) : class$org$openide$explorer$view$TreeTable).getString("ACSD_TreeTable"));
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
        this.setUI(new TreeTableUI());
        this.needCalcRowHeight = true;
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == (class$org$openide$explorer$view$TreeTableModelAdapter == null ? (class$org$openide$explorer$view$TreeTableModelAdapter = TreeTable.class$("org.openide.explorer.view.TreeTableModelAdapter")) : class$org$openide$explorer$view$TreeTableModelAdapter) ? -1 : this.editingRow;
    }

    public void paint(Graphics g) {
        if (this.needCalcRowHeight) {
            this.calcRowHeight(g);
        }
        super.paint(g);
    }

    private void calcRowHeight(Graphics g) {
        Font f = this.getFont();
        FontMetrics fm = g.getFontMetrics(f);
        int rowHeight = fm.getHeight();
        this.needCalcRowHeight = false;
        this.setRowHeight(rowHeight);
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    JTree getTree() {
        return this.tree;
    }

    int getTreeColumnIndex() {
        return this.treeColumnIndex;
    }

    void setTreeColumnIndex(int index) {
        if (this.treeColumnIndex == index) {
            return;
        }
        int old = this.treeColumnIndex;
        this.treeColumnIndex = index;
        this.firePropertyChange("treeColumnIndex", old, this.treeColumnIndex);
    }

    public void clearSelection() {
        if (!this.ignoreClearSelection) {
            super.clearSelection();
        }
    }

    public void tableChanged(TableModelEvent e) {
        int modelColumn = this.getTreeColumnIndex();
        if (e.getFirstRow() <= 0 && modelColumn != -1 && this.getColumnCount() > 0) {
            String columnName = this.getModel().getColumnName(modelColumn);
            TableColumn aColumn = this.getColumnModel().getColumn(modelColumn);
            aColumn.setHeaderValue(columnName);
        }
        this.ignoreClearSelection = true;
        try {
            super.tableChanged(e);
            Object var6_5 = null;
            this.ignoreClearSelection = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.ignoreClearSelection = false;
            throw throwable;
        }
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        this.canEdit = this.lastRow == row;
        boolean ret = super.editCellAt(row, column, e);
        if (ret && column == this.getTreeColumnIndex()) {
            this.ignoreScrolling = true;
            this.tree.scrollRectToVisible(this.tree.getRowBounds(row));
            this.ignoreScrolling = false;
        }
        return ret;
    }

    public void valueChanged(ListSelectionEvent e) {
        this.lastRow = this.getSelectedRowCount() == 1 ? this.getSelectedRow() : -1;
        super.valueChanged(e);
    }

    public void columnAdded(TableColumnModelEvent e) {
        super.columnAdded(e);
        this.updateTreeColumnIndex();
    }

    public void columnRemoved(TableColumnModelEvent e) {
        super.columnRemoved(e);
        this.updateTreeColumnIndex();
    }

    public void columnMoved(TableColumnModelEvent e) {
        super.columnMoved(e);
        this.updateTreeColumnIndex();
        int from = e.getFromIndex();
        int to = e.getToIndex();
        if (from != to) {
            this.firePropertyChange("column_moved", from, to);
        }
    }

    private void updateTreeColumnIndex() {
        int i = this.getColumnCount() - 1;
        while (i >= 0) {
            if (this.getColumnClass(i) == (class$org$openide$explorer$view$TreeTableModelAdapter == null ? TreeTable.class$("org.openide.explorer.view.TreeTableModelAdapter") : class$org$openide$explorer$view$TreeTableModelAdapter)) {
                this.setTreeColumnIndex(i);
                return;
            }
            --i;
        }
        this.setTreeColumnIndex(-1);
    }

    public int getPositionX() {
        return this.positionX;
    }

    public void setPositionX(int x) {
        if (x == this.positionX || !this.treeHScrollingEnabled) {
            return;
        }
        int old = this.positionX;
        this.positionX = x;
        this.firePropertyChange("positionX", old, x);
        if (this.isEditing() && this.getEditingColumn() == this.getTreeColumnIndex()) {
            TableCellEditor editor = this.getCellEditor();
            if (this.ignoreScrolling && editor instanceof TreeTableCellEditor) {
                ((TreeTableCellEditor)editor).revalidateTextField();
            } else {
                this.removeEditor();
            }
        }
        this.repaint();
    }

    void setTreeHScrollingEnabled(boolean enabled) {
        this.treeHScrollingEnabled = enabled;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TreeTableAction
    extends AbstractAction {
        Action treeAction;
        Action tableAction;

        TreeTableAction(Action treeAction, Action tableAction) {
            this.treeAction = treeAction;
            this.tableAction = tableAction;
        }

        public void actionPerformed(ActionEvent e) {
            if (TreeTable.this.getSelectedColumn() == TreeTable.this.getTreeColumnIndex()) {
                this.treeAction.actionPerformed(e);
            }
        }
    }

    class TreeTableUI
    extends BasicTableUI {
        TreeTableUI() {
        }

        protected MouseInputListener createMouseInputListener() {
            return new TreeTableMouseInputHandler();
        }

        public class TreeTableMouseInputHandler
        extends BasicTableUI.MouseInputHandler {
            private Component dispatchComponent;
            static /* synthetic */ Class class$org$openide$explorer$view$TreeTableModelAdapter;

            public TreeTableMouseInputHandler() {
                super(TreeTableUI.this);
            }

            public void mouseClicked(MouseEvent e) {
                this.processMouseEvent(e);
            }

            public void mousePressed(MouseEvent e) {
                this.processMouseEvent(e);
            }

            public void mouseReleased(MouseEvent e) {
                if (this.shouldIgnore(e)) {
                    return;
                }
                this.repostEvent(e);
                this.dispatchComponent = null;
                this.setValueIsAdjusting(false);
                if (!TreeTable.this.isEditing()) {
                    this.processMouseEvent(e);
                }
            }

            public void mouseDragged(MouseEvent e) {
            }

            private void setDispatchComponent(MouseEvent e) {
                Component editorComponent = TreeTableUI.this.table.getEditorComponent();
                Point p = e.getPoint();
                Point p2 = SwingUtilities.convertPoint(TreeTableUI.this.table, p, editorComponent);
                this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
            }

            private boolean repostEvent(MouseEvent e) {
                if (this.dispatchComponent == null) {
                    return false;
                }
                MouseEvent e2 = SwingUtilities.convertMouseEvent(TreeTableUI.this.table, e, this.dispatchComponent);
                this.dispatchComponent.dispatchEvent(e2);
                return true;
            }

            private void setValueIsAdjusting(boolean flag) {
                TreeTableUI.this.table.getSelectionModel().setValueIsAdjusting(flag);
                TreeTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
            }

            private boolean shouldIgnore(MouseEvent e) {
                return !TreeTableUI.this.table.isEnabled();
            }

            private boolean isTreeColumn(int column) {
                return TreeTable.this.getColumnClass(column) == (class$org$openide$explorer$view$TreeTableModelAdapter == null ? (class$org$openide$explorer$view$TreeTableModelAdapter = TreeTableMouseInputHandler.class$("org.openide.explorer.view.TreeTableModelAdapter")) : class$org$openide$explorer$view$TreeTableModelAdapter);
            }

            private void processMouseEvent(MouseEvent e) {
                if (this.shouldIgnore(e)) {
                    return;
                }
                Point p = e.getPoint();
                int row = TreeTableUI.this.table.rowAtPoint(p);
                int column = TreeTableUI.this.table.columnAtPoint(p);
                if (column == -1 || row == -1) {
                    return;
                }
                if (TreeTable.this.getEditingColumn() == column && TreeTable.this.getEditingRow() == row) {
                    return;
                }
                boolean changeSelection = true;
                if (this.isTreeColumn(column)) {
                    TreePath path = TreeTable.this.tree.getPathForRow(TreeTable.this.rowAtPoint(e.getPoint()));
                    Rectangle r = TreeTable.this.tree.getPathBounds(path);
                    if (e.getX() >= r.x - TreeTable.this.positionX && e.getX() <= r.x - TreeTable.this.positionX + r.width) {
                        changeSelection = false;
                    }
                }
                if (TreeTableUI.this.table.getSelectionModel().isSelectedIndex(row) && e.isPopupTrigger()) {
                    return;
                }
                if (TreeTableUI.this.table.editCellAt(row, column, e)) {
                    this.setDispatchComponent(e);
                    this.repostEvent(e);
                } else {
                    TreeTableUI.this.table.requestFocus();
                }
                TableCellEditor editor = TreeTableUI.this.table.getCellEditor();
                if (changeSelection && (editor == null || editor.shouldSelectCell(e))) {
                    this.setValueIsAdjusting(true);
                    TreeTableUI.this.table.changeSelection(row, column, e.isControlDown(), e.isShiftDown());
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                    Object var2_1 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        int counter = min;
                        while (counter <= max) {
                            TreePath selPath;
                            if (this.listSelectionModel.isSelectedIndex(counter) && (selPath = TreeTable.this.tree.getPathForRow(counter)) != null) {
                                this.addSelectionPath(selPath);
                            }
                            ++counter;
                        }
                    }
                    Object var6_5 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    static class TreeTableTextField
    extends JTextField {
        public int offset;

        TreeTableTextField() {
        }

        public void reshape(int x, int y, int w, int h) {
            int newX = Math.max(x, this.offset);
            super.reshape(newX, y, w - (newX - x), h);
        }

        public void addNotify() {
            super.addNotify();
            this.requestFocus();
        }
    }

    class TreeTableCellEditor
    extends DefaultCellEditor
    implements TreeSelectionListener,
    ActionListener,
    FocusListener,
    CellEditorListener {
        protected transient int offset;
        protected transient Timer timer;
        static /* synthetic */ Class class$org$openide$explorer$view$TreeViewCellEditor;

        public TreeTableCellEditor() {
            super(new TreeTableTextField());
            TreeTable.this.tree.addTreeSelectionListener(this);
            this.addCellEditorListener(this);
            super.getComponent().addFocusListener(this);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            Component component = super.getTableCellEditorComponent(table, value, isSelected, r, c);
            this.determineOffset(value, isSelected, r);
            ((TreeTableTextField)this.getComponent()).offset = this.offset;
            return component;
        }

        public boolean isCellEditable(EventObject e) {
            Node n;
            if (!(TreeTable.this.lastRow == -1 || (n = Visualizer.findNode(TreeTable.this.tree.getPathForRow(TreeTable.this.lastRow).getLastPathComponent())) != null && n.canRename())) {
                TreeTable.this.canEdit = false;
            }
            if (TreeTable.this.canEdit && e != null && e.getSource() instanceof Timer) {
                return true;
            }
            if (TreeTable.this.canEdit && this.shouldStartEditingTimer(e)) {
                this.startEditingTimer();
            } else if (this.shouldStopEditingTimer(e)) {
                this.timer.stop();
            }
            if (e instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e;
                int column = TreeTable.this.getTreeColumnIndex();
                if (MouseUtils.isLeftMouseButton(me) && me.getClickCount() == 2) {
                    TreePath path = TreeTable.this.tree.getPathForRow(TreeTable.this.rowAtPoint(me.getPoint()));
                    Rectangle r = TreeTable.this.tree.getPathBounds(path);
                    if (me.getX() < r.x - TreeTable.this.positionX || me.getX() > r.x - TreeTable.this.positionX + r.width) {
                        me.translatePoint(r.x - me.getX(), 0);
                    }
                }
                MouseEvent newME = new MouseEvent(TreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - TreeTable.this.getCellRect((int)0, (int)column, (boolean)true).x + TreeTable.this.positionX, me.getY(), me.getClickCount(), me.isPopupTrigger());
                TreeTable.this.tree.dispatchEvent(newME);
            }
            return false;
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (this.timer != null) {
                this.timer.stop();
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (TreeTable.this.lastRow != -1) {
                TreeTable.this.editCellAt(TreeTable.this.lastRow, TreeTable.this.getTreeColumnIndex(), new EventObject(this.timer));
            }
        }

        private boolean shouldStartEditingTimer(EventObject event) {
            if (event instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)event)) {
                MouseEvent me = (MouseEvent)event;
                return me.getID() == 501 && me.getClickCount() == 1 && this.inHitRegion(me);
            }
            return false;
        }

        private boolean shouldStopEditingTimer(EventObject event) {
            if (this.timer == null) {
                return false;
            }
            if (event instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)event;
                return !SwingUtilities.isLeftMouseButton(me) || me.getClickCount() > 1;
            }
            return false;
        }

        private void startEditingTimer() {
            if (this.timer == null) {
                this.timer = new Timer(1200, this);
                this.timer.setRepeats(false);
            }
            this.timer.start();
        }

        private boolean inHitRegion(MouseEvent me) {
            this.determineOffset(me);
            return me.getX() > this.offset;
        }

        private void determineOffset(MouseEvent me) {
            int row = TreeTable.this.rowAtPoint(me.getPoint());
            if (row == -1) {
                this.offset = 0;
                return;
            }
            this.determineOffset(TreeTable.this.tree.getPathForRow(row).getLastPathComponent(), TreeTable.this.isRowSelected(row), row);
        }

        private void determineOffset(Object value, boolean isSelected, int row) {
            Icon icon;
            Object node;
            JTree t = TreeTable.this.getTree();
            boolean rv = t.isRootVisible();
            int offsetRow = row;
            if (!rv && row > 0) {
                --offsetRow;
            }
            Rectangle bounds = t.getRowBounds(offsetRow);
            this.offset = bounds.x;
            TreeCellRenderer tcr = t.getCellRenderer();
            Component comp = tcr.getTreeCellRendererComponent(t, node = t.getPathForRow(offsetRow).getLastPathComponent(), isSelected, t.isExpanded(offsetRow), t.getModel().isLeaf(node), offsetRow, false);
            if (comp instanceof JLabel && (icon = ((JLabel)comp).getIcon()) != null) {
                this.offset += ((JLabel)comp).getIconTextGap() + icon.getIconWidth();
            }
            this.offset -= TreeTable.this.positionX;
        }

        private void revalidateTextField() {
            int row = TreeTable.this.editingRow;
            if (row == -1) {
                this.offset = 0;
                return;
            }
            this.determineOffset(TreeTable.this.tree.getPathForRow(row).getLastPathComponent(), TreeTable.this.isRowSelected(row), row);
            ((TreeTableTextField)super.getComponent()).offset = this.offset;
            this.getComponent().setBounds(TreeTable.this.getCellRect(row, TreeTable.this.getTreeColumnIndex(), false));
        }

        public void focusLost(FocusEvent evt) {
        }

        public void focusGained(FocusEvent evt) {
            ((TreeTableTextField)super.getComponent()).selectAll();
        }

        /*
         * Unable to fully structure code
         */
        public void editingStopped(ChangeEvent e) {
            block7: {
                lastP = TreeTable.access$300(TreeTable.this).getPathForRow(TreeTable.access$400(TreeTable.this));
                if (lastP != null && (n = Visualizer.findNode(lastP.getLastPathComponent())) != null && n.canRename()) {
                    block8: {
                        newStr = (String)this.getCellEditorValue();
                        try {
                            if (!n.getName().equals(newStr)) {
                                n.setName(newStr);
                            }
                            break block7;
                        }
                        catch (IllegalArgumentException exc) {
                            needToAnnotate = true;
                            em = ErrorManager.getDefault();
                            ann = em.findAnnotations(exc);
                            if (ann == null || ann.length <= 0) break block8;
                            i = 0;
                            ** while (i < ann.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            glm = ann[i].getLocalizedMessage();
                            if (glm != null && !glm.equals("")) {
                                needToAnnotate = false;
                            }
                            ++i;
                            continue;
                        }
                    }
                    if (needToAnnotate) {
                        msg = NbBundle.getMessage(TreeTableCellEditor.class$org$openide$explorer$view$TreeViewCellEditor == null ? (TreeTableCellEditor.class$org$openide$explorer$view$TreeViewCellEditor = TreeTableCellEditor.class$("org.openide.explorer.view.TreeViewCellEditor")) : TreeTableCellEditor.class$org$openide$explorer$view$TreeViewCellEditor, "RenameFailed", n.getName(), newStr);
                        em.annotate((Throwable)exc, msg);
                    }
                    em.notify(exc);
                }
            }
        }

        public void editingCanceled(ChangeEvent e) {
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;
        private int oldWidth;
        boolean hasFocus;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
            this.setRowHeight(this.getRowHeight());
            this.setToggleClickCount(0);
            this.putClientProperty("JTree.lineStyle", "None");
        }

        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (TreeTable.this != null && TreeTable.this.getRowHeight() != rowHeight) {
                    TreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w + TreeTable.this.positionX, TreeTable.this.getHeight());
        }

        public void reshape(int x, int y, int w, int h) {
            super.reshape(x, y, w, h);
            int newWidth = this.getPreferredSize().width;
            if (this.oldWidth != newWidth) {
                this.firePropertyChange("width", this.oldWidth, newWidth);
                this.oldWidth = newWidth;
            }
        }

        public void paint(Graphics g) {
            g.translate(-TreeTable.this.positionX, -this.visibleRow * this.getRowHeight());
            super.paint(g);
        }

        public Rectangle getVisibleRect() {
            Rectangle visibleRect = TreeTable.this.getVisibleRect();
            visibleRect.x = TreeTable.this.positionX;
            visibleRect.width = TreeTable.this.getColumnModel().getColumn(TreeTable.this.getTreeColumnIndex()).getWidth();
            return visibleRect;
        }

        public void scrollRectToVisible(Rectangle aRect) {
            Rectangle rect = this.getVisibleRect();
            rect.y = aRect.y;
            rect.height = aRect.height;
            TreeTable.this.scrollRectToVisible(rect);
            int x = rect.x;
            if (aRect.width > rect.width) {
                x = aRect.x;
            } else if (aRect.x < rect.x) {
                x = aRect.x;
            } else if (aRect.x + aRect.width > rect.x + rect.width) {
                x = aRect.x + aRect.width - rect.width;
            }
            TreeTable.this.setPositionX(x);
        }

        public String getToolTipText(MouseEvent event) {
            if (event != null) {
                Point p = event.getPoint();
                p.translate(TreeTable.this.positionX, this.visibleRow * this.getRowHeight());
                int selRow = this.getRowForLocation(p.x, p.y);
                if (selRow != -1) {
                    TreePath path = this.getPathForRow(selRow);
                    VisualizerNode v = (VisualizerNode)path.getLastPathComponent();
                    String tooltip = v.getShortDescription();
                    String displayName = v.getDisplayName();
                    if (tooltip != null && !tooltip.equals(displayName)) {
                        return tooltip;
                    }
                }
            }
            return null;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.hasFocus = hasFocus;
            this.visibleRow = row;
            return this;
        }

        protected TreeModelListener createTreeModelListener() {
            return new JTree.TreeModelHandler(this){
                private final /* synthetic */ TreeTableCellRenderer this$1;
                {
                    this.this$1 = this$1;
                }

                public void treeNodesRemoved(TreeModelEvent e) {
                    if (TreeTable.access$300(TreeTableCellRenderer.access$200(this.this$1)).getSelectionCount() == 0) {
                        TreePath path = TreeView.findSiblingTreePath(e.getTreePath(), e.getChildIndices());
                        if (path == null) {
                            return;
                        }
                        if (path.getPathCount() > 0 || TreeTable.access$300(TreeTableCellRenderer.access$200(this.this$1)).isRootVisible()) {
                            TreeTable.access$300(TreeTableCellRenderer.access$200(this.this$1)).setSelectionPath(path);
                        }
                    }
                }
            };
        }

        static /* synthetic */ TreeTable access$200(TreeTableCellRenderer x0) {
            return x0.TreeTable.this;
        }
    }
}

