/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.ListenerList;
import org.openide.filesystems.Repository;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.enum.FilterEnumeration;
import org.openide.util.enum.QueueEnumeration;

abstract class AbstractFolder
extends FileObject {
    private static final AbstractFolder[] EMPTY_ARRAY = new AbstractFolder[0];
    private static final char EXT_SEP = '.';
    private static final HashMap EMPTY = new HashMap(0);
    private FileSystem system;
    protected String name;
    protected final AbstractFolder parent;
    boolean validFlag;
    private AbstractFolder validRoot = null;
    private String[] children;
    private HashMap map;
    private ListenerList listeners;
    static /* synthetic */ Class class$org$openide$filesystems$FileChangeListener;

    public AbstractFolder(FileSystem fs, AbstractFolder parent, String name) {
        this.system = fs;
        this.parent = parent;
        this.name = name;
        this.validFlag = true;
        if (parent != null) {
            this.validRoot = (AbstractFolder)fs.getRoot();
        }
    }

    public final String getName() {
        int i = this.name.lastIndexOf(46);
        return i <= 0 ? this.name : this.name.substring(0, i);
    }

    public final String getExt() {
        int i = this.name.lastIndexOf(46) + 1;
        return i <= 1 || i == this.name.length() ? "" : this.name.substring(i);
    }

    public final String getNameExt() {
        return this.name;
    }

    final boolean isHasExtOverride() {
        return true;
    }

    boolean hasExtOverride(String ext) {
        if (ext == null) {
            return false;
        }
        if (this.name.length() - ext.length() <= 1) {
            return false;
        }
        boolean ret = this.name.endsWith(ext);
        if (!ret) {
            return false;
        }
        return this.name.charAt(this.name.length() - ext.length() - 1) == '.';
    }

    public final FileSystem getFileSystem() {
        return this.system;
    }

    public final boolean isRoot() {
        return this.parent == null;
    }

    public final boolean isValid() {
        if (this.parent == null) {
            return true;
        }
        boolean isValidRoot = this.getFileSystem().getRoot() == this.validRoot;
        return this.validFlag && isValidRoot;
    }

    public final FileObject getParent() {
        return this.parent;
    }

    public final synchronized FileObject[] getChildren() {
        this.check();
        if (this.children == null) {
            return new FileObject[0];
        }
        int size = this.children.length;
        FileObject[] arr = new FileObject[size];
        int i = 0;
        while (i < size) {
            arr[i] = this.getChild(this.children[i]);
            ++i;
        }
        return arr;
    }

    final FileObject find(Enumeration en) {
        AbstractFolder fo;
        for (fo = this; fo != null && en.hasMoreElements(); fo = fo.getChild((String)en.nextElement())) {
            AbstractFolder abstractFolder = fo;
            synchronized (abstractFolder) {
                fo.check();
                continue;
            }
        }
        return fo;
    }

    final FileObject findIfExists(Enumeration en) {
        Reference r = this.findRefIfExists(en);
        return r == null ? null : (FileObject)r.get();
    }

    final Reference findRefIfExists(Enumeration en) {
        String name;
        for (AbstractFolder fo = this; fo != null && en.hasMoreElements(); fo = fo.getChild(name)) {
            if (fo.map == null) {
                return null;
            }
            AbstractFolder abstractFolder = fo;
            synchronized (abstractFolder) {
                name = (String)en.nextElement();
                if (!en.hasMoreElements()) {
                    Reference reference = (Reference)fo.map.get(name);
                    return reference;
                }
                continue;
            }
        }
        return null;
    }

    protected final AbstractFolder getChild(String name) {
        Reference r = (Reference)this.map.get(name);
        if (r == null) {
            return null;
        }
        AbstractFolder fo = (AbstractFolder)r.get();
        if (fo == null) {
            fo = this.createFile(name);
            this.map.put(name, this.createReference(fo));
        }
        return fo;
    }

    final String[] getChildrenArray() {
        return this.children;
    }

    protected Reference createReference(FileObject fo) {
        return new WeakReference<FileObject>(fo);
    }

    final synchronized AbstractFolder[] subfiles() {
        if (this.map == null) {
            return EMPTY_ARRAY;
        }
        Iterator it = this.map.values().iterator();
        ArrayList<AbstractFolder> ll = new ArrayList<AbstractFolder>(this.map.size() + 2);
        while (it.hasNext()) {
            AbstractFolder fo;
            Reference r = (Reference)it.next();
            if (r == null || (fo = (AbstractFolder)r.get()) == null) continue;
            ll.add(fo);
        }
        return ll.toArray(EMPTY_ARRAY);
    }

    final boolean isInitialized() {
        return this.map != null;
    }

    final Enumeration existingSubFiles(boolean rec) {
        if (!rec) {
            return new ArrayEnumeration(this.subfiles());
        }
        QueueEnumeration en = new QueueEnumeration(){

            public void process(Object o) {
                AbstractFolder af = (AbstractFolder)o;
                this.put(af.subfiles());
            }
        };
        en.put(this);
        return en;
    }

    abstract void setAttribute(String var1, Object var2, boolean var3) throws IOException;

    public final synchronized FileObject getFileObject(String name, String ext) {
        this.check();
        if (ext == null || ext.equals("")) {
            return this.getChild(name);
        }
        StringBuffer sb = new StringBuffer(name.length() + 1 + (ext == null ? 0 : ext.length()));
        sb.append(name).append('.').append(ext);
        return this.getChild(sb.toString());
    }

    public void refresh(boolean expected) {
        if (!this.isInitialized() && this.isFolder()) {
            return;
        }
        this.refresh(null, null, true, expected);
    }

    public final void addFileChangeListener(FileChangeListener fcl) {
        AbstractFolder[] abstractFolderArray = EMPTY_ARRAY;
        synchronized (abstractFolderArray) {
            if (this.listeners == null) {
                this.listeners = new ListenerList(class$org$openide$filesystems$FileChangeListener == null ? (class$org$openide$filesystems$FileChangeListener = AbstractFolder.class$("org.openide.filesystems.FileChangeListener")) : class$org$openide$filesystems$FileChangeListener);
            }
        }
        this.listeners.add(fcl);
    }

    public final void removeFileChangeListener(FileChangeListener fcl) {
        if (this.listeners != null) {
            this.listeners.remove(fcl);
        }
    }

    protected final void fileDeleted0(FileEvent fileevent) {
        super.fireFileDeletedEvent(this.listeners(), fileevent);
        if (fileevent.getFile().equals(this) && this.parent != null) {
            FileEvent ev = new FileEvent((FileObject)this.parent, fileevent.getFile(), fileevent.isExpected());
            this.parent.fileDeleted0(ev);
        }
    }

    protected final void fileCreated0(FileEvent fileevent, boolean flag) {
        if (flag) {
            super.fireFileDataCreatedEvent(this.listeners(), fileevent);
        } else {
            super.fireFileFolderCreatedEvent(this.listeners(), fileevent);
        }
        if (fileevent.getFile().equals(this) && this.parent != null) {
            FileEvent ev = new FileEvent((FileObject)this.parent, fileevent.getFile(), fileevent.isExpected());
            this.parent.fileCreated0(ev, flag);
        }
    }

    protected final void fileCreated0(FileObject src, FileObject file, boolean expected) {
        FileEvent ev = new FileEvent(src, file, expected);
        this.fileCreated0(ev, false);
    }

    protected final void fileChanged0(FileEvent fileevent) {
        super.fireFileChangedEvent(this.listeners(), fileevent);
        if (fileevent.getFile().equals(this) && this.parent != null) {
            FileEvent ev = new FileEvent((FileObject)this.parent, fileevent.getFile(), fileevent.isExpected());
            this.parent.fileChanged0(ev);
        }
    }

    final void fileChanged1(FileEvent fileevent) {
        super.fireFileChangedEvent(this.listeners(), fileevent);
    }

    protected final void fileRenamed0(FileRenameEvent filerenameevent) {
        super.fireFileRenamedEvent(this.listeners(), filerenameevent);
        if (filerenameevent.getFile().equals(this) && this.parent != null) {
            FileRenameEvent ev = new FileRenameEvent(this.parent, filerenameevent.getFile(), filerenameevent.getName(), filerenameevent.getExt(), filerenameevent.isExpected());
            this.parent.fileRenamed0(ev);
        }
    }

    protected final void fileAttributeChanged0(FileAttributeEvent fileattributeevent) {
        super.fireFileAttributeChangedEvent(this.listeners(), fileattributeevent);
        if (fileattributeevent.getFile().equals(this) && this.parent != null) {
            FileAttributeEvent ev = new FileAttributeEvent(this.parent, fileattributeevent.getFile(), fileattributeevent.getName(), fileattributeevent.getOldValue(), fileattributeevent.getNewValue(), fileattributeevent.isExpected());
            this.parent.fileAttributeChanged0(ev);
        }
    }

    protected final boolean hasListeners() {
        boolean fsHas = this.getFileSystem().getFCLSupport().hasListeners();
        boolean repHas = false;
        Repository rep = this.getFileSystem().getRepository();
        if (rep != null) {
            repHas = rep.getFCLSupport().hasListeners();
        }
        return this.listeners != null && this.listeners.getAllListeners().length != 0 || repHas || fsHas;
    }

    protected final boolean hasAtLeastOneListeners() {
        return this.hasListeners() || this.parent != null && this.parent.hasListeners();
    }

    private final Enumeration listeners() {
        if (this.listeners == null) {
            return EmptyEnumeration.EMPTY;
        }
        return new FilterEnumeration(new ArrayEnumeration(this.listeners.getAllListeners())){
            static /* synthetic */ Class class$org$openide$filesystems$FileChangeListener;

            public boolean accept(Object o) {
                return o != (class$org$openide$filesystems$FileChangeListener == null ? (class$org$openide$filesystems$FileChangeListener = 2.class$("org.openide.filesystems.FileChangeListener")) : class$org$openide$filesystems$FileChangeListener);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
    }

    private final void check() {
        if (this.map == null) {
            this.refresh(null, null, false, false);
            if (this.map == null) {
                this.map = EMPTY;
            }
        }
    }

    protected final void refresh(String added, String removed) {
        this.refresh(added, removed, false);
    }

    protected final void refresh(String added, String removed, boolean reuseChildren) {
        if (reuseChildren && removed != null) {
            String[] nc = new String[this.children.length];
            System.arraycopy(this.children, 0, nc, 0, this.children.length);
            int i = nc.length;
            while (--i >= 0) {
                if (!removed.equals(nc[i])) continue;
                nc[i] = null;
                break;
            }
            this.refresh(added, removed, true, false, nc);
        } else {
            this.refresh(added, removed, true, false, null);
        }
    }

    protected abstract String[] list();

    protected abstract AbstractFolder createFile(String var1);

    protected void refresh(String added, String removed, boolean fire, boolean expected) {
        this.refresh(added, removed, fire, expected, null);
    }

    void registerChild(String name) {
        AbstractFolder abstractFolder = this;
        synchronized (abstractFolder) {
            WeakReference<Object> o;
            if (this.map == null) {
                this.check();
            }
            if ((o = this.map.put(name, new WeakReference<Object>(null))) != null) {
                this.map.put(name, o);
            } else {
                String[] newChildren = new String[this.children.length + 1];
                System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
                newChildren[this.children.length] = name;
                this.children = newChildren;
            }
        }
    }

    protected final void refreshFolder(String added, String removed, boolean fire, boolean expected, String[] list) {
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFolder abstractFolder = this;
            synchronized (abstractFolder) {
                Iterator it;
                HashSet<String> add;
                HashMap<String, WeakReference<Object>> m;
                String[] newChildren;
                if (list == null) {
                    list = this.list();
                }
                if ((newChildren = list) == null && this.parent == null) {
                    newChildren = new String[]{};
                }
                if (this.children == null && newChildren == null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 23] lbl11 : MonitorExitStatement: MONITOREXIT : var6_6
                    Object var19_8 = null;
                    this.getFileSystem().finishAtomicAction();
                    return;
                }
                int newChildrenContainNull = 0;
                if (newChildren != null) {
                    int size = newChildren.length;
                    m = new HashMap(size * 4 / 3 + 1, 0.75f);
                    add = new HashSet<String>(size * 4 / 3 + 1, 0.75f);
                    Object replaceInSteadOfRemoved = this.map != null ? (Object)this.map.get(removed) : null;
                    int i = 0;
                    while (i < size) {
                        String ch = newChildren[i];
                        if (ch == null) {
                            ++newChildrenContainNull;
                        } else {
                            boolean isSpecialRename;
                            WeakReference<Object> old = this.map == null ? null : (WeakReference<Object>)this.map.remove(ch);
                            boolean bl = isSpecialRename = added != null && ch.equals(removed);
                            if (old == null || isSpecialRename) {
                                old = new WeakReference<Object>(null);
                                add.add(ch);
                            }
                            m.put(ch, old);
                        }
                        ++i;
                    }
                    if (added != null && replaceInSteadOfRemoved != null) {
                        m.put(added, (WeakReference<Object>)replaceInSteadOfRemoved);
                    }
                } else {
                    m = new HashMap<String, WeakReference<Object>>(0);
                    add = Collections.EMPTY_SET;
                }
                HashMap disappeared = null;
                if (fire) {
                    if (added != null) {
                        add.remove(added);
                    }
                    if (this.map != null) {
                        disappeared = this.map;
                        it = this.map.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            entry.setValue(this.getChild((String)entry.getKey()));
                        }
                        if (removed != null) {
                            disappeared.remove(removed);
                        }
                        if (disappeared.isEmpty()) {
                            disappeared = null;
                        }
                    }
                }
                this.map = m;
                if (newChildrenContainNull != 0) {
                    String[] arr = new String[newChildren.length - newChildrenContainNull];
                    int j = 0;
                    int i = 0;
                    while (i < newChildren.length) {
                        if (newChildren[i] != null) {
                            arr[j++] = newChildren[i];
                        }
                        ++i;
                    }
                    this.children = arr;
                } else {
                    this.children = newChildren;
                }
                if (fire && !add.isEmpty() && this.hasAtLeastOneListeners()) {
                    it = add.iterator();
                    while (it.hasNext()) {
                        String name = (String)((Object)it.next());
                        AbstractFolder fo = this.getChild(name);
                        if (fo == null) continue;
                        this.fileCreated0(this, fo, expected);
                    }
                }
                if (fire && disappeared != null) {
                    it = disappeared.values().iterator();
                    while (it.hasNext()) {
                        AbstractFolder fo = (AbstractFolder)((Object)it.next());
                        fo.validFlag = false;
                        if (!this.hasAtLeastOneListeners() && !fo.hasAtLeastOneListeners()) continue;
                        FileEvent ev = new FileEvent((FileObject)fo, (FileObject)fo, expected);
                        fo.fileDeleted0(ev);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var19_10 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
        Object var19_9 = null;
        this.getFileSystem().finishAtomicAction();
    }

    protected void refresh(String added, String removed, boolean fire, boolean expected, String[] list) {
        if (this.isFolder()) {
            this.refreshFolder(added, removed, fire, expected, list);
        }
    }

    protected void outputStreamClosed(boolean fireFileChange) {
        if (fireFileChange) {
            this.fileChanged0(new FileEvent(this));
        }
    }

    public final Object writeReplace() {
        return new AbstractFileObject.Replace(this.getFileSystem().getSystemName(), this.getPath());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

