/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.rmi.MarshalledObject;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.XMLMapAttr;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.NbObjectInputStream;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultAttributes
implements AbstractFileSystem.Attr,
AbstractFileSystem.List {
    static final long serialVersionUID = -5801291358293736478L;
    public static final String ATTR_NAME = "filesystem";
    public static final String ATTR_EXT = "attributes";
    public static final String ATTR_NAME_EXT = "filesystem.attributes";
    private static final String ATTR_NAME_EXT_XML = System.getProperty("org.openide.filesystems.DefaultAttributes.ATTR_NAME_EXT_XML", ".nbattrs");
    private AbstractFileSystem.Info info;
    private AbstractFileSystem.Change change;
    private AbstractFileSystem.List list;
    private static final String READONLY_ATTRIBUTES = "readOnlyAttrs";
    private transient Map cache;
    private static final String PUBLIC_ID = "-//NetBeans//DTD DefaultAttributes 1.0//EN";
    private static final String DTD_PATH = "org/openide/filesystems/attributes.dtd";
    static /* synthetic */ Class class$org$openide$filesystems$DefaultAttributes;

    public DefaultAttributes(AbstractFileSystem.Info info, AbstractFileSystem.Change change, AbstractFileSystem.List list) {
        this.info = info;
        this.change = change;
        this.list = list;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = ois.readFields();
        Object o1 = AbstractFileSystem.readImpl("change", fields);
        Object o2 = AbstractFileSystem.readImpl("info", fields);
        Object o3 = AbstractFileSystem.readImpl("list", fields);
        this.change = (AbstractFileSystem.Change)o1;
        this.info = (AbstractFileSystem.Info)o2;
        this.list = (AbstractFileSystem.List)o3;
    }

    public String[] children(String f) {
        String[] arr = this.list.children(f);
        int lookUpIndex = 0;
        if (arr == null) {
            return null;
        }
        int size = arr.length;
        if (size == 1) {
            if (Utilities.getOperatingSystem() == 8192 && arr[0] != null && f != null && arr[0].equalsIgnoreCase("_nbattrs.")) {
                try {
                    this.change.delete(f + "/" + arr[0]);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                arr[0] = ATTR_NAME_EXT_XML;
            }
            if (ATTR_NAME_EXT_XML.equals(arr[0]) || ATTR_NAME_EXT.equals(arr[0])) {
                try {
                    this.change.delete(f + "/" + arr[0]);
                }
                catch (IOException iox) {
                    // empty catch block
                }
                return new String[0];
            }
        }
        int i = 0;
        while (i < size) {
            if (Utilities.getOperatingSystem() == 8192 && arr[i] != null && f != null && arr[i].equalsIgnoreCase("_nbattrs.")) {
                try {
                    File fp = new File(f + "/" + ".nbattrs");
                    if (!fp.exists()) {
                        this.cache = null;
                        this.copyVMSAttrFile(f);
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                arr[i] = ATTR_NAME_EXT_XML;
            }
            if (ATTR_NAME_EXT.equals(arr[i]) || ATTR_NAME_EXT_XML.equals(arr[i])) {
                arr[i] = null;
                if (++lookUpIndex >= 2) break;
            }
            ++i;
        }
        return arr;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyVMSAttrFile(String f) throws IOException {
        OutputStream os;
        block10: {
            InputStream is = null;
            os = null;
            try {
                try {
                    this.change.createData(f + "/" + ATTR_NAME_EXT_XML);
                    is = this.info.inputStream(f + "/" + "_nbattrs.");
                    os = this.info.outputStream(f + "/" + ATTR_NAME_EXT_XML);
                    byte[] buf = new byte[256];
                    while (true) {
                        void var5_6;
                        int readi;
                        if ((readi = is.read(buf, 0, 256)) < 0) {
                            is.close();
                            is = null;
                            break;
                        }
                        os.write(buf, 0, (int)var5_6);
                    }
                }
                catch (IOException ie) {
                    Object var7_8 = null;
                    if (is != null) {
                        is.close();
                    }
                    if (os == null) return;
                    os.close();
                    return;
                }
                Object var7_7 = null;
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (is != null) {
                    is.close();
                }
                if (os == null) throw throwable;
                os.close();
                throw throwable;
            }
            is.close();
        }
        if (os == null) return;
        os.close();
    }

    public Object readAttribute(String name, String attrName) {
        Table t;
        String[] arr = new String[2];
        DefaultAttributes.split(name, arr);
        if (attrName.equals(READONLY_ATTRIBUTES)) {
            return this.info.readOnly(arr[0]) ? Boolean.TRUE : Boolean.FALSE;
        }
        DefaultAttributes defaultAttributes = this;
        synchronized (defaultAttributes) {
            t = this.loadTable(arr[0]);
        }
        return t.getAttr(arr[1], attrName);
    }

    public void writeAttribute(String name, String attrName, Object value) throws IOException {
        String[] arr = new String[2];
        DefaultAttributes.split(name, arr);
        while (true) {
            int version;
            Table t;
            DefaultAttributes defaultAttributes = this;
            synchronized (defaultAttributes) {
                t = this.loadTable(arr[0]);
                version = t.version;
            }
            Object prev = t.getAttr(arr[1], attrName);
            if (prev == value) {
                return;
            }
            DefaultAttributes defaultAttributes2 = this;
            synchronized (defaultAttributes2) {
                Table t2 = this.loadTable(arr[0]);
                if (t == t2 && version == t2.version) {
                    if (value == null) {
                        t.setAttr(arr[1], attrName, null);
                    } else {
                        int objType = XMLMapAttr.Attr.distinguishObject(value);
                        if (objType == XMLMapAttr.Attr.isValid("SERIALVALUE")) {
                            t.setAttr(arr[1], attrName, value);
                        } else {
                            t.setAttr(arr[1], attrName, new XMLMapAttr.Attr(objType, value.toString()));
                        }
                    }
                    this.saveTable(arr[0], t);
                    return;
                }
            }
        }
    }

    public synchronized Enumeration attributes(String name) {
        String[] arr = new String[2];
        DefaultAttributes.split(name, arr);
        Table t = this.loadTable(arr[0]);
        return t.attrs(arr[1]);
    }

    public synchronized void renameAttributes(String oldName, String newName) {
        try {
            String[] arr = new String[2];
            DefaultAttributes.split(oldName, arr);
            Table t = this.loadTable(arr[0]);
            Map v = (Map)t.remove(arr[1]);
            if (v == null) {
                return;
            }
            DefaultAttributes.split(newName, arr);
            Iterator it = v.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pair = it.next();
                if (!FileUtil.transientAttributes.contains(pair.getKey())) continue;
                it.remove();
            }
            t.put(arr[1], v);
            this.saveTable(arr[0], t);
        }
        catch (IOException e) {
            ExternalUtil.exception(e);
        }
    }

    public synchronized void deleteAttributes(String name) {
        try {
            String[] arr = new String[2];
            DefaultAttributes.split(name, arr);
            Table t = this.loadTable(arr[0]);
            if (t.remove(arr[1]) != null) {
                this.saveTable(arr[0], t);
            }
        }
        catch (IOException e) {
            ExternalUtil.exception(e);
        }
    }

    private Map getCache() {
        if (this.cache == null) {
            this.cache = new HashMap(31);
        }
        return this.cache;
    }

    private static void split(String name, String[] arr) {
        int i = name.lastIndexOf(47);
        if (i == -1) {
            arr[0] = "";
            arr[1] = name;
            return;
        }
        arr[0] = name.substring(0, i);
        arr[1] = ++i == name.length() ? "" : name.substring(i);
    }

    /*
     * Loose catch block
     */
    private void saveTable(String name, Table map) throws IOException {
        block19: {
            IOException ioexc;
            PrintWriter pw;
            String safeName;
            String fullName;
            block17: {
                fullName = (name.length() == 0 ? "" : name + '/') + ATTR_NAME_EXT_XML;
                safeName = fullName + "~";
                if (this.info.folder(fullName)) {
                    if (map.size() == 0) {
                        return;
                    }
                    this.change.createData(fullName);
                } else if (map.size() == 0) {
                    this.change.delete(fullName);
                    return;
                }
                pw = null;
                ioexc = null;
                pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.info.outputStream(safeName)), "UTF8"));
                map.writeToXML(pw);
                pw.flush();
                Object var9_7 = null;
                if (pw != null) {
                    pw.close();
                }
                if (ioexc == null) break block17;
                this.change.delete(safeName);
                throw ioexc;
            }
            try {
                this.change.delete(fullName);
            }
            catch (IOException iex2) {
                // empty catch block
            }
            this.change.rename(safeName, fullName);
            {
                break block19;
                catch (IOException iex) {
                    ioexc = iex;
                    Object var9_8 = null;
                    if (pw != null) {
                        pw.close();
                    }
                    if (ioexc != null) {
                        this.change.delete(safeName);
                        throw ioexc;
                    }
                    try {
                        this.change.delete(fullName);
                    }
                    catch (IOException iex2) {
                        // empty catch block
                    }
                    this.change.rename(safeName, fullName);
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (pw != null) {
                    pw.close();
                }
                if (ioexc != null) {
                    this.change.delete(safeName);
                    throw ioexc;
                }
                try {
                    this.change.delete(fullName);
                }
                catch (IOException iex2) {
                    // empty catch block
                }
                this.change.rename(safeName, fullName);
                throw throwable;
            }
        }
    }

    private Table loadTable(String name) {
        Table m;
        Reference r = (Reference)this.getCache().get(name);
        if (r != null && (m = (Table)r.get()) != null) {
            return m;
        }
        Table t = this.load(name);
        t.attach(name, this);
        this.getCache().put(name, new SoftReference<Table>(t));
        return t;
    }

    private Table load(String name) {
        String[] acceptNames = new String[]{(name.length() == 0 ? "" : name + '/') + ATTR_NAME_EXT_XML, (name.length() == 0 ? "" : name + '/') + ATTR_NAME_EXT};
        int i = 0;
        while (i < acceptNames.length) {
            block8: {
                if (this.info.size(acceptNames[i]) <= 0L) break block8;
                try {
                    Table table;
                    InputStream fis = this.info.inputStream(acceptNames[i]);
                    try {
                        table = DefaultAttributes.loadTable(fis, acceptNames[i]);
                        Object var7_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return table;
                }
                catch (FileNotFoundException ex) {
                    ExternalUtil.exception(ex);
                }
            }
            ++i;
        }
        return new Table();
    }

    static Table loadTable(InputStream is, String folderName) {
        block5: {
            Table retTable = new Table();
            PushbackInputStream pbStream = null;
            boolean isSerialized = false;
            try {
                if (!folderName.endsWith(ATTR_NAME_EXT_XML)) {
                    pbStream = new PushbackInputStream(is, 4);
                    isSerialized = DefaultAttributes.isSerialized(pbStream);
                }
                if (isSerialized && pbStream != null) {
                    BufferedInputStream fis = new BufferedInputStream(pbStream);
                    NbObjectInputStream ois = new NbObjectInputStream(fis);
                    Object o = ois.readObject();
                    if (o instanceof Table) {
                        return (Table)o;
                    }
                    break block5;
                }
                retTable.readFromXML(new BufferedInputStream(is), false);
                return retTable;
            }
            catch (Exception e) {
                IOException summaryEx = new IOException(NbBundle.getMessage(class$org$openide$filesystems$DefaultAttributes == null ? (class$org$openide$filesystems$DefaultAttributes = DefaultAttributes.class$("org.openide.filesystems.DefaultAttributes")) : class$org$openide$filesystems$DefaultAttributes, "EXC_DefAttrReadErr") + ": " + folderName);
                ExternalUtil.copyAnnotation(summaryEx, e);
                ExternalUtil.exception(summaryEx);
            }
        }
        return new Table();
    }

    private static final boolean isSerialized(PushbackInputStream pbStream) throws IOException {
        int[] serialPattern = new int[]{172, 237, 0, 5};
        byte[] checkedArray = new byte[serialPattern.length];
        int unsignedConv = 0;
        pbStream.read(checkedArray, 0, checkedArray.length);
        pbStream.unread(checkedArray);
        int i = 0;
        while (i < checkedArray.length) {
            int n = unsignedConv = checkedArray[i] < 0 ? checkedArray[i] + 256 : checkedArray[i];
            if (serialPattern[i] != unsignedConv) {
                return false;
            }
            ++i;
        }
        return true;
    }

    synchronized void removeTable(String name) {
        this.getCache().remove(name);
    }

    static boolean acceptName(String name) {
        return name.endsWith(ATTR_NAME_EXT) || name.endsWith(ATTR_NAME_EXT_XML);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class InnerParser
    extends HandlerBase {
        private ElementHandler[] elmKeyService;
        private String tagInProcess = "";
        private String publicId;
        private String publicURL;
        static /* synthetic */ Class class$org$openide$filesystems$DefaultAttributes;

        InnerParser(String publicId, String publicURL, ElementHandler[] elmKeyService) {
            this.elmKeyService = elmKeyService;
            this.publicId = publicId;
            this.publicURL = publicURL;
        }

        public void parseXML(String uri, boolean validate) throws IOException, SAXException, ParserConfigurationException, FactoryConfigurationError {
            Parser parser = this.getParser(validate);
            parser.parse(uri);
        }

        public void parseXML(InputStream is, boolean validate) throws IOException, SAXException, ParserConfigurationException, FactoryConfigurationError {
            InputSource iSource = new InputSource(is);
            Parser parser = this.getParser(validate);
            parser.parse(iSource);
        }

        private Parser getParser(boolean validate) throws SAXException, ParserConfigurationException, FactoryConfigurationError {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(validate);
            factory.setNamespaceAware(false);
            Parser parser = factory.newSAXParser().getParser();
            if (parser == null) {
                throw new InternalError(NbBundle.getMessage(class$org$openide$filesystems$DefaultAttributes == null ? (class$org$openide$filesystems$DefaultAttributes = InnerParser.class$("org.openide.filesystems.DefaultAttributes")) : class$org$openide$filesystems$DefaultAttributes, "EXC_UnreachableCode"));
            }
            parser.setEntityResolver(this);
            parser.setDocumentHandler(this);
            parser.setErrorHandler(this);
            return parser;
        }

        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String name, AttributeList amap) throws SAXException {
            this.tagInProcess = name = name.trim();
            int i = 0;
            while (i < this.elmKeyService.length) {
                if (this.elmKeyService[i].isMyTag(name) != -1) {
                    this.elmKeyService[i].startElement(name, amap);
                    return;
                }
                ++i;
            }
            throw new SAXException(NbBundle.getMessage(class$org$openide$filesystems$DefaultAttributes == null ? (class$org$openide$filesystems$DefaultAttributes = InnerParser.class$("org.openide.filesystems.DefaultAttributes")) : class$org$openide$filesystems$DefaultAttributes, "XML_UnknownElement") + " " + name);
        }

        public void endElement(String name) throws SAXException {
            int i = 0;
            while (i < this.elmKeyService.length) {
                if (this.elmKeyService[i].isMyTag(name.trim()) != -1) {
                    this.elmKeyService[i].endElement(name.trim());
                    return;
                }
                ++i;
            }
            throw new SAXException(NbBundle.getMessage(class$org$openide$filesystems$DefaultAttributes == null ? (class$org$openide$filesystems$DefaultAttributes = InnerParser.class$("org.openide.filesystems.DefaultAttributes")) : class$org$openide$filesystems$DefaultAttributes, "XML_UnknownElement") + " " + name);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            int i = 0;
            while (i < this.elmKeyService.length) {
                if (this.elmKeyService[i].isMyTag(this.tagInProcess) != -1) {
                    this.elmKeyService[i].characters(ch, start, length);
                    return;
                }
                ++i;
            }
            throw new SAXException(NbBundle.getMessage(class$org$openide$filesystems$DefaultAttributes == null ? (class$org$openide$filesystems$DefaultAttributes = InnerParser.class$("org.openide.filesystems.DefaultAttributes")) : class$org$openide$filesystems$DefaultAttributes, "XML_UnknownElement") + " " + this.tagInProcess);
        }

        public InputSource resolveEntity(String pid, String sid) throws SAXException {
            if (pid != null && pid.equals(this.publicId)) {
                return new InputSource(this.publicURL);
            }
            return new InputSource(sid);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static abstract class ElementHandler {
        private int mandatAttrCount;
        private static final String[] EMPTY = new String[0];
        static /* synthetic */ Class class$org$openide$filesystems$DefaultAttributes;

        ElementHandler() {
        }

        public void startElement(String elemName, AttributeList attrList) throws SAXException {
            HashMap mapMandatory = new HashMap();
            HashMap mapAllowed = new HashMap();
            if (!this.checkAttributes(attrList, mapMandatory, mapAllowed)) {
                throw new SAXException(NbBundle.getMessage(class$org$openide$filesystems$DefaultAttributes == null ? (class$org$openide$filesystems$DefaultAttributes = ElementHandler.class$("org.openide.filesystems.DefaultAttributes")) : class$org$openide$filesystems$DefaultAttributes, "XML_InaccurateParam") + ": " + elemName);
            }
            this.internalStartElement(elemName, mapMandatory, mapAllowed);
        }

        protected void internalStartElement(String elemName, HashMap mapMandatory, HashMap mapAllowed) throws SAXException {
        }

        protected void characters(char[] ch, int start, int length) throws SAXException {
        }

        protected void endElement(String elemName) throws SAXException {
        }

        protected String[] getKeys() {
            return EMPTY;
        }

        protected String[] getMandatoryAttrs() {
            return this.getKeys();
        }

        protected String[] getAllowedAttrs() {
            return EMPTY;
        }

        private int isMyTag(String name) {
            return this.isInArray(name, this.getKeys());
        }

        private int isAllowedAttr(String name) {
            return this.isInArray(name, this.getAllowedAttrs());
        }

        private boolean isMandatOK() {
            return this.mandatAttrCount == this.getMandatoryAttrs().length;
        }

        private int isMandatoryAttr(String name) {
            int retValue = this.isInArray(name, this.getMandatoryAttrs());
            if (retValue != -1) {
                ++this.mandatAttrCount;
            }
            return retValue;
        }

        private int isInArray(String name, String[] arr) {
            if (arr == null || name == null) {
                return -1;
            }
            String correctStr = name.trim();
            int i = 0;
            while (i < arr.length) {
                if (correctStr.equalsIgnoreCase(arr[i])) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private boolean checkAttributes(AttributeList attrList, HashMap mapMandatory, HashMap mapAllowed) {
            this.mandatAttrCount = 0;
            if (attrList == null) {
                return false;
            }
            int i = 0;
            while (i < attrList.getLength()) {
                String temp;
                if (this.isMandatoryAttr(attrList.getName(i)) != -1) {
                    temp = attrList.getName(i).toUpperCase();
                    mapMandatory.put(temp, attrList.getValue(i));
                } else if (this.isAllowedAttr(attrList.getName(i)) != -1) {
                    temp = attrList.getName(i).toUpperCase();
                    mapAllowed.put(temp, attrList.getValue(i));
                }
                ++i;
            }
            return this.isMandatOK();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static final class Table
    extends HashMap
    implements Externalizable {
        static final long serialVersionUID = 2353458763249746934L;
        private transient String name;
        private transient DefaultAttributes attrs;
        private transient int version = 0;
        static /* synthetic */ Class class$org$openide$filesystems$DefaultAttributes;

        public Table() {
            super(11);
        }

        public void attach(String name, DefaultAttributes attrs) {
            this.name = name;
            this.attrs = attrs;
        }

        protected void finalize() {
            this.attrs.removeTable(this.name);
        }

        public Object getAttr(String fileName, String attrName) {
            XMLMapAttr m = (XMLMapAttr)this.get(fileName);
            if (m != null) {
                Object o = null;
                try {
                    o = m.getAttribute(attrName);
                }
                catch (Exception e) {
                    ExternalUtil.annotate((Throwable)e, "fileName = " + fileName);
                    ExternalUtil.exception(e);
                }
                if (o == null) {
                    return null;
                }
                if (!(o instanceof NbMarshalledObject)) {
                    return o;
                }
                NbMarshalledObject mo = (NbMarshalledObject)o;
                try {
                    return mo == null ? null : mo.get();
                }
                catch (IOException e) {
                    ExternalUtil.log("Cannot load attribute " + attrName + " from " + fileName);
                    ExternalUtil.exception(e);
                }
                catch (ClassNotFoundException e) {
                    ExternalUtil.log("Cannot load attribute " + attrName + " from " + fileName);
                    ExternalUtil.exception(e);
                }
            }
            return null;
        }

        final void setMarshalledAttr(String fileName, String attrName, NbMarshalledObject obj) {
            this.setAttr(fileName, attrName, obj);
        }

        final void setAttr(String fileName, String attrName, Object obj) {
            Map m = (Map)this.get(fileName);
            if (m == null) {
                m = new XMLMapAttr();
                this.put(fileName, m);
            }
            m.put(attrName, obj);
            ++this.version;
        }

        public Enumeration attrs(String fileName) {
            Map m = (Map)this.get(fileName);
            if (m == null) {
                return EmptyEnumeration.EMPTY;
            }
            HashSet s = new HashSet(m.keySet());
            return Collections.enumeration(s);
        }

        private ElementHandler parseFirstLevel() {
            ElementHandler elemService = new ElementHandler(this){
                private final String[] ELM_KEYS;
                private final String[] MANDAT_ATTR_KEYS;
                private final /* synthetic */ Table this$0;
                {
                    this.this$0 = this$0;
                    this.ELM_KEYS = new String[]{"ATTRIBUTES"};
                    this.MANDAT_ATTR_KEYS = new String[]{"VERSION"};
                }

                public void internalStartElement(String elemName, HashMap mapMandatory, HashMap mapAllowed) throws SAXException {
                }

                protected String[] getKeys() {
                    return this.ELM_KEYS;
                }

                protected String[] getMandatoryAttrs() {
                    return this.MANDAT_ATTR_KEYS;
                }
            };
            return elemService;
        }

        private ElementHandler parseSecondLevel(StringBuffer fileName) {
            ElementHandler elemService = new ElementHandler(this, fileName){
                private final String[] ELM_KEYS;
                private final String[] MANDAT_ATTR_KEYS;
                private final /* synthetic */ StringBuffer val$fileName;
                private final /* synthetic */ Table this$0;
                {
                    this.this$0 = this$0;
                    this.val$fileName = val$fileName;
                    this.ELM_KEYS = new String[]{"FILEOBJECT"};
                    this.MANDAT_ATTR_KEYS = new String[]{"NAME"};
                }

                public void internalStartElement(String elemName, HashMap mapMandatory, HashMap mapAllowed) throws SAXException {
                    this.val$fileName.delete(0, this.val$fileName.length());
                    String temp = (String)mapMandatory.get("NAME");
                    if (temp == null) {
                        temp = (String)mapMandatory.get("name");
                    }
                    if (temp != null) {
                        this.val$fileName.append(temp);
                    }
                }

                public void endElement(String elementName) throws SAXException {
                }

                protected String[] getKeys() {
                    return this.ELM_KEYS;
                }

                protected String[] getMandatoryAttrs() {
                    return this.MANDAT_ATTR_KEYS;
                }
            };
            return elemService;
        }

        private ElementHandler parseThirdLevel(StringBuffer fileName) {
            ElementHandler elemService = new ElementHandler(this, fileName){
                private final String[] ELM_KEYS;
                private final String[] MANDAT_ATTR_KEYS;
                private final /* synthetic */ StringBuffer val$fileName;
                private final /* synthetic */ Table this$0;
                {
                    this.this$0 = this$0;
                    this.val$fileName = val$fileName;
                    this.ELM_KEYS = new String[]{"ATTR"};
                    this.MANDAT_ATTR_KEYS = new String[]{"NAME"};
                }

                public void internalStartElement(String elemName, HashMap mapMandatory, HashMap mapAllowed) throws SAXException {
                    if (mapAllowed.isEmpty()) {
                        return;
                    }
                    String attrName = (String)mapMandatory.get("NAME");
                    if (attrName == null) {
                        attrName = (String)mapMandatory.get("name");
                    }
                    if (attrName == null) {
                        return;
                    }
                    Iterator<Map.Entry<K, V>> it = mapAllowed.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<K, V> pair = it.next();
                        if (XMLMapAttr.Attr.isValid((String)pair.getKey()) == -1) continue;
                        XMLMapAttr.Attr attr = new XMLMapAttr.Attr((String)pair.getKey(), (String)pair.getValue());
                        this.this$0.setAttr(this.val$fileName.toString(), attrName, attr);
                    }
                }

                protected String[] getKeys() {
                    return this.ELM_KEYS;
                }

                protected String[] getMandatoryAttrs() {
                    return this.MANDAT_ATTR_KEYS;
                }

                protected String[] getAllowedAttrs() {
                    return XMLMapAttr.Attr.getAttrTypes();
                }
            };
            return elemService;
        }

        public void writeToXML(PrintWriter pw) {
            Iterator it = this.keySet().iterator();
            XMLMapAttr.writeHeading(pw);
            while (it.hasNext()) {
                String file = (String)it.next();
                XMLMapAttr attr = (XMLMapAttr)this.get(file);
                if (attr == null || attr.isEmpty()) continue;
                attr.write(pw, file, "    ");
            }
            XMLMapAttr.writeEnding(pw);
        }

        public void readFromXML(InputStream is, boolean validate) throws SAXException {
            StringBuffer fileName = new StringBuffer();
            ElementHandler[] elmKeyService = new ElementHandler[]{this.parseFirstLevel(), this.parseSecondLevel(fileName), this.parseThirdLevel(fileName)};
            String dtd = this.getClass().getClassLoader().getResource(DefaultAttributes.DTD_PATH).toExternalForm();
            InnerParser parser = new InnerParser(DefaultAttributes.PUBLIC_ID, dtd, elmKeyService);
            try {
                parser.parseXML(is, validate);
            }
            catch (Exception ioe) {
                throw (SAXException)ExternalUtil.copyAnnotation(new SAXException(NbBundle.getMessage(class$org$openide$filesystems$DefaultAttributes == null ? (class$org$openide$filesystems$DefaultAttributes = Table.class$("org.openide.filesystems.DefaultAttributes")) : class$org$openide$filesystems$DefaultAttributes, "EXC_DefAttrReadErr")), ioe);
            }
            catch (FactoryConfigurationError fce) {
                throw (SAXException)ExternalUtil.copyAnnotation(new SAXException(NbBundle.getMessage(class$org$openide$filesystems$DefaultAttributes == null ? (class$org$openide$filesystems$DefaultAttributes = Table.class$("org.openide.filesystems.DefaultAttributes")) : class$org$openide$filesystems$DefaultAttributes, "EXC_DefAttrReadErr")), fce);
            }
        }

        public void writeExternal(ObjectOutput oo) throws IOException {
            Iterator it = this.keySet().iterator();
            while (it.hasNext()) {
                String file = (String)it.next();
                Map attr = (Map)this.get(file);
                if (attr == null || attr.isEmpty()) continue;
                oo.writeObject(file);
                Iterator entries = attr.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (key == null || value == null) continue;
                    oo.writeObject(key);
                    oo.writeObject(value);
                }
                oo.writeObject(null);
            }
            oo.writeObject(null);
        }

        public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
            String file;
            while ((file = (String)oi.readObject()) != null) {
                String attr;
                while ((attr = (String)oi.readObject()) != null) {
                    Object o = oi.readObject();
                    if (o instanceof MarshalledObject) {
                        o = ((MarshalledObject)o).get();
                        o = new NbMarshalledObject(o);
                    }
                    if (!(o instanceof NbMarshalledObject)) continue;
                    this.setAttr(file, attr, o);
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

