/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.UnknownServiceException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;

final class FileURL
extends URLConnection {
    public static final String PROTOCOL = "nbfs";
    private static final char SEPARATOR = '/';
    static URLStreamHandler HANDLER = new URLStreamHandler(){

        public URLConnection openConnection(URL u) throws IOException {
            return new FileURL(u);
        }
    };
    private FileObject fo;

    private FileURL(URL u) {
        super(u);
    }

    public static URL encodeFileObject(FileObject fo) throws FileStateInvalidException {
        return FileURL.encodeFileObject(fo.getFileSystem(), fo);
    }

    private static URL encodeFileObject(FileSystem fs, FileObject fo) {
        String fsName = FileURL.encodeFileSystemName(fs.getSystemName());
        String fileName = fo.getPath();
        String name = fsName + '/' + fileName;
        boolean needOfSlash = fo.isFolder() && fileName.length() != 0 && fileName.charAt(fileName.length() - 1) != '/';
        needOfSlash = needOfSlash;
        final String url = needOfSlash ? name + "/" : name;
        try {
            return (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new URL(FileURL.PROTOCOL, "", -1, url, HANDLER);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            IllegalStateException ise = new IllegalStateException(pae.toString());
            ExternalUtil.annotate((Throwable)ise, pae);
            throw ise;
        }
    }

    public static FileObject decodeURL(URL u) {
        int first;
        if (!u.getProtocol().equals(PROTOCOL)) {
            return null;
        }
        String resourceName = u.getFile();
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        if ((first = resourceName.indexOf(47)) == -1) {
            return null;
        }
        String fileSystemName = FileURL.decodeFileSystemName(resourceName.substring(0, first));
        resourceName = resourceName.substring(first);
        FileSystem fsys = ExternalUtil.getRepository().findFileSystem(fileSystemName);
        return fsys == null ? null : fsys.findResource(resourceName);
    }

    public void connect() throws IOException {
        if (this.fo != null) {
            return;
        }
        this.fo = FileURL.decodeURL(this.url);
        if (this.fo == null) {
            throw new FileNotFoundException("Cannot find: " + this.url);
        }
    }

    public InputStream getInputStream() throws IOException, UnknownServiceException {
        this.connect();
        try {
            if (this.fo.isFolder()) {
                return new FIS(this.fo);
            }
            return this.fo.getInputStream();
        }
        catch (FileNotFoundException e) {
            ExternalUtil.exception(e);
            throw e;
        }
    }

    public OutputStream getOutputStream() throws IOException, UnknownServiceException {
        this.connect();
        if (this.fo.isFolder()) {
            throw new UnknownServiceException();
        }
        FileLock flock = this.fo.lock();
        return new LockOS(this.fo.getOutputStream(flock), flock);
    }

    public int getContentLength() {
        try {
            this.connect();
            return (int)this.fo.getSize();
        }
        catch (IOException ex) {
            return 0;
        }
    }

    public String getHeaderField(String name) {
        if (name.equalsIgnoreCase("content-type")) {
            try {
                this.connect();
                if (this.fo.isFolder()) {
                    return "text/html";
                }
                return this.fo.getMIMEType();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getHeaderField(name);
    }

    public Permission getPermission() throws IOException {
        if (this.fo != null) {
            File f = FileUtil.toFile(this.fo);
            if (f != null) {
                return new FilePermission(f.getAbsolutePath(), "read");
            }
            try {
                FileSystem fs = this.fo.getFileSystem();
                if (fs instanceof JarFileSystem) {
                    return new FilePermission(((JarFileSystem)fs).getJarFile().getAbsolutePath(), "read");
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return new FilePermission("<<ALL FILES>>", "read");
    }

    static String encodeFileSystemName(String fs) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < fs.length()) {
            switch (fs.charAt(i)) {
                case 'Q': {
                    sb.append("QQ");
                    break;
                }
                case '/': {
                    sb.append("QB");
                    break;
                }
                case ':': {
                    sb.append("QC");
                    break;
                }
                case '\\': {
                    sb.append("QD");
                    break;
                }
                case '#': {
                    sb.append("QE");
                    break;
                }
                default: {
                    sb.append(fs.charAt(i));
                }
            }
            ++i;
        }
        return sb.toString();
    }

    static String decodeFileSystemName(String name) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int len = name.length();
        while (i < len) {
            char ch;
            if ((ch = name.charAt(i++)) == 'Q' && i < len) {
                switch (name.charAt(i++)) {
                    case 'B': {
                        sb.append('/');
                        break;
                    }
                    case 'C': {
                        sb.append(':');
                        break;
                    }
                    case 'D': {
                        sb.append('\\');
                        break;
                    }
                    case 'E': {
                        sb.append('#');
                        break;
                    }
                    default: {
                        sb.append('Q');
                        break;
                    }
                }
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static final class FIS
    extends InputStream {
        private StringReader reader;

        public FIS(FileObject folder) throws IOException {
            this.reader = new StringReader(this.createDocument(folder));
        }

        private String createDocument(FileObject folder) throws IOException {
            StringBuffer buff = new StringBuffer(150);
            StringBuffer lit = new StringBuffer(15);
            FileObject[] fobia = folder.getChildren();
            buff.append("<HTML>\n");
            buff.append("<BODY>\n");
            FileObject parent = folder.getParent();
            if (parent != null) {
                buff.append("<P>");
                buff.append("<A HREF=").append("..").append(">").append("..").append("</A>").append("\n");
                buff.append("</P>");
            }
            int i = 0;
            while (i < fobia.length) {
                lit.setLength(0);
                lit.append(fobia[i].getNameExt());
                String name = lit.toString();
                if (fobia[i].isFolder()) {
                    lit.append('/');
                }
                buff.append("<P>");
                buff.append("<A HREF=").append((Object)lit).append(">").append(name).append("</A>").append("\n");
                buff.append("</P>");
                ++i;
            }
            buff.append("</BODY>\n");
            buff.append("</HTML>\n");
            return buff.toString();
        }

        public int read() throws IOException {
            return this.reader.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            char[] ch = new char[len];
            int r = this.reader.read(ch, 0, len);
            int i = 0;
            while (i < r) {
                b[off + i] = (byte)ch[i];
                ++i;
            }
            return r;
        }

        public long skip(long skip) throws IOException {
            return this.reader.skip(skip);
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public void reset() throws IOException {
            this.reader.reset();
        }

        public boolean markSupported() {
            return false;
        }
    }

    private static class LockOS
    extends BufferedOutputStream {
        private FileLock flock;

        public LockOS(OutputStream os, FileLock lock) throws IOException {
            super(os);
            this.flock = lock;
        }

        public void close() throws IOException {
            this.flock.releaseLock();
            super.close();
        }
    }
}

