/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.LoaderTransfer;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeListener;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.ExTransferable;

public class DataShadow
extends MultiDataObject
implements DataObject.Container {
    static final long serialVersionUID = 6305590675982925167L;
    private DataObject original;
    private OrigL origL = null;
    private LinkedList nodes = new LinkedList();
    static final String SHADOW_EXTENSION = "shadow";
    private static Set allDataShadows;
    private static ReferenceQueue rqueue;
    private static Mutex MUTEX;
    private static final int IDX_FS = 0;
    private static final int IDX_PATH = 1;
    static /* synthetic */ Class class$org$openide$loaders$DataShadow;

    private static Set getDataShadowsSet() {
        if (allDataShadows == null) {
            Class clazz = class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = DataShadow.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow;
            synchronized (clazz) {
                if (allDataShadows == null) {
                    allDataShadows = new HashSet();
                }
            }
        }
        return allDataShadows;
    }

    private static ReferenceQueue getRqueue() {
        if (rqueue == null) {
            Class clazz = class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = DataShadow.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow;
            synchronized (clazz) {
                if (rqueue == null) {
                    rqueue = new ReferenceQueue();
                }
            }
        }
        return rqueue;
    }

    private static void checkQueue() {
        if (rqueue == null) {
            return;
        }
        Reference ref = rqueue.poll();
        while (ref != null) {
            DataShadow.getDataShadowsSet().remove(ref);
            ref = rqueue.poll();
        }
    }

    static Reference createReference(Object ds, ReferenceQueue q) {
        return new DSWeakReference(ds, q);
    }

    private static synchronized void enqueueDataShadow(DataShadow ds) {
        DataShadow.checkQueue();
        DataShadow.getDataShadowsSet().add(DataShadow.createReference(ds, DataShadow.getRqueue()));
    }

    private static synchronized List getAllDataShadows() {
        Set allShadows = allDataShadows;
        if (allShadows == null || allShadows.isEmpty()) {
            return null;
        }
        ArrayList ret = new ArrayList(allShadows.size());
        Iterator it = allShadows.iterator();
        while (it.hasNext()) {
            Reference ref = (Reference)it.next();
            Object shadow = ref.get();
            if (shadow == null) continue;
            ret.add(shadow);
        }
        return ret;
    }

    static void checkValidity(EventObject ev) {
        List all = DataShadow.getAllDataShadows();
        if (all == null) {
            return;
        }
        boolean moved = false;
        if (ev instanceof OperationEvent.Rename || ev instanceof OperationEvent.Move) {
            moved = true;
        }
        int size = all.size();
        int i = 0;
        while (i < size) {
            Object obj = all.get(i);
            ((DataShadow)obj).refresh(moved);
            ++i;
        }
    }

    protected DataShadow(FileObject fo, DataObject original, MultiFileLoader loader) throws DataObjectExistsException {
        super(fo, loader);
        this.init(original);
    }

    protected DataShadow(FileObject fo, DataObject original, DataLoader loader) throws DataObjectExistsException {
        super(fo, loader);
        this.init(original);
    }

    private void init(DataObject original) {
        if (original == null) {
            throw new IllegalArgumentException();
        }
        this.setOriginal(original);
        DataShadow.enqueueDataShadow(this);
    }

    private DataShadow(FileObject fo, DataObject original) throws DataObjectExistsException {
        this(fo, original, DataLoaderPool.getShadowLoader());
    }

    public static DataShadow create(DataFolder folder, DataObject original) throws IOException {
        return DataShadow.create(folder, null, original, SHADOW_EXTENSION);
    }

    public static DataShadow create(DataFolder folder, String name, DataObject original) throws IOException {
        return DataShadow.create(folder, name, original, SHADOW_EXTENSION);
    }

    public static DataShadow create(DataFolder folder, final String name, final DataObject original, final String ext) throws IOException {
        final FileObject fo = folder.getPrimaryFile();
        final DataShadow[] arr = new DataShadow[1];
        fo.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject file = DataShadow.writeOriginal(name, ext, fo, original);
                DataObject obj = DataObject.find(file);
                if (!(obj instanceof DataShadow)) {
                    DataObjectNotFoundException dnfe = new DataObjectNotFoundException(obj.getPrimaryFile());
                    ErrorManager errMan = ErrorManager.getDefault();
                    errMan.annotate((Throwable)dnfe, obj == null ? null : obj.getClass().toString());
                    errMan.annotate((Throwable)dnfe, file == null ? null : file.getPath());
                    throw dnfe;
                }
                arr[0] = (DataShadow)obj;
            }
        });
        return arr[0];
    }

    private static FileObject writeOriginal(final String name, final String ext, final FileObject trg, final DataObject obj) throws IOException {
        try {
            return (FileObject)MUTEX.writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    FileObject fo;
                    if (trg.isData()) {
                        fo = trg;
                    } else {
                        String n = name == null ? FileUtil.findFreeFileName(trg, obj.getName(), ext) : name;
                        fo = trg.createData(n, ext);
                    }
                    FileLock lock = fo.lock();
                    OutputStreamWriter os = new OutputStreamWriter(fo.getOutputStream(lock), "UTF-8");
                    try {
                        FileObject pf = obj.getPrimaryFile();
                        os.write(pf.getPath());
                        ((Writer)os).write(10);
                        os.write(pf.getFileSystem().getSystemName());
                        ((Writer)os).write(10);
                        Object var6_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        ((Writer)os).close();
                        lock.releaseLock();
                        throw throwable;
                    }
                    ((Writer)os).close();
                    lock.releaseLock();
                    return fo;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    protected static DataObject deserialize(FileObject fileObject) throws IOException {
        String[] result = DataShadow.read(fileObject);
        FileObject fo = DataShadow.checkOriginal(result[1], result[0], fileObject.getFileSystem());
        return DataObject.find(fo);
    }

    private static String[] read(final FileObject f) throws IOException {
        if (f.getSize() == 0L) {
            Object fileName = f.getAttribute("originalFile");
            if (fileName instanceof String) {
                Object fileSystemName = f.getAttribute("originalFileSystem");
                if (!(fileSystemName instanceof String)) {
                    fileSystemName = null;
                }
                return new String[]{(String)fileSystemName, (String)fileName};
            }
            throw new FileNotFoundException(f.getPath());
        }
        try {
            return (String[])MUTEX.readAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    String[] stringArray;
                    BufferedReader ois = new BufferedReader(new InputStreamReader(f.getInputStream(), "UTF-8"));
                    try {
                        String s = ois.readLine();
                        String fs = ois.readLine();
                        if (s == null) {
                            throw new FileNotFoundException(f.getPath());
                        }
                        stringArray = new String[]{fs, s};
                        Object var6_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        ois.close();
                        throw throwable;
                    }
                    ois.close();
                    return stringArray;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private FileObject checkOriginal(DataObject orig) throws IOException {
        if (orig == null) {
            return null;
        }
        return DataShadow.deserialize(this.getPrimaryFile()).getPrimaryFile();
    }

    static FileObject checkOriginal(String strFile, String strFS, FileSystem origSystem) throws IOException {
        Repository rep = Repository.getDefault();
        FileSystem fileSystem = strFS != null ? rep.findFileSystem(strFS) : origSystem;
        FileObject fo = fileSystem != null ? fileSystem.findResource(strFile) : null;
        if (fo == null) {
            throw new FileNotFoundException(strFile);
        }
        return fo;
    }

    public DataObject getOriginal() {
        return this.original;
    }

    public DataObject[] getChildren() {
        return new DataObject[]{this.getOriginal()};
    }

    protected Node createNodeDelegate() {
        return new ShadowNode(this);
    }

    public boolean isDeleteAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public boolean isRenameAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public HelpCtx getHelpCtx() {
        return this.getOriginal().getHelpCtx();
    }

    protected DataShadow handleCreateShadow(DataFolder f) throws IOException {
        return this.original.handleCreateShadow(f);
    }

    public Node.Cookie getCookie(Class c) {
        if (c.isInstance(this)) {
            return this;
        }
        return this.original.getCookie(this, c);
    }

    public void refresh() {
        this.refresh(false);
    }

    private void refresh(boolean moved) {
        try {
            if (moved) {
                this.tryUpdate();
            }
            if (this.checkOriginal(this.original) != null) {
                return;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void tryUpdate() throws IOException {
        FileObject pf;
        String[] result = DataShadow.read(this.getPrimaryFile());
        if (result[1].equals((pf = this.original.getPrimaryFile()).getPath()) && (result[0] == null ? this.getPrimaryFile().getFileSystem() == pf.getFileSystem() : result[0].equals(pf.getFileSystem().getSystemName()))) {
            return;
        }
        DataShadow.writeOriginal(null, null, this.getPrimaryFile(), this.original);
    }

    private void setOriginal(DataObject o) {
        if (this.origL == null) {
            this.origL = new OrigL(this);
        }
        if (this.original != null) {
            this.original.removePropertyChangeListener(this.origL);
        }
        DataObject oldOriginal = this.original;
        o.addPropertyChangeListener(this.origL);
        this.original = o;
        ShadowNode[] n = null;
        LinkedList linkedList = this.nodes;
        synchronized (linkedList) {
            n = this.nodes.toArray(new ShadowNode[this.nodes.size()]);
        }
        try {
            int i = 0;
            while (i < n.length) {
                n[i].originalChanged();
                ++i;
            }
        }
        catch (IllegalStateException e) {
            System.out.println("Please reopen the bug #18998 if you see this message.");
            System.out.println("Old:" + oldOriginal + (oldOriginal == null ? "" : " / " + oldOriginal.isValid() + " / " + System.identityHashCode(oldOriginal)));
            System.out.println("New:" + this.original + (this.original == null ? "" : " / " + this.original.isValid() + " / " + System.identityHashCode(this.original)));
            throw e;
        }
    }

    private static void updateShadowOriginal(final DataShadow shadow) {
        final FileObject primary = shadow.original.getPrimaryFile();
        RequestProcessor.postRequest(new Runnable(){

            public void run() {
                DataObject newOrig;
                try {
                    newOrig = DataObject.find(primary);
                }
                catch (DataObjectNotFoundException e) {
                    newOrig = null;
                }
                if (newOrig != null) {
                    shadow.setOriginal(newOrig);
                }
            }
        }, 100);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MUTEX = new Mutex();
    }

    static final class DSWeakReference
    extends WeakReference {
        private int hash;

        DSWeakReference(Object o, ReferenceQueue rqueue) {
            super(o, rqueue);
            this.hash = o.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            Object mine = this.get();
            if (mine == null) {
                return false;
            }
            if (o instanceof DSWeakReference) {
                DSWeakReference him = (DSWeakReference)o;
                return mine.equals(him.get());
            }
            return false;
        }
    }

    protected static class ShadowNode
    extends FilterNode {
        private static MessageFormat format;
        private static MessageFormat descriptionFormat;
        private static final String ATTR_USEOWNNAME = "UseOwnName";
        private DataShadow obj;
        private Sheet sheet;
        private String originalFS;
        static /* synthetic */ Class class$org$openide$loaders$DataShadow;

        public ShadowNode(DataShadow shadow) {
            this(shadow, shadow.getOriginal().getNodeDelegate());
        }

        private ShadowNode(DataShadow shadow, Node node) {
            super(node);
            this.obj = shadow;
            LinkedList linkedList = this.obj.nodes;
            synchronized (linkedList) {
                this.obj.nodes.add(this);
            }
        }

        public Node cloneNode() {
            ShadowNode sn = new ShadowNode(this.obj);
            return sn;
        }

        public void setName(String name) {
            try {
                if (!name.equals(this.obj.getName())) {
                    this.obj.rename(name);
                    if (this.obj.original.getPrimaryFile().isRoot()) {
                        this.obj.getPrimaryFile().setAttribute(ATTR_USEOWNNAME, Boolean.TRUE);
                    }
                    this.fireDisplayNameChange(null, null);
                    this.fireNameChange(null, null);
                }
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }

        public String getName() {
            return this.obj.getName();
        }

        private String getOriginalFileSystemName() {
            if (this.originalFS != null) {
                return this.originalFS;
            }
            try {
                this.originalFS = this.obj.getOriginal().getPrimaryFile().getFileSystem().getDisplayName();
            }
            catch (FileStateInvalidException ex) {
                this.originalFS = "";
            }
            return this.originalFS;
        }

        public String getDisplayName() {
            if (format == null) {
                format = new MessageFormat(NbBundle.getBundle(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = ShadowNode.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow).getString("FMT_shadowName"));
            }
            String n = format.format(this.createArguments());
            try {
                this.obj.getPrimaryFile().getFileSystem().getStatus().annotateName(n, this.obj.files());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return n;
        }

        private Object[] createArguments() {
            String shadowName = this.obj.getName();
            String origDisp = this.obj.original.isValid() ? this.obj.original.getNodeDelegate().getDisplayName() : "";
            Boolean useOwnName = (Boolean)this.obj.getPrimaryFile().getAttribute(ATTR_USEOWNNAME);
            if (this.obj.original.getPrimaryFile().isRoot() && (useOwnName == null || !useOwnName.booleanValue())) {
                try {
                    shadowName = this.obj.original.getPrimaryFile().getFileSystem().getDisplayName();
                }
                catch (FileStateInvalidException e) {
                    // empty catch block
                }
            }
            return new Object[]{shadowName, super.getDisplayName(), ShadowNode.systemNameOrFileName(this.obj.getPrimaryFile()), ShadowNode.systemNameOrFileName(this.obj.getOriginal().getPrimaryFile()), origDisp};
        }

        private static String systemNameOrFileName(FileObject fo) {
            if (fo.isRoot()) {
                try {
                    return fo.getFileSystem().getDisplayName();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            return fo.getPath();
        }

        public String getShortDescription() {
            if (descriptionFormat == null) {
                descriptionFormat = new MessageFormat(NbBundle.getBundle(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = ShadowNode.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow).getString("FMT_shadowHint"));
            }
            return descriptionFormat.format(this.createArguments());
        }

        public Image getIcon(int type) {
            Image i = this.rootIcon(type);
            if (i != null) {
                return i;
            }
            return super.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            Image i = this.rootIcon(type);
            if (i != null) {
                return i;
            }
            return super.getOpenedIcon(type);
        }

        private Image rootIcon(int type) {
            FileObject orig = this.obj.getOriginal().getPrimaryFile();
            if (orig.isRoot()) {
                try {
                    FileSystem fs = orig.getFileSystem();
                    try {
                        Image i = Introspector.getBeanInfo(fs.getClass()).getIcon(type);
                        return fs.getStatus().annotateIcon(i, type, this.obj.files());
                    }
                    catch (IntrospectionException ie) {
                        ErrorManager.getDefault().notify(1, ie);
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            return null;
        }

        public boolean canDestroy() {
            return this.obj.isDeleteAllowed();
        }

        public void destroy() throws IOException {
            LinkedList linkedList = this.obj.nodes;
            synchronized (linkedList) {
                this.obj.nodes.remove(this);
            }
            this.obj.delete();
        }

        public final boolean canRename() {
            return this.obj.isRenameAllowed();
        }

        public final boolean canCopy() {
            return this.obj.isCopyAllowed();
        }

        public final boolean canCut() {
            return this.obj.isMoveAllowed();
        }

        public Node.Cookie getCookie(Class cl) {
            Node.Cookie c = this.obj.getCookie(cl);
            if (c != null) {
                return c;
            }
            return super.getCookie(cl);
        }

        public Node.PropertySet[] getPropertySets() {
            Sheet s = this.sheet;
            if (s == null) {
                s = this.sheet = this.cloneSheet();
            }
            return s.toArray();
        }

        public Transferable clipboardCopy() throws IOException {
            ExTransferable t = ExTransferable.create(super.clipboardCopy());
            t.put(LoaderTransfer.transferable(this.obj, 1));
            return t;
        }

        public Transferable clipboardCut() throws IOException {
            ExTransferable t = ExTransferable.create(super.clipboardCut());
            t.put(LoaderTransfer.transferable(this.obj, 4));
            return t;
        }

        public Transferable drag() throws IOException {
            return this.clipboardCopy();
        }

        protected NodeListener createNodeListener() {
            return new PropL(this);
        }

        public boolean equals(Object o) {
            if (o instanceof ShadowNode) {
                ShadowNode sn = (ShadowNode)o;
                return sn.obj == this.obj;
            }
            return false;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        private Sheet cloneSheet() {
            Node.PropertySet[] sets = this.getOriginal().getPropertySets();
            Sheet s = new Sheet();
            int i = 0;
            while (i < sets.length) {
                Sheet.Set ss = new Sheet.Set();
                ss.put(sets[i].getProperties());
                ss.setName(sets[i].getName());
                ss.setDisplayName(sets[i].getDisplayName());
                ss.setShortDescription(sets[i].getShortDescription());
                this.modifySheetSet(ss);
                s.put(ss);
                ++i;
            }
            return s;
        }

        private void modifySheetSet(Sheet.Set ss) {
            Node.Property p = ss.remove("name");
            if (p != null) {
                p = new PropertySupport.Name(this);
                ss.put(p);
                p = new Name();
                ss.put(p);
                p = new FileSystemProperty();
                ss.put(p);
            }
        }

        private void originalChanged() {
            DataObject ori = this.obj.getOriginal();
            if (ori.isValid()) {
                this.changeOriginal(ori.getNodeDelegate(), true);
            } else {
                DataShadow.updateShadowOriginal(this.obj);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private static class PropL
        extends FilterNode.NodeAdapter {
            public PropL(ShadowNode sn) {
                super(sn);
            }

            protected void propertyChange(FilterNode fn, PropertyChangeEvent ev) {
                if ("propertySets".equals(ev.getPropertyName())) {
                    ShadowNode sn = (ShadowNode)fn;
                    sn.sheet = null;
                }
                super.propertyChange(fn, ev);
            }
        }

        private final class FileSystemProperty
        extends PropertySupport.ReadOnly {
            static /* synthetic */ Class class$java$lang$String;

            public FileSystemProperty() {
                super("OriginalFileSystem", class$java$lang$String == null ? (class$java$lang$String = FileSystemProperty.class$("java.lang.String")) : class$java$lang$String, DataObject.getString("PROP_ShadowOriginalFileSystem"), DataObject.getString("HINT_ShadowOriginalFileSystem"));
            }

            public Object getValue() {
                return ShadowNode.this.getOriginalFileSystemName();
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private final class Name
        extends PropertySupport.ReadWrite {
            static /* synthetic */ Class class$java$lang$String;

            public Name() {
                super("OriginalName", class$java$lang$String == null ? (class$java$lang$String = Name.class$("java.lang.String")) : class$java$lang$String, DataObject.getString("PROP_ShadowOriginalName"), DataObject.getString("HINT_ShadowOriginalName"));
            }

            public Object getValue() {
                return ShadowNode.this.obj.getOriginal().getName();
            }

            public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                if (!(val instanceof String)) {
                    throw new IllegalArgumentException();
                }
                try {
                    DataObject orig = ShadowNode.this.obj.getOriginal();
                    orig.rename((String)val);
                    DataShadow.writeOriginal(null, null, ShadowNode.this.obj.getPrimaryFile(), orig);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean canWrite() {
                return ShadowNode.this.obj.getOriginal().isRenameAllowed();
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }
    }

    private static class OrigL
    implements PropertyChangeListener {
        WeakReference shadow = null;

        public OrigL(DataShadow shadow) {
            this.shadow = new WeakReference<DataShadow>(shadow);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            DataShadow shadow = (DataShadow)this.shadow.get();
            if (shadow != null && "valid".equals(evt.getPropertyName())) {
                DataShadow.updateShadowOriginal(shadow);
            }
        }
    }
}

