/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FileEntry;
import org.openide.loaders.FilesSet;
import org.openide.loaders.FolderList;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.UserCancelException;

public class MultiDataObject
extends DataObject {
    static final long serialVersionUID = -7750146802134210308L;
    private static final Object cookieSetLock = new Object();
    private static final Object secondaryCreationLock = new Object();
    private static final RequestProcessor firingProcessor = new RequestProcessor("MDO PropertyChange processor");
    private static final RequestProcessor delayProcessor = new RequestProcessor("MDO Firing delayer");
    private RequestProcessor.Task delayedPropFilesTask;
    private static final Object delayedPropFilesLock = new Object();
    private Entry primary = this.createPrimaryEntry(this, this.getPrimaryFile());
    private HashMap secondary;
    private CookieSet cookieSet;
    boolean checked = false;
    private ChangeListener chLis;
    private static EmptyRecognizer RECOGNIZER = new EmptyRecognizer();

    public MultiDataObject(FileObject fo, MultiFileLoader loader) throws DataObjectExistsException {
        super(fo, loader);
    }

    MultiDataObject(FileObject fo, DataLoader loader) throws DataObjectExistsException {
        super(fo, loader);
    }

    public final MultiFileLoader getMultiFileLoader() {
        DataLoader loader = this.getLoader();
        if (!(loader instanceof MultiFileLoader)) {
            return null;
        }
        return (MultiFileLoader)loader;
    }

    public Set files() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            this.removeAllInvalid();
            FilesSet filesSet = new FilesSet(this.getPrimaryFile(), this.getSecondary());
            return filesSet;
        }
    }

    public boolean isDeleteAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    private boolean existReadOnlySecondary() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            Iterator it = this.getSecondary().keySet().iterator();
            while (it.hasNext()) {
                if (!((FileObject)it.next()).isReadOnly()) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private HashMap checkSecondary() {
        if (!this.checked) {
            this.checkFiles(this);
            this.checked = true;
        }
        return this.getSecondary();
    }

    private HashMap getSecondary() {
        Object object = secondaryCreationLock;
        synchronized (object) {
            if (this.secondary == null) {
                this.secondary = new HashMap(11);
            }
            HashMap hashMap = this.secondary;
            return hashMap;
        }
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    public boolean isRenameAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    Object synchObjectSecondary() {
        HashMap lock = this.checkSecondary();
        if (lock == null) {
            throw new IllegalStateException("checkSecondary was null from " + this);
        }
        return this.checkSecondary();
    }

    protected Node createNodeDelegate() {
        DataNode dataNode = (DataNode)super.createNodeDelegate();
        return dataNode;
    }

    protected final void addSecondaryEntry(Entry fe) {
        HashMap hashMap = this.getSecondary();
        synchronized (hashMap) {
            this.getSecondary().put(fe.getFile(), fe);
        }
        FolderList l = this.getFolderList();
        if (l == null) {
            this.firePropertyChangeLater("files", null, null);
        } else if (l.isCreated()) {
            this.firePropertyChangeLater("files", null, null);
        } else {
            this.firePropFilesAfterFinishing();
        }
    }

    private FolderList getFolderList() {
        FileObject parent = this.primary.file.getParent();
        if (parent != null) {
            return FolderList.find(parent, false);
        }
        return null;
    }

    protected final void removeSecondaryEntry(Entry fe) {
        HashMap hashMap = this.getSecondary();
        synchronized (hashMap) {
            this.getSecondary().remove(fe.getFile());
        }
        this.firePropertyChangeLater("files", null, null);
        if (fe.isImportant()) {
            this.checkConsistency(this);
        }
    }

    final void markSecondaryEntriesRecognized(DataLoader.RecognizedFiles recognized) {
        HashMap hashMap = this.getSecondary();
        synchronized (hashMap) {
            Iterator it = this.getSecondary().keySet().iterator();
            while (it.hasNext()) {
                FileObject fo = (FileObject)it.next();
                recognized.markRecognized(fo);
            }
        }
    }

    protected final Entry registerEntry(FileObject fo) {
        HashMap hashMap = this.getSecondary();
        synchronized (hashMap) {
            if (fo == null) {
                Entry entry = this.primary;
                return entry;
            }
            if (fo.equals(this.getPrimaryFile())) {
                Entry entry = this.primary;
                return entry;
            }
            Entry e = (Entry)this.getSecondary().get(fo);
            if (e != null) {
                Entry entry = e;
                return entry;
            }
            e = this.createSecondaryEntry(this, fo);
            this.addSecondaryEntry(e);
            Entry entry = e;
            return entry;
        }
    }

    final void removeFile(FileObject fo) {
        HashMap hashMap = this.getSecondary();
        synchronized (hashMap) {
            Entry e = (Entry)this.getSecondary().get(fo);
            if (e != null) {
                this.removeSecondaryEntry(e);
            }
        }
    }

    public final Entry getPrimaryEntry() {
        return this.primary;
    }

    public final Set secondaryEntries() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            this.removeAllInvalid();
            HashSet hashSet = new HashSet(this.getSecondary().values());
            return hashSet;
        }
    }

    public final Entry findSecondaryEntry(FileObject fo) {
        Entry e;
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            e = (Entry)this.getSecondary().get(fo);
        }
        return e;
    }

    private void removeAllInvalid() {
        Iterator it = this.checkSecondary().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            FileObject fo = (FileObject)e.getKey();
            if (fo.isValid()) continue;
            it.remove();
            this.firePropertyChangeLater("files", null, null);
        }
    }

    protected FileLock takePrimaryFileLock() throws IOException {
        return this.getPrimaryEntry().takeLock();
    }

    private String existInFolder(FileObject fo, FileObject folder) {
        if (fo.isFolder() && this.isMergingFolders()) {
            return "";
        }
        String orig = fo.getName();
        String name = FileUtil.findFreeFileName(folder, orig, fo.getExt());
        if (name.length() <= orig.length()) {
            return "";
        }
        return name.substring(orig.length());
    }

    boolean isMergingFolders() {
        return false;
    }

    protected DataObject handleCopy(DataFolder df) throws IOException {
        String suffix = this.existInFolder(this.getPrimaryEntry().getFile(), df.getPrimaryFile());
        if (suffix == null) {
            throw new UserCancelException();
        }
        FileObject fo = this.getPrimaryEntry().copy(df.getPrimaryFile(), suffix);
        Iterator it = this.secondaryEntries().iterator();
        while (it.hasNext()) {
            ((Entry)it.next()).copy(df.getPrimaryFile(), suffix);
        }
        try {
            return this.createMultiObject(fo);
        }
        catch (DataObjectExistsException ex) {
            return ex.getDataObject();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleDelete() throws IOException {
        Iterator it;
        ArrayList toRemove = new ArrayList();
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            it = ((AbstractList)new ArrayList(this.getSecondary().entrySet())).iterator();
        }
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            ((Entry)e.getValue()).delete();
            toRemove.add(e.getKey());
        }
        Object object2 = this.synchObjectSecondary();
        synchronized (object2) {
            Object[] objects = toRemove.toArray();
            int i = 0;
            while (i < objects.length) {
                this.getSecondary().remove(objects[i]);
                ++i;
            }
        }
        this.getPrimaryEntry().delete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected FileObject handleRename(String name) throws IOException {
        Iterator it;
        this.getPrimaryEntry().changeFile(this.getPrimaryEntry().rename(name));
        HashMap<FileObject, Entry> add = null;
        ArrayList toRemove = new ArrayList();
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            it = ((AbstractList)new ArrayList(this.getSecondary().entrySet())).iterator();
        }
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            FileObject fo = ((Entry)e.getValue()).rename(name);
            if (fo == null) {
                toRemove.add(e.getKey());
                continue;
            }
            if (fo.equals(e.getKey())) continue;
            if (add == null) {
                add = new HashMap<FileObject, Entry>();
            }
            Entry entry = (Entry)e.getValue();
            entry.changeFile(fo);
            add.put(entry.getFile(), entry);
            toRemove.add(e.getKey());
        }
        if (add != null || !toRemove.isEmpty()) {
            Object object2 = this.synchObjectSecondary();
            synchronized (object2) {
                if (!toRemove.isEmpty()) {
                    Object[] objects = toRemove.toArray();
                    int i = 0;
                    while (i < objects.length) {
                        this.getSecondary().remove(objects[i]);
                        ++i;
                    }
                }
                if (add != null) {
                    this.getSecondary().putAll(add);
                }
            }
            this.firePropertyChangeLater("files", null, null);
        }
        return this.getPrimaryEntry().getFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected FileObject handleMove(DataFolder df) throws IOException {
        String suffix = this.existInFolder(this.getPrimaryEntry().getFile(), df.getPrimaryFile());
        if (suffix == null) {
            throw new UserCancelException();
        }
        List backup = this.saveEntries();
        try {
            Iterator it;
            this.getPrimaryEntry().changeFile(this.getPrimaryEntry().move(df.getPrimaryFile(), suffix));
            HashMap<FileObject, Entry> add = null;
            ArrayList toRemove = new ArrayList();
            Object object = this.synchObjectSecondary();
            synchronized (object) {
                it = ((AbstractList)new ArrayList(this.getSecondary().entrySet())).iterator();
            }
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                FileObject fo = ((Entry)e.getValue()).move(df.getPrimaryFile(), suffix);
                if (fo == null) {
                    toRemove.add(e.getKey());
                    continue;
                }
                if (fo.equals(e.getKey())) continue;
                if (add == null) {
                    add = new HashMap<FileObject, Entry>();
                }
                Entry entry = (Entry)e.getValue();
                entry.changeFile(fo);
                add.put(entry.getFile(), entry);
                toRemove.add(e.getKey());
            }
            if (add != null || !toRemove.isEmpty()) {
                Object object2 = this.synchObjectSecondary();
                synchronized (object2) {
                    if (!toRemove.isEmpty()) {
                        Object[] objects = toRemove.toArray();
                        int i = 0;
                        while (i < objects.length) {
                            this.getSecondary().remove(objects[i]);
                            ++i;
                        }
                    }
                    if (add != null) {
                        this.getSecondary().putAll(add);
                    }
                }
                this.firePropertyChangeLater("files", null, null);
            }
            return this.getPrimaryEntry().getFile();
        }
        catch (IOException e) {
            this.restoreEntries(backup);
            throw e;
        }
    }

    protected DataObject handleCreateFromTemplate(DataFolder df, String name) throws IOException {
        if (name == null) {
            name = FileUtil.findFreeFileName(df.getPrimaryFile(), this.getPrimaryFile().getName(), this.getPrimaryFile().getExt());
        }
        FileObject fo = this.getPrimaryEntry().createFromTemplate(df.getPrimaryFile(), name);
        Iterator it = this.secondaryEntries().iterator();
        while (it.hasNext()) {
            ((Entry)it.next()).createFromTemplate(df.getPrimaryFile(), name);
        }
        try {
            return this.createMultiObject(fo);
        }
        catch (DataObjectExistsException ex) {
            return ex.getDataObject();
        }
    }

    protected final void setCookieSet(CookieSet s) {
        this.setCookieSet(s, true);
    }

    private void setCookieSet(CookieSet s, boolean fireChange) {
        Object object = cookieSetLock;
        synchronized (object) {
            ChangeListener ch = this.getChangeListener();
            if (this.cookieSet != null) {
                this.cookieSet.removeChangeListener(ch);
            }
            s.addChangeListener(ch);
            this.cookieSet = s;
        }
        if (fireChange) {
            this.fireCookieChange();
        }
    }

    protected final CookieSet getCookieSet() {
        CookieSet s = this.cookieSet;
        if (s != null) {
            return s;
        }
        Object object = cookieSetLock;
        synchronized (object) {
            if (this.cookieSet != null) {
                CookieSet cookieSet = this.cookieSet;
                return cookieSet;
            }
            this.setCookieSet(new CookieSet(), false);
            CookieSet cookieSet = this.cookieSet;
            return cookieSet;
        }
    }

    public Node.Cookie getCookie(Class type) {
        Node.Cookie cookie;
        CookieSet c = this.cookieSet;
        if (c != null && (cookie = c.getCookie(type)) != null) {
            return cookie;
        }
        return super.getCookie(type);
    }

    final void fireCookieChange() {
        this.firePropertyChange("cookie", null, null);
    }

    private void firePropertyChangeLater(final String name, final Object oldV, final Object newV) {
        firingProcessor.post(new Runnable(){

            public void run() {
                MultiDataObject.this.firePropertyChange(name, oldV, newV);
            }
        });
    }

    private void firePropFilesAfterFinishing() {
        Object object = delayedPropFilesLock;
        synchronized (object) {
            if (this.delayedPropFilesTask == null) {
                this.delayedPropFilesTask = delayProcessor.post(new Runnable(){

                    public void run() {
                        FolderList l = MultiDataObject.this.getFolderList();
                        if (l != null) {
                            l.waitProcessingFinished();
                        }
                        MultiDataObject.this.firePropertyChangeLater("files", null, null);
                    }
                });
            } else {
                this.delayedPropFilesTask.schedule(0);
            }
        }
    }

    final void recognizedByFolder() {
        this.checked = true;
    }

    final ChangeListener getChangeListener() {
        if (this.chLis == null) {
            this.chLis = new ChangeListener(){

                public void stateChanged(ChangeEvent ev) {
                    MultiDataObject.this.fireCookieChange();
                }
            };
        }
        return this.chLis;
    }

    private final Entry createPrimaryEntry(MultiDataObject obj, FileObject fo) {
        MultiFileLoader loader = this.getMultiFileLoader();
        if (loader != null) {
            return loader.createPrimaryEntry(obj, fo);
        }
        Entry e = fo.isFolder() ? new FileEntry.Folder(obj, fo) : new FileEntry(obj, fo);
        return e;
    }

    private final Entry createSecondaryEntry(MultiDataObject obj, FileObject fo) {
        MultiFileLoader loader = this.getMultiFileLoader();
        if (loader != null) {
            return loader.createSecondaryEntryImpl(obj, fo);
        }
        Entry e = fo.isFolder() ? new FileEntry.Folder(obj, fo) : new FileEntry(obj, fo);
        return e;
    }

    private final MultiDataObject createMultiObject(FileObject fo) throws DataObjectExistsException, IOException {
        MultiFileLoader loader = this.getMultiFileLoader();
        MultiDataObject obj = loader != null ? loader.createMultiObject(fo) : (MultiDataObject)this.getLoader().findDataObject(fo, RECOGNIZER);
        DataObjectPool.getPOOL().notifyCreation(obj);
        return obj;
    }

    private final void checkConsistency(MultiDataObject obj) {
        MultiFileLoader loader = this.getMultiFileLoader();
        if (loader != null) {
            loader.checkConsistency(obj);
        }
    }

    private final void checkFiles(MultiDataObject obj) {
        MultiFileLoader loader = this.getMultiFileLoader();
        if (loader != null) {
            loader.checkFiles(obj);
        }
    }

    final List saveEntries() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            LinkedList<Pair> ll = new LinkedList<Pair>();
            Iterator it = this.secondaryEntries().iterator();
            ll.add(new Pair(this.getPrimaryEntry()));
            while (it.hasNext()) {
                Entry en = (Entry)it.next();
                ll.add(new Pair(en));
            }
            LinkedList<Pair> linkedList = ll;
            return linkedList;
        }
    }

    final void restoreEntries(List backup) {
        Iterator it = backup.iterator();
        while (it.hasNext()) {
            Pair p = (Pair)it.next();
            if (p.entry.getFile().equals(p.file)) continue;
            if (p.file.isValid()) {
                p.entry.changeFile(p.file);
                continue;
            }
            try {
                if (p.entry.getFile().isData()) {
                    p.entry.changeFile(p.entry.getFile().copy(p.file.getParent(), p.file.getName(), p.file.getExt()));
                    continue;
                }
                FileObject fo = p.file.getParent().createFolder(p.file.getName());
                FileUtil.copyAttributes(p.entry.getFile(), fo);
                p.entry.changeFile(fo);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    void notifyFileDeleted(FileEvent fe) {
        this.removeFile(fe.getFile());
        if (fe.getFile().equals(this.getPrimaryFile())) {
            try {
                this.setValid(false);
            }
            catch (PropertyVetoException ex) {
                ErrorManager.getDefault().notify(1, ex);
            }
        }
    }

    void notifyFileDataCreated(FileEvent fe) {
        this.checked = false;
    }

    private static final class EntryReplace
    implements Serializable {
        static final long serialVersionUID = -1498798537289529182L;
        private FileObject file;
        private transient Entry entry;

        public EntryReplace(FileObject fo) {
            this.file = fo;
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            try {
                DataObject obj = DataObject.find(this.file);
                if (obj instanceof MultiDataObject) {
                    MultiDataObject m = (MultiDataObject)obj;
                    if (this.file.equals(m.getPrimaryFile())) {
                        this.entry = m.getPrimaryEntry();
                    } else {
                        Entry e = m.findSecondaryEntry(this.file);
                        if (e == null) {
                            throw new InvalidObjectException(obj.toString());
                        }
                        this.entry = e;
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                throw new InvalidObjectException(ex.getMessage());
            }
        }

        public Object readResolve() {
            return this.entry;
        }
    }

    public abstract class Entry
    implements Serializable {
        static final long serialVersionUID = 6024795908818133571L;
        private FileObject file;
        private transient WeakReference lock;

        protected Entry(FileObject file) {
            this.file = file;
            file.setImportant(this.isImportant());
        }

        final void changeFile(FileObject newFile) {
            FileLock l;
            if (newFile.equals(this.file)) {
                return;
            }
            newFile.setImportant(this.isImportant());
            this.file = newFile;
            FileLock fileLock = l = this.lock == null ? null : (FileLock)this.lock.get();
            if (l != null && l.isValid()) {
                l.releaseLock();
            }
            this.lock = null;
        }

        public final FileObject getFile() {
            return this.file;
        }

        public final MultiDataObject getDataObject() {
            return MultiDataObject.this;
        }

        public boolean isImportant() {
            return true;
        }

        public abstract FileObject copy(FileObject var1, String var2) throws IOException;

        public abstract FileObject rename(String var1) throws IOException;

        public abstract FileObject move(FileObject var1, String var2) throws IOException;

        public abstract void delete() throws IOException;

        public abstract FileObject createFromTemplate(FileObject var1, String var2) throws IOException;

        public FileLock takeLock() throws IOException {
            FileLock l;
            FileLock fileLock = l = this.lock == null ? null : (FileLock)this.lock.get();
            if (l == null || !l.isValid()) {
                l = this.getFile().lock();
                this.lock = new WeakReference<FileLock>(l);
            }
            return l;
        }

        public boolean isLocked() {
            FileLock l = this.lock == null ? null : (FileLock)this.lock.get();
            return l != null && l.isValid();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            return this.getFile().equals(((Entry)o).getFile());
        }

        public int hashCode() {
            return this.getFile().hashCode();
        }

        protected Object writeReplace() {
            return new EntryReplace(this.getFile());
        }
    }

    private static final class Pair {
        Entry entry;
        FileObject file;

        Pair(Entry e) {
            this.entry = e;
            this.file = e.getFile();
        }
    }

    private static class EmptyRecognizer
    implements DataLoader.RecognizedFiles {
        EmptyRecognizer() {
        }

        public void markRecognized(FileObject fo) {
        }
    }
}

