/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.Collection;
import java.util.WeakHashMap;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;

final class ChildrenArray
extends NodeAdapter {
    public Children children;
    private Node[] nodes;
    private WeakHashMap map;

    public Children getChildren() {
        return this.children;
    }

    protected void finalize() {
        this.children.finalizedChildrenArray();
    }

    public Node[] nodes() {
        if (this.children == null) {
            return null;
        }
        if (this.nodes == null) {
            this.nodes = this.children.justComputeNodes();
            int i = 0;
            while (i < this.nodes.length) {
                this.nodes[i].reassignTo(this.children, this);
                ++i;
            }
            this.children.registerChildrenArray(this, this.nodes.length > 0);
        }
        return this.nodes;
    }

    public void clear() {
        if (this.nodes != null) {
            this.nodes = null;
            this.children.registerChildrenArray(this, false);
        }
    }

    public void finalizeNodes() {
        WeakHashMap m = this.map;
        if (m != null) {
            m.remove(null);
        }
    }

    public boolean isInitialized() {
        return this.nodes != null;
    }

    public Collection nodesFor(Children.Info info) {
        Collection nodes;
        if (this.map == null) {
            this.map = new WeakHashMap(7);
        }
        if ((nodes = (Collection)this.map.get(info)) == null) {
            nodes = info.entry.nodes();
            info.length = nodes.size();
            this.map.put(info, nodes);
        }
        return nodes;
    }

    public void useNodes(Children.Info info, Collection list) {
        if (this.map == null) {
            this.map = new WeakHashMap(7);
        }
        info.length = list.size();
        this.map.put(info, list);
    }

    public String toString() {
        return super.toString() + "  " + this.getChildren();
    }
}

