/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public final class RequestProcessor {
    private static RequestProcessor DEFAULT = new RequestProcessor();
    private static RequestProcessor UNLIMITED = new RequestProcessor("Default RequestProcessor", 50);
    private static Timer starterThread = new Timer(true);
    private static ErrorManager logger;
    String name;
    private static int counter;
    boolean stopped = false;
    private Object processorLock = new Object();
    private HashSet processors = new HashSet();
    private List queue = new LinkedList();
    private int running = 0;
    private int throughput;
    static final boolean SLOW;

    public RequestProcessor() {
        this(null, 1);
    }

    public RequestProcessor(String name) {
        this(name, 1);
    }

    public RequestProcessor(String name, int throughput) {
        this.throughput = throughput;
        this.name = name != null ? name : "OpenIDE-request-processor-" + counter++;
    }

    public static RequestProcessor getDefault() {
        return UNLIMITED;
    }

    public Task post(Runnable run) {
        return this.post(run, 0, 1);
    }

    public Task post(Runnable run, int timeToWait) {
        return this.post(run, timeToWait, 1);
    }

    public Task post(Runnable run, int timeToWait, int priority) {
        Task task = new Task(run, priority);
        task.schedule(timeToWait);
        return task;
    }

    public Task create(Runnable run) {
        return new Task(run);
    }

    public boolean isRequestProcessorThread() {
        Thread c = Thread.currentThread();
        Object object = this.processorLock;
        synchronized (object) {
            boolean bl = this.processors.contains(c);
            return bl;
        }
    }

    public void stop() {
        if (this == UNLIMITED || this == DEFAULT) {
            throw new IllegalArgumentException("Can't stop shared RP's");
        }
        Object object = this.processorLock;
        synchronized (object) {
            this.stopped = true;
            Iterator it = this.processors.iterator();
            while (it.hasNext()) {
                ((Processor)it.next()).interrupt();
            }
        }
    }

    public static Task postRequest(Runnable run) {
        return DEFAULT.post(run);
    }

    public static Task postRequest(Runnable run, int timeToWait) {
        return DEFAULT.post(run, timeToWait);
    }

    public static Task postRequest(Runnable run, int timeToWait, int priority) {
        return DEFAULT.post(run, timeToWait, priority);
    }

    public static Task createRequest(Runnable run) {
        return DEFAULT.create(run);
    }

    private static ErrorManager logger() {
        Timer timer = starterThread;
        synchronized (timer) {
            if (logger == null) {
                logger = ErrorManager.getDefault().getInstance("org.openide.util.RequestProcessor");
            }
            ErrorManager errorManager = logger;
            return errorManager;
        }
    }

    void enqueue(Item item) {
        Object object = this.processorLock;
        synchronized (object) {
            if (item.getTask() == null) {
                return;
            }
            this.prioritizedEnqueue(item);
            if (this.running < this.throughput) {
                ++this.running;
                Processor proc = Processor.get();
                this.processors.add(proc);
                proc.setName(this.name);
                proc.attachTo(this);
            }
        }
    }

    private void prioritizedEnqueue(Item item) {
        int iprio = item.getPriority();
        if (this.queue.isEmpty()) {
            this.queue.add(item);
            item.enqueued = true;
            return;
        }
        if (iprio > ((Item)this.queue.get(this.queue.size() - 1)).getPriority()) {
            ListIterator<Item> it = this.queue.listIterator();
            while (it.hasNext()) {
                Item next = (Item)it.next();
                if (iprio <= next.getPriority()) continue;
                it.set(item);
                it.add(next);
                item.enqueued = true;
                return;
            }
            throw new IllegalStateException("Prioritized enqueue failed!");
        }
        this.queue.add(item);
        item.enqueued = true;
    }

    Task askForWork(Processor worker) {
        Object object = this.processorLock;
        synchronized (object) {
            if (this.stopped || this.queue.isEmpty()) {
                this.processors.remove(worker);
                Processor.put(worker);
                --this.running;
                Task task = null;
                return task;
            }
            Task task = ((Item)this.queue.remove(0)).getTask();
            return task;
        }
    }

    static {
        counter = 0;
        SLOW = Boolean.getBoolean("org.openide.util.RequestProcessor.Item.SLOW");
    }

    private static class Processor
    extends Thread {
        private static Stack pool = new Stack();
        private RequestProcessor source;
        private static final int INACTIVE_TIMEOUT = 60000;
        private boolean idle = true;
        private Object lock = new Object();
        static /* synthetic */ Class class$org$openide$util$RequestProcessor;

        static Processor get() {
            Stack stack = pool;
            synchronized (stack) {
                if (pool.isEmpty()) {
                    Processor proc = new Processor();
                    proc.idle = false;
                    proc.start();
                    Processor processor = proc;
                    return processor;
                }
                Processor proc = (Processor)pool.pop();
                proc.idle = false;
                Processor processor = proc;
                return processor;
            }
        }

        static void put(Processor proc) {
            Stack stack = pool;
            synchronized (stack) {
                proc.setName("Inactive RequestProcessor thread");
                proc.idle = true;
                pool.push(proc);
            }
        }

        public Processor() {
            super(Processor.getTopLevelThreadGroup(), "Inactive RequestProcessor thread");
            this.setDaemon(true);
        }

        void setPrio(int priority) {
            if (priority != this.getPriority()) {
                this.setPriority(priority);
            }
        }

        public void attachTo(RequestProcessor src) {
            Object object = this.lock;
            synchronized (object) {
                this.source = src;
                this.lock.notify();
            }
        }

        public void run() {
            while (true) {
                Task todo;
                Stack e2;
                RequestProcessor current = null;
                Object object = this.lock;
                synchronized (object) {
                    try {
                        if (this.source == null) {
                            this.lock.wait(60000L);
                        }
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    current = this.source;
                    this.source = null;
                    if (current == null) {
                        e2 = pool;
                        synchronized (e2) {
                            if (this.idle) {
                                pool.remove(this);
                                break;
                            }
                            continue;
                        }
                    }
                }
                RequestProcessor.logger().log(1, "Begining work " + this.getName());
                while ((todo = current.askForWork(this)) != null) {
                    if (e2 == null) continue;
                    this.setPrio(((Task)((Object)e2)).getPriority());
                    try {
                        RequestProcessor.logger().log("  Executing " + e2);
                        ((Task)((Object)e2)).run();
                        RequestProcessor.logger().log("  Execution finished in" + this.getName());
                    }
                    catch (RuntimeException e3) {
                        Processor.doNotify((Task)((Object)e2), e3);
                    }
                    catch (LinkageError e4) {
                        Processor.doNotify((Task)((Object)e2), e4);
                    }
                    catch (StackOverflowError e5) {
                        Processor.doNotify((Task)((Object)e2), e5);
                    }
                }
                RequestProcessor.logger().log(1, "Work finished " + this.getName());
            }
        }

        private static void doNotify(Task todo, Throwable ex) {
            ErrorManager err = ErrorManager.getDefault();
            err.annotate(ex, 4096, null, NbBundle.getMessage(class$org$openide$util$RequestProcessor == null ? (class$org$openide$util$RequestProcessor = Processor.class$("org.openide.util.RequestProcessor")) : class$org$openide$util$RequestProcessor, "EXC_IN_REQUEST_PROCESSOR"), SLOW ? todo.item : null, null);
            err.notify(ex);
        }

        static ThreadGroup getTopLevelThreadGroup() {
            PrivilegedAction run = new PrivilegedAction(){

                public Object run() {
                    ThreadGroup current = Thread.currentThread().getThreadGroup();
                    while (current.getParent() != null) {
                        current = current.getParent();
                    }
                    return current;
                }
            };
            return (ThreadGroup)AccessController.doPrivileged(run);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class Item
    extends Exception {
        private final RequestProcessor owner;
        private Task action;
        private boolean enqueued;

        Item(Task task, RequestProcessor rp) {
            super("Posted StackTrace");
            this.action = task;
            this.owner = rp;
        }

        Task getTask() {
            return this.action;
        }

        boolean clear() {
            Object object = this.owner.processorLock;
            synchronized (object) {
                this.action = null;
                boolean bl = this.enqueued ? this.owner.queue.remove(this) : true;
                return bl;
            }
        }

        int getPriority() {
            return this.action.getPriority();
        }

        public Throwable fillInStackTrace() {
            return SLOW ? super.fillInStackTrace() : this;
        }
    }

    public final class Task
    extends org.openide.util.Task {
        private Item item;
        private int priority = 1;
        private long time = 0L;
        private Thread lastThread = null;

        Task(Runnable run) {
            super(run);
        }

        Task(Runnable run, int priority) {
            super(run);
            if (priority < 1) {
                priority = 1;
            }
            if (priority > 10) {
                priority = 10;
            }
            this.priority = priority;
        }

        public void run() {
            this.lastThread = Thread.currentThread();
            super.run();
            this.lastThread = null;
        }

        public int getDelay() {
            long delay = this.time - System.currentTimeMillis();
            if (delay < 0L) {
                return 0;
            }
            if (delay > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)delay;
        }

        public void schedule(int delay) {
            Item localItem;
            if (RequestProcessor.this.stopped) {
                throw new IllegalStateException("RequestProcessor already stopped!");
            }
            this.time = System.currentTimeMillis() + (long)delay;
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                this.notifyRunning();
                if (this.item != null) {
                    this.item.clear();
                }
                localItem = this.item = new Item(this, RequestProcessor.this);
            }
            if (delay == 0) {
                RequestProcessor.this.enqueue(localItem);
            } else {
                starterThread.schedule(new TimerTask(this, localItem){
                    private final /* synthetic */ Item val$localItem;
                    private final /* synthetic */ Task this$1;
                    {
                        this.this$1 = this$1;
                        this.val$localItem = val$localItem;
                    }

                    public void run() {
                        Task.access$100(this.this$1).enqueue(this.val$localItem);
                    }
                }, delay);
            }
        }

        public boolean cancel() {
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                boolean success;
                boolean bl = success = this.item == null ? false : this.item.clear();
                if (success) {
                    this.notifyFinished();
                }
                boolean bl2 = success;
                return bl2;
            }
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            if (this.priority == priority) {
                return;
            }
            if (priority < 1) {
                priority = 1;
            }
            if (priority > 10) {
                priority = 10;
            }
            this.priority = priority;
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                if (this.item == null) {
                    return;
                }
                if (RequestProcessor.this.queue.remove(this.item)) {
                    RequestProcessor.this.prioritizedEnqueue(this.item);
                }
            }
        }

        public void waitFinished() {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean toRun;
                Object object = RequestProcessor.this.processorLock;
                synchronized (object) {
                    toRun = !this.isFinished() && (this.item == null || this.item.clear());
                }
                if (toRun) {
                    this.run();
                } else if (this.lastThread != Thread.currentThread()) {
                    super.waitFinished();
                }
            } else {
                super.waitFinished();
            }
        }

        public String toString() {
            return "RequestProcessor.Task [" + RequestProcessor.this.name + ", " + this.priority + "] for " + super.toString();
        }

        static /* synthetic */ RequestProcessor access$100(Task x0) {
            return x0.RequestProcessor.this;
        }
    }
}

