/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.awt.Actions;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListener;
import org.openide.util.WeakSet;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public abstract class NodeAction
extends CallableSystemAction
implements ContextAwareAction {
    private static final long serialVersionUID = -5672895970450115226L;
    private static final String PROP_HAS_LISTENERS = "hasListeners";
    private static final String PROP_LAST_NODES = "lastNodes";
    private static final String PROP_LAST_ENABLED = "lastEnabled";
    private static NodesL l;
    private static final Set listeningActions;

    protected void initialize() {
        super.initialize();
        this.putProperty(PROP_HAS_LISTENERS, Boolean.FALSE);
        this.putProperty("enabled", null);
    }

    protected void addNotify() {
        super.addNotify();
        this.putProperty(PROP_HAS_LISTENERS, Boolean.TRUE);
        Set set = listeningActions;
        synchronized (set) {
            if (l == null) {
                l = new NodesL();
            }
            if (listeningActions.isEmpty()) {
                l.setActive(true);
            }
            listeningActions.add(this);
        }
    }

    protected void removeNotify() {
        Set set = listeningActions;
        synchronized (set) {
            listeningActions.remove(this);
            if (listeningActions.isEmpty()) {
                l.setActive(false);
            }
        }
        this.putProperty(PROP_HAS_LISTENERS, Boolean.FALSE);
        this.putProperty("enabled", null);
        super.removeNotify();
    }

    public boolean isEnabled() {
        Node[] ns = null;
        Boolean b = null;
        Object object = this.getLock();
        synchronized (object) {
            b = (Boolean)this.getProperty("enabled");
            if (b == null) {
                ns = NodeAction.getActivatedNodes(this.surviveFocusChange());
                Reference r = (Reference)this.getProperty(PROP_LAST_NODES);
                if (r != null && r.get() == ns) {
                    b = (Boolean)this.getProperty(PROP_LAST_ENABLED);
                    if (((Boolean)this.getProperty(PROP_HAS_LISTENERS)).booleanValue()) {
                        this.putProperty("enabled", b);
                    }
                }
            }
        }
        if (b == null) {
            b = ns != null && this.enable(ns) ? Boolean.TRUE : Boolean.FALSE;
            Object object2 = this.getLock();
            synchronized (object2) {
                this.putProperty(PROP_LAST_NODES, new WeakReference<Node[]>(ns));
                this.putProperty(PROP_LAST_ENABLED, b);
                if (((Boolean)this.getProperty(PROP_HAS_LISTENERS)).booleanValue()) {
                    this.putProperty("enabled", b);
                }
            }
        }
        return b;
    }

    public void setEnabled(boolean e) {
        this.putProperty(PROP_LAST_ENABLED, null);
        this.putProperty(PROP_LAST_NODES, null);
        if (((Boolean)this.getProperty(PROP_HAS_LISTENERS)).booleanValue()) {
            super.setEnabled(e);
        } else {
            this.putProperty("enabled", null, true);
        }
    }

    public void actionPerformed(ActionEvent ev) {
        Object s;
        Object object = s = ev == null ? null : ev.getSource();
        if (s instanceof Node) {
            this.performAction(new Node[]{(Node)s});
        } else if (s instanceof Node[]) {
            this.performAction((Node[])s);
        } else {
            this.performAction();
        }
    }

    public void performAction() {
        this.performAction(this.getActivatedNodes());
    }

    public final Node[] getActivatedNodes() {
        TopComponent.Registry r = CallbackSystemAction.getRegistry();
        if (r != null) {
            return r.getActivatedNodes();
        }
        ExplorerManager em = CallbackSystemAction.getExplorerManager();
        if (em != null) {
            return em.getSelectedNodes();
        }
        return new Node[0];
    }

    protected boolean surviveFocusChange() {
        return true;
    }

    protected abstract void performAction(Node[] var1);

    protected abstract boolean enable(Node[] var1);

    public Action createContextAwareInstance(Lookup actionContext) {
        return new DelegateAction(this, actionContext);
    }

    void maybeFireEnabledChange() {
        boolean fire = false;
        Object object = this.getLock();
        synchronized (object) {
            if (this.getProperty("enabled") != null) {
                this.putProperty("enabled", null);
                fire = true;
            }
        }
        if (fire) {
            this.firePropertyChange("enabled", null, null);
        }
    }

    private static Node[] getActivatedNodes(boolean survive) {
        TopComponent.Registry r = CallbackSystemAction.getRegistry();
        if (r != null) {
            if (survive) {
                return r.getActivatedNodes();
            }
            return r.getCurrentNodes();
        }
        ExplorerManager em = CallbackSystemAction.getExplorerManager();
        if (em != null) {
            return em.getSelectedNodes();
        }
        return new Node[0];
    }

    static {
        listeningActions = new WeakSet(100);
    }

    private static final class DelegateAction
    implements Action,
    LookupListener,
    Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar {
        private NodeAction delegate;
        private Lookup.Result result;
        private boolean enabled = true;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);
        static /* synthetic */ Class class$org$openide$nodes$Node;
        static /* synthetic */ Class class$org$openide$util$LookupListener;
        static /* synthetic */ Class class$org$openide$util$actions$CallableSystemAction;

        public DelegateAction(NodeAction a, Lookup actionContext) {
            this.delegate = a;
            this.result = actionContext.lookup(new Lookup.Template(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = DelegateAction.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node));
            this.result.addLookupListener((LookupListener)WeakListener.create(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = DelegateAction.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, this, this.result));
            this.resultChanged(null);
        }

        public String toString() {
            return super.toString() + "[delegate=" + this.delegate + "]";
        }

        private synchronized Node[] nodes() {
            Node[] empty = new Node[]{};
            if (this.result != null) {
                return this.result.allInstances().toArray(empty);
            }
            return empty;
        }

        public void actionPerformed(ActionEvent e) {
            this.delegate.performAction(this.nodes());
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        public void putValue(String key, Object o) {
        }

        public Object getValue(String key) {
            return this.delegate.getValue(key);
        }

        public boolean isEnabled() {
            return this.delegate.enable(this.nodes());
        }

        public void setEnabled(boolean b) {
        }

        public void resultChanged(LookupEvent ev) {
            boolean newEnabled = this.delegate.enable(this.nodes());
            if (newEnabled != this.enabled) {
                this.support.firePropertyChange("enabled", this.enabled, newEnabled);
                this.enabled = newEnabled;
            }
        }

        public JMenuItem getMenuPresenter() {
            if (this.isMethodOverriden(this.delegate, "getMenuPresenter")) {
                return this.delegate.getMenuPresenter();
            }
            return new Actions.MenuItem(this, true);
        }

        public JMenuItem getPopupPresenter() {
            if (this.isMethodOverriden(this.delegate, "getPopupPresenter")) {
                return this.delegate.getPopupPresenter();
            }
            return new Actions.MenuItem(this, false);
        }

        public Component getToolbarPresenter() {
            if (this.isMethodOverriden(this.delegate, "getToolbarPresenter")) {
                return this.delegate.getToolbarPresenter();
            }
            return new Actions.ToolbarButton(this);
        }

        private boolean isMethodOverriden(NodeAction d, String name) {
            try {
                Method m = d.getClass().getMethod(name, new Class[0]);
                return m.getDeclaringClass() != (class$org$openide$util$actions$CallableSystemAction == null ? (class$org$openide$util$actions$CallableSystemAction = DelegateAction.class$("org.openide.util.actions.CallableSystemAction")) : class$org$openide$util$actions$CallableSystemAction);
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
                throw new IllegalStateException("Error searching for method " + name + " in " + d);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static final class NodesL
    implements PropertyChangeListener {
        private boolean chgSFC = false;
        private boolean chgNSFC = false;

        void setActive(boolean active) {
            TopComponent.Registry r = CallbackSystemAction.getRegistry();
            if (r != null) {
                if (active) {
                    r.addPropertyChangeListener(this);
                } else {
                    r.removePropertyChangeListener(this);
                    this.forget(true);
                    this.forget(false);
                }
            } else {
                ExplorerManager em = CallbackSystemAction.getExplorerManager();
                if (em != null) {
                    if (active) {
                        em.addPropertyChangeListener(this);
                    } else {
                        em.removePropertyChangeListener(this);
                        this.forget(true);
                        this.forget(false);
                    }
                }
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String p = ev.getPropertyName();
            boolean schedule = false;
            if (p == null || p.equals("activatedNodes")) {
                this.chgSFC = true;
                schedule = true;
            }
            if (p == null || p.equals("currentNodes")) {
                this.chgNSFC = true;
                schedule = true;
            }
            if (p == null || p.equals("selectedNodes")) {
                this.chgSFC = true;
                this.chgNSFC = true;
                schedule = true;
            }
            if (schedule) {
                this.update();
            }
        }

        public void update() {
            if (this.chgSFC) {
                this.forget(true);
                this.chgSFC = false;
            }
            if (this.chgNSFC) {
                this.forget(false);
                this.chgNSFC = false;
            }
        }

        private void forget(boolean sfc) {
            Iterator it;
            ArrayList as;
            Set set = listeningActions;
            synchronized (set) {
                as = new ArrayList(listeningActions.size());
                it = listeningActions.iterator();
                while (it.hasNext()) {
                    as.add(it.next());
                }
            }
            it = as.iterator();
            while (it.hasNext()) {
                NodeAction a = (NodeAction)it.next();
                if (a.surviveFocusChange() != sfc) continue;
                a.maybeFireEnabledChange();
            }
        }
    }
}

