/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglib;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.filechooser.FileFilter;
import org.openide.util.NbBundle;

public class TagLibFilter
extends FileFilter {
    private Hashtable filters = null;
    private boolean debug = false;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglib$TagLibFilter;

    public TagLibFilter() {
        this((String)null);
    }

    public TagLibFilter(String extension) {
        this(new String[]{extension});
    }

    public TagLibFilter(String[] filters) {
        this.filters = new Hashtable(filters.length);
        int i = 0;
        while (i < filters.length) {
            this.addExtension(filters[i]);
            ++i;
        }
    }

    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null && this.filters.get(extension) != null) {
                return this.isTaglib(f);
            }
        }
        return false;
    }

    public boolean isTaglib(File file) {
        JarFile jf;
        if (this.debug) {
            System.out.println("Checking the jar file : " + file.getName());
        }
        try {
            jf = new JarFile(file);
        }
        catch (IOException e) {
            return false;
        }
        Enumeration<JarEntry> en = jf.entries();
        while (en.hasMoreElements()) {
            int idx;
            String s = ((Object)en.nextElement()).toString();
            int i = s.lastIndexOf(46);
            if (i <= 0 || i >= s.length() - 1 || !s.substring(i + 1).toLowerCase().equals("tld")) continue;
            if (this.debug) {
                System.out.println("Jar Entry : " + s);
            }
            if ((idx = (s = s.toLowerCase().replace('\\', '/')).lastIndexOf(47)) <= 0 || !s.substring(0, idx).toLowerCase().equals("meta-inf")) continue;
            return true;
        }
        return false;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(extension.toLowerCase(), this);
    }

    public String getDescription() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglib$TagLibFilter == null ? (class$org$netbeans$modules$web$taglib$TagLibFilter = TagLibFilter.class$("org.netbeans.modules.web.taglib.TagLibFilter")) : class$org$netbeans$modules$web$taglib$TagLibFilter)).getString("TLS_TagLibFilter.description");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

