/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglib;

import java.awt.Component;
import java.awt.Dialog;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Vector;
import org.netbeans.modules.jarpackager.JarDataObject;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.taglib.TagLibListPanel;
import org.netbeans.modules.web.taglib.TagLibSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

public class TagLibFinder {
    static Node lastVisitedNode;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglib$TagLibFinder;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglib$TagLibSupport;

    public String getI18NString(ResourceBundle resBundle, String i18nKey) {
        return resBundle.getString(i18nKey);
    }

    public boolean isTagLibJar(FileObject tagLibJarFileObject) {
        return tagLibJarFileObject.getExt().equalsIgnoreCase("jar");
    }

    public boolean isTagLibFileSystemRoot(DataObject dataObject) {
        return dataObject.getPrimaryFile().isRoot();
    }

    public boolean acceptDataObjectForTagLib(DataObject dataObj) {
        if (dataObj instanceof DataFolder) {
            return true;
        }
        try {
            return TagLibSupport.isTagLibJar(dataObj);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Node[] browseForTagLibs(DataFilter dataFilter, String title, String rootTitle, Component additionalComponent) {
        Node place = RepositoryNodeFactory.getDefault().repository(dataFilter);
        try {
            Node[] selected = NodeOperation.getDefault().select(title, rootTitle, place, new NodeAcceptor(){
                static /* synthetic */ Class class$org$openide$loaders$DataObject;
                static /* synthetic */ Class class$org$openide$loaders$DataFolder;

                public final boolean acceptNodes(Node[] nodes) {
                    if (nodes == null) {
                        return false;
                    }
                    boolean hasTagLibJar = false;
                    int i = 0;
                    while (i < nodes.length) {
                        DataObject dataObject = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? 1.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                        if (dataObject == null) {
                            return false;
                        }
                        if (TagLibFinder.this.isTagLibFileSystemRoot(dataObject)) {
                            hasTagLibJar = true;
                        } else {
                            if (nodes[i].getCookie(class$org$openide$loaders$DataFolder == null ? 1.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder) != null) {
                                return false;
                            }
                            hasTagLibJar = true;
                        }
                        ++i;
                    }
                    return hasTagLibJar;
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            }, additionalComponent);
            return selected;
        }
        catch (UserCancelException ex) {
            return null;
        }
    }

    public Collection nodesToFileObjects(Node[] selectedNodes) {
        Vector<FileObject> fileObjects = new Vector<FileObject>();
        int i = 0;
        while (i < selectedNodes.length) {
            FileObject taglibJarFileObject = null;
            DataObject dataObject = (DataObject)selectedNodes[i].getCookie(class$org$openide$loaders$DataObject == null ? TagLibFinder.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (dataObject != null && TagLibSupport.isTagLibJar(taglibJarFileObject = dataObject instanceof JarDataObject ? ((JarDataObject)dataObject).findArchiveFile() : dataObject.getPrimaryFile())) {
                fileObjects.add(taglibJarFileObject);
            }
            ++i;
        }
        return fileObjects;
    }

    HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$web$taglib$TagLibFinder == null ? (class$org$netbeans$modules$web$taglib$TagLibFinder = TagLibFinder.class$("org.netbeans.modules.web.taglib.TagLibFinder")) : class$org$netbeans$modules$web$taglib$TagLibFinder);
    }

    public Collection findTagLibsFromFileSystems() {
        String rootTitle;
        DataFilter dataFilter = new DataFilter(){

            public boolean acceptDataObject(DataObject dataObj) {
                return TagLibFinder.this.acceptDataObjectForTagLib(dataObj);
            }
        };
        ResourceBundle resBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglib$TagLibSupport == null ? (class$org$netbeans$modules$web$taglib$TagLibSupport = TagLibFinder.class$("org.netbeans.modules.web.taglib.TagLibSupport")) : class$org$netbeans$modules$web$taglib$TagLibSupport));
        String title = this.getI18NString(resBundle, "TLS_TagLibFinderFromFSDialogTitle");
        Node[] selected = this.browseForTagLibs(dataFilter, title, rootTitle = this.getI18NString(resBundle, "TLS_TagLibFinderFromFSRootTitle"), null);
        if (selected == null || selected.length <= 0) {
            return new Vector();
        }
        lastVisitedNode = selected[selected.length - 1];
        Collection tagLibs = this.nodesToFileObjects(selected);
        return tagLibs;
    }

    public Collection findTagLibsFromTagLibRepository() {
        Collection tagLibs = new Vector();
        ResourceBundle resBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglib$TagLibSupport == null ? (class$org$netbeans$modules$web$taglib$TagLibSupport = TagLibFinder.class$("org.netbeans.modules.web.taglib.TagLibSupport")) : class$org$netbeans$modules$web$taglib$TagLibSupport));
        String title = this.getI18NString(resBundle, "TLS_TagLibFinderFromRepDialogTitle");
        TagLibListPanel tagLibListPanel = new TagLibListPanel();
        DialogDescriptor descriptor = new DialogDescriptor((Object)tagLibListPanel, title);
        descriptor.setHelpCtx(this.getHelpCtx());
        Dialog tagLibFinderDialog = DialogDisplayer.getDefault().createDialog(descriptor);
        tagLibFinderDialog.show();
        if (descriptor.getValue() == NotifyDescriptor.OK_OPTION) {
            tagLibs = tagLibListPanel.getSelectedItems();
        }
        return tagLibs;
    }

    public void addTagLibsFromFileSystemsToWebModule(WebContextObject wco) throws IOException, PropertyVetoException {
        Collection tagLibs = this.findTagLibsFromFileSystems();
        TagLibSupport.useLibraries(tagLibs, wco);
    }

    public void addTagLibsFromTagLibRepositoryToWebModule(WebContextObject wco) throws IOException, PropertyVetoException {
        Collection tagLibs = this.findTagLibsFromTagLibRepository();
        TagLibSupport.useSystemLibraries(tagLibs, wco);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

