/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglib;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.web.taglib.TagLibActionCookie;
import org.netbeans.modules.web.taglib.TagLibSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.util.NbBundle;

public class TagLibListPanel
extends JPanel
implements TagLibActionCookie {
    JLabel repositoryLabel;
    JList taglibList;
    DefaultListModel listModel;
    final int PREF_WIDTH = 310;
    final int PREF_HEIGHT = 250;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglib$TagLibListPanel;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglib$TagLibSupport;

    public TagLibListPanel() {
        this.setBorder(new EmptyBorder(new Insets(8, 8, 8, 0)));
        this.setLayout(new GridBagLayout());
        ResourceBundle resBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglib$TagLibListPanel == null ? (class$org$netbeans$modules$web$taglib$TagLibListPanel = TagLibListPanel.class$("org.netbeans.modules.web.taglib.TagLibListPanel")) : class$org$netbeans$modules$web$taglib$TagLibListPanel));
        this.getAccessibleContext().setAccessibleDescription(resBundle.getString("ACS_TLS_TagLibListPanel.DialogA11yDesc"));
        this.getAccessibleContext().setAccessibleName(resBundle.getString("ACS_TLS_TagLibListPanel.DialogA11yName"));
        this.repositoryLabel = new JLabel(resBundle.getString("TLS_TagLibListPanel_taglib"));
        this.repositoryLabel.setDisplayedMnemonic(resBundle.getString("TLS_TagLibListPanel_taglib_Mnemonic").charAt(0));
        this.repositoryLabel.getAccessibleContext().setAccessibleDescription(resBundle.getString("ACS_TLS_TagLibListPanel_taglibA11yDesc"));
        this.listModel = new DefaultListModel();
        this.taglibList = new JList();
        this.repositoryLabel.setLabelFor(this.taglibList);
        this.populateList();
        this.taglibList.getAccessibleContext().setAccessibleName(resBundle.getString("ACS_TLS_TagLibListPanel_taglibListA11yName"));
        this.taglibList.setToolTipText(resBundle.getString("ACS_TLS_TagLibListPanel_taglibListA11yDesc"));
        JScrollPane scrollPane = new JScrollPane(this.taglibList);
        scrollPane.setPreferredSize(new Dimension(310, 250));
        scrollPane.setMinimumSize(new Dimension(310, 250));
        int gridy = 0;
        this.addGridBagComponent(this, this.repositoryLabel, 0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 0), 0, 5);
        this.addGridBagComponent(this, scrollPane, 0, ++gridy, 1, 1, 0.0, 100.0, 17, 1, new Insets(2, 2, 2, 2), 0, 5);
    }

    private void addGridBagComponent(Container parent, Component comp, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets, int ipadx, int ipady) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = gridx;
        cons.gridy = gridy;
        cons.gridwidth = gridwidth;
        cons.gridheight = gridheight;
        cons.weightx = weightx;
        cons.weighty = weighty;
        cons.anchor = anchor;
        cons.fill = fill;
        cons.insets = insets;
        cons.ipadx = ipadx;
        cons.ipady = ipady;
        parent.add(comp, cons);
    }

    public void deleteSelectedItems() {
        int[] idx = this.taglibList.getSelectedIndices();
        if (idx.length > 0 && idx[0] >= 0) {
            int i = idx.length - 1;
            while (i >= 0) {
                String str = (String)this.listModel.elementAt(idx[i]);
                try {
                    TagLibSupport.removeFromRepository(str);
                    this.listModel.removeElementAt(idx[i]);
                }
                catch (FileNotFoundException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                catch (FileAlreadyLockedException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                    String warning = NbBundle.getMessage((Class)(class$org$netbeans$modules$web$taglib$TagLibSupport == null ? TagLibListPanel.class$("org.netbeans.modules.web.taglib.TagLibSupport") : class$org$netbeans$modules$web$taglib$TagLibSupport), (String)"TLS_Repository.deleteFailed", (Object)str);
                    String title = NbBundle.getMessage((Class)(class$org$netbeans$modules$web$taglib$TagLibSupport == null ? TagLibListPanel.class$("org.netbeans.modules.web.taglib.TagLibSupport") : class$org$netbeans$modules$web$taglib$TagLibSupport), (String)"TLS_Repository.warningTitle");
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)warning, 2);
                    msg.setTitle(title);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                }
                --i;
            }
        }
    }

    public Collection getSelectedItems() {
        int[] idx = this.taglibList.getSelectedIndices();
        Vector rv = new Vector();
        if (idx.length > 0 && idx[0] >= 0) {
            int i = 0;
            while (i < idx.length) {
                rv.add(this.listModel.elementAt(idx[i]));
                ++i;
            }
        }
        return rv;
    }

    public void populateList() {
        String[] taglibs;
        try {
            taglibs = TagLibSupport.getLibraries();
        }
        catch (FileNotFoundException e) {
            taglibs = null;
        }
        if (taglibs != null && taglibs.length > 0) {
            this.listModel.clear();
            int i = 0;
            while (i < taglibs.length) {
                this.listModel.addElement(taglibs[i]);
                ++i;
            }
        }
        this.taglibList.setModel(this.listModel);
        if (this.listModel.size() > 0) {
            this.taglibList.setSelectedIndex(0);
        }
    }

    public void addItem(Object obj) {
        if (!this.listModel.contains(obj)) {
            this.listModel.addElement(obj);
        }
    }

    public TagLibListPanel getListPanel() {
        return this;
    }

    protected JList getTagLibList() {
        return this.taglibList;
    }

    protected boolean isTagListSelectionEmpty() {
        if (this.taglibList == null) {
            return true;
        }
        return this.taglibList.isSelectionEmpty();
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame();
        frame.setContentPane(new TagLibListPanel());
        ((Component)frame).setSize(400, 300);
        frame.pack();
        ((Component)frame).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

