/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglib;

import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.modules.jarpackager.JarDataObject;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.dd.DDDataObject;
import org.netbeans.modules.web.dd.model.Taglib;
import org.netbeans.modules.web.dd.model.WebApp;
import org.netbeans.modules.web.taglib.FileExistsException;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class TagLibSupport {
    private static final boolean debug = false;
    private static final boolean debugdetail = false;
    private static final boolean debugreplace = false;
    private static final String TAGLIBDIR = "TagLibrary";
    private static FileObject taglibdir = null;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglib$TagLibSupport;

    public static FileObject getDirectory() throws FileNotFoundException {
        if (taglibdir == null) {
            FileObject rootdir = Repository.getDefault().getDefaultFileSystem().getRoot();
            try {
                taglibdir = rootdir.getFileObject(TAGLIBDIR);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (taglibdir == null) {
                try {
                    rootdir.createFolder(TAGLIBDIR);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (taglibdir == null) {
                throw new FileNotFoundException();
            }
        }
        return taglibdir;
    }

    public static String[] getLibraries() throws FileNotFoundException {
        if (taglibdir == null) {
            TagLibSupport.getDirectory();
        }
        if (taglibdir == null) {
            throw new FileNotFoundException();
        }
        FileObject[] files = taglibdir.getChildren();
        Vector<FileObject> taglibs = new Vector<FileObject>();
        int i = 0;
        while (i < files.length) {
            if (files[i].hasExt("jar")) {
                taglibs.addElement(files[i]);
            }
            ++i;
        }
        int j = 0;
        String[] names = new String[taglibs.size()];
        Enumeration en = taglibs.elements();
        while (en.hasMoreElements()) {
            FileObject taglib = (FileObject)en.nextElement();
            names[j] = taglib.getName();
            ++j;
        }
        return names;
    }

    public static void useSystemLibraries(Collection names, WebContextObject webmodule) throws FileNotFoundException, IOException, PropertyVetoException {
        if (taglibdir == null) {
            TagLibSupport.getDirectory();
        }
        if (taglibdir == null) {
            throw new FileNotFoundException();
        }
        FileObject source = null;
        Vector<FileObject> fileObjects = new Vector<FileObject>();
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            try {
                source = taglibdir.getFileObject(name, "jar");
                fileObjects.addElement(source);
                TagLibSupport.addExtraJarsFromNamedirectory(fileObjects, taglibdir, name);
            }
            catch (Exception e) {
                throw new FileNotFoundException();
            }
        }
        TagLibSupport.useLibraries(fileObjects, webmodule);
    }

    private static void addExtraJarsFromNamedirectory(Vector fileObjects, FileObject taglibdir, String name) {
        FileObject auxDirectory = taglibdir.getFileObject(name);
        if (auxDirectory == null) {
            return;
        }
        if (!auxDirectory.isFolder()) {
            return;
        }
        FileObject[] files = auxDirectory.getChildren();
        int i = 0;
        while (i < files.length) {
            if (files[i].hasExt("jar")) {
                fileObjects.addElement(files[i]);
            }
            ++i;
        }
    }

    public static void useLibraries(Collection fileObjects, WebContextObject webmodule) throws IOException, PropertyVetoException {
        TagLibSupport.addTagLibraries(webmodule, fileObjects);
    }

    public static void removeLibrary(String name, FileObject webmodule) throws FileNotFoundException, IOException {
    }

    public static boolean isJarFileOrFS(DataObject d) {
        if (d instanceof JarDataObject) {
            return true;
        }
        FileObject fo = d.getPrimaryFile();
        if (fo == null) {
            return false;
        }
        try {
            FileSystem fs = fo.getFileSystem();
            if (fo == fs.getRoot() && fs instanceof JarFileSystem) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fo.hasExt("jar");
    }

    public static boolean isTagLibJar(DataObject d) {
        if (d instanceof JarDataObject) {
            return TagLibSupport.isTagLibJar(((JarDataObject)d).findArchiveFile());
        }
        try {
            FileObject fo = d.getPrimaryFile();
            if (fo == fo.getFileSystem().getRoot()) {
                return TagLibSupport.isTagLibJar(fo.getFileSystem());
            }
            return TagLibSupport.isTagLibJar(fo);
        }
        catch (FileStateInvalidException fsie) {
            return false;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isTagLibJar(FileObject fo) {
        ZipFile jar;
        boolean result;
        block9: {
            result = false;
            if (fo == null || !fo.hasExt("jar")) return result;
            jar = null;
            File jf = NbClassPath.toFile((FileObject)fo);
            if (jf == null) break block9;
            jar = new JarFile(jf);
            Enumeration<JarEntry> en = ((JarFile)jar).entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                String entryName = entry.getName();
                if (!entryName.startsWith("META-INF/") || !entryName.endsWith(".tld")) continue;
                result = true;
                break;
            }
        }
        Object var8_8 = null;
        if (jar == null) return result;
        try {
            jar.close();
            return result;
        }
        catch (IOException ex2) {}
        return result;
        {
            catch (IOException ex) {
                Object var8_9 = null;
                if (jar == null) return result;
                try {
                    jar.close();
                    return result;
                }
                catch (IOException ex2) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (jar == null) throw throwable;
            try {
                jar.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isTagLibJarWithMETA_INF_tld(FileObject fo) {
        ZipFile jar;
        boolean result;
        block8: {
            result = false;
            if (fo == null || !fo.hasExt("jar")) return result;
            jar = null;
            File jf = NbClassPath.toFile((FileObject)fo);
            ZipEntry entry = null;
            if (jf == null) break block8;
            jar = new JarFile(jf);
            entry = ((JarFile)jar).getEntry("META-INF/taglib.tld");
            result = entry != null;
        }
        Object var6_6 = null;
        if (jar == null) return result;
        try {
            jar.close();
            return result;
        }
        catch (IOException ex2) {}
        return result;
        {
            catch (IOException ex) {
                Object var6_7 = null;
                if (jar == null) return result;
                try {
                    jar.close();
                    return result;
                }
                catch (IOException ex2) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (jar == null) throw throwable;
            try {
                jar.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static boolean isTagLibJar(FileSystem fs) {
        FileObject metaInf;
        if (fs instanceof JarFileSystem && (metaInf = ((JarFileSystem)fs).find("META-INF", null, null)) != null) {
            FileObject[] children = metaInf.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i].hasExt("tld")) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isTagLibJarWithMETA_INF_tld(FileSystem fs) {
        return fs instanceof JarFileSystem && ((JarFileSystem)fs).find("META-INF", "taglib", "tld") != null;
    }

    public static void addToRepository(DataObject d) throws FileNotFoundException, FileExistsException, IOException, FileStateInvalidException {
        if (d instanceof JarDataObject) {
            TagLibSupport.addToRepository(((JarDataObject)d).findArchiveFile());
        } else {
            FileObject fo = d.getPrimaryFile();
            if (fo.hasExt("jar")) {
                TagLibSupport.addToRepository(fo);
            } else {
                JarFileSystem jfs = (JarFileSystem)fo.getFileSystem();
                TagLibSupport.addToRepository(jfs.getJarFile());
            }
        }
    }

    public static void addToRepository(FileObject taglib) throws FileNotFoundException, FileExistsException, IOException {
        TagLibSupport.addToRepository(taglib, false);
    }

    public static void addToRepository(FileObject taglib, boolean force) throws FileNotFoundException, FileExistsException, IOException {
        if (taglibdir == null) {
            TagLibSupport.getDirectory();
        }
        if (taglibdir == null) {
            throw new FileNotFoundException();
        }
        String filename = taglib.getNameExt();
        FileObject fo = taglibdir.getFileObject(filename);
        if (fo != null && fo.isData()) {
            boolean replace = false;
            if (!force) {
                replace = TagLibSupport.askUserAboutReplacingRepositoryJar(filename);
            }
            if (force || replace) {
                try {
                    TagLibSupport.removeFromRepository(filename);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            } else {
                return;
            }
        }
        taglib.copy(taglibdir, taglib.getName(), "jar");
    }

    public static void addToRepository(File taglib) throws FileNotFoundException, FileExistsException, IOException {
        try {
            TagLibSupport.addToRepository(taglib, false);
        }
        catch (FileNotFoundException f) {
            throw f;
        }
        catch (FileExistsException fe) {
            throw fe;
        }
        catch (IOException i) {
            throw i;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addToRepository(File taglib, boolean force) throws FileNotFoundException, FileExistsException, IOException {
        if (taglibdir == null) {
            TagLibSupport.getDirectory();
        }
        if (taglibdir == null) {
            throw new FileNotFoundException();
        }
        String filenameExt = taglib.getName();
        String ext = filenameExt.substring(filenameExt.lastIndexOf(46) + 1);
        String filename = filenameExt.substring(0, filenameExt.lastIndexOf(46));
        FileObject tagJarFileObj = taglibdir.getFileObject(filename, ext);
        if (tagJarFileObj != null && tagJarFileObj.isData()) {
            boolean replace = false;
            if (!force) {
                replace = TagLibSupport.askUserAboutReplacingRepositoryJar(filenameExt);
            }
            if (!force && !replace) return;
            try {
                TagLibSupport.removeFromRepository(filename);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        FileLock lock = null;
        try {
            int c;
            FileInputStream fin = new FileInputStream(taglib);
            BufferedInputStream in = new BufferedInputStream(fin);
            FileObject fo = taglibdir.createData(filename, "jar");
            lock = fo.lock();
            OutputStream fout = fo.getOutputStream(lock);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            while ((c = in.read()) != -1) {
                void var12_15;
                out.write((int)var12_15);
            }
            out.flush();
            in.close();
            out.close();
            fin.close();
            fout.close();
            Object var14_16 = null;
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (lock == null) throw throwable;
            lock.releaseLock();
            throw throwable;
        }
        lock.releaseLock();
    }

    private static boolean askUserAboutReplacingRepositoryJar(String filename) {
        String title = NbBundle.getMessage((Class)(class$org$netbeans$modules$web$taglib$TagLibSupport == null ? (class$org$netbeans$modules$web$taglib$TagLibSupport = TagLibSupport.class$("org.netbeans.modules.web.taglib.TagLibSupport")) : class$org$netbeans$modules$web$taglib$TagLibSupport), (String)"TLS_AddToRepository.OverwriteTitle");
        NotifyDescriptor question = TagLibSupport.showQuestionI18N("TLS_AddToRepository.OverwriteQuestion", filename, title);
        boolean goAhead_Overwrite = question.getValue() == NotifyDescriptor.YES_OPTION;
        return goAhead_Overwrite;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeFromRepository(String name) throws FileNotFoundException, FileAlreadyLockedException, IOException {
        FileObject taglib;
        if (taglibdir == null) {
            TagLibSupport.getDirectory();
        }
        if (taglibdir == null) {
            throw new FileNotFoundException();
        }
        int idx = name.lastIndexOf(46);
        String ext = "jar";
        String filename = name;
        if (idx > 0) {
            filename = filename.substring(0, idx);
        }
        if ((taglib = taglibdir.getFileObject(filename, ext)) == null) {
            throw new FileNotFoundException(name);
        }
        FileLock lock = null;
        try {
            try {
                DataObject taglibDo = DataObject.find((FileObject)taglib);
                if (taglibDo != null) {
                    taglibDo.delete();
                }
                lock = taglib.lock();
                taglib.delete(lock);
            }
            catch (FileAlreadyLockedException fale) {
                throw fale;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            Object var9_8 = null;
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (lock == null) throw throwable;
            lock.releaseLock();
            throw throwable;
        }
        lock.releaseLock();
    }

    private static void addTagLibToDd(WebContextObject wco, FileObject lib) {
        try {
            if (!TagLibSupport.isTagLibJarWithMETA_INF_tld(lib)) {
                return;
            }
            DDDataObject deplDesc = (DDDataObject)wco.getDeploymentDescriptor();
            WebApp dd = deplDesc.getWebApp();
            Taglib t = new Taglib();
            t.setTaglibUri("/" + lib.getName());
            t.setTaglibLocation("/" + lib.getPackageNameExt('/', '.'));
            Taglib[] currTaglibs = dd.getTaglib();
            ArrayList<Taglib> newTaglibs = new ArrayList<Taglib>();
            boolean found = false;
            String t_uri = t.getTaglibUri();
            String t_location = t.getTaglibLocation();
            int i = 0;
            while (i < currTaglibs.length) {
                if (currTaglibs[i].getTaglibUri().equals(t_uri)) {
                    found = true;
                    break;
                }
                if (currTaglibs[i].getTaglibLocation().equals(t_location)) {
                    found = true;
                    break;
                }
                newTaglibs.add(currTaglibs[i]);
                ++i;
            }
            if (!found) {
                newTaglibs.add(t);
                dd.setTaglib(newTaglibs.toArray(new Taglib[0]));
                deplDesc.setNodeDirty(true);
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public static void addTagLibraries(final WebContextObject wco, Collection taglibFileObjects) throws IOException, PropertyVetoException {
        FileSystem wcofs = wco.getPrimaryFile().getFileSystem();
        Iterator it = taglibFileObjects.iterator();
        while (it.hasNext()) {
            final FileObject taglib = (FileObject)it.next();
            FileSystem.AtomicAction quark = new FileSystem.AtomicAction(){

                public void run() {
                    try {
                        TagLibSupport.addTagLibrary_impl(wco, taglib);
                    }
                    catch (Exception ex) {
                        System.out.println("TagLibSupport::addTagLibraries caught exception in atomic action. " + ex);
                        ex.printStackTrace();
                    }
                }
            };
            wcofs.runAtomicAction(quark);
        }
    }

    public static void obsolete_multiple_RunAtomic_addTagLibraries(final WebContextObject wco, final Collection taglibFileObjects) throws IOException, PropertyVetoException {
        FileSystem.AtomicAction quark = new FileSystem.AtomicAction(){

            public void run() {
                Iterator it = taglibFileObjects.iterator();
                while (it.hasNext()) {
                    FileObject taglib = (FileObject)it.next();
                    try {
                        TagLibSupport.addTagLibrary_impl(wco, taglib);
                    }
                    catch (Exception ex) {
                        System.out.println("TagLibSupport::addTagLibraries caught exception in atomic action. " + ex);
                        ex.printStackTrace();
                    }
                }
            }
        };
        FileSystem wcofs = wco.getPrimaryFile().getFileSystem();
        wcofs.runAtomicAction(quark);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addTagLibrary_impl(WebContextObject wco, FileObject taglib) throws IOException, PropertyVetoException {
        FileObject target;
        FileObject folder;
        String name;
        block10: {
            name = taglib.getName();
            folder = wco.getLibraries().getPrimaryFile();
            FileObject preExistingJar = folder.getFileObject(name, "jar");
            if (preExistingJar != null) {
                String title = NbBundle.getMessage((Class)(class$org$netbeans$modules$web$taglib$TagLibSupport == null ? (class$org$netbeans$modules$web$taglib$TagLibSupport = TagLibSupport.class$("org.netbeans.modules.web.taglib.TagLibSupport")) : class$org$netbeans$modules$web$taglib$TagLibSupport), (String)"TLS_AddTagLibAction.OverwriteTitle");
                NotifyDescriptor question = TagLibSupport.showQuestionI18N("TLS_AddTagLibAction.OverwriteQuestion", name, title);
                if (question.getValue() != NotifyDescriptor.YES_OPTION) return;
                boolean bl = true;
                boolean goAhead_Overwrite = bl;
                if (!goAhead_Overwrite) {
                    return;
                }
                FileLock lock = null;
                try {
                    try {
                        DataObject jarDo = DataObject.find((FileObject)preExistingJar);
                        if (jarDo != null) {
                            jarDo.delete();
                        } else {
                            lock = preExistingJar.lock();
                            preExistingJar.delete(lock);
                        }
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                        Object var11_12 = null;
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        break block10;
                    }
                    Object var11_11 = null;
                    if (lock == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    if (lock == null) throw throwable;
                    lock.releaseLock();
                    throw throwable;
                }
                lock.releaseLock();
            }
        }
        if ((target = taglib.copy(folder, name, "jar")) == null) return;
        TagLibSupport.addTagLibToDd(wco, target);
        wco.mountLib(target);
    }

    public static NotifyDescriptor showQuestionI18N(String key, String arg0, String title) {
        NotifyDescriptor.Confirmation msg = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$web$taglib$TagLibSupport == null ? (class$org$netbeans$modules$web$taglib$TagLibSupport = TagLibSupport.class$("org.netbeans.modules.web.taglib.TagLibSupport")) : class$org$netbeans$modules$web$taglib$TagLibSupport), (String)key, (Object)arg0), 0);
        msg.setMessageType(3);
        msg.setTitle(title);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
        return msg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

