/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglib;

import java.awt.Component;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Vector;
import org.netbeans.modules.web.context.WebContextLoader;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

public class WebModuleFinder {
    static Node lastVisitedNode;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglib$TagLibSupport;

    public String getI18NString(ResourceBundle resBundle, String i18nKey) {
        return resBundle.getString(i18nKey);
    }

    public boolean isWebModule(FileObject webModuleFileObject) {
        try {
            return WebContextLoader.isWebApplication((FileSystem)webModuleFileObject.getFileSystem());
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isWebModuleRoot(DataObject webModuleDataObject) {
        try {
            FileObject webModuleRootFileObject = webModuleDataObject.getPrimaryFile();
            return webModuleRootFileObject.isRoot();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean acceptDataObjectForWebModule(DataObject dataObj) {
        if (dataObj instanceof DataFolder) {
            return true;
        }
        try {
            return this.isWebModule(dataObj.getPrimaryFile());
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Node[] browseForWebModules(DataFilter dataFilter, String title, String rootTitle, Component additionalComponent) {
        Node place = RepositoryNodeFactory.getDefault().repository(dataFilter);
        try {
            Node[] selected = NodeOperation.getDefault().select(title, rootTitle, place, new NodeAcceptor(){
                static /* synthetic */ Class class$org$openide$loaders$DataObject;

                public final boolean acceptNodes(Node[] nodes) {
                    if (nodes == null) {
                        return false;
                    }
                    boolean hasWebModule = false;
                    int i = 0;
                    while (i < nodes.length) {
                        DataObject dataObject = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? 1.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                        if (dataObject == null) {
                            return false;
                        }
                        if (!WebModuleFinder.this.isWebModuleRoot(dataObject)) {
                            return false;
                        }
                        hasWebModule = true;
                        ++i;
                    }
                    return hasWebModule;
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            }, additionalComponent);
            return selected;
        }
        catch (UserCancelException ex) {
            return null;
        }
    }

    public Collection nodesToFileObjects(Node[] selectedNodes) {
        Vector<FileObject> fileObjects = new Vector<FileObject>();
        int i = 0;
        while (i < selectedNodes.length) {
            DataObject dataObject = (DataObject)selectedNodes[i].getCookie(class$org$openide$loaders$DataObject == null ? WebModuleFinder.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (dataObject != null) {
                fileObjects.add(dataObject.getPrimaryFile());
            }
            ++i;
        }
        return fileObjects;
    }

    public Collection findWebModulesFromFileSystems() {
        String rootTitle;
        DataFilter dataFilter = new DataFilter(){

            public boolean acceptDataObject(DataObject dataObj) {
                return WebModuleFinder.this.acceptDataObjectForWebModule(dataObj);
            }
        };
        ResourceBundle resBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglib$TagLibSupport == null ? (class$org$netbeans$modules$web$taglib$TagLibSupport = WebModuleFinder.class$("org.netbeans.modules.web.taglib.TagLibSupport")) : class$org$netbeans$modules$web$taglib$TagLibSupport));
        String title = this.getI18NString(resBundle, "JTL_WebModuleFinderFromFSDialogTitle");
        Node[] selected = this.browseForWebModules(dataFilter, title, rootTitle = this.getI18NString(resBundle, "JTL_WebModuleFinderFromFSRootTitle"), null);
        if (selected == null || selected.length <= 0) {
            return new Vector();
        }
        lastVisitedNode = selected[selected.length - 1];
        Collection webModules = this.nodesToFileObjects(selected);
        return webModules;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

