/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMInputSourceImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.parsers.DOMBuilderImpl;
import org.apache.xml.serialize.DOMWriterImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMBuilder;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.DOMInputSource;
import org.w3c.dom.ls.DOMWriter;

public class CoreDOMImplementationImpl
implements DOMImplementation,
DOMImplementationLS {
    RevalidationHandler fDOMRevalidator = null;
    boolean free = true;
    static CoreDOMImplementationImpl singleton = new CoreDOMImplementationImpl();

    public static DOMImplementation getDOMImplementation() {
        return singleton;
    }

    public boolean hasFeature(String feature, String version) {
        boolean anyVersion = version == null || version.length() == 0;
        return feature.equalsIgnoreCase("Core") && (anyVersion || version.equals("1.0") || version.equals("2.0")) || feature.equalsIgnoreCase("XML") && (anyVersion || version.equals("1.0") || version.equals("2.0")) || feature.equalsIgnoreCase("LS-Load") && (anyVersion || version.equals("3.0"));
    }

    public DocumentType createDocumentType(String qualifiedName, String publicID, String systemID) {
        if (!CoreDocumentImpl.isXMLName(qualifiedName)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        int index = qualifiedName.indexOf(58);
        int lastIndex = qualifiedName.lastIndexOf(58);
        if (index == 0 || index == qualifiedName.length() - 1 || lastIndex != index) {
            throw new DOMException(14, "DOM003 Namespace error");
        }
        return new DocumentTypeImpl(null, qualifiedName, publicID, systemID);
    }

    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        if (doctype != null && doctype.getOwnerDocument() != null) {
            throw new DOMException(4, "DOM005 Wrong document");
        }
        CoreDocumentImpl doc = new CoreDocumentImpl(doctype);
        Element e = doc.createElementNS(namespaceURI, qualifiedName);
        doc.appendChild(e);
        return doc;
    }

    public DOMImplementation getInterface(String feature) {
        throw new DOMException(9, "getInterface() is not implemented");
    }

    public DOMBuilder createDOMBuilder(short mode, String schemaType) throws DOMException {
        if (mode == 2) {
            throw new DOMException(9, "Asynchronous mode is not supported");
        }
        if (schemaType != null && schemaType.equals("http://www.w3.org/TR/REC-xml")) {
            return new DOMBuilderImpl("org.apache.xerces.parsers.DTDConfiguration", schemaType);
        }
        return new DOMBuilderImpl("org.apache.xerces.parsers.StandardParserConfiguration", schemaType);
    }

    public DOMWriter createDOMWriter() {
        return new DOMWriterImpl(true);
    }

    public DOMInputSource createDOMInputSource() {
        return new DOMInputSourceImpl();
    }

    synchronized RevalidationHandler getValidator(String schemaType) {
        if (this.fDOMRevalidator == null) {
            try {
                this.fDOMRevalidator = (RevalidationHandler)Class.forName("org.apache.xerces.impl.xs.XMLSchemaValidator").newInstance();
            }
            catch (ClassNotFoundException ex) {
            }
            catch (Exception e) {}
        }
        while (!this.isFree()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                try {
                    return (RevalidationHandler)Class.forName("org.apache.xerces.impl.xs.XMLSchemaValidator").newInstance();
                }
                catch (ClassNotFoundException ex) {
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        this.free = false;
        return this.fDOMRevalidator;
    }

    synchronized void releaseValidator(String schemaType) {
        this.notifyAll();
        this.free = true;
    }

    final synchronized boolean isFree() {
        return this.free;
    }
}

