/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaNamespaceSupport;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.dom.DOMNodePool;
import org.apache.xerces.impl.xs.dom.DOMParser;
import org.apache.xerces.impl.xs.dom.ElementNSImpl;
import org.apache.xerces.impl.xs.psvi.XSObject;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAttributeGroupTraverser;
import org.apache.xerces.impl.xs.traversers.XSDAttributeTraverser;
import org.apache.xerces.impl.xs.traversers.XSDComplexTypeTraverser;
import org.apache.xerces.impl.xs.traversers.XSDElementTraverser;
import org.apache.xerces.impl.xs.traversers.XSDGroupTraverser;
import org.apache.xerces.impl.xs.traversers.XSDKeyrefTraverser;
import org.apache.xerces.impl.xs.traversers.XSDNotationTraverser;
import org.apache.xerces.impl.xs.traversers.XSDSimpleTypeTraverser;
import org.apache.xerces.impl.xs.traversers.XSDUniqueOrKeyTraverser;
import org.apache.xerces.impl.xs.traversers.XSDWildcardTraverser;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XSDHandler {
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    protected static final boolean DEBUG_NODE_POOL = false;
    static final int ATTRIBUTE_TYPE = 1;
    static final int ATTRIBUTEGROUP_TYPE = 2;
    static final int ELEMENT_TYPE = 3;
    static final int GROUP_TYPE = 4;
    static final int IDENTITYCONSTRAINT_TYPE = 5;
    static final int NOTATION_TYPE = 6;
    static final int TYPEDECL_TYPE = 7;
    public static final String REDEF_IDENTIFIER = "_fn3dktizrknc9pi";
    public String EMPTY_STRING;
    protected Hashtable fNotationRegistry = new Hashtable();
    protected XSDeclarationPool fDeclPool = null;
    private Hashtable fUnparsedAttributeRegistry = new Hashtable();
    private Hashtable fUnparsedAttributeGroupRegistry = new Hashtable();
    private Hashtable fUnparsedElementRegistry = new Hashtable();
    private Hashtable fUnparsedGroupRegistry = new Hashtable();
    private Hashtable fUnparsedIdentityConstraintRegistry = new Hashtable();
    private Hashtable fUnparsedNotationRegistry = new Hashtable();
    private Hashtable fUnparsedTypeRegistry = new Hashtable();
    private Hashtable fXSDocumentInfoRegistry = new Hashtable();
    private Hashtable fDependencyMap = new Hashtable();
    private Hashtable fImportMap = new Hashtable();
    private Vector fAllTNSs = new Vector();
    private Hashtable fLocationPairs = null;
    private Hashtable fTraversed = new Hashtable();
    private Hashtable fDoc2SystemId = new Hashtable();
    private XSDocumentInfo fRoot = null;
    private Hashtable fDoc2XSDocumentMap = new Hashtable();
    private Hashtable fRedefine2XSDMap = new Hashtable();
    private Hashtable fRedefine2NSSupport = new Hashtable();
    private Hashtable fRedefinedRestrictedAttributeGroupRegistry = new Hashtable();
    private Hashtable fRedefinedRestrictedGroupRegistry = new Hashtable();
    private boolean fLastSchemaWasDuplicate;
    private XMLErrorReporter fErrorReporter;
    private XMLEntityResolver fEntityResolver;
    private XSAttributeChecker fAttributeChecker;
    private SymbolTable fSymbolTable;
    private XSGrammarBucket fGrammarBucket;
    private XSDDescription fSchemaGrammarDescription;
    private XMLGrammarPool fGrammarPool;
    XSDAttributeGroupTraverser fAttributeGroupTraverser;
    XSDAttributeTraverser fAttributeTraverser;
    XSDComplexTypeTraverser fComplexTypeTraverser;
    XSDElementTraverser fElementTraverser;
    XSDGroupTraverser fGroupTraverser;
    XSDKeyrefTraverser fKeyrefTraverser;
    XSDNotationTraverser fNotationTraverser;
    XSDSimpleTypeTraverser fSimpleTypeTraverser;
    XSDUniqueOrKeyTraverser fUniqueOrKeyTraverser;
    XSDWildcardTraverser fWildCardTraverser;
    DOMParser fSchemaParser;
    final DOMNodePool fDOMPool = new DOMNodePool();
    private static final int INIT_STACK_SIZE = 30;
    private static final int INC_STACK_SIZE = 10;
    private int fLocalElemStackPos = 0;
    private XSParticleDecl[] fParticle = new XSParticleDecl[30];
    private Element[] fLocalElementDecl = new Element[30];
    private int[] fAllContext = new int[30];
    private XSComplexTypeDecl[] fEnclosingCT = new XSComplexTypeDecl[30];
    private String[][] fLocalElemNamespaceContext = new String[30][1];
    private static final int INIT_KEYREF_STACK = 2;
    private static final int INC_KEYREF_STACK_AMOUNT = 2;
    private int fKeyrefStackPos = 0;
    private Element[] fKeyrefs = new Element[2];
    private XSElementDecl[] fKeyrefElems = new XSElementDecl[2];
    private String[][] fKeyrefNamespaceContext = new String[2][1];
    private static final String[][] NS_ERROR_CODES = new String[][]{{"src-include.2.1", "src-include.2.1"}, {"src-redefine.3.1", "src-redefine.3.1"}, {"src-import.3.1", "src-import.3.2"}, null, {"TargetNamespace.1", "TargetNamespace.2"}, {"TargetNamespace.1", "TargetNamespace.2"}, {"TargetNamespace.1", "TargetNamespace.2"}, {"TargetNamespace.1", "TargetNamespace.2"}};
    private static final String[] ELE_ERROR_CODES = new String[]{"src-include.1", "src-redefine.2", "src-import.2", "schema_reference.4", "schema_reference.4", "schema_reference.4", "schema_reference.4", "schema_reference.4"};
    private Vector fReportedTNS = null;
    private static final String[] COMP_TYPE = new String[]{null, "attribute declaration", "attribute group", "elment declaration", "group", "identity constraint", "notation", "type definition"};
    private static final String[] DOC_ERROR_CODES = new String[]{"src-include.0", "src-redefine.0", "src-import.0", "schema_reference.4", "schema_reference.4", "schema_reference.4", "schema_reference.4", "schema_reference.4"};
    private SimpleLocator xl = new SimpleLocator();

    private String null2EmptyString(String ns) {
        return ns == null ? this.EMPTY_STRING : ns;
    }

    private String emptyString2Null(String ns) {
        return ns == this.EMPTY_STRING ? null : ns;
    }

    public XSDHandler(XSGrammarBucket gBucket) {
        this.fGrammarBucket = gBucket;
        this.fSchemaGrammarDescription = new XSDDescription();
    }

    public SchemaGrammar parseSchema(XMLInputSource is, XSDDescription desc, Hashtable locationPairs) {
        Element schemaElem;
        this.fLocationPairs = locationPairs;
        SchemaGrammar grammar = this.findGrammar(desc);
        if (grammar != null) {
            return grammar;
        }
        this.fDOMPool.reset();
        if (this.fSchemaParser != null) {
            this.fSchemaParser.setPool(this.fDOMPool);
        }
        short referType = desc.getContextType();
        String schemaNamespace = desc.getTargetNamespace();
        if (schemaNamespace != null) {
            schemaNamespace = this.fSymbolTable.addSymbol(schemaNamespace);
        }
        this.prepareForParse();
        Document schemaRoot = this.getSchema(schemaNamespace, is, referType == 3, referType, null);
        if (schemaRoot == null) {
            return null;
        }
        if (schemaNamespace == null && referType == 3 && (schemaNamespace = DOMUtil.getAttrValue(schemaElem = DOMUtil.getRoot(schemaRoot), SchemaSymbols.ATT_TARGETNAMESPACE)) != null && schemaNamespace.length() > 0) {
            this.fSymbolTable.addSymbol(schemaNamespace);
            desc.setTargetNamespace(schemaNamespace);
            String schemaId = XMLEntityManager.expandSystemId(desc.getLiteralSystemId(), desc.getBaseSystemId());
            XSDKey key = new XSDKey(schemaId, referType, schemaNamespace);
            this.fTraversed.put(key, schemaRoot);
            if (schemaId != null) {
                this.fDoc2SystemId.put(schemaRoot, schemaId);
            }
        }
        this.prepareForTraverse();
        this.fRoot = this.constructTrees(schemaRoot, is.getSystemId(), desc);
        if (this.fRoot == null) {
            return null;
        }
        this.buildGlobalNameRegistries();
        this.traverseSchemas();
        this.traverseLocalElements();
        this.resolveKeyRefs();
        int i = this.fAllTNSs.size() - 1;
        while (i >= 0) {
            String tns = (String)this.fAllTNSs.elementAt(i);
            Vector ins = (Vector)this.fImportMap.get(tns);
            SchemaGrammar sg = this.fGrammarBucket.getGrammar(this.emptyString2Null(tns));
            if (sg != null) {
                int count = 0;
                int j = 0;
                while (j < ins.size()) {
                    SchemaGrammar isg = this.fGrammarBucket.getGrammar((String)ins.elementAt(j));
                    if (isg != null) {
                        ins.setElementAt(isg, count++);
                    }
                    ++j;
                }
                ins.setSize(count);
                sg.setImportedGrammars(ins);
            }
            --i;
        }
        return this.fGrammarBucket.getGrammar(this.fRoot.fTargetNamespace);
    }

    protected SchemaGrammar findGrammar(XSDDescription desc) {
        SchemaGrammar sg = this.fGrammarBucket.getGrammar(desc.getTargetNamespace());
        if (sg == null && this.fGrammarPool != null && (sg = (SchemaGrammar)this.fGrammarPool.retrieveGrammar(desc)) != null && !this.fGrammarBucket.putGrammar(sg, true)) {
            this.reportSchemaWarning("GrammarConflict", null, null);
            sg = null;
        }
        return sg;
    }

    protected XSDocumentInfo constructTrees(Document schemaRoot, String locationHint, XSDDescription desc) {
        if (schemaRoot == null) {
            return null;
        }
        String callerTNS = desc.getTargetNamespace();
        short referType = desc.getContextType();
        XSDocumentInfo currSchemaInfo = null;
        try {
            currSchemaInfo = new XSDocumentInfo(schemaRoot, this.fAttributeChecker, this.fSymbolTable);
        }
        catch (XMLSchemaException se) {
            this.reportSchemaError(ELE_ERROR_CODES[referType], new Object[]{locationHint}, DOMUtil.getRoot(schemaRoot));
            return null;
        }
        if (currSchemaInfo.fTargetNamespace != null && currSchemaInfo.fTargetNamespace.length() == 0) {
            this.reportSchemaWarning("EmptyTargetNamespace", new Object[]{locationHint}, DOMUtil.getRoot(schemaRoot));
            currSchemaInfo.fTargetNamespace = null;
        }
        if (callerTNS != null) {
            int secondIdx = 0;
            if (referType == 0 || referType == 1) {
                if (currSchemaInfo.fTargetNamespace == null) {
                    currSchemaInfo.fTargetNamespace = callerTNS;
                    currSchemaInfo.fIsChameleonSchema = true;
                } else if (callerTNS != currSchemaInfo.fTargetNamespace) {
                    this.reportSchemaError(NS_ERROR_CODES[referType][secondIdx], new Object[]{callerTNS, currSchemaInfo.fTargetNamespace}, DOMUtil.getRoot(schemaRoot));
                    return null;
                }
            } else if (referType != 3 && callerTNS != currSchemaInfo.fTargetNamespace) {
                this.reportSchemaError(NS_ERROR_CODES[referType][secondIdx], new Object[]{callerTNS, currSchemaInfo.fTargetNamespace}, DOMUtil.getRoot(schemaRoot));
                return null;
            }
        } else if (currSchemaInfo.fTargetNamespace != null) {
            if (referType == 3) {
                desc.setTargetNamespace(currSchemaInfo.fTargetNamespace);
                callerTNS = currSchemaInfo.fTargetNamespace;
            } else {
                int secondIdx = 1;
                this.reportSchemaError(NS_ERROR_CODES[referType][secondIdx], new Object[]{callerTNS, currSchemaInfo.fTargetNamespace}, DOMUtil.getRoot(schemaRoot));
                return null;
            }
        }
        currSchemaInfo.addAllowedNS(currSchemaInfo.fTargetNamespace);
        SchemaGrammar sg = null;
        if (referType == 0 || referType == 1) {
            sg = this.fGrammarBucket.getGrammar(currSchemaInfo.fTargetNamespace);
        } else {
            sg = new SchemaGrammar(currSchemaInfo.fTargetNamespace, desc.makeClone());
            this.fGrammarBucket.putGrammar(sg);
        }
        sg.addDocument(null, (String)this.fDoc2SystemId.get(currSchemaInfo));
        this.fDoc2XSDocumentMap.put(schemaRoot, currSchemaInfo);
        Vector<XSDocumentInfo> dependencies = new Vector<XSDocumentInfo>();
        Element rootNode = DOMUtil.getRoot(schemaRoot);
        Document newSchemaRoot = null;
        Element child = DOMUtil.getFirstChildElement(rootNode);
        while (child != null) {
            block29: {
                String localName;
                String schemaHint;
                block31: {
                    Object[] includeAttrs;
                    short refType;
                    String schemaNamespace;
                    block30: {
                        schemaNamespace = null;
                        schemaHint = null;
                        localName = DOMUtil.getLocalName(child);
                        refType = -1;
                        if (localName.equals(SchemaSymbols.ELT_ANNOTATION)) break block29;
                        if (!localName.equals(SchemaSymbols.ELT_IMPORT)) break block30;
                        refType = 2;
                        includeAttrs = this.fAttributeChecker.checkAttributes(child, true, currSchemaInfo);
                        schemaHint = (String)includeAttrs[XSAttributeChecker.ATTIDX_SCHEMALOCATION];
                        schemaNamespace = (String)includeAttrs[XSAttributeChecker.ATTIDX_NAMESPACE];
                        if (schemaNamespace != null) {
                            schemaNamespace = this.fSymbolTable.addSymbol(schemaNamespace);
                        }
                        if (schemaNamespace == currSchemaInfo.fTargetNamespace) {
                            this.reportSchemaError("src-import.1.1", new Object[]{schemaNamespace}, child);
                        }
                        this.fAttributeChecker.returnAttrArray(includeAttrs, currSchemaInfo);
                        if (currSchemaInfo.isAllowedNS(schemaNamespace)) break block29;
                        currSchemaInfo.addAllowedNS(schemaNamespace);
                        String tns = this.null2EmptyString(currSchemaInfo.fTargetNamespace);
                        Vector<String> ins = (Vector<String>)this.fImportMap.get(tns);
                        if (ins == null) {
                            this.fAllTNSs.addElement(tns);
                            ins = new Vector<String>();
                            this.fImportMap.put(tns, ins);
                            ins.addElement(schemaNamespace);
                        } else if (!ins.contains(schemaNamespace)) {
                            ins.addElement(schemaNamespace);
                        }
                        this.fSchemaGrammarDescription.reset();
                        this.fSchemaGrammarDescription.setContextType((short)2);
                        this.fSchemaGrammarDescription.setBaseSystemId((String)this.fDoc2SystemId.get(schemaRoot));
                        this.fSchemaGrammarDescription.setLocationHints(new String[]{schemaHint});
                        this.fSchemaGrammarDescription.setTargetNamespace(schemaNamespace);
                        if (this.findGrammar(this.fSchemaGrammarDescription) != null) break block29;
                        newSchemaRoot = this.getSchema(this.fSchemaGrammarDescription, false, child);
                        break block31;
                    }
                    if (!localName.equals(SchemaSymbols.ELT_INCLUDE) && !localName.equals(SchemaSymbols.ELT_REDEFINE)) break;
                    includeAttrs = this.fAttributeChecker.checkAttributes(child, true, currSchemaInfo);
                    schemaHint = (String)includeAttrs[XSAttributeChecker.ATTIDX_SCHEMALOCATION];
                    if (localName.equals(SchemaSymbols.ELT_REDEFINE)) {
                        this.fRedefine2NSSupport.put(child, new SchemaNamespaceSupport(currSchemaInfo.fNamespaceSupport));
                    }
                    this.fAttributeChecker.returnAttrArray(includeAttrs, currSchemaInfo);
                    if (schemaHint == null) {
                        this.reportSchemaError("s4s-att-must-appear", new Object[]{"<include> or <redefine>", "schemaLocation"}, child);
                    }
                    boolean mustResolve = false;
                    refType = 0;
                    if (localName.equals(SchemaSymbols.ELT_REDEFINE)) {
                        mustResolve = this.nonAnnotationContent(child);
                        refType = 1;
                    }
                    this.fSchemaGrammarDescription.reset();
                    this.fSchemaGrammarDescription.setContextType(refType);
                    this.fSchemaGrammarDescription.setBaseSystemId((String)this.fDoc2SystemId.get(schemaRoot));
                    this.fSchemaGrammarDescription.setLocationHints(new String[]{schemaHint});
                    this.fSchemaGrammarDescription.setTargetNamespace(callerTNS);
                    newSchemaRoot = this.getSchema(this.fSchemaGrammarDescription, mustResolve, child);
                    schemaNamespace = currSchemaInfo.fTargetNamespace;
                }
                XSDocumentInfo newSchemaInfo = null;
                newSchemaInfo = this.fLastSchemaWasDuplicate ? (XSDocumentInfo)this.fDoc2XSDocumentMap.get(newSchemaRoot) : this.constructTrees(newSchemaRoot, schemaHint, this.fSchemaGrammarDescription);
                if (localName.equals(SchemaSymbols.ELT_REDEFINE) && newSchemaInfo != null) {
                    this.fRedefine2XSDMap.put(child, newSchemaInfo);
                }
                if (newSchemaRoot != null) {
                    if (newSchemaInfo != null) {
                        dependencies.addElement(newSchemaInfo);
                    }
                    newSchemaRoot = null;
                }
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        this.fDependencyMap.put(currSchemaInfo, dependencies);
        return currSchemaInfo;
    }

    protected void buildGlobalNameRegistries() {
        Stack<XSDocumentInfo> schemasToProcess = new Stack<XSDocumentInfo>();
        schemasToProcess.push(this.fRoot);
        while (!schemasToProcess.empty()) {
            XSDocumentInfo currSchemaDoc = (XSDocumentInfo)schemasToProcess.pop();
            Document currDoc = currSchemaDoc.fSchemaDoc;
            if (DOMUtil.isHidden(currDoc)) continue;
            Element currRoot = DOMUtil.getRoot(currDoc);
            boolean dependenciesCanOccur = true;
            Element globalComp = DOMUtil.getFirstChildElement(currRoot);
            while (globalComp != null) {
                if (!DOMUtil.getLocalName(globalComp).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    if (DOMUtil.getLocalName(globalComp).equals(SchemaSymbols.ELT_INCLUDE) || DOMUtil.getLocalName(globalComp).equals(SchemaSymbols.ELT_IMPORT)) {
                        if (!dependenciesCanOccur) {
                            this.reportSchemaError("sch-props-correct.1", new Object[]{DOMUtil.getLocalName(globalComp)}, globalComp);
                        }
                        DOMUtil.setHidden(globalComp);
                    } else if (DOMUtil.getLocalName(globalComp).equals(SchemaSymbols.ELT_REDEFINE)) {
                        if (!dependenciesCanOccur) {
                            this.reportSchemaError("sch-props-correct.1", new Object[]{DOMUtil.getLocalName(globalComp)}, globalComp);
                        }
                        Element redefineComp = DOMUtil.getFirstChildElement(globalComp);
                        while (redefineComp != null) {
                            String lName = DOMUtil.getAttrValue(redefineComp, SchemaSymbols.ATT_NAME);
                            if (lName.length() != 0) {
                                String targetLName;
                                String qName = currSchemaDoc.fTargetNamespace == null ? "," + lName : currSchemaDoc.fTargetNamespace + "," + lName;
                                String componentType = DOMUtil.getLocalName(redefineComp);
                                if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
                                    this.checkForDuplicateNames(qName, this.fUnparsedAttributeGroupRegistry, redefineComp, currSchemaDoc);
                                    targetLName = DOMUtil.getAttrValue(redefineComp, SchemaSymbols.ATT_NAME) + REDEF_IDENTIFIER;
                                    this.renameRedefiningComponents(currSchemaDoc, redefineComp, SchemaSymbols.ELT_ATTRIBUTEGROUP, lName, targetLName);
                                } else if (componentType.equals(SchemaSymbols.ELT_COMPLEXTYPE) || componentType.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                                    this.checkForDuplicateNames(qName, this.fUnparsedTypeRegistry, redefineComp, currSchemaDoc);
                                    targetLName = DOMUtil.getAttrValue(redefineComp, SchemaSymbols.ATT_NAME) + REDEF_IDENTIFIER;
                                    if (componentType.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
                                        this.renameRedefiningComponents(currSchemaDoc, redefineComp, SchemaSymbols.ELT_COMPLEXTYPE, lName, targetLName);
                                    } else {
                                        this.renameRedefiningComponents(currSchemaDoc, redefineComp, SchemaSymbols.ELT_SIMPLETYPE, lName, targetLName);
                                    }
                                } else if (componentType.equals(SchemaSymbols.ELT_GROUP)) {
                                    this.checkForDuplicateNames(qName, this.fUnparsedGroupRegistry, redefineComp, currSchemaDoc);
                                    targetLName = DOMUtil.getAttrValue(redefineComp, SchemaSymbols.ATT_NAME) + REDEF_IDENTIFIER;
                                    this.renameRedefiningComponents(currSchemaDoc, redefineComp, SchemaSymbols.ELT_GROUP, lName, targetLName);
                                }
                            }
                            redefineComp = DOMUtil.getNextSiblingElement(redefineComp);
                        }
                    } else {
                        dependenciesCanOccur = false;
                        String lName = DOMUtil.getAttrValue(globalComp, SchemaSymbols.ATT_NAME);
                        if (lName.length() != 0) {
                            String qName = currSchemaDoc.fTargetNamespace == null ? "," + lName : currSchemaDoc.fTargetNamespace + "," + lName;
                            String componentType = DOMUtil.getLocalName(globalComp);
                            if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTE)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedAttributeRegistry, globalComp, currSchemaDoc);
                            } else if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedAttributeGroupRegistry, globalComp, currSchemaDoc);
                            } else if (componentType.equals(SchemaSymbols.ELT_COMPLEXTYPE) || componentType.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedTypeRegistry, globalComp, currSchemaDoc);
                            } else if (componentType.equals(SchemaSymbols.ELT_ELEMENT)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedElementRegistry, globalComp, currSchemaDoc);
                            } else if (componentType.equals(SchemaSymbols.ELT_GROUP)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedGroupRegistry, globalComp, currSchemaDoc);
                            } else if (componentType.equals(SchemaSymbols.ELT_NOTATION)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedNotationRegistry, globalComp, currSchemaDoc);
                            }
                        }
                    }
                }
                globalComp = DOMUtil.getNextSiblingElement(globalComp);
            }
            DOMUtil.setHidden(currDoc);
            Vector currSchemaDepends = (Vector)this.fDependencyMap.get(currSchemaDoc);
            int i = 0;
            while (i < currSchemaDepends.size()) {
                schemasToProcess.push((XSDocumentInfo)currSchemaDepends.elementAt(i));
                ++i;
            }
        }
    }

    protected void traverseSchemas() {
        this.setSchemasVisible(this.fRoot);
        Stack<XSDocumentInfo> schemasToProcess = new Stack<XSDocumentInfo>();
        schemasToProcess.push(this.fRoot);
        while (!schemasToProcess.empty()) {
            XSDocumentInfo currSchemaDoc = (XSDocumentInfo)schemasToProcess.pop();
            Document currDoc = currSchemaDoc.fSchemaDoc;
            SchemaGrammar currSG = this.fGrammarBucket.getGrammar(currSchemaDoc.fTargetNamespace);
            if (DOMUtil.isHidden(currDoc)) continue;
            Element currRoot = DOMUtil.getRoot(currDoc);
            Element globalComp = DOMUtil.getFirstVisibleChildElement(currRoot);
            while (globalComp != null) {
                DOMUtil.setHidden(globalComp);
                String componentType = DOMUtil.getLocalName(globalComp);
                if (DOMUtil.getLocalName(globalComp).equals(SchemaSymbols.ELT_REDEFINE)) {
                    currSchemaDoc.backupNSSupport((SchemaNamespaceSupport)this.fRedefine2NSSupport.get(globalComp));
                    Element redefinedComp = DOMUtil.getFirstVisibleChildElement(globalComp);
                    while (redefinedComp != null) {
                        String redefinedComponentType = DOMUtil.getLocalName(redefinedComp);
                        DOMUtil.setHidden(redefinedComp);
                        if (redefinedComponentType.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
                            this.fAttributeGroupTraverser.traverseGlobal(redefinedComp, currSchemaDoc, currSG);
                        } else if (redefinedComponentType.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
                            this.fComplexTypeTraverser.traverseGlobal(redefinedComp, currSchemaDoc, currSG);
                        } else if (redefinedComponentType.equals(SchemaSymbols.ELT_GROUP)) {
                            this.fGroupTraverser.traverseGlobal(redefinedComp, currSchemaDoc, currSG);
                        } else if (redefinedComponentType.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                            this.fSimpleTypeTraverser.traverseGlobal(redefinedComp, currSchemaDoc, currSG);
                        } else if (redefinedComponentType.equals(SchemaSymbols.ELT_ANNOTATION)) {
                            this.fElementTraverser.traverseAnnotationDecl(redefinedComp, null, true, currSchemaDoc);
                        } else {
                            this.reportSchemaError("src-redefine", new Object[]{componentType}, redefinedComp);
                        }
                        redefinedComp = DOMUtil.getNextVisibleSiblingElement(redefinedComp);
                    }
                    currSchemaDoc.restoreNSSupport();
                } else if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTE)) {
                    this.fAttributeTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
                    this.fAttributeGroupTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
                    this.fComplexTypeTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_ELEMENT)) {
                    this.fElementTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_GROUP)) {
                    this.fGroupTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_NOTATION)) {
                    this.fNotationTraverser.traverse(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                    this.fSimpleTypeTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_ANNOTATION)) {
                    this.fElementTraverser.traverseAnnotationDecl(globalComp, null, true, currSchemaDoc);
                } else {
                    this.reportSchemaError("sch-props-correct.1", new Object[]{DOMUtil.getLocalName(globalComp)}, globalComp);
                }
                globalComp = DOMUtil.getNextVisibleSiblingElement(globalComp);
            }
            DOMUtil.setHidden(currDoc);
            Vector currSchemaDepends = (Vector)this.fDependencyMap.get(currSchemaDoc);
            int i = 0;
            while (i < currSchemaDepends.size()) {
                schemasToProcess.push((XSDocumentInfo)currSchemaDepends.elementAt(i));
                ++i;
            }
        }
    }

    private final boolean needReportTNSError(String uri) {
        if (this.fReportedTNS == null) {
            this.fReportedTNS = new Vector();
        } else if (this.fReportedTNS.contains(uri)) {
            return false;
        }
        this.fReportedTNS.addElement(uri);
        return true;
    }

    protected Object getGlobalDecl(XSDocumentInfo currSchema, int declType, QName declToTraverse, Element elmNode) {
        XSTypeDecl retObj;
        if (declToTraverse.uri != null && declToTraverse.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && declType == 7 && (retObj = SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl(declToTraverse.localpart)) != null) {
            return retObj;
        }
        if (!currSchema.isAllowedNS(declToTraverse.uri)) {
            if (currSchema.needReportTNSError(declToTraverse.uri)) {
                this.reportSchemaError("src-resolve.4", new Object[]{this.fDoc2SystemId.get(currSchema.fSchemaDoc), declToTraverse.uri}, elmNode);
            }
            return null;
        }
        SchemaGrammar sGrammar = this.fGrammarBucket.getGrammar(declToTraverse.uri);
        if (sGrammar == null) {
            if (this.needReportTNSError(declToTraverse.uri)) {
                this.reportSchemaError("src-resolve", new Object[]{declToTraverse.rawname, COMP_TYPE[declType]}, elmNode);
            }
            return null;
        }
        XSObject retObj2 = null;
        switch (declType) {
            case 1: {
                retObj2 = sGrammar.getGlobalAttributeDecl(declToTraverse.localpart);
                break;
            }
            case 2: {
                retObj2 = sGrammar.getGlobalAttributeGroupDecl(declToTraverse.localpart);
                break;
            }
            case 3: {
                retObj2 = sGrammar.getGlobalElementDecl(declToTraverse.localpart);
                break;
            }
            case 4: {
                retObj2 = sGrammar.getGlobalGroupDecl(declToTraverse.localpart);
                break;
            }
            case 5: {
                retObj2 = sGrammar.getIDConstraintDecl(declToTraverse.localpart);
                break;
            }
            case 6: {
                retObj2 = sGrammar.getGlobalNotationDecl(declToTraverse.localpart);
                break;
            }
            case 7: {
                retObj2 = sGrammar.getGlobalTypeDecl(declToTraverse.localpart);
            }
        }
        if (retObj2 != null) {
            return retObj2;
        }
        XSDocumentInfo schemaWithDecl = null;
        Element decl = null;
        String declKey = declToTraverse.uri == null ? "," + declToTraverse.localpart : declToTraverse.uri + "," + declToTraverse.localpart;
        switch (declType) {
            case 1: {
                decl = (Element)this.fUnparsedAttributeRegistry.get(declKey);
                break;
            }
            case 2: {
                decl = (Element)this.fUnparsedAttributeGroupRegistry.get(declKey);
                break;
            }
            case 3: {
                decl = (Element)this.fUnparsedElementRegistry.get(declKey);
                break;
            }
            case 4: {
                decl = (Element)this.fUnparsedGroupRegistry.get(declKey);
                break;
            }
            case 5: {
                decl = (Element)this.fUnparsedIdentityConstraintRegistry.get(declKey);
                break;
            }
            case 6: {
                decl = (Element)this.fUnparsedNotationRegistry.get(declKey);
                break;
            }
            case 7: {
                decl = (Element)this.fUnparsedTypeRegistry.get(declKey);
                break;
            }
            default: {
                this.reportSchemaError("Internal-Error", new Object[]{"XSDHandler asked to locate component of type " + declType + "; it does not recognize this type!"}, elmNode);
            }
        }
        if (decl == null) {
            this.reportSchemaError("src-resolve", new Object[]{declToTraverse.rawname, COMP_TYPE[declType]}, elmNode);
            return null;
        }
        schemaWithDecl = this.findXSDocumentForDecl(currSchema, decl);
        if (schemaWithDecl == null) {
            this.reportSchemaError("src-resolve.4", new Object[]{this.fDoc2SystemId.get(currSchema.fSchemaDoc), declToTraverse.uri}, elmNode);
            return null;
        }
        if (DOMUtil.isHidden(decl)) {
            this.reportSchemaError("st-props-correct.2", new Object[]{declToTraverse.prefix + ":" + declToTraverse.localpart}, elmNode);
            return null;
        }
        DOMUtil.setHidden(decl);
        SchemaNamespaceSupport nsSupport = null;
        Element parent = DOMUtil.getParent(decl);
        if (DOMUtil.getLocalName(parent).equals(SchemaSymbols.ELT_REDEFINE)) {
            nsSupport = (SchemaNamespaceSupport)this.fRedefine2NSSupport.get(parent);
        }
        schemaWithDecl.backupNSSupport(nsSupport);
        switch (declType) {
            case 1: {
                retObj2 = this.fAttributeTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar);
                break;
            }
            case 2: {
                retObj2 = this.fAttributeGroupTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar);
                break;
            }
            case 3: {
                retObj2 = this.fElementTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar);
                break;
            }
            case 4: {
                retObj2 = this.fGroupTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar);
                break;
            }
            case 5: {
                retObj2 = null;
                break;
            }
            case 6: {
                retObj2 = this.fNotationTraverser.traverse(decl, schemaWithDecl, sGrammar);
                break;
            }
            case 7: {
                retObj2 = DOMUtil.getLocalName(decl).equals(SchemaSymbols.ELT_COMPLEXTYPE) ? this.fComplexTypeTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar) : this.fSimpleTypeTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar);
            }
        }
        schemaWithDecl.restoreNSSupport();
        return retObj2;
    }

    Object getGrpOrAttrGrpRedefinedByRestriction(int type, QName name, XSDocumentInfo currSchema, Element elmNode) {
        String realName = name.uri != null ? name.uri + "," + name.localpart : "," + name.localpart;
        String nameToFind = null;
        switch (type) {
            case 2: {
                nameToFind = (String)this.fRedefinedRestrictedAttributeGroupRegistry.get(realName);
                break;
            }
            case 4: {
                nameToFind = (String)this.fRedefinedRestrictedGroupRegistry.get(realName);
                break;
            }
            default: {
                return null;
            }
        }
        if (nameToFind == null) {
            return null;
        }
        int commaPos = nameToFind.indexOf(",");
        QName qNameToFind = new QName(this.EMPTY_STRING, nameToFind.substring(commaPos + 1), nameToFind.substring(commaPos), commaPos == 0 ? null : nameToFind.substring(0, commaPos));
        Object retObj = this.getGlobalDecl(currSchema, type, qNameToFind, elmNode);
        if (retObj == null) {
            switch (type) {
                case 2: {
                    this.reportSchemaError("src-redefine.7.2.1", new Object[]{name.localpart}, elmNode);
                    break;
                }
                case 4: {
                    this.reportSchemaError("src-redefine.6.2.1", new Object[]{name.localpart}, elmNode);
                }
            }
            return null;
        }
        return retObj;
    }

    protected void resolveKeyRefs() {
        int i = 0;
        while (i < this.fKeyrefStackPos) {
            Document keyrefDoc = DOMUtil.getDocument(this.fKeyrefs[i]);
            XSDocumentInfo keyrefSchemaDoc = (XSDocumentInfo)this.fDoc2XSDocumentMap.get(keyrefDoc);
            keyrefSchemaDoc.fNamespaceSupport.makeGlobal();
            keyrefSchemaDoc.fNamespaceSupport.setEffectiveContext(this.fKeyrefNamespaceContext[i]);
            SchemaGrammar keyrefGrammar = this.fGrammarBucket.getGrammar(keyrefSchemaDoc.fTargetNamespace);
            DOMUtil.setHidden(this.fKeyrefs[i]);
            this.fKeyrefTraverser.traverse(this.fKeyrefs[i], this.fKeyrefElems[i], keyrefSchemaDoc, keyrefGrammar);
            ++i;
        }
    }

    protected Hashtable getIDRegistry() {
        return this.fUnparsedIdentityConstraintRegistry;
    }

    protected void storeKeyRef(Element keyrefToStore, XSDocumentInfo schemaDoc, XSElementDecl currElemDecl) {
        String keyrefName = DOMUtil.getAttrValue(keyrefToStore, SchemaSymbols.ATT_NAME);
        if (keyrefName.length() != 0) {
            String keyrefQName = schemaDoc.fTargetNamespace == null ? "," + keyrefName : schemaDoc.fTargetNamespace + "," + keyrefName;
            this.checkForDuplicateNames(keyrefQName, this.fUnparsedIdentityConstraintRegistry, keyrefToStore, schemaDoc);
        }
        if (this.fKeyrefStackPos == this.fKeyrefs.length) {
            Element[] elemArray = new Element[this.fKeyrefStackPos + 2];
            System.arraycopy(this.fKeyrefs, 0, elemArray, 0, this.fKeyrefStackPos);
            this.fKeyrefs = elemArray;
            XSElementDecl[] declArray = new XSElementDecl[this.fKeyrefStackPos + 2];
            System.arraycopy(this.fKeyrefElems, 0, declArray, 0, this.fKeyrefStackPos);
            this.fKeyrefElems = declArray;
            String[][] stringArray = new String[this.fKeyrefStackPos + 2][];
            System.arraycopy(this.fKeyrefNamespaceContext, 0, stringArray, 0, this.fKeyrefStackPos);
            this.fKeyrefNamespaceContext = stringArray;
        }
        this.fKeyrefs[this.fKeyrefStackPos] = keyrefToStore;
        this.fKeyrefElems[this.fKeyrefStackPos] = currElemDecl;
        this.fKeyrefNamespaceContext[this.fKeyrefStackPos++] = schemaDoc.fNamespaceSupport.getEffectiveLocalContext();
    }

    private Document getSchema(XSDDescription desc, boolean mustResolve, Element referElement) {
        XMLInputSource schemaSource = null;
        try {
            schemaSource = XMLSchemaLoader.resolveDocument(desc, this.fLocationPairs, this.fEntityResolver);
        }
        catch (IOException ex) {
            if (mustResolve) {
                this.reportSchemaError(DOC_ERROR_CODES[desc.getContextType()], new Object[]{desc.getLocationHints()[0]}, referElement);
            }
            this.reportSchemaWarning(DOC_ERROR_CODES[desc.getContextType()], new Object[]{desc.getLocationHints()[0]}, referElement);
        }
        return this.getSchema(desc.getTargetNamespace(), schemaSource, mustResolve, desc.getContextType(), referElement);
    }

    private Document getSchema(String schemaNamespace, XMLInputSource schemaSource, boolean mustResolve, short referType, Element referElement) {
        boolean hasInput = true;
        Document schemaDoc = null;
        try {
            if (schemaSource != null && (schemaSource.getSystemId() != null || schemaSource.getByteStream() != null || schemaSource.getCharacterStream() != null)) {
                String schemaId = XMLEntityManager.expandSystemId(schemaSource.getSystemId(), schemaSource.getBaseSystemId());
                XSDKey key = new XSDKey(schemaId, referType, schemaNamespace);
                schemaDoc = (Document)this.fTraversed.get(key);
                if (schemaDoc != null) {
                    this.fLastSchemaWasDuplicate = true;
                    return schemaDoc;
                }
                if (this.fSchemaParser == null) {
                    this.fSchemaParser = new DOMParser();
                    this.resetSchemaParserErrorHandler();
                    this.fSchemaParser.setPool(this.fDOMPool);
                }
                this.fSchemaParser.reset();
                this.fSchemaParser.parse(schemaSource);
                schemaDoc = this.fSchemaParser.getDocument();
                this.fTraversed.put(key, schemaDoc);
                if (schemaId != null) {
                    this.fDoc2SystemId.put(schemaDoc, schemaId);
                }
                this.fLastSchemaWasDuplicate = false;
                return schemaDoc;
            }
            hasInput = false;
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (mustResolve) {
            this.reportSchemaError(DOC_ERROR_CODES[referType], new Object[]{schemaSource.getSystemId()}, referElement);
        } else if (hasInput) {
            this.reportSchemaWarning(DOC_ERROR_CODES[referType], new Object[]{schemaSource.getSystemId()}, referElement);
        }
        this.fLastSchemaWasDuplicate = false;
        return null;
    }

    private void createTraversers() {
        this.fAttributeChecker = new XSAttributeChecker(this);
        this.fAttributeGroupTraverser = new XSDAttributeGroupTraverser(this, this.fAttributeChecker);
        this.fAttributeTraverser = new XSDAttributeTraverser(this, this.fAttributeChecker);
        this.fComplexTypeTraverser = new XSDComplexTypeTraverser(this, this.fAttributeChecker);
        this.fElementTraverser = new XSDElementTraverser(this, this.fAttributeChecker);
        this.fGroupTraverser = new XSDGroupTraverser(this, this.fAttributeChecker);
        this.fKeyrefTraverser = new XSDKeyrefTraverser(this, this.fAttributeChecker);
        this.fNotationTraverser = new XSDNotationTraverser(this, this.fAttributeChecker);
        this.fSimpleTypeTraverser = new XSDSimpleTypeTraverser(this, this.fAttributeChecker);
        this.fUniqueOrKeyTraverser = new XSDUniqueOrKeyTraverser(this, this.fAttributeChecker);
        this.fWildCardTraverser = new XSDWildcardTraverser(this, this.fAttributeChecker);
    }

    void prepareForParse() {
        this.fTraversed.clear();
        this.fDoc2SystemId.clear();
        this.fLastSchemaWasDuplicate = false;
    }

    void prepareForTraverse() {
        this.fUnparsedAttributeRegistry.clear();
        this.fUnparsedAttributeGroupRegistry.clear();
        this.fUnparsedElementRegistry.clear();
        this.fUnparsedGroupRegistry.clear();
        this.fUnparsedIdentityConstraintRegistry.clear();
        this.fUnparsedNotationRegistry.clear();
        this.fUnparsedTypeRegistry.clear();
        this.fXSDocumentInfoRegistry.clear();
        this.fDependencyMap.clear();
        this.fDoc2XSDocumentMap.clear();
        this.fRedefine2XSDMap.clear();
        this.fRedefine2NSSupport.clear();
        this.fAllTNSs.removeAllElements();
        this.fImportMap.clear();
        this.fRoot = null;
        int i = 0;
        while (i < this.fLocalElemStackPos) {
            this.fParticle[i] = null;
            this.fLocalElementDecl[i] = null;
            this.fLocalElemNamespaceContext[i] = null;
            ++i;
        }
        this.fLocalElemStackPos = 0;
        int i2 = 0;
        while (i2 < this.fKeyrefStackPos) {
            this.fKeyrefs[i2] = null;
            this.fKeyrefElems[i2] = null;
            this.fKeyrefNamespaceContext[i2] = null;
            ++i2;
        }
        this.fKeyrefStackPos = 0;
        if (this.fAttributeChecker == null) {
            this.createTraversers();
        }
        this.fAttributeChecker.reset(this.fSymbolTable);
        this.fAttributeGroupTraverser.reset(this.fSymbolTable);
        this.fAttributeTraverser.reset(this.fSymbolTable);
        this.fComplexTypeTraverser.reset(this.fSymbolTable);
        this.fElementTraverser.reset(this.fSymbolTable);
        this.fGroupTraverser.reset(this.fSymbolTable);
        this.fKeyrefTraverser.reset(this.fSymbolTable);
        this.fNotationTraverser.reset(this.fSymbolTable);
        this.fSimpleTypeTraverser.reset(this.fSymbolTable);
        this.fUniqueOrKeyTraverser.reset(this.fSymbolTable);
        this.fWildCardTraverser.reset(this.fSymbolTable);
        this.fRedefinedRestrictedAttributeGroupRegistry.clear();
        this.fRedefinedRestrictedGroupRegistry.clear();
    }

    public void setDeclPool(XSDeclarationPool declPool) {
        this.fDeclPool = declPool;
    }

    public void reset(XMLErrorReporter errorReporter, XMLEntityResolver entityResolver, SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        this.fErrorReporter = errorReporter;
        this.fEntityResolver = entityResolver;
        this.fSymbolTable = symbolTable;
        this.fGrammarPool = grammarPool;
        this.EMPTY_STRING = this.fSymbolTable.addSymbol("");
        this.resetSchemaParserErrorHandler();
    }

    void resetSchemaParserErrorHandler() {
        try {
            XMLErrorHandler currErrorHandler;
            if (this.fSchemaParser != null && (currErrorHandler = this.fErrorReporter.getErrorHandler()) != this.fSchemaParser.getProperty(ERROR_HANDLER)) {
                this.fSchemaParser.setProperty(ERROR_HANDLER, currErrorHandler);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void traverseLocalElements() {
        this.fElementTraverser.fDeferTraversingLocalElements = false;
        int i = 0;
        while (i < this.fLocalElemStackPos) {
            Element currElem = this.fLocalElementDecl[i];
            XSDocumentInfo currSchema = (XSDocumentInfo)this.fDoc2XSDocumentMap.get(DOMUtil.getDocument(currElem));
            SchemaGrammar currGrammar = this.fGrammarBucket.getGrammar(currSchema.fTargetNamespace);
            this.fElementTraverser.traverseLocal(this.fParticle[i], currElem, currSchema, currGrammar, this.fAllContext[i], this.fEnclosingCT[i]);
            ++i;
        }
    }

    void fillInLocalElemInfo(Element elmDecl, XSDocumentInfo schemaDoc, int allContextFlags, XSComplexTypeDecl enclosingCT, XSParticleDecl particle) {
        if (this.fParticle.length == this.fLocalElemStackPos) {
            XSParticleDecl[] newStackP = new XSParticleDecl[this.fLocalElemStackPos + 10];
            System.arraycopy(this.fParticle, 0, newStackP, 0, this.fLocalElemStackPos);
            this.fParticle = newStackP;
            Element[] newStackE = new Element[this.fLocalElemStackPos + 10];
            System.arraycopy(this.fLocalElementDecl, 0, newStackE, 0, this.fLocalElemStackPos);
            this.fLocalElementDecl = newStackE;
            int[] newStackI = new int[this.fLocalElemStackPos + 10];
            System.arraycopy(this.fAllContext, 0, newStackI, 0, this.fLocalElemStackPos);
            this.fAllContext = newStackI;
            XSComplexTypeDecl[] newStackC = new XSComplexTypeDecl[this.fLocalElemStackPos + 10];
            System.arraycopy(this.fEnclosingCT, 0, newStackC, 0, this.fLocalElemStackPos);
            this.fEnclosingCT = newStackC;
            String[][] newStackN = new String[this.fLocalElemStackPos + 10][];
            System.arraycopy(this.fLocalElemNamespaceContext, 0, newStackN, 0, this.fLocalElemStackPos);
            this.fLocalElemNamespaceContext = newStackN;
        }
        this.fParticle[this.fLocalElemStackPos] = particle;
        this.fLocalElementDecl[this.fLocalElemStackPos] = elmDecl;
        this.fAllContext[this.fLocalElemStackPos] = allContextFlags;
        this.fEnclosingCT[this.fLocalElemStackPos] = enclosingCT;
        this.fLocalElemNamespaceContext[this.fLocalElemStackPos++] = schemaDoc.fNamespaceSupport.getEffectiveLocalContext();
    }

    void checkForDuplicateNames(String qName, Hashtable registry, Element currComp, XSDocumentInfo currSchema) {
        Object objElem = null;
        Object v = registry.get(qName);
        objElem = v;
        if (v == null) {
            registry.put(qName, currComp);
        } else {
            Element collidingElem = objElem;
            if (collidingElem == currComp) {
                return;
            }
            Element elemParent = null;
            XSDocumentInfo redefinedSchema = null;
            boolean collidedWithRedefine = true;
            elemParent = DOMUtil.getParent(collidingElem);
            if (DOMUtil.getLocalName(elemParent).equals(SchemaSymbols.ELT_REDEFINE)) {
                redefinedSchema = (XSDocumentInfo)this.fRedefine2XSDMap.get(elemParent);
            } else if (DOMUtil.getLocalName(DOMUtil.getParent(currComp)).equals(SchemaSymbols.ELT_REDEFINE)) {
                redefinedSchema = (XSDocumentInfo)this.fDoc2XSDocumentMap.get(DOMUtil.getDocument(collidingElem));
                collidedWithRedefine = false;
            }
            if (redefinedSchema != null) {
                String newName = qName.substring(qName.lastIndexOf(44) + 1) + REDEF_IDENTIFIER;
                if (redefinedSchema == currSchema) {
                    currComp.setAttribute(SchemaSymbols.ATT_NAME, newName);
                    if (currSchema.fTargetNamespace == null) {
                        registry.put("," + newName, currComp);
                    } else {
                        registry.put(currSchema.fTargetNamespace + "," + newName, currComp);
                    }
                    if (currSchema.fTargetNamespace == null) {
                        this.checkForDuplicateNames("," + newName, registry, currComp, currSchema);
                    } else {
                        this.checkForDuplicateNames(currSchema.fTargetNamespace + "," + newName, registry, currComp, currSchema);
                    }
                } else if (collidedWithRedefine) {
                    if (currSchema.fTargetNamespace == null) {
                        this.checkForDuplicateNames("," + newName, registry, currComp, currSchema);
                    } else {
                        this.checkForDuplicateNames(currSchema.fTargetNamespace + "," + newName, registry, currComp, currSchema);
                    }
                } else {
                    this.reportSchemaError("src-redefine.1", new Object[]{qName}, currComp);
                }
            } else {
                this.reportSchemaError("sch-props-correct.2", new Object[]{qName}, currComp);
            }
        }
    }

    private void renameRedefiningComponents(XSDocumentInfo currSchema, Element child, String componentType, String oldName, String newName) {
        SchemaNamespaceSupport currNSMap = currSchema.fNamespaceSupport;
        if (componentType.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
            Element grandKid = DOMUtil.getFirstChildElement(child);
            if (grandKid == null) {
                this.reportSchemaError("src-redefine.5", null, child);
            } else {
                String grandKidName = grandKid.getLocalName();
                if (grandKidName.equals(SchemaSymbols.ELT_ANNOTATION)) {
                    grandKid = DOMUtil.getNextSiblingElement(grandKid);
                    grandKidName = grandKid.getLocalName();
                }
                if (grandKid == null) {
                    this.reportSchemaError("src-redefine.5", null, child);
                } else if (!grandKidName.equals(SchemaSymbols.ELT_RESTRICTION)) {
                    this.reportSchemaError("src-redefine.5", null, child);
                } else {
                    Object[] attrs = this.fAttributeChecker.checkAttributes(grandKid, false, currSchema);
                    QName derivedBase = (QName)attrs[XSAttributeChecker.ATTIDX_BASE];
                    if (derivedBase == null || derivedBase.uri != currSchema.fTargetNamespace || !derivedBase.localpart.equals(oldName)) {
                        this.reportSchemaError("src-redefine.5", null, child);
                    } else if (derivedBase.prefix != null && derivedBase.prefix.length() > 0) {
                        grandKid.setAttribute(SchemaSymbols.ATT_BASE, derivedBase.prefix + ":" + newName);
                    } else {
                        grandKid.setAttribute(SchemaSymbols.ATT_BASE, newName);
                    }
                    this.fAttributeChecker.returnAttrArray(attrs, currSchema);
                }
            }
        } else if (componentType.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
            Element grandKid = DOMUtil.getFirstChildElement(child);
            if (grandKid == null) {
                this.reportSchemaError("src-redefine.5", null, child);
            } else {
                if (grandKid.getLocalName().equals(SchemaSymbols.ELT_ANNOTATION)) {
                    grandKid = DOMUtil.getNextSiblingElement(grandKid);
                }
                if (grandKid == null) {
                    this.reportSchemaError("src-redefine.5", null, child);
                } else {
                    Element greatGrandKid = DOMUtil.getFirstChildElement(grandKid);
                    if (greatGrandKid == null) {
                        this.reportSchemaError("src-redefine.5", null, grandKid);
                    } else {
                        String greatGrandKidName = greatGrandKid.getLocalName();
                        if (greatGrandKidName.equals(SchemaSymbols.ELT_ANNOTATION)) {
                            greatGrandKid = DOMUtil.getNextSiblingElement(greatGrandKid);
                            greatGrandKidName = greatGrandKid.getLocalName();
                        }
                        if (greatGrandKid == null) {
                            this.reportSchemaError("src-redefine.5", null, grandKid);
                        } else if (!greatGrandKidName.equals(SchemaSymbols.ELT_RESTRICTION) && !greatGrandKidName.equals(SchemaSymbols.ELT_EXTENSION)) {
                            this.reportSchemaError("src-redefine.5", null, greatGrandKid);
                        } else {
                            Object[] attrs = this.fAttributeChecker.checkAttributes(greatGrandKid, false, currSchema);
                            QName derivedBase = (QName)attrs[XSAttributeChecker.ATTIDX_BASE];
                            if (derivedBase == null || derivedBase.uri != currSchema.fTargetNamespace || !derivedBase.localpart.equals(oldName)) {
                                this.reportSchemaError("src-redefine.5", null, greatGrandKid);
                            } else if (derivedBase.prefix != null && derivedBase.prefix.length() > 0) {
                                greatGrandKid.setAttribute(SchemaSymbols.ATT_BASE, derivedBase.prefix + ":" + newName);
                            } else {
                                greatGrandKid.setAttribute(SchemaSymbols.ATT_BASE, newName);
                            }
                        }
                    }
                }
            }
        } else if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
            String processedBaseName = currSchema.fTargetNamespace == null ? "," + oldName : currSchema.fTargetNamespace + "," + oldName;
            int attGroupRefsCount = this.changeRedefineGroup(processedBaseName, componentType, newName, child, currSchema);
            if (attGroupRefsCount > 1) {
                this.reportSchemaError("src-redefine.7.1", new Object[]{new Integer(attGroupRefsCount)}, child);
            } else if (attGroupRefsCount != 1) {
                if (currSchema.fTargetNamespace == null) {
                    this.fRedefinedRestrictedAttributeGroupRegistry.put(processedBaseName, "," + newName);
                } else {
                    this.fRedefinedRestrictedAttributeGroupRegistry.put(processedBaseName, currSchema.fTargetNamespace + "," + newName);
                }
            }
        } else if (componentType.equals(SchemaSymbols.ELT_GROUP)) {
            String processedBaseName = currSchema.fTargetNamespace == null ? "," + oldName : currSchema.fTargetNamespace + "," + oldName;
            int groupRefsCount = this.changeRedefineGroup(processedBaseName, componentType, newName, child, currSchema);
            if (groupRefsCount > 1) {
                this.reportSchemaError("src-redefine.6.1.1", new Object[]{new Integer(groupRefsCount)}, child);
            } else if (groupRefsCount != 1) {
                if (currSchema.fTargetNamespace == null) {
                    this.fRedefinedRestrictedGroupRegistry.put(processedBaseName, "," + newName);
                } else {
                    this.fRedefinedRestrictedGroupRegistry.put(processedBaseName, currSchema.fTargetNamespace + "," + newName);
                }
            }
        } else {
            this.reportSchemaError("Internal-Error", new Object[]{"could not handle this particular <redefine>; please submit your schemas and instance document in a bug report!"}, child);
        }
    }

    private String findQName(String name, XSDocumentInfo schemaDoc) {
        String localpart;
        SchemaNamespaceSupport currNSMap = schemaDoc.fNamespaceSupport;
        int colonPtr = name.indexOf(58);
        String prefix = this.EMPTY_STRING;
        if (colonPtr > 0) {
            prefix = name.substring(0, colonPtr);
        }
        String uri = currNSMap.getURI(this.fSymbolTable.addSymbol(prefix));
        String string = localpart = colonPtr == 0 ? name : name.substring(colonPtr + 1);
        if (prefix == this.EMPTY_STRING && uri == null && schemaDoc.fIsChameleonSchema) {
            uri = schemaDoc.fTargetNamespace;
        }
        if (uri == null) {
            return "," + localpart;
        }
        return uri + "," + localpart;
    }

    private int changeRedefineGroup(String originalQName, String elementSought, String newName, Element curr, XSDocumentInfo schemaDoc) {
        SchemaNamespaceSupport currNSMap = schemaDoc.fNamespaceSupport;
        int result = 0;
        Element child = DOMUtil.getFirstChildElement(curr);
        while (child != null) {
            String name = child.getLocalName();
            if (!name.equals(elementSought)) {
                result += this.changeRedefineGroup(originalQName, elementSought, newName, child, schemaDoc);
            } else {
                String processedRef;
                String ref = child.getAttribute(SchemaSymbols.ATT_REF);
                if (ref.length() != 0 && originalQName.equals(processedRef = this.findQName(ref, schemaDoc))) {
                    String prefix = this.EMPTY_STRING;
                    String localpart = ref;
                    int colonptr = ref.indexOf(":");
                    if (colonptr > 0) {
                        prefix = ref.substring(0, colonptr);
                        child.setAttribute(SchemaSymbols.ATT_REF, prefix + ":" + newName);
                    } else {
                        child.setAttribute(SchemaSymbols.ATT_REF, newName);
                    }
                    ++result;
                    if (elementSought.equals(SchemaSymbols.ELT_GROUP)) {
                        String minOccurs = child.getAttribute(SchemaSymbols.ATT_MINOCCURS);
                        String maxOccurs = child.getAttribute(SchemaSymbols.ATT_MAXOCCURS);
                        if (maxOccurs.length() != 0 && !maxOccurs.equals("1") || minOccurs.length() != 0 && !minOccurs.equals("1")) {
                            this.reportSchemaError("src-redefine.6.1.2", new Object[]{ref}, child);
                        }
                    }
                }
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        return result;
    }

    private XSDocumentInfo findXSDocumentForDecl(XSDocumentInfo currSchema, Element decl) {
        Document declDoc = DOMUtil.getDocument(decl);
        Object temp = this.fDoc2XSDocumentMap.get(declDoc);
        if (temp == null) {
            return null;
        }
        XSDocumentInfo declDocInfo = (XSDocumentInfo)temp;
        return declDocInfo;
    }

    private boolean nonAnnotationContent(Element elem) {
        Element child = DOMUtil.getFirstChildElement(elem);
        while (child != null) {
            if (!DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                return true;
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        return false;
    }

    private void setSchemasVisible(XSDocumentInfo startSchema) {
        if (DOMUtil.isHidden(startSchema.fSchemaDoc)) {
            DOMUtil.setVisible(startSchema.fSchemaDoc);
            Vector dependingSchemas = (Vector)this.fDependencyMap.get(startSchema);
            int i = 0;
            while (i < dependingSchemas.size()) {
                this.setSchemasVisible((XSDocumentInfo)dependingSchemas.elementAt(i));
                ++i;
            }
        }
    }

    public SimpleLocator element2Locator(Element e) {
        if (!(e instanceof ElementNSImpl)) {
            return null;
        }
        SimpleLocator l = new SimpleLocator();
        return this.element2Locator(e, l) ? l : null;
    }

    public boolean element2Locator(Element e, SimpleLocator l) {
        if (!(e instanceof ElementNSImpl) || l == null) {
            return false;
        }
        ElementNSImpl ele = (ElementNSImpl)e;
        Document doc = ele.getOwnerDocument();
        String sid = (String)this.fDoc2SystemId.get(doc);
        int line = ele.getLineNumber();
        int column = ele.getColumnNumber();
        l.setValues(sid, sid, line, column);
        return true;
    }

    void reportSchemaError(String key, Object[] args, Element ele) {
        if (this.element2Locator(ele, this.xl)) {
            this.fErrorReporter.reportError(this.xl, "http://www.w3.org/TR/xml-schema-1", key, args, (short)1);
        } else {
            this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", key, args, (short)1);
        }
    }

    void reportSchemaWarning(String key, Object[] args, Element ele) {
        if (this.element2Locator(ele, this.xl)) {
            this.fErrorReporter.reportError(this.xl, "http://www.w3.org/TR/xml-schema-1", key, args, (short)0);
        } else {
            this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", key, args, (short)0);
        }
    }

    private static class XSDKey {
        String systemId;
        short referType;
        String referNS;

        XSDKey(String systemId, short referType, String referNS) {
            this.systemId = systemId;
            this.referType = referType;
            this.referNS = referNS;
        }

        public int hashCode() {
            if (this.referType == 0 || this.referType == 1) {
                return this.systemId.hashCode();
            }
            return this.referNS == null ? 0 : this.referNS.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof XSDKey)) {
                return false;
            }
            XSDKey key = (XSDKey)obj;
            if (this.referType == 0 || this.referType == 1 || key.referType == 0 || key.referType == 1) {
                return this.referType == key.referType && this.referNS == key.referNS && this.systemId != null && this.systemId.equals(key.systemId);
            }
            if (this.referType == 3 || key.referType == 3) {
                return false;
            }
            return this.referNS == key.referNS;
        }
    }
}

