/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.io.PrintWriter;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMLocator;

public class DOMErrorHandlerWrapper
implements XMLErrorHandler,
DOMErrorHandler {
    protected DOMErrorHandler fDomErrorHandler;
    boolean eStatus = true;
    protected PrintWriter fOut;

    public DOMErrorHandlerWrapper() {
        this.fOut = new PrintWriter(System.err);
    }

    public DOMErrorHandlerWrapper(DOMErrorHandler domErrorHandler) {
        this.fDomErrorHandler = domErrorHandler;
    }

    public void setErrorHandler(DOMErrorHandler errorHandler) {
        this.fDomErrorHandler = errorHandler;
    }

    public DOMErrorHandler getErrorHandler() {
        return this.fDomErrorHandler;
    }

    public void warning(String domain, String key, XMLParseException exception) throws XNIException {
        DOMErrorImpl error = new DOMErrorImpl(0, exception);
        this.fDomErrorHandler.handleError(error);
    }

    public void error(String domain, String key, XMLParseException exception) throws XNIException {
        DOMErrorImpl error = new DOMErrorImpl(1, exception);
        this.fDomErrorHandler.handleError(error);
    }

    public void fatalError(String domain, String key, XMLParseException exception) throws XNIException {
        DOMErrorImpl error = new DOMErrorImpl(2, exception);
        this.fDomErrorHandler.handleError(error);
    }

    public boolean handleError(DOMError error) {
        this.printError(error);
        return this.eStatus;
    }

    private void printError(DOMError error) {
        int severity = -1;
        this.fOut.print("[");
        if (severity == 0) {
            this.fOut.print("Warning");
        } else if (severity == 1) {
            this.fOut.print("Error");
        } else {
            this.fOut.print("Fatal Error");
            this.eStatus = false;
        }
        this.fOut.print("] ");
        this.fOut.print(": ");
        this.fOut.print(error.getMessage());
        this.fOut.print(':');
        this.fOut.print(error.getRelatedException());
        DOMLocator locator = error.getLocation();
        if (locator != null) {
            this.fOut.print(":L ");
            this.fOut.print(locator.getLineNumber());
            this.fOut.print(":C ");
            this.fOut.print(locator.getColumnNumber());
            this.fOut.print(": ");
            this.fOut.print(locator.getOffset());
            this.fOut.print(": ");
            this.fOut.print(locator.getErrorNode().getNodeName());
            String systemId = locator.getUri();
            if (systemId != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                this.fOut.print(": ");
                this.fOut.print(systemId);
            }
        }
        this.fOut.println();
        this.fOut.flush();
    }
}

