/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.api.ArchiveFilter;
import org.netbeans.modules.jarpackager.api.ArchiveMember;
import org.netbeans.modules.jarpackager.util.Assert;
import org.netbeans.modules.jarpackager.util.JarUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

public class ContentMember
implements Serializable,
ArchiveMember,
Node.Cookie {
    static final long serialVersionUID = -7995415137147855602L;
    DataObject dataObject;
    ArchiveFilter filter;
    String targetDirectory;
    String targetName;
    boolean isRecursive;

    public ContentMember() {
        this.dataObject = null;
        this.filter = JarContent.ALL;
        this.targetName = null;
        this.targetDirectory = null;
        this.isRecursive = true;
    }

    public ContentMember(DataObject dataObj) {
        this(dataObj, JarContent.ALL, ContentMember.getPath(dataObj.getPrimaryFile()), ContentMember.getName(dataObj.getPrimaryFile()), true);
    }

    private static String getPath(FileObject ob) {
        if (ob.isFolder()) {
            return ob.getPath();
        }
        FileObject par = ob.getParent();
        if (par != null) {
            return par.getPath();
        }
        return "<root>";
    }

    private static String getName(FileObject ob) {
        return null;
    }

    public ContentMember(DataObject dataObject, ArchiveFilter filter, String targetDirectory) {
        this(dataObject, filter, targetDirectory, null, true);
    }

    public ContentMember(DataObject dataObject, ArchiveFilter filter, String targetDirectory, boolean recursive) {
        this(dataObject, filter, targetDirectory, null, recursive);
    }

    public ContentMember(DataObject dataObject, ArchiveFilter filter, String targetDirectory, String targetName) {
        this(dataObject, filter, targetDirectory, targetName, true);
    }

    public ContentMember(DataObject dataObject, ArchiveFilter filter, String targetDirectory, String targetName, boolean recursive) {
        this.dataObject = dataObject;
        this.targetDirectory = targetDirectory;
        this.targetName = targetName;
        this.filter = filter;
        this.isRecursive = recursive;
        this.fillInMissing();
        this.assertValid();
    }

    public ContentMember(DataObject dO, ContentMember existing) {
        this(dO, existing.filter, existing.targetDirectory, existing.targetName, existing.isRecursive);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContentMember)) {
            return false;
        }
        ContentMember other = (ContentMember)obj;
        return this.dataObject.equals(other.dataObject) && (this.targetName == null && other.targetName == null || this.targetName.equals(other.targetName)) && this.targetDirectory.equals(other.targetDirectory) && this.isRecursive == other.isRecursive && this.filter.equals(other.filter);
    }

    public int hashCode() {
        return this.dataObject.hashCode();
    }

    public ContentMember resolve() {
        DataObject resolved = JarUtils.resolve(this.dataObject);
        if (resolved == this.dataObject) {
            return this;
        }
        return new ContentMember(resolved, this.filter, this.targetDirectory, this.targetName, this.isRecursive);
    }

    public DataObject getDataObject() {
        return this.dataObject;
    }

    public ArchiveFilter getFilter() {
        return this.filter;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(String dir) {
        Assert.notEmpty(dir, "targetDirectory");
        this.targetDirectory = dir;
    }

    public void setFilter(ArchiveFilter f) {
        Assert.notNull(f, "filter");
        this.filter = f;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String name) {
        this.targetName = name;
    }

    boolean isRecursive() {
        return this.isRecursive;
    }

    void setRecursive(boolean r) {
        this.isRecursive = r;
    }

    String[] saveDataObject() {
        try {
            String[] result = new String[2];
            FileObject primary = this.dataObject.getPrimaryFile();
            result[0] = primary.getFileSystem().getSystemName();
            result[1] = primary.toString();
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String[] result = new String[]{};
            return result;
        }
    }

    void restoreDataObject(String[] name) {
        if (name.length != 2) {
            this.dataObject = null;
        } else {
            try {
                Repository rep = Repository.getDefault();
                FileSystem fs = rep.findFileSystem(name[0]);
                FileObject fo = null;
                if (fs != null) {
                    fo = fs.findResource(name[1]);
                }
                if (fo == null) {
                    fo = rep.findResource(name[1]);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.dataObject = null;
            }
        }
    }

    public String toString() {
        return this.dataObject == null ? "<NULL>" : this.dataObject.getName();
    }

    public void copyPropertiesFrom(ContentMember member) {
        this.setFilter(member.getFilter());
        this.setTargetDirectory(member.getTargetDirectory());
        this.setTargetName(member.getTargetName());
    }

    private void fillInMissing() {
        if (this.filter == null) {
            this.filter = JarContent.ALL;
        }
        if (this.targetDirectory == null || this.targetDirectory.length() == 0) {
            if (this.dataObject.getPrimaryFile().isFolder()) {
                this.targetDirectory = this.dataObject.getPrimaryFile().getPath();
            } else {
                FileObject foparent = this.dataObject.getPrimaryFile().getParent();
                if (foparent != null) {
                    this.targetDirectory = foparent.getPath();
                }
            }
            if (this.targetDirectory == null || this.targetDirectory.length() == 0) {
                this.targetDirectory = "<root>";
            }
        }
    }

    private void assertValid() {
        Assert.notNull(this.dataObject, "dataObject");
        Assert.notEmpty(this.targetDirectory, "targetDirectory");
        Assert.notNull(this.filter, "filter");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.dataObject == null) {
            throw new IOException("dataObject missing");
        }
        this.fillInMissing();
    }
}

