/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.jarpackager.ContentMember;
import org.netbeans.modules.jarpackager.DataObjectList;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarCreator;
import org.netbeans.modules.jarpackager.api.ArchiveFilter;
import org.netbeans.modules.jarpackager.api.ArchiveMember;
import org.netbeans.modules.jarpackager.api.ArchiveMemberSet;
import org.netbeans.modules.jarpackager.util.Assert;
import org.netbeans.modules.jarpackager.util.JarUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class ContentMemberList
extends ArrayList
implements Serializable {
    static final long serialVersionUID = 7194592824986427208L;
    public static final String PROP_CONTENTS = "CONTENTS_PROP";
    private PropertyChangeSupport pcs = null;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$ContentMemberList;

    public ContentMemberList() {
    }

    public ContentMemberList(Collection collection) {
        super(collection);
    }

    public ContentMemberList(int capacity) {
        super(capacity);
    }

    public ContentMemberList(ArrayList list) {
        int i = 0;
        while (i < list.size()) {
            Object o = list.get(i);
            if (o instanceof ContentMember) {
                this.add(o);
            } else if (o instanceof DataObject) {
                this.addMember((DataObject)o);
            } else if (o instanceof FileObject) {
                DataObject dobj = ContentMemberList.resolveFileObject((FileObject)o);
                if (dobj != null) {
                    this.addMember(dobj);
                } else {
                    String fmt = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ContentMemberList == null ? ContentMemberList.class$("org.netbeans.modules.jarpackager.ContentMemberList") : class$org$netbeans$modules$jarpackager$ContentMemberList)).getString("FMT_ContentFileNotFound");
                    System.out.println(MessageFormat.format(fmt, o));
                }
            } else {
                String fmt = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ContentMemberList == null ? ContentMemberList.class$("org.netbeans.modules.jarpackager.ContentMemberList") : class$org$netbeans$modules$jarpackager$ContentMemberList)).getString("FMT_ContentBadClass`");
                String className = o.getClass().getName();
                System.out.println(MessageFormat.format(fmt, className));
            }
            ++i;
        }
    }

    public boolean addMember(DataObject o) {
        if (this.findDataObject(o) == -1) {
            ContentMember member = new ContentMember(o);
            this.add(member);
            this.getPCS().firePropertyChange(PROP_CONTENTS, null, null);
            return true;
        }
        return false;
    }

    public boolean addMember(DataObject o, String targetDir) {
        return this.addMember(o, targetDir, "");
    }

    public boolean addMember(DataObject o, String targetDir, String targetName) {
        if (this.findDataObject(o) == -1) {
            ContentMember member = new ContentMember(o, JarContent.ALL, targetDir, targetName, true);
            this.add(member);
            this.getPCS().firePropertyChange(PROP_CONTENTS, null, null);
            return true;
        }
        return false;
    }

    public boolean addMember(ContentMember cm) {
        if (this.findDataObject(cm.getDataObject()) == -1) {
            this.add(cm);
            this.getPCS().firePropertyChange(PROP_CONTENTS, null, null);
            return true;
        }
        return false;
    }

    public void addList(ArrayList list) {
        int i = 0;
        while (i < list.size()) {
            Object o = list.get(i);
            if (o instanceof DataObject) {
                this.addMember((DataObject)o);
            } else if (o instanceof ContentMember) {
                this.add(o);
                this.getPCS().firePropertyChange(PROP_CONTENTS, null, null);
            }
            ++i;
        }
    }

    public void addContentMemberList(ArrayList list) {
        int i = 0;
        while (i < list.size()) {
            Object o = list.get(i);
            if (!(o instanceof ContentMember)) {
                throw new IllegalArgumentException("not a content member");
            }
            this.add(o);
            this.getPCS().firePropertyChange(PROP_CONTENTS, null, null);
            ++i;
        }
    }

    public boolean removeMember(DataObject o) {
        int result = this.findDataObject(o);
        if (result != -1) {
            this.remove(result);
            this.getPCS().firePropertyChange(PROP_CONTENTS, null, null);
            return true;
        }
        return false;
    }

    public boolean removeMember(int index) {
        if (index >= 0 && index < this.size()) {
            this.remove(index);
            this.getPCS().firePropertyChange(PROP_CONTENTS, null, null);
            return true;
        }
        return false;
    }

    public int findDataObject(DataObject o) {
        int i = 0;
        while (i < this.size()) {
            ContentMember member = (ContentMember)this.get(i);
            if (member.getDataObject().equals(o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List getAllFiles(ArchiveFilter globalFilter) {
        ArrayList files = new ArrayList();
        int i = 0;
        while (i < this.size()) {
            ContentMember member = (ContentMember)this.get(i);
            this.addFiles(files, member.getDataObject(), member.isRecursive(), globalFilter, member.getFilter());
            ++i;
        }
        return files;
    }

    private void addFiles(List list, DataObject dataObj, boolean recursive, ArchiveFilter global, ArchiveFilter local) {
        if (dataObj instanceof DataFolder) {
            Enumeration enumeration = ((DataFolder)dataObj).children(false);
            while (enumeration.hasMoreElements()) {
                DataObject curChild = (DataObject)enumeration.nextElement();
                if (!recursive && curChild instanceof DataFolder) continue;
                this.addFiles(list, curChild, recursive, global, local);
            }
        }
        Iterator fileIter = dataObj.files().iterator();
        while (fileIter.hasNext()) {
            FileObject fo = (FileObject)fileIter.next();
            if (global != null && !global.accept(fo)) {
                fo = null;
            }
            if (fo != null && local != null && !local.accept(fo)) {
                fo = null;
            }
            if (fo == null) continue;
            list.add(fo);
        }
    }

    public Enumeration enumerateDataObjects() {
        return new DataObjectEnumeration();
    }

    public boolean anyInvalid() {
        int i = 0;
        while (i < this.size()) {
            ContentMember member = (ContentMember)this.get(i);
            if (!member.getDataObject().isValid()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean resolveAll() {
        int numInvalid = 0;
        int i = 0;
        while (i < this.size()) {
            ContentMember member = (ContentMember)this.get(i);
            DataObject dO = member.getDataObject();
            if (!dO.isValid()) {
                DataObject newDo = ContentMemberList.resolveDataObject(dO);
                if (newDo != null) {
                    ContentMember newCM = new ContentMember(newDo, member);
                    this.set(i, newCM);
                } else {
                    ++numInvalid;
                }
            }
            ++i;
        }
        return numInvalid == 0;
    }

    static DataObject resolveDataObject(DataObject dO) {
        FileObject fo = dO.getPrimaryFile();
        DataObject newDo = null;
        String fsName = null;
        try {
            fsName = fo.getFileSystem().getSystemName();
        }
        catch (FileStateInvalidException ex) {
            fsName = ex.getFileSystemName();
        }
        catch (Exception ex) {
            // empty catch block
        }
        String fileName = fo.toString();
        Repository rep = Repository.getDefault();
        FileSystem fs = fsName == null ? null : rep.findFileSystem(fsName);
        FileObject newFo = null;
        if (fs != null) {
            newFo = fs.findResource(fileName);
        }
        if (newFo == null) {
            newFo = rep.findResource(fileName);
        }
        if (newFo != null) {
            newDo = ContentMemberList.resolveFileObject(newFo);
        }
        if (newDo != null) {
            // empty if block
        }
        return newDo;
    }

    static DataObject resolveFileObject(FileObject fo) {
        try {
            return DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    private PropertyChangeSupport getPCS() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPCS().addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPCS().removePropertyChangeListener(l);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ArchiveMemberSetImpl
    implements ArchiveMemberSet {
        private Map entries = new HashMap();
        private ArchiveMember[] members = null;
        private boolean changed = false;

        ArchiveMemberSetImpl(ContentMemberList list) {
            int i = 0;
            while (i < list.size()) {
                ContentMember origMember = (ContentMember)list.get(i);
                ContentMember member = origMember.resolve();
                if (member.getDataObject() instanceof DataFolder) {
                    List children = this.expandFolder(member, member.isRecursive());
                    Iterator iter = children.iterator();
                    while (iter.hasNext()) {
                        ContentMember child = (ContentMember)iter.next();
                        child.setFilter(member.getFilter());
                        this.addEntry(child);
                    }
                } else {
                    this.addEntry(member.getDataObject(), member.getFilter(), member.getTargetDirectory(), member.getTargetName());
                }
                ++i;
            }
            this.dumpContents();
        }

        ArchiveMemberSetImpl(DataObjectList dol) {
            this(new ContentMemberList(dol));
        }

        int size() {
            return this.entries.size();
        }

        void setChanged() {
            this.changed = true;
            this.members = null;
        }

        void setUnchanged() {
            this.changed = false;
        }

        boolean wasChanged() {
            return this.changed;
        }

        public ArchiveMember[] allMembers() {
            if (this.members == null) {
                ArchiveMember[] template = new ArchiveMember[this.entries.size()];
                this.members = this.entries.values().toArray(template);
            }
            return this.members;
        }

        public int addMember(DataObject dataObj, ArchiveFilter filter, String targetDirectory) {
            if (dataObj == null) {
                return 0;
            }
            return this.addMember(dataObj, filter, targetDirectory, null, false);
        }

        public int addMember(DataObject dataObj, ArchiveFilter filter, String targetDirectory, String targetName) {
            if (dataObj == null) {
                return 0;
            }
            return this.addMember(dataObj, filter, targetDirectory, targetName, false);
        }

        private int addMember(DataObject dataObj, ArchiveFilter filter, String targetDirectory, String targetName, boolean recursive) {
            int retval = 0;
            if (dataObj instanceof DataFolder) {
                List children = ArchiveMemberSetImpl.expandFolder((DataFolder)dataObj, recursive, targetDirectory, filter);
                Iterator iter = children.iterator();
                while (iter.hasNext()) {
                    ContentMember child = (ContentMember)iter.next();
                    child.setFilter(filter);
                    if (!this.addEntry(child)) continue;
                    ++retval;
                }
            } else if (this.addEntry(dataObj, filter, targetDirectory, targetName)) {
                ++retval;
            }
            return retval;
        }

        public int removeMember(DataObject dataObj) {
            int retval = 0;
            if (dataObj == null) {
                return 0;
            }
            if (dataObj instanceof DataFolder) {
                List children = ArchiveMemberSetImpl.expandFolder((DataFolder)dataObj, false, null, JarContent.ALL);
                Iterator iter = children.iterator();
                while (iter.hasNext()) {
                    ContentMember child = (ContentMember)iter.next();
                    int nr = this.removeMember(child.getDataObject());
                    if (nr <= 0) continue;
                    this.setChanged();
                    retval += nr;
                }
            } else {
                Object key = this.findDataObjectKey(dataObj);
                if (key != null && this.entries.remove(key) != null) {
                    this.setChanged();
                    ++retval;
                }
            }
            return retval;
        }

        Object findDataObjectKey(DataObject dataObj) {
            Iterator it = this.entries.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                ContentMember member = (ContentMember)this.entries.get(key);
                if (!member.getDataObject().equals(dataObj)) continue;
                return key;
            }
            return null;
        }

        public ArchiveMember getMember(DataObject dataObj) {
            Object key = this.findDataObjectKey(dataObj);
            if (key != null) {
                return (ArchiveMember)this.entries.get(key);
            }
            return null;
        }

        public ArchiveMember[] getMembers(DataFolder dataFolder) {
            if (dataFolder == null) {
                return new ArchiveMember[0];
            }
            ArrayList<ArchiveMember> list = new ArrayList<ArchiveMember>();
            List children = ArchiveMemberSetImpl.expandFolder(dataFolder, false, null, JarContent.ALL);
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                ContentMember child = (ContentMember)iter.next();
                ArchiveMember entry = this.getMember(child.getDataObject());
                if (entry == null) continue;
                list.add(entry);
            }
            ArchiveMember[] retval = new ArchiveMember[list.size()];
            return list.toArray(retval);
        }

        private boolean addEntry(DataObject dataObj, ArchiveFilter filter, String targetDirectory, String targetName) {
            return this.addEntry(new ContentMember(dataObj, filter, targetDirectory, targetName, true));
        }

        private boolean addEntry(ContentMember member) {
            if (this.entries.get(member.getDataObject()) == null) {
                this.entries.put(member.getDataObject(), member);
                this.setChanged();
                return true;
            }
            return false;
        }

        private List expandFolder(ContentMember member, boolean recursive) {
            return ArchiveMemberSetImpl.expandFolder((DataFolder)member.getDataObject(), recursive, member.getTargetDirectory(), member.getFilter());
        }

        static List expandFolder(DataFolder folder, boolean recursive, String targetDir, ArchiveFilter filter) {
            ArrayList<ContentMember> retval = new ArrayList<ContentMember>();
            Assert.notNull(targetDir, "targetDir (before canonization)");
            targetDir = JarCreator.getCanonicalTargetName(targetDir);
            Assert.notNull(targetDir, "targetDir (after canonization)");
            Set set = folder.secondaryEntries();
            if (set.size() > 0) {
                retval.add(new ContentMember((DataObject)folder, JarContent.ALL, targetDir, "", true));
            }
            Enumeration enumeration = folder.children(false);
            while (enumeration.hasMoreElements()) {
                DataObject curChild = JarUtils.resolve((DataObject)enumeration.nextElement());
                if (!(curChild instanceof DataFolder)) {
                    retval.add(new ContentMember(curChild, filter, targetDir, "", false));
                    continue;
                }
                if (!recursive) continue;
                String childTarget = null;
                if ("<root>".equals(targetDir)) {
                    childTarget = curChild.getName();
                    if (childTarget == null) {
                        throw new NullPointerException("childTarget must not be null in expandFolder");
                    }
                } else {
                    childTarget = targetDir + curChild.getName();
                }
                List sublist = ArchiveMemberSetImpl.expandFolder((DataFolder)curChild, recursive, childTarget, filter);
                retval.addAll(sublist);
            }
            return retval;
        }

        private void dumpContents() {
            ArchiveMember[] allMembers = this.allMembers();
            int i = 0;
            while (i < allMembers.length) {
                ArchiveMember archiveMember = allMembers[i];
                ++i;
            }
        }
    }

    class DataObjectEnumeration
    implements Enumeration {
        private int index = 0;
        private int size;

        DataObjectEnumeration() {
            this.size = ContentMemberList.this.size();
        }

        public boolean hasMoreElements() {
            return this.index < this.size;
        }

        public Object nextElement() {
            ContentMember member = (ContentMember)ContentMemberList.this.get(this.index++);
            return member.getDataObject();
        }
    }
}

