/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.jarpackager.FileObjectFilter;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.REFilter;
import org.openide.explorer.propertysheet.PropertySheetSettings;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public class FilterEditor
extends JPanel
implements PropertyEditor {
    protected JCheckBox negativeCheckBox;
    protected JComboBox filtersComboBox;
    protected JTextField regExpTextField;
    protected JRadioButton filterRadio;
    protected JRadioButton regExpRadio;
    private FileObjectFilter value;
    private DefaultComboBoxModel model;
    private PropertyChangeSupport support;
    private boolean isValid = true;
    private PropertySheetSettings pss = (PropertySheetSettings)SharedClassObject.findObject((Class)(class$org$openide$explorer$propertysheet$PropertySheetSettings == null ? (class$org$openide$explorer$propertysheet$PropertySheetSettings = FilterEditor.class$("org.openide.explorer.propertysheet.PropertySheetSettings")) : class$org$openide$explorer$propertysheet$PropertySheetSettings), (boolean)true);
    private ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$FilterEditor == null ? (class$org$netbeans$modules$jarpackager$FilterEditor = FilterEditor.class$("org.netbeans.modules.jarpackager.FilterEditor")) : class$org$netbeans$modules$jarpackager$FilterEditor));
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$FilterEditor;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertySheetSettings;

    private void initComponents() {
        this.filterRadio = new JRadioButton();
        this.filtersComboBox = new JComboBox();
        this.regExpRadio = new JRadioButton();
        this.regExpTextField = new JTextField();
        this.negativeCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.filterRadio.setText(this.bundle.getString("CTL_CommonFilter"));
        this.filterRadio.setToolTipText(this.bundle.getString("CTL_CommonFilterTip"));
        this.filterRadio.setMnemonic(this.bundle.getString("MNM_Common").charAt(0));
        this.filterRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilterEditor.this.filterRadioActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.filterRadio, gridBagConstraints);
        this.filtersComboBox.getAccessibleContext().setAccessibleName(this.bundle.getString("ACCN_FilterList"));
        this.filtersComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilterEditor.this.filtersComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.filtersComboBox, gridBagConstraints);
        this.regExpRadio.setText(this.bundle.getString("CTL_RegExp"));
        this.regExpRadio.setToolTipText(this.bundle.getString("CTL_RegExpTip"));
        this.regExpRadio.setMnemonic(this.bundle.getString("MNM_Regular").charAt(0));
        this.regExpRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilterEditor.this.regExpRadioActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.regExpRadio, gridBagConstraints);
        this.regExpTextField.getAccessibleContext().setAccessibleName(this.bundle.getString("ACCN_Expression"));
        this.regExpTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilterEditor.this.regExpTextFieldActionPerformed(evt);
            }
        });
        this.regExpTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                FilterEditor.this.regExpTextFieldFocusLost(evt);
            }
        });
        this.regExpTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                FilterEditor.this.regExpTextFieldKeyReleased(evt);
            }

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    FilterEditor.this.dispatchEvent(evt);
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.regExpTextField, gridBagConstraints);
        this.negativeCheckBox.setText(this.bundle.getString("CTL_Negative"));
        this.negativeCheckBox.setToolTipText(this.bundle.getString("CTL_NegativeTip"));
        this.negativeCheckBox.setMnemonic(this.bundle.getString("MNM_Negative").charAt(0));
        this.negativeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilterEditor.this.negativeCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.negativeCheckBox, gridBagConstraints);
    }

    private void negativeCheckBoxActionPerformed(ActionEvent evt) {
        this.updateValue();
    }

    private void regExpTextFieldFocusLost(FocusEvent evt) {
        this.updateValue();
    }

    private void regExpTextFieldActionPerformed(ActionEvent evt) {
        this.updateValue();
    }

    private void filtersComboBoxActionPerformed(ActionEvent evt) {
        this.updateValue();
    }

    private void regExpTextFieldKeyReleased(KeyEvent evt) {
        this.regExpTextField.setForeground(this.checkValid() ? this.pss.getValueColor() : Color.red);
    }

    private void filterRadioActionPerformed(ActionEvent evt) {
        this.updateValue();
        this.checkValid();
        this.updateFilteringControlStates();
    }

    private void regExpRadioActionPerformed(ActionEvent evt) {
        this.updateValue();
        this.checkValid();
        this.updateFilteringControlStates();
    }

    public FilterEditor() {
        this.initComponents();
        this.localize();
        this.model = new DefaultComboBoxModel();
        this.model.addElement(JarContent.DEFAULT);
        this.model.addElement(JarContent.CLASSES_ONLY);
        this.model.addElement(JarContent.ALL);
        this.filtersComboBox.setModel(this.model);
        this.setValue(JarContent.DEFAULT);
        HelpCtx.setHelpIDString((JComponent)this, (String)(class$org$netbeans$modules$jarpackager$FilterEditor == null ? (class$org$netbeans$modules$jarpackager$FilterEditor = FilterEditor.class$("org.netbeans.modules.jarpackager.FilterEditor")) : class$org$netbeans$modules$jarpackager$FilterEditor).getName());
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("CTL_FilterTip"));
    }

    public boolean isValid() {
        return this.isValid;
    }

    private boolean checkValid() {
        boolean nowValid = true;
        if (this.regExpRadio.isSelected()) {
            nowValid = REFilter.checkRegExp(this.regExpTextField.getText());
        }
        if (nowValid != this.isValid) {
            this.isValid = nowValid;
            this.support().firePropertyChange("propertyValueValid", !this.isValid, this.isValid);
        }
        return this.isValid;
    }

    private void localize() {
        this.setBorder(new CompoundBorder(new TitledBorder(new CompoundBorder(), NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$FilterEditor == null ? (class$org$netbeans$modules$jarpackager$FilterEditor = FilterEditor.class$("org.netbeans.modules.jarpackager.FilterEditor")) : class$org$netbeans$modules$jarpackager$FilterEditor)).getString("CTL_FilterEditor")), new EmptyBorder(new Insets(0, 8, 7, 8))));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.filterRadio);
        bg.add(this.regExpRadio);
    }

    public String getJavaInitializationString() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics p1, Rectangle p2) {
    }

    public String[] getTags() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener pchl) {
        this.support().addPropertyChangeListener(pchl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pchl) {
        this.support().addPropertyChangeListener(pchl);
    }

    public void setValue(Object value) {
        this.doSetValue(value);
        this.updateGui(value);
    }

    public Object getValue() {
        return this.value;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public String getAsText() {
        if (this.value instanceof REFilter) {
            return ((REFilter)this.value).getSummary();
        }
        return this.value.toString();
    }

    public void addFilter(FileObjectFilter filter) {
        this.model.addElement(filter);
    }

    public void removeFilter(FileObjectFilter filter) {
        this.model.removeElement(filter);
    }

    void doSetValue(Object value) {
        if (this.model.getIndexOf(value) < 0 && !(value instanceof REFilter)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.value = (FileObjectFilter)value;
        this.support().firePropertyChange("", null, null);
    }

    private PropertyChangeSupport support() {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        return this.support;
    }

    void updateFilteringControlStates() {
        boolean regExpEnabled = this.regExpRadio.isSelected();
        this.regExpTextField.setEnabled(regExpEnabled);
        this.negativeCheckBox.setEnabled(regExpEnabled);
        this.filtersComboBox.setEnabled(this.filterRadio.isSelected() && this.model.getSize() > 0);
    }

    void updateValue() {
        boolean regExpEnabled = this.regExpRadio.isSelected();
        FileObjectFilter newValue = null;
        if (regExpEnabled) {
            String pattern = this.regExpTextField.getText();
            try {
                newValue = new REFilter(pattern);
                ((REFilter)newValue).setNegative(this.negativeCheckBox.isSelected());
            }
            catch (RESyntaxException exc) {
                return;
            }
        } else {
            newValue = (FileObjectFilter)this.model.getSelectedItem();
        }
        this.doSetValue(newValue);
    }

    void updateGui(Object value) {
        boolean isRegExp = value instanceof REFilter;
        this.regExpRadio.setSelected(isRegExp);
        this.filterRadio.setSelected(!isRegExp);
        this.filtersComboBox.setEnabled(!isRegExp);
        this.regExpTextField.setEnabled(isRegExp);
        this.negativeCheckBox.setEnabled(isRegExp);
        if (isRegExp) {
            REFilter reFilter = (REFilter)value;
            this.regExpTextField.setText(reFilter.toString());
            this.negativeCheckBox.setSelected(reFilter.isNegative());
        } else {
            this.model.setSelectedItem(value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

