/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.jarpackager.ContentMember;
import org.netbeans.modules.jarpackager.ContentMemberList;
import org.netbeans.modules.jarpackager.DataObjectListEditor;
import org.netbeans.modules.jarpackager.JarChildren;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarContentChildren;
import org.netbeans.modules.jarpackager.JarDataObject;
import org.netbeans.modules.jarpackager.util.BadgeIconCache;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.ExecutionSupport;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;

public class JarChildren
extends Children.Keys {
    private JarDataObject recipe;
    public Object GENERATEJAR_KEY = new Object();
    public Object CONTENTS_KEY = new Object();
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarChildren;

    private static String getMessage(String msg) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$jarpackager$JarChildren == null ? (class$org$netbeans$modules$jarpackager$JarChildren = JarChildren.class$("org.netbeans.modules.jarpackager.JarChildren")) : class$org$netbeans$modules$jarpackager$JarChildren), (String)msg);
    }

    public JarChildren(JarDataObject jdo) {
        this.recipe = jdo;
    }

    private void refreshKeys() {
        this.setKeys(new Object[]{this.GENERATEJAR_KEY, this.CONTENTS_KEY});
    }

    protected void addNotify() {
        this.refreshKeys();
    }

    protected void removeNotify() {
        this.setKeys(new ArrayList());
    }

    protected Node[] createNodes(Object key) {
        if (key == this.GENERATEJAR_KEY) {
            return new Node[]{new GeneratedJarNode(this.recipe)};
        }
        if (key == this.CONTENTS_KEY) {
            return new Node[]{new RecipeContentsNode(this.recipe)};
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class RecipeContentsNode
    extends AbstractNode
    implements PropertyChangeListener {
        private JarDataObject recipe;
        private static final String ICON_BASE = "org/netbeans/modules/jarpackager/resources/";
        private static final String JAR_ICON_BASE = "org/netbeans/modules/jarpackager/resources/content";
        private static final String BADGE_DATAOBJECT_INVALID = "org/netbeans/modules/jarpackager/resources/dataobject-invalid";
        private static final int BADGE_DATAOBJECT_INVALID_KEY = 1;
        private static BadgeIconCache badgeCache;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarChildren;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarChildren$RecipeContentsNode;
        static /* synthetic */ Class class$org$openide$actions$PasteAction;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarContent;

        public RecipeContentsNode(JarDataObject jdo) {
            super((Children)new JarContentChildren(jdo));
            this.recipe = jdo;
            super.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$jarpackager$JarChildren == null ? (class$org$netbeans$modules$jarpackager$JarChildren = RecipeContentsNode.class$("org.netbeans.modules.jarpackager.JarChildren")) : class$org$netbeans$modules$jarpackager$JarChildren), (String)"PROP_Contents"));
            this.setIconBase(JAR_ICON_BASE);
            Class clazz = class$org$netbeans$modules$jarpackager$JarChildren$RecipeContentsNode == null ? (class$org$netbeans$modules$jarpackager$JarChildren$RecipeContentsNode = RecipeContentsNode.class$("org.netbeans.modules.jarpackager.JarChildren$RecipeContentsNode")) : class$org$netbeans$modules$jarpackager$JarChildren$RecipeContentsNode;
            synchronized (clazz) {
                if (badgeCache == null) {
                    this.loadBadges();
                }
            }
            this.recipe.addPropertyChangeListener(this);
        }

        protected int loadBadges() {
            badgeCache = new BadgeIconCache(JAR_ICON_BASE);
            badgeCache.registerBadge(BADGE_DATAOBJECT_INVALID, 1, 16, 8);
            return 4;
        }

        public Image getIcon(int type) {
            Image base = super.getIcon(type);
            int key = 0;
            if (!this.recipe.allValid()) {
                key |= 1;
            }
            Image merged = badgeCache.getIcon(base, key);
            return merged;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }

        public SystemAction[] getActions() {
            return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = RecipeContentsNode.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = RecipeContentsNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }

        public boolean canDestroy() {
            return false;
        }

        public final boolean canCopy() {
            return false;
        }

        public final boolean canCut() {
            return false;
        }

        protected void createPasteTypes(Transferable t, List ls) {
            Node[] nds;
            Node[] ns = NodeTransfer.nodes((Transferable)t, (int)1);
            if (ns != null) {
                ls.add(new PasteType(this, ns){
                    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$ContentMember;
                    private final /* synthetic */ Node[] val$ns;
                    private final /* synthetic */ RecipeContentsNode this$0;
                    {
                        this.this$0 = this$0;
                        this.val$ns = val$ns;
                    }

                    public Transferable paste() throws IOException {
                        Node[] nue = new Node[this.val$ns.length];
                        int i = 0;
                        while (i < nue.length) {
                            if (this.val$ns[i] instanceof DataNode) {
                                RecipeContentsNode.access$300(this.this$0).getJarContent().addDataObject(((DataNode)this.val$ns[i]).getDataObject());
                            } else if (this.val$ns[i] instanceof JarContentChildren.ContentMemberNode) {
                                DataObject dob = ((JarContentChildren.ContentMemberNode)this.val$ns[i]).getDataObject();
                                ContentMember oldMemb = (ContentMember)this.val$ns[i].getCookie(class$org$netbeans$modules$jarpackager$ContentMember == null ? 3.class$("org.netbeans.modules.jarpackager.ContentMember") : class$org$netbeans$modules$jarpackager$ContentMember);
                                RecipeContentsNode.access$300(this.this$0).getJarContent().addDataObject(dob);
                                ContentMemberList list = RecipeContentsNode.access$300(this.this$0).getJarContent().getContentList();
                                int ind = list.findDataObject(dob);
                                if (ind >= 0) {
                                    ContentMember memb = (ContentMember)list.get(ind);
                                    memb.copyPropertiesFrom(oldMemb);
                                }
                            }
                            ++i;
                        }
                        RecipeContentsNode.access$401(this.this$0, "CONTENT_LIST_PROP", null, null);
                        RecipeContentsNode.access$300(this.this$0).setModified(true, "CONTENT_LIST_PROP");
                        return null;
                    }

                    static /* synthetic */ Class class$(String x0) {
                        try {
                            return Class.forName(x0);
                        }
                        catch (ClassNotFoundException x1) {
                            throw new NoClassDefFoundError(x1.getMessage());
                        }
                    }
                });
            }
            if ((nds = NodeTransfer.nodes((Transferable)t, (int)6)) != null) {
                ls.add(new PasteType(this, nds){
                    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$ContentMember;
                    private final /* synthetic */ Node[] val$nds;
                    private final /* synthetic */ RecipeContentsNode this$0;
                    {
                        this.this$0 = this$0;
                        this.val$nds = val$nds;
                    }

                    public Transferable paste() throws IOException {
                        int i = 0;
                        while (i < this.val$nds.length) {
                            if (this.val$nds[i] instanceof JarContentChildren.ContentMemberNode) {
                                DataObject dob = ((JarContentChildren.ContentMemberNode)this.val$nds[i]).getDataObject();
                                ContentMember oldMemb = (ContentMember)this.val$nds[i].getCookie(class$org$netbeans$modules$jarpackager$ContentMember == null ? 4.class$("org.netbeans.modules.jarpackager.ContentMember") : class$org$netbeans$modules$jarpackager$ContentMember);
                                RecipeContentsNode.access$300(this.this$0).getJarContent().addDataObject(dob);
                                ContentMemberList list = RecipeContentsNode.access$300(this.this$0).getJarContent().getContentList();
                                int ind = list.findDataObject(dob);
                                if (ind >= 0) {
                                    ContentMember memb = (ContentMember)list.get(ind);
                                    memb.copyPropertiesFrom(oldMemb);
                                }
                                this.val$nds[i].destroy();
                            }
                            ++i;
                        }
                        RecipeContentsNode.access$300(this.this$0).setModified(true, "CONTENT_LIST_PROP");
                        return null;
                    }

                    static /* synthetic */ Class class$(String x0) {
                        try {
                            return Class.forName(x0);
                        }
                        catch (ClassNotFoundException x1) {
                            throw new NoClassDefFoundError(x1.getMessage());
                        }
                    }
                });
            }
            super.createPasteTypes(t, ls);
        }

        protected Sheet createSheet() {
            Sheet sheet = Sheet.createDefault();
            sheet.get("properties").put(this.createContentsProperty());
            sheet.get("properties").setValue("helpID", "org.netbeans.modules.jarpackager.JarChildren$RecipeContentsNode.Properties");
            return sheet;
        }

        public Node.Property createContentsProperty() {
            PropertySupport.ReadWrite contentsProp = new PropertySupport.ReadWrite(this, "CONTENT_LIST_PROP", class$org$netbeans$modules$jarpackager$JarContent == null ? (class$org$netbeans$modules$jarpackager$JarContent = RecipeContentsNode.class$("org.netbeans.modules.jarpackager.JarContent")) : class$org$netbeans$modules$jarpackager$JarContent, JarChildren.getMessage("PROP_Contents"), JarChildren.getMessage("CTL_ContentsTip")){
                private final /* synthetic */ RecipeContentsNode this$0;
                {
                    this.this$0 = this$0;
                }

                public Object getValue() {
                    return RecipeContentsNode.access$300(this.this$0).getJarContent().makeCopy();
                }

                public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(val instanceof JarContent)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        RecipeContentsNode.access$300(this.this$0).getJarContent().setContentList(((JarContent)val).getContentList());
                        RecipeContentsNode.access$601(this.this$0, "CONTENT_LIST_PROP", null, null);
                        RecipeContentsNode.access$300(this.this$0).setModified(true, "CONTENT_LIST_PROP");
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException();
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    return new DataObjectListEditor();
                }
            };
            contentsProp.setValue("canEditAsText", Boolean.FALSE);
            return contentsProp;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$jarpackager$JarChildren$RecipeContentsNode == null ? (class$org$netbeans$modules$jarpackager$JarChildren$RecipeContentsNode = RecipeContentsNode.class$("org.netbeans.modules.jarpackager.JarChildren$RecipeContentsNode")) : class$org$netbeans$modules$jarpackager$JarChildren$RecipeContentsNode);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ JarDataObject access$300(RecipeContentsNode x0) {
            return x0.recipe;
        }

        static /* synthetic */ void access$401(RecipeContentsNode x0, String x1, Object x2, Object x3) {
            super.firePropertyChange(x1, x2, x3);
        }

        static /* synthetic */ void access$601(RecipeContentsNode x0, String x1, Object x2, Object x3) {
            super.firePropertyChange(x1, x2, x3);
        }
    }

    public static class GeneratedJarNode
    extends AbstractNode
    implements PropertyChangeListener,
    NodeTransfer.Paste {
        private JarDataObject recipe;
        private static final String ICON_BASE = "org/netbeans/modules/jarpackager/resources/";
        private static final String JAR_ICON_BASE = "org/netbeans/modules/jarpackager/resources/jar";
        private static final String GREY_JAR_ICON_BASE = "org/netbeans/modules/jarpackager/resources/greyjar";
        private boolean fileExists;
        private IconRefresher refresher;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarChildren$GeneratedJarNode;
        static /* synthetic */ Class class$org$openide$actions$CopyAction;
        static /* synthetic */ Class class$org$openide$actions$ExecuteAction;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$actions$MountJarAction;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject$JarNode;
        static /* synthetic */ Class class$org$openide$loaders$ExecutionSupport;
        static /* synthetic */ Class class$java$io$File;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarChildren;

        public GeneratedJarNode(JarDataObject jdo) {
            super(Children.LEAF);
            this.recipe = jdo;
            this.refresher = new IconRefresher(this);
            this.setIcon(true);
            if (this.recipe != null) {
                if (this.recipe.getJarContent() != null && this.recipe.getJarContent().getTargetFile() != null) {
                    this.setName(this.recipe.getJarContent().getTargetFile().toString());
                } else {
                    this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarChildren$GeneratedJarNode == null ? (class$org$netbeans$modules$jarpackager$JarChildren$GeneratedJarNode = GeneratedJarNode.class$("org.netbeans.modules.jarpackager.JarChildren$GeneratedJarNode")) : class$org$netbeans$modules$jarpackager$JarChildren$GeneratedJarNode)).getString("GeneratedJarNode.defaultName"));
                }
                this.recipe.addPropertyChangeListener(this);
                this.getCookieSet().add((Node.Cookie)this.recipe);
                this.getCookieSet().add((Node.Cookie)new JarDataObject.JarExecSupport(this.recipe.getPrimaryEntry()));
            }
        }

        public SystemAction[] getActions() {
            return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = GeneratedJarNode.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), null, SystemAction.get((Class)(class$org$openide$actions$ExecuteAction == null ? (class$org$openide$actions$ExecuteAction = GeneratedJarNode.class$("org.openide.actions.ExecuteAction")) : class$org$openide$actions$ExecuteAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$jarpackager$actions$MountJarAction == null ? (class$org$netbeans$modules$jarpackager$actions$MountJarAction = GeneratedJarNode.class$("org.netbeans.modules.jarpackager.actions.MountJarAction")) : class$org$netbeans$modules$jarpackager$actions$MountJarAction)), null, SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = GeneratedJarNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.setDisplayName(this.recipe.getJarContent().getTarget());
            this.setIcon(false);
        }

        protected Sheet createSheet() {
            Sheet sheet = Sheet.createDefault();
            sheet.get("properties").setValue("helpID", "org.netbeans.modules.jarpackager.JarChildren$GeneratedJarNode.Properties");
            PropertySupport.ReadWrite p = (PropertySupport.ReadWrite)this.createLocationProperty();
            p.setValue("files", Boolean.TRUE);
            p.setValue("directories", Boolean.FALSE);
            sheet.get("properties").put((Node.Property)p);
            Sheet.Set ps = new Sheet.Set();
            ps.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject == null ? (class$org$netbeans$modules$jarpackager$JarDataObject = GeneratedJarNode.class$("org.netbeans.modules.jarpackager.JarDataObject")) : class$org$netbeans$modules$jarpackager$JarDataObject)).getString("CTL_ExecutionSet"));
            ps.setDisplayName(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject$JarNode == null ? (class$org$netbeans$modules$jarpackager$JarDataObject$JarNode = GeneratedJarNode.class$("org.netbeans.modules.jarpackager.JarDataObject$JarNode")) : class$org$netbeans$modules$jarpackager$JarDataObject$JarNode)).getString("PROP_executionSetName"));
            ps.setShortDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject$JarNode == null ? (class$org$netbeans$modules$jarpackager$JarDataObject$JarNode = GeneratedJarNode.class$("org.netbeans.modules.jarpackager.JarDataObject$JarNode")) : class$org$netbeans$modules$jarpackager$JarDataObject$JarNode)).getString("HINT_executionSetName"));
            ExecutionSupport exec = (ExecutionSupport)this.getCookie(class$org$openide$loaders$ExecutionSupport == null ? (class$org$openide$loaders$ExecutionSupport = GeneratedJarNode.class$("org.openide.loaders.ExecutionSupport")) : class$org$openide$loaders$ExecutionSupport);
            if (exec != null) {
                exec.addProperties(ps);
            }
            sheet.put(ps);
            ps.setValue("helpID", "org.netbeans.modules.jarpackager.JarDataObject$JarNode.Execution");
            return sheet;
        }

        public Node.Property createLocationProperty() {
            return new PropertySupport.ReadWrite(this, "TARGET_FILE_PROP", class$java$io$File == null ? (class$java$io$File = GeneratedJarNode.class$("java.io.File")) : class$java$io$File, NbBundle.getMessage((Class)(class$org$netbeans$modules$jarpackager$JarChildren == null ? (class$org$netbeans$modules$jarpackager$JarChildren = GeneratedJarNode.class$("org.netbeans.modules.jarpackager.JarChildren")) : class$org$netbeans$modules$jarpackager$JarChildren), (String)"PROP_Location"), NbBundle.getMessage((Class)(class$org$netbeans$modules$jarpackager$JarChildren == null ? (class$org$netbeans$modules$jarpackager$JarChildren = GeneratedJarNode.class$("org.netbeans.modules.jarpackager.JarChildren")) : class$org$netbeans$modules$jarpackager$JarChildren), (String)"CTL_LocationTip")){
                private final /* synthetic */ GeneratedJarNode this$0;
                {
                    this.this$0 = this$0;
                }

                public Object getValue() {
                    return GeneratedJarNode.access$000(this.this$0).getJarContent().getTargetFile();
                }

                public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (val == null) {
                        JarContent jc = GeneratedJarNode.access$000(this.this$0).getJarContent();
                        jc.setTargetFile(null);
                        GeneratedJarNode.access$000(this.this$0).setModified(true, "TARGET_FILE_PROP");
                        return;
                    }
                    if (!(val instanceof File)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        JarContent jc = GeneratedJarNode.access$000(this.this$0).getJarContent();
                        jc.setTargetFile((File)val);
                        GeneratedJarNode.access$000(this.this$0).setModified(true, "TARGET_FILE_PROP");
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException();
                    }
                }
            };
        }

        public final boolean canCopy() {
            this.setIcon(false);
            return this.fileExists;
        }

        boolean checkFile() {
            boolean retval;
            try {
                retval = this.recipe.getJarContent().getTargetFile().exists();
            }
            catch (RuntimeException ex) {
                retval = false;
            }
            return retval;
        }

        public Image getIcon(int type) {
            return super.getIcon(type);
        }

        synchronized void setIcon(boolean force) {
            boolean fileExisted = this.fileExists;
            this.fileExists = this.checkFile();
            if (force || this.fileExists != fileExisted) {
                this.setIconBase(this.fileExists ? JAR_ICON_BASE : GREY_JAR_ICON_BASE);
            }
        }

        public Transferable clipboardCopy() throws IOException {
            return NodeTransfer.createPaste((NodeTransfer.Paste)this);
        }

        public PasteType[] types(Node target) {
            if (target instanceof DataNode) {
                FileObject targetFile = ((DataNode)target).getDataObject().getPrimaryFile();
                File sfile = this.recipe.getJarContent().getTargetFile();
                if (targetFile != null && targetFile.isFolder() && sfile.exists()) {
                    return new PasteType[]{new GeneratedJarPasteType(sfile, targetFile)};
                }
            }
            return new PasteType[0];
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$jarpackager$JarChildren$GeneratedJarNode == null ? (class$org$netbeans$modules$jarpackager$JarChildren$GeneratedJarNode = GeneratedJarNode.class$("org.netbeans.modules.jarpackager.JarChildren$GeneratedJarNode")) : class$org$netbeans$modules$jarpackager$JarChildren$GeneratedJarNode);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ JarDataObject access$000(GeneratedJarNode x0) {
            return x0.recipe;
        }

        static class IconRefresher
        implements Runnable {
            private static final int REFRESH_TIME = Integer.getInteger("org.openide.filesystems.LocalFileSystem.REFRESH_TIME", 15000);
            private WeakReference nodeRef;

            IconRefresher(GeneratedJarNode node) {
                if (REFRESH_TIME > 0) {
                    this.nodeRef = new WeakReference<GeneratedJarNode>(node);
                    this.schedule();
                }
            }

            private void schedule() {
                RequestProcessor.Task task = RequestProcessor.postRequest((Runnable)this, (int)REFRESH_TIME);
            }

            public void run() {
                GeneratedJarNode node = (GeneratedJarNode)this.nodeRef.get();
                if (node != null) {
                    node.setIcon(false);
                    this.schedule();
                }
            }
        }

        public static class GeneratedJarPasteType
        extends PasteType {
            private File generatedJar;
            private FileObject target;

            public GeneratedJarPasteType(File gen, FileObject targ) {
                this.generatedJar = gen;
                this.target = targ;
            }

            public Transferable paste() {
                try {
                    FileSystem fs = this.target.getFileSystem();
                    fs.runAtomicAction(new FileSystem.AtomicAction(this){
                        private final /* synthetic */ GeneratedJarPasteType this$0;
                        {
                            this.this$0 = this$0;
                        }

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() throws IOException {
                            FileLock lock = null;
                            try {
                                try {
                                    FileInputStream is = new FileInputStream(GeneratedJarPasteType.access$100(this.this$0));
                                    FileObject tf = FileUtil.createData((FileObject)GeneratedJarPasteType.access$200(this.this$0), (String)GeneratedJarPasteType.access$100(this.this$0).getName());
                                    lock = tf.lock();
                                    OutputStream os = tf.getOutputStream(lock);
                                    FileUtil.copy((InputStream)is, (OutputStream)os);
                                    lock.releaseLock();
                                }
                                catch (IOException ioe) {
                                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                                    Object var6_7 = null;
                                    if (lock == null) return;
                                    lock.releaseLock();
                                    return;
                                }
                                Object var6_6 = null;
                                if (lock == null) return;
                            }
                            catch (Throwable throwable) {
                                Object var6_8 = null;
                                if (lock == null) throw throwable;
                                lock.releaseLock();
                                throw throwable;
                            }
                            lock.releaseLock();
                        }
                    });
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                }
                return null;
            }

            public String getName() {
                return "Jar File";
            }

            static /* synthetic */ File access$100(GeneratedJarPasteType x0) {
                return x0.generatedJar;
            }

            static /* synthetic */ FileObject access$200(GeneratedJarPasteType x0) {
                return x0.target;
            }
        }
    }
}

