/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import org.netbeans.modules.jarpackager.ArchiveDescriptor;
import org.netbeans.modules.jarpackager.CompressionLevel;
import org.netbeans.modules.jarpackager.ContentMember;
import org.netbeans.modules.jarpackager.ContentMemberList;
import org.netbeans.modules.jarpackager.FileObjectFilter;
import org.netbeans.modules.jarpackager.JarCreator;
import org.netbeans.modules.jarpackager.api.ExtendedPropertyFactory;
import org.netbeans.modules.jarpackager.options.JarPackagerOption;
import org.netbeans.modules.jarpackager.util.JarUtils;
import org.netbeans.modules.jarpackager.util.VersionSerializator;
import org.openide.ErrorManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class JarContent
implements ArchiveDescriptor,
Cloneable {
    public static final FileObjectFilter CLASSES_ONLY = new ClassesOnlyFilter();
    public static final FileObjectFilter DEFAULT = new AllButJavaFilter();
    public static final FileObjectFilter ALL = new AcceptAllFilter();
    public static final String PROP_COMPRESSION_LEVEL = "COMPRESSION_LEVEL_PROP";
    public static final String PROP_FILTER = "FILTER_PROP";
    public static final String PROP_MANIFEST = "MANIFEST_PROP";
    public static final String PROP_CONTENT_LIST = "CONTENT_LIST_PROP";
    public static final String PROP_TARGET_FILE = "TARGET_FILE_PROP";
    private ContentMemberList contentList;
    private FileObjectFilter filter;
    private Manifest manifest;
    boolean manifestFileList;
    boolean mainAttributes;
    private CompressionLevel compressionLevel;
    private File targetFile;
    Map extendedProperties;
    private boolean sameFolder;
    private List sameFSPath;
    VersionSerializator serializationManager;
    private PropertyChangeSupport pcs = null;
    private ContentMemberListListener contentMemberListListener = new ContentMemberListListener();
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarContent;

    private PropertyChangeSupport getPCS() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public JarContent() {
        this(DEFAULT);
    }

    public JarContent(FileObjectFilter filter) {
        this.filter = filter;
        this.manifestFileList = false;
        this.compressionLevel = new CompressionLevel();
        this.mainAttributes = true;
    }

    public void putFile(FileObject file) {
        try {
            this.addDataObject(DataObject.find((FileObject)file));
        }
        catch (DataObjectNotFoundException exc) {
            ErrorManager.getDefault().notify(16, (Throwable)exc);
        }
    }

    public void putFiles(FileObject[] files) {
        int i = 0;
        while (i < files.length) {
            this.putFile(files[i]);
            ++i;
        }
    }

    public void putFiles(Collection files) {
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            this.putFile((FileObject)iter.next());
        }
    }

    public void removeFile(FileObject file) {
        try {
            this.removeDataObject(DataObject.find((FileObject)file));
        }
        catch (DataObjectNotFoundException exc) {
            ErrorManager.getDefault().notify(16, (Throwable)exc);
        }
    }

    public void removeFiles(FileObject[] files) {
        int i = 0;
        while (i < files.length) {
            this.removeFile(files[i]);
            ++i;
        }
    }

    public void clear() {
        this.getContentList().clear();
    }

    public FileObjectFilter getFilter() {
        return this.filter;
    }

    public synchronized void setFilter(FileObjectFilter filter) {
        FileObjectFilter oldf = this.filter;
        this.filter = filter;
        this.getPCS().firePropertyChange(PROP_FILTER, oldf, filter);
    }

    public void setManifest(Manifest manifest) {
        Manifest oldm = this.manifest;
        this.manifest = manifest;
        this.getPCS().firePropertyChange(PROP_MANIFEST, oldm, manifest);
    }

    public Manifest getManifest() {
        return this.manifest();
    }

    public String saveManifest() {
        String result;
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        try {
            this.getManifest().write(bao);
            result = bao.toString();
        }
        catch (IOException ex) {
            result = "";
        }
        return result;
    }

    public void restoreManifest(String str) {
        try {
            ByteArrayInputStream bai = new ByteArrayInputStream(str.getBytes());
            Manifest man = new Manifest();
            man.read(bai);
            this.setManifest(man);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setManifestFileList(boolean manifestFileList) {
        this.manifestFileList = manifestFileList;
    }

    public boolean isManifestFileList() {
        return this.manifestFileList;
    }

    public void setMainAttributes(boolean mainAttributes) {
        this.mainAttributes = mainAttributes;
    }

    public boolean isMainAttributes() {
        return this.mainAttributes;
    }

    public File getTargetFile() {
        if (this.targetFile != null) {
            return this.targetFile.getAbsoluteFile();
        }
        return this.targetFile;
    }

    public void setTargetFile(File targetFile) {
        File oldtf = this.targetFile;
        this.targetFile = targetFile;
        this.getPCS().firePropertyChange(PROP_TARGET_FILE, oldtf, targetFile);
    }

    public int getCompressionLevel() {
        return this.compressionLevel.getValue();
    }

    public void setCompressionLevel(int compressionLevel) {
        this.setCompLevel(new CompressionLevel(compressionLevel));
    }

    private Manifest manifest() {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        return this.manifest;
    }

    public Object getExtendedProperty(String name) {
        if (this.extendedProperties == null) {
            return null;
        }
        return this.extendedProperties.get(name);
    }

    public void setExtendedProperty(String name, Object value) {
        Map props = this.getExtendedProperties();
        props.put(name, value);
    }

    public Map getExtendedProperties() {
        if (this.extendedProperties == null) {
            this.extendedProperties = new HashMap();
        }
        return this.extendedProperties;
    }

    public void setExtendedProperties(Map properties) {
        this.extendedProperties = properties;
    }

    public void readContent(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readContent(in, null);
    }

    public void readContent(ObjectInput in, FileObject fo) throws IOException, ClassNotFoundException {
        VersionSerializator vs = this.serializationManager();
        vs.readVersion(in);
        if (fo != null) {
            if (this.sameFolder) {
                File target = this.getTargetFile();
                File parent = FileUtil.toFile((FileObject)fo.getParent());
                if (target != null && parent != null) {
                    this.setTargetFile(new File(parent, target.getName()));
                }
            } else if (this.sameFSPath != null) {
                try {
                    File f = FileUtil.toFile((FileObject)fo.getFileSystem().getRoot());
                    if (f != null) {
                        int i = this.sameFSPath.size() - 1;
                        while (i >= 0) {
                            f = new File(f, (String)this.sameFSPath.get(i));
                            --i;
                        }
                        this.setTargetFile(f);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    private boolean targetInSameFolder(FileObject output) {
        boolean retval = false;
        try {
            File target = this.getTargetFile();
            if (output != null && target != null) {
                String outputFolder = NbClassPath.toFile((FileObject)output.getParent()).getCanonicalPath();
                String parent = target.getParent();
                String targetFolder = new File(parent).getCanonicalPath();
                retval = targetFolder.equals(outputFolder);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retval;
    }

    private List targetInSameFS(FileObject output) {
        ArrayList<String> path;
        boolean sameFS;
        block4: {
            sameFS = false;
            path = null;
            try {
                File fsRoot = output == null ? null : FileUtil.toFile((FileObject)output.getFileSystem().getRoot());
                File target = this.getTargetFile();
                if (fsRoot == null || target == null) break block4;
                path = new ArrayList<String>();
                path.add(target.getName());
                for (File parent = target.getParentFile(); parent != null; parent = parent.getParentFile()) {
                    if (fsRoot.equals(parent)) {
                        sameFS = true;
                        break;
                    }
                    path.add(parent.getName());
                }
            }
            catch (IOException ex) {
                sameFS = false;
            }
        }
        return sameFS ? path : null;
    }

    public void writeContent(ObjectOutput out) throws IOException {
        this.writeContent(out, null);
    }

    public void writeContent(ObjectOutput out, FileObject fo) throws IOException {
        this.sameFolder = this.targetInSameFolder(fo);
        this.sameFSPath = this.sameFolder ? null : this.targetInSameFS(fo);
        VersionSerializator vs = this.serializationManager();
        vs.writeLastVersion(out);
    }

    private VersionSerializator serializationManager() {
        if (this.serializationManager == null) {
            this.serializationManager = new VersionSerializator();
            this.serializationManager.putVersion(new Version1Serializator(this));
        }
        return this.serializationManager;
    }

    public boolean addDataObject(DataObject dataObj) {
        ContentMember cm = new ContentMember(dataObj);
        return this.getContentList().addMember(cm);
    }

    public boolean removeDataObject(DataObject dataObj) {
        return this.getContentList().removeMember(dataObj);
    }

    public ContentMemberList getContentList() {
        if (this.contentList == null) {
            this.contentList = new ContentMemberList();
        }
        return this.contentList;
    }

    public void setContentList(ContentMemberList list) {
        ContentMemberList oldcml = this.contentList;
        if (oldcml != null) {
            oldcml.removePropertyChangeListener(this.contentMemberListListener);
        }
        this.contentList = list;
        if (this.contentList != null) {
            this.contentList.addPropertyChangeListener(this.contentMemberListListener);
        }
        this.getPCS().firePropertyChange(PROP_CONTENT_LIST, oldcml, list);
    }

    public String getTarget() {
        URL url = this.getTargetResource();
        return url != null ? url.toString() : null;
    }

    public URL getTargetResource() {
        if (this.targetFile == null) {
            return null;
        }
        try {
            return this.targetFile.toURL();
        }
        catch (MalformedURLException exc) {
            ErrorManager.getDefault().notify(16, (Throwable)exc);
            return null;
        }
    }

    public void setTarget(String urlString) {
        URL theURL;
        try {
            theURL = new URL(urlString);
        }
        catch (MalformedURLException exc) {
            ErrorManager.getDefault().notify(16, (Throwable)exc);
            return;
        }
        this.setTargetResource(theURL);
    }

    public void setTargetResource(URL url) {
        this.targetFile = JarUtils.urlToFile(url);
    }

    public CompressionLevel getCompLevel() {
        return this.compressionLevel;
    }

    public void setCompLevel(CompressionLevel compressionLevel) {
        CompressionLevel oldcl = this.compressionLevel;
        this.compressionLevel = compressionLevel;
        this.getPCS().firePropertyChange(PROP_COMPRESSION_LEVEL, oldcl, this.compressionLevel);
    }

    /*
     * Loose catch block
     */
    static JarContent readFromFile(FileObject fo) {
        JarContent jc;
        block19: {
            ObjectInputStream ois;
            InputStream is;
            block18: {
                jc = new JarContent();
                is = null;
                ois = null;
                is = fo.getInputStream();
                if (is.available() <= 2) break block18;
                ois = new ObjectInputStream(is);
                jc.readContent(ois, fo);
            }
            Object var9_4 = null;
            try {
                if (ois != null) {
                    ois.close();
                } else if (is != null) {
                    is.close();
                }
                break block19;
            }
            catch (IOException ex2) {}
            break block19;
            {
                catch (Exception ex) {
                    ErrorManager errMgr = ErrorManager.getDefault();
                    String fmt = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarContent == null ? (class$org$netbeans$modules$jarpackager$JarContent = JarContent.class$("org.netbeans.modules.jarpackager.JarContent")) : class$org$netbeans$modules$jarpackager$JarContent)).getString("EXC_AnnotatedReadErrorAt");
                    String msg = MessageFormat.format(fmt, fo.getPath());
                    errMgr.annotate((Throwable)ex, msg);
                    errMgr.notify(1, (Throwable)ex);
                    if (jc.getTargetFile() == null) {
                        jc.setTargetFile(JarContent.getDefaultTargetFile(fo));
                    }
                    Object var9_5 = null;
                    try {
                        if (ois != null) {
                            ois.close();
                        } else if (is != null) {
                            is.close();
                        }
                        break block19;
                    }
                    catch (IOException ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_6 = null;
                try {
                    if (ois != null) {
                        ois.close();
                    } else if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return jc;
    }

    public static File getDefaultTargetFile(FileObject fo) {
        File file;
        StringBuffer name = new StringBuffer("jarRecipe");
        if (fo != null && (file = FileUtil.toFile((FileObject)fo)) != null) {
            name.setLength(0);
            String parent = file.getParent();
            if (parent != null) {
                name.append(parent);
                name.append(File.separator);
            }
            name.append(fo.getName());
        }
        name.append('.');
        name.append("jar");
        return new File(new String(name));
    }

    public JarContent makeCopy() {
        JarContent copy = null;
        try {
            copy = (JarContent)super.clone();
            copy.pcs = null;
            copy.contentMemberListListener = copy.new ContentMemberListListener();
            this.serializationManager = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copy;
    }

    public void copyContentList(JarContent source) {
        ContentMemberList newContent = source == null ? new ContentMemberList() : new ContentMemberList(source.getContentList());
        this.setContentList(newContent);
    }

    public void copyManifest(JarContent source) {
        Manifest newManifest = source == null ? new Manifest() : new Manifest(source.getManifest());
        this.setManifest(newManifest);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPCS().addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyname, PropertyChangeListener l) {
        this.getPCS().addPropertyChangeListener(propertyname, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPCS().removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.getPCS().removePropertyChangeListener(prop, l);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ContentMemberListListener
    implements PropertyChangeListener {
        private ContentMemberListListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            JarContent.this.getPCS().firePropertyChange(JarContent.PROP_CONTENT_LIST, null, null);
        }
    }

    static final class Version1Serializator
    implements VersionSerializator.Versionable {
        JarContent jc;
        private static final String JCPA_JAR_IN_SAME_FOLDER = "SameFolder";
        private static final String JCPA_JAR_SAME_FS_PATH = "SameFSPath";

        public Version1Serializator(JarContent jc) {
            this.jc = jc;
        }

        public String getName() {
            return "Version_1.0";
        }

        public void readData(ObjectInput in) throws IOException, ClassNotFoundException {
            Object obj = in.readObject();
            if (obj instanceof ContentMemberList) {
                this.jc.setContentList((ContentMemberList)obj);
            } else {
                this.jc.setContentList(new ContentMemberList((ArrayList)obj));
            }
            this.jc.filter = (FileObjectFilter)in.readObject();
            Object o = in.readObject();
            this.jc.sameFolder = false;
            this.jc.sameFSPath = null;
            if (o instanceof Map) {
                Object o3;
                Map map = (Map)o;
                Object o2 = map.get(JCPA_JAR_IN_SAME_FOLDER);
                if (o2 != null && o2 instanceof Boolean) {
                    this.jc.sameFolder = (Boolean)o2;
                }
                if (!this.jc.sameFolder && (o3 = map.get(JCPA_JAR_SAME_FS_PATH)) != null && o3 instanceof List) {
                    this.jc.sameFSPath = (List)o3;
                }
            }
            this.jc.setTargetFile((File)in.readObject());
            this.jc.manifestFileList = (Boolean)in.readObject();
            this.jc.mainAttributes = (Boolean)in.readObject();
            in.readObject();
            this.jc.setCompressionLevel((Integer)in.readObject());
            if (((Boolean)in.readObject()).booleanValue()) {
                this.jc.manifest = new Manifest();
                this.jc.manifest.read((InputStream)((Object)in));
            }
            try {
                this.readExtendedProperties(in, this.jc);
            }
            catch (EOFException ex) {
                // empty catch block
            }
        }

        public void writeData(ObjectOutput out) throws IOException {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(JCPA_JAR_IN_SAME_FOLDER, this.jc.sameFolder ? Boolean.TRUE : Boolean.FALSE);
            if (this.jc.sameFSPath != null) {
                map.put(JCPA_JAR_SAME_FS_PATH, this.jc.sameFSPath);
            }
            out.writeObject(this.jc.getContentList());
            out.writeObject(this.jc.filter);
            out.writeObject(map);
            out.writeObject(this.jc.getTargetFile());
            out.writeObject(this.jc.manifestFileList ? Boolean.TRUE : Boolean.FALSE);
            out.writeObject(this.jc.mainAttributes ? Boolean.TRUE : Boolean.FALSE);
            out.writeObject(null);
            out.writeObject(new Integer(this.jc.getCompressionLevel()));
            out.writeObject(this.jc.manifest != null ? Boolean.TRUE : Boolean.FALSE);
            if (this.jc.manifest != null) {
                this.jc.manifest.write((OutputStream)((Object)out));
            }
            this.writeExtendedProperties(out, this.jc);
        }

        private void readExtendedProperties(ObjectInput in, JarContent jc) throws IOException, ClassNotFoundException {
            jc.extendedProperties = new HashMap();
            Map persist = (Map)in.readObject();
            Map definedProps = JarCreator.getExtendedProperties();
            if (persist == null || definedProps == null) {
                return;
            }
            Iterator persistKeys = persist.keySet().iterator();
            while (persistKeys.hasNext()) {
                String key = (String)persistKeys.next();
                ExtendedPropertyFactory fact = (ExtendedPropertyFactory)definedProps.get(key);
                if (fact == null) continue;
                Node.Property prop = fact.createProperty(null, jc);
                PropertyEditor propEd = prop.getPropertyEditor();
                propEd.setAsText((String)persist.get(key));
                try {
                    prop.setValue(propEd.getValue());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }

        private void writeExtendedProperties(ObjectOutput out, JarContent jc) throws IOException {
            HashMap<String, String> persist = null;
            Map definedProps = JarCreator.getExtendedProperties();
            if (jc.extendedProperties != null && definedProps != null) {
                persist = new HashMap<String, String>();
                Iterator keys = jc.extendedProperties.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    ExtendedPropertyFactory fact = (ExtendedPropertyFactory)definedProps.get(key);
                    if (fact == null) continue;
                    Node.Property prop = fact.createProperty(null, jc);
                    PropertyEditor propEd = prop.getPropertyEditor();
                    try {
                        propEd.setValue(prop.getValue());
                        persist.put(key, propEd.getAsText());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            out.writeObject(persist);
        }
    }

    public static final class AcceptAllFilter
    implements FileObjectFilter {
        static final long serialVersionUID = 8921981094756492767L;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarContent;

        public boolean accept(FileObject fo) {
            return true;
        }

        private Object readResolve() throws ObjectStreamException {
            return ALL;
        }

        public String toString() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarContent == null ? (class$org$netbeans$modules$jarpackager$JarContent = AcceptAllFilter.class$("org.netbeans.modules.jarpackager.JarContent")) : class$org$netbeans$modules$jarpackager$JarContent)).getString("CTL_AcceptAllFilter");
        }

        public boolean equals(Object other) {
            return other instanceof AcceptAllFilter;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class AllButJavaFilter
    implements FileObjectFilter {
        static final long serialVersionUID = -6474655716324211768L;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarContent;

        public boolean accept(FileObject fo) {
            String extension = fo.getExt();
            return !"java".equals(extension) && !"jar".equals(extension) && !"form".equals(extension) && !JarPackagerOption.singleton().getContentExt().equals(extension);
        }

        private Object readResolve() throws ObjectStreamException {
            return DEFAULT;
        }

        public String toString() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarContent == null ? (class$org$netbeans$modules$jarpackager$JarContent = AllButJavaFilter.class$("org.netbeans.modules.jarpackager.JarContent")) : class$org$netbeans$modules$jarpackager$JarContent)).getString("CTL_AllButJavaFilter");
        }

        public boolean equals(Object other) {
            return other instanceof AllButJavaFilter;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class ClassesOnlyFilter
    implements FileObjectFilter {
        static final long serialVersionUID = 7475557013758392767L;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarContent;

        public boolean accept(FileObject fo) {
            return "class".equals(fo.getExt());
        }

        private Object readResolve() throws ObjectStreamException {
            return CLASSES_ONLY;
        }

        public String toString() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarContent == null ? (class$org$netbeans$modules$jarpackager$JarContent = ClassesOnlyFilter.class$("org.netbeans.modules.jarpackager.JarContent")) : class$org$netbeans$modules$jarpackager$JarContent)).getString("CTL_ClassesOnlyFilter");
        }

        public boolean equals(Object other) {
            return other instanceof ClassesOnlyFilter;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

