/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.netbeans.modules.jarpackager.ArchiveDescriptor;
import org.netbeans.modules.jarpackager.ContentMemberList;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.ManifestTab;
import org.netbeans.modules.jarpackager.api.ArchiveBuilder;
import org.netbeans.modules.jarpackager.api.ArchiveController;
import org.netbeans.modules.jarpackager.api.ArchiveEntry;
import org.netbeans.modules.jarpackager.api.ArchiveFilter;
import org.netbeans.modules.jarpackager.api.ArchiveMember;
import org.netbeans.modules.jarpackager.api.ExtendedPropertyFactory;
import org.netbeans.modules.jarpackager.api.FOArchiveEntry;
import org.netbeans.modules.jarpackager.options.JarPackagerOption;
import org.netbeans.modules.jarpackager.util.ProgressListener;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.InstanceDataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class JarCreator {
    public static final String EXTENDED_PROPERTIES_FOLDER_NAME = "JarPackager/ExtendedProperties";
    public static final String STATIC_BUILDERS_FOLDER_NAME = "JarPackager/Builders";
    private static final int BLOCKSIZE = 65536;
    private static MessageFormat progressInfo;
    private static List builders;
    private List myBuilders;
    ArchiveDescriptor ad;
    HashSet listeners;
    ArchiveEntry curEntry;
    private static final Map extendedProperties;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarCreator;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie$Of;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$api$ArchiveBuilder;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$api$ExtendedPropertyFactory;

    public JarCreator(ArchiveDescriptor ad) {
        this.ad = ad;
        if (progressInfo == null) {
            progressInfo = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarCreator == null ? (class$org$netbeans$modules$jarpackager$JarCreator = JarCreator.class$("org.netbeans.modules.jarpackager.JarCreator")) : class$org$netbeans$modules$jarpackager$JarCreator)).getString("FMT_ProgressInfo"));
        }
    }

    public void createJar(FileObject fo) throws IOException {
        File file = NbClassPath.toFile((FileObject)fo);
        FileLock lock = fo.lock();
        try {
            this.createJar(file);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.releaseLock();
            throw throwable;
        }
        lock.releaseLock();
    }

    public void createJar(OutputStream os, File targetFile) throws IOException {
        this.doCreateJar(os, targetFile);
        JarCreator.recognizeFile(targetFile);
    }

    public void createJar(File targetFile) throws IOException {
        File tempFile;
        block8: {
            tempFile = null;
            OutputStream os = null;
            try {
                tempFile = File.createTempFile("jarpackager", null, targetFile.getParentFile());
                os = new FileOutputStream(tempFile);
                this.doCreateJar(os, targetFile);
                os.close();
                os = null;
                JarCreator.copyFile(tempFile, targetFile);
                Object var5_4 = null;
                if (os == null) break block8;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (tempFile != null) {
                    tempFile.delete();
                }
                throw throwable;
            }
            try {
                os.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (tempFile != null) {
            tempFile.delete();
        }
        JarCreator.recognizeFile(targetFile);
    }

    static void copyFile(File source, File target) throws IOException {
        Exception ex22;
        FileOutputStream out;
        block11: {
            FileInputStream in = null;
            out = null;
            try {
                in = new FileInputStream(source);
                out = new FileOutputStream(target);
                FileUtil.copy((InputStream)in, (OutputStream)out);
                Object var5_4 = null;
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                Exception ex22;
                Object var5_5 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ex22) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception ex22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (Exception ex22) {
                // empty catch block
            }
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception ex22) {}
        }
    }

    public FileObject getProcessedFileObject() {
        ArchiveEntry entry = this.getProcessedEntry();
        if (entry == null || !(entry instanceof FOArchiveEntry)) {
            ContentMemberList content = ((JarContent)this.ad).getContentList();
            if (content.size() > 0) {
                return (FileObject)content.get(0);
            }
            return null;
        }
        return ((FOArchiveEntry)entry).getFileObject();
    }

    public ArchiveEntry getProcessedEntry() {
        return this.curEntry;
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(pl);
    }

    public static synchronized boolean addBuilder(ArchiveBuilder builder) {
        return builders.contains(builder) ? false : builders.add(builder);
    }

    public static synchronized boolean removeBuilder(ArchiveBuilder builder) {
        return builders.remove(builder);
    }

    public synchronized boolean addSpecificBuilder(ArchiveBuilder builder) {
        if (this.myBuilders == null) {
            this.myBuilders = new ArrayList();
        }
        return this.myBuilders.contains(builder) ? false : this.myBuilders.add(builder);
    }

    public synchronized boolean removeSpecificBuilder(ArchiveBuilder builder) {
        return this.myBuilders == null ? false : this.myBuilders.remove(builder);
    }

    synchronized ArchiveBuilder[] getBuilders() {
        FileSystem defFs;
        FileObject fo;
        ArrayList<ArchiveBuilder> tempList = new ArrayList<ArchiveBuilder>(builders);
        if (this.myBuilders != null) {
            tempList.addAll(this.myBuilders);
        }
        if ((fo = (defFs = Repository.getDefault().getDefaultFileSystem()).findResource(STATIC_BUILDERS_FOLDER_NAME)) != null) {
            DataObject dobj;
            try {
                dobj = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException exc) {
                dobj = null;
            }
            if (dobj != null && dobj instanceof DataFolder) {
                DataFolder folder = (DataFolder)dobj;
                Enumeration enumeration = folder.children();
                while (enumeration.hasMoreElements()) {
                    InstanceCookie.Of cook;
                    InstanceDataObject ido;
                    Object obj = enumeration.nextElement();
                    if (!(obj instanceof InstanceDataObject) || !(ido = (InstanceDataObject)obj).isValid() || (cook = (InstanceCookie.Of)ido.getCookie(class$org$openide$cookies$InstanceCookie$Of == null ? JarCreator.class$("org.openide.cookies.InstanceCookie$Of") : class$org$openide$cookies$InstanceCookie$Of)) == null || !cook.instanceOf(class$org$netbeans$modules$jarpackager$api$ArchiveBuilder == null ? JarCreator.class$("org.netbeans.modules.jarpackager.api.ArchiveBuilder") : class$org$netbeans$modules$jarpackager$api$ArchiveBuilder)) continue;
                    try {
                        ArchiveBuilder build = (ArchiveBuilder)cook.instanceCreate();
                        tempList.add(build);
                    }
                    catch (IOException exc) {
                        ErrorManager.getDefault().notify(4096, (Throwable)exc);
                    }
                    catch (ClassNotFoundException cnfExc) {
                        ErrorManager.getDefault().notify(4096, (Throwable)cnfExc);
                    }
                }
            }
        }
        ArchiveBuilder[] retval = new ArchiveBuilder[tempList.size()];
        return tempList.toArray(retval);
    }

    protected void fireProgressEvent(int percent, String description) {
        HashSet cloned;
        if (this.listeners == null) {
            return;
        }
        JarCreator jarCreator = this;
        synchronized (jarCreator) {
            cloned = (HashSet)this.listeners.clone();
        }
        Iterator iter = cloned.iterator();
        while (iter.hasNext()) {
            ((ProgressListener)iter.next()).progress(percent, description);
        }
    }

    public static String getCanonicalTargetName(String target) {
        if (target == null || target.length() == 0) {
            return null;
        }
        if (target.equals("<root>")) {
            return target;
        }
        if (!target.endsWith("/")) {
            return target + "/";
        }
        return target;
    }

    private ArchiveController[] initControllers(File targetFile, Map props) {
        ArchiveBuilder[] acArray = this.getBuilders();
        ArrayList<ArchiveController> ctrlList = new ArrayList<ArchiveController>();
        int i = 0;
        while (i < acArray.length) {
            ArchiveController ctl = acArray[i].initController(targetFile, props);
            if (ctl != null) {
                ctrlList.add(ctl);
            }
            ++i;
        }
        ArchiveController[] ctrls = new ArchiveController[ctrlList.size()];
        return ctrlList.toArray(ctrls);
    }

    private ArchiveMember[] processMemberSet(ArchiveDescriptor ad, ArchiveController[] ctrls) throws IOException {
        ContentMemberList.ArchiveMemberSetImpl memberSet = new ContentMemberList.ArchiveMemberSetImpl(ad.getContentList());
        do {
            memberSet.setUnchanged();
            int i = 0;
            while (i < ctrls.length) {
                ctrls[i].processMemberSet(memberSet);
                ++i;
            }
        } while (memberSet.wasChanged());
        return memberSet.allMembers();
    }

    private List makeArchiveEntries(ArchiveFilter globalFilter, ArchiveMember[] members) throws IOException {
        ArrayList<FOArchiveEntry> archiveEntries = new ArrayList<FOArchiveEntry>();
        int i = 0;
        while (i < members.length) {
            DataObject obj = members[i].getDataObject();
            Iterator iter = null;
            if (obj instanceof DataFolder) {
                DataFolder folder = (DataFolder)obj;
                Set set = folder.secondaryEntries();
                int setSize = set.size();
                if (setSize > 0) {
                    HashSet<FileObject> hs = new HashSet<FileObject>(setSize);
                    Iterator iter1 = set.iterator();
                    while (iter1.hasNext()) {
                        MultiDataObject.Entry entry = (MultiDataObject.Entry)iter1.next();
                        hs.add(entry.getFile());
                    }
                    iter = hs.iterator();
                }
            } else {
                iter = members[i].getDataObject().files().iterator();
            }
            while (iter != null && iter.hasNext()) {
                String targetName;
                FileObject file = (FileObject)iter.next();
                if (globalFilter != null && !globalFilter.accept(file)) {
                    file = null;
                } else {
                    ArchiveFilter localFilter = members[i].getFilter();
                    if (localFilter != null && !localFilter.accept(file)) {
                        file = null;
                    }
                }
                if (file == null) continue;
                if (file.getExt().equals("shadow")) {
                    String warning = NbBundle.getMessage((Class)(class$org$netbeans$modules$jarpackager$JarCreator == null ? JarCreator.class$("org.netbeans.modules.jarpackager.JarCreator") : class$org$netbeans$modules$jarpackager$JarCreator), (String)"MSG_BrokenLink", (Object)JarCreator.pathnameWithoutExtension(file));
                    JarCreator.showWarning(warning);
                    continue;
                }
                String targetDir = JarCreator.getCanonicalTargetName(members[i].getTargetDirectory());
                if (targetDir == null) {
                    targetDir = "<root>";
                }
                if (members[i].getTargetName() != null && members[i].getTargetName().length() > 0) {
                    String name = file.getName();
                    String ext = file.getExt();
                    targetName = JarCreator.mergeNames(members[i].getTargetName(), name, ext);
                } else {
                    targetName = file.getNameExt();
                }
                FOArchiveEntry ae = targetDir.equals("<root>") ? new FOArchiveEntry(file, targetName) : new FOArchiveEntry(file, targetDir + targetName);
                archiveEntries.add(ae);
            }
            ++i;
        }
        return archiveEntries;
    }

    private static String mergeNames(String newNameExt, String oldName, String oldExt) {
        if (newNameExt.lastIndexOf(46) != -1) {
            return newNameExt;
        }
        return newNameExt + "." + oldExt;
    }

    private void addEntries(ArchiveController[] ctrls, List archiveEntries) throws IOException {
        HashSet<String> entryNames = null;
        int i = 0;
        while (i < ctrls.length) {
            ArchiveEntry[] more = ctrls[i].addEntry();
            if (more != null) {
                if (entryNames == null) {
                    entryNames = new HashSet<String>(archiveEntries.size());
                    Iterator it = archiveEntries.iterator();
                    while (it.hasNext()) {
                        entryNames.add(((ArchiveEntry)it.next()).getName());
                    }
                }
                int j = 0;
                while (j < more.length) {
                    if (more[j] != null && !entryNames.contains(more[j].getName())) {
                        archiveEntries.add(more[j]);
                        entryNames.add(more[j].getName());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private List willPostprocess(ArchiveController[] ctrls, List archiveEntries) throws IOException {
        ArrayList<ArchiveController> others = null;
        ArrayList<AnnotatedEntry> annotatedEntries = new ArrayList<AnnotatedEntry>();
        int i = 0;
        while (i < archiveEntries.size()) {
            ArchiveEntry entry = (ArchiveEntry)archiveEntries.get(i);
            if (others == null) {
                others = new ArrayList<ArchiveController>();
            }
            ArchiveController first = null;
            ArchiveController last = null;
            int j = 0;
            while (j < ctrls.length) {
                int mode = ctrls[j].willPostprocess(entry);
                switch (mode) {
                    case 1: {
                        others.add(ctrls[j]);
                        break;
                    }
                    case 2: {
                        if (first != null) {
                            // empty if block
                        }
                        first = ctrls[j];
                        break;
                    }
                    case 3: {
                        if (last != null) {
                            // empty if block
                        }
                        last = ctrls[j];
                    }
                }
                ++j;
            }
            if (first != null) {
                others.add(0, first);
            }
            if (last != null) {
                others.add(last);
            }
            ArrayList<ArchiveController> pp = null;
            if (others.size() > 0) {
                pp = others;
                others = null;
            }
            AnnotatedEntry ae = new AnnotatedEntry(entry, pp);
            annotatedEntries.add(ae);
            ++i;
        }
        return annotatedEntries;
    }

    boolean doCreateJar(OutputStream os, File targetFile) throws IOException {
        ArchiveEntry manEntry;
        Manifest manifest;
        List annotatedEntries;
        block17: {
            long now = System.currentTimeMillis();
            ArchiveController[] ctrls = this.initControllers(targetFile, this.ad.getExtendedProperties());
            ArchiveMember[] members = this.processMemberSet(this.ad, ctrls);
            List archiveEntries = this.makeArchiveEntries(this.ad.getFilter(), members);
            this.addEntries(ctrls, archiveEntries);
            annotatedEntries = this.willPostprocess(ctrls, archiveEntries);
            manifest = this.ad.getManifest();
            manEntry = null;
            if (manifest != null && manifest.getMainAttributes().size() == 0 && manifest.getEntries().size() == 0) {
                Iterator iter = annotatedEntries.iterator();
                while (iter.hasNext()) {
                    AnnotatedEntry currAnn = (AnnotatedEntry)iter.next();
                    if (!currAnn.entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                    if (currAnn.controllers != null && currAnn.controllers.size() > 0) {
                        throw new IOException(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarCreator == null ? (class$org$netbeans$modules$jarpackager$JarCreator = JarCreator.class$("org.netbeans.modules.jarpackager.JarCreator")) : class$org$netbeans$modules$jarpackager$JarCreator)).getString("MSG_CannotPostprocessManifest"));
                    }
                    manEntry = currAnn.entry;
                }
                try {
                    if (manEntry == null) break block17;
                    InputStream is = manEntry.createInputStream();
                    try {
                        manifest = ManifestTab.readManifest(is);
                        ManifestTab.ensureVersionAttribute(manifest);
                        Object var14_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_14 = null;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                    {
                    }
                }
                catch (IOException ex) {
                    String error = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarCreator == null ? (class$org$netbeans$modules$jarpackager$JarCreator = JarCreator.class$("org.netbeans.modules.jarpackager.JarCreator")) : class$org$netbeans$modules$jarpackager$JarCreator)).getString("FMT_CanNotReadManifest"), ex.getMessage());
                    throw new IOException(error);
                }
            }
        }
        JarOutputStream jos = manifest == null ? new JarOutputStream(os) : new JarOutputStream(os, manifest);
        try {
            jos.setMethod(8);
            jos.setLevel(this.ad.getCompLevel().getValue());
            this.curEntry = null;
            BufferedInputStream bufIs = null;
            JarEntry curJarEntry = null;
            long curSize = 0L;
            InputStream in = null;
            long curIndex = 1L;
            double fullPercentage = (double)annotatedEntries.size() / 100.0;
            String ContentPath = targetFile.getAbsolutePath();
            int offsetOfDot = ContentPath.lastIndexOf(".");
            if (offsetOfDot != -1) {
                ContentPath = ContentPath.substring(0, offsetOfDot);
            }
            ContentPath = ContentPath + "." + JarPackagerOption.singleton().getContentExt();
            File targetContentFile = new File(ContentPath);
            Iterator iter = annotatedEntries.iterator();
            while (iter.hasNext()) {
                Object var30_31;
                File curFile;
                AnnotatedEntry currAnn = (AnnotatedEntry)iter.next();
                this.curEntry = currAnn.entry;
                if (this.curEntry == manEntry || this.curEntry instanceof FOArchiveEntry && (curFile = NbClassPath.toFile((FileObject)((FOArchiveEntry)this.curEntry).getFileObject())) != null && (targetFile.compareTo(curFile) == 0 || targetContentFile.compareTo(curFile) == 0)) continue;
                try {
                    in = this.curEntry.createInputStream();
                }
                catch (IOException exc) {
                    JarCreator.cannotAdd(this.curEntry);
                    continue;
                }
                bufIs = new BufferedInputStream(in);
                curJarEntry = new JarEntry(this.curEntry.getName());
                jos.putNextEntry(curJarEntry);
                try {
                    InputStream strm = bufIs;
                    if (currAnn.controllers != null) {
                        int i = 0;
                        while (i < currAnn.controllers.size()) {
                            ArchiveController ctrl = (ArchiveController)currAnn.controllers.get(i);
                            strm = ctrl.postProcess(this.curEntry, strm);
                            ++i;
                        }
                    }
                    FileUtil.copy((InputStream)strm, (OutputStream)jos);
                    var30_31 = null;
                }
                catch (Throwable throwable) {
                    var30_31 = null;
                    bufIs.close();
                    throw throwable;
                }
                bufIs.close();
                jos.closeEntry();
                this.fireProgressEvent((int)Math.round((double)curIndex++ / fullPercentage), progressInfo.format(new Object[]{this.curEntry.getName()}));
            }
            Object var32_33 = null;
        }
        catch (Throwable throwable) {
            Object var32_34 = null;
            jos.finish();
            this.curEntry = null;
            throw throwable;
        }
        jos.finish();
        this.curEntry = null;
        return true;
    }

    private static void showWarning(String warning) {
        String compilerTab = NbBundle.getBundle((String)"org.openide.compiler.Bundle").getString("CTL_CompileTab");
        IOProvider.getDefault().getStdOut().println(warning);
        InputOutput compIO = IOProvider.getDefault().getIO(compilerTab, false);
        if (compIO != null) {
            compIO.getOut().println(warning);
        }
    }

    private static void cannotAdd(ArchiveEntry entry) {
        String warning = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarCreator == null ? (class$org$netbeans$modules$jarpackager$JarCreator = JarCreator.class$("org.netbeans.modules.jarpackager.JarCreator")) : class$org$netbeans$modules$jarpackager$JarCreator)).getString("FMT_CannotAddFo"), entry.getName());
        JarCreator.showWarning(warning);
    }

    static void recognizeFile(File file) {
        String arName;
        int dot;
        FileObject[] folders = null;
        File parent = file.getParentFile();
        if (parent != null) {
            folders = FileUtil.fromFile((File)parent);
        }
        if (folders != null && (dot = (arName = file.getName()).lastIndexOf(46)) >= 0) {
            String arBase = arName.substring(0, dot);
            String arExt = arName.substring(dot + 1);
            int i = 0;
            while (i < folders.length) {
                folders[i].refresh();
                FileObject fo = folders[i].getFileObject(arBase, arExt);
                if (fo != null) {
                    try {
                        DataObject dO = DataObject.find((FileObject)fo);
                    }
                    catch (DataObjectNotFoundException ex) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    public static boolean addExtendedProperty(ExtendedPropertyFactory option) {
        String name = option.getName();
        Map map = extendedProperties;
        synchronized (map) {
            ExtendedPropertyFactory oldFactory = extendedProperties.put(name, option);
            boolean bl = oldFactory != option;
            return bl;
        }
    }

    public static boolean removeExtendedProperty(String name) {
        Map map = extendedProperties;
        synchronized (map) {
            boolean bl = extendedProperties.remove(name) != null;
            return bl;
        }
    }

    static Map getExtendedProperties() {
        HashMap<String, ExtendedPropertyFactory> map;
        Map map2 = extendedProperties;
        synchronized (map2) {
            map = new HashMap<String, ExtendedPropertyFactory>(extendedProperties);
        }
        FileSystem defFs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = defFs.findResource(EXTENDED_PROPERTIES_FOLDER_NAME);
        if (fo != null) {
            DataObject dobj;
            try {
                dobj = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException exc) {
                dobj = null;
            }
            if (dobj != null && dobj instanceof DataFolder) {
                DataFolder folder = (DataFolder)dobj;
                Enumeration enumeration = folder.children();
                while (enumeration.hasMoreElements()) {
                    InstanceCookie.Of cook;
                    InstanceDataObject ido;
                    Object obj = enumeration.nextElement();
                    if (!(obj instanceof InstanceDataObject) || !(ido = (InstanceDataObject)obj).isValid() || (cook = (InstanceCookie.Of)ido.getCookie(class$org$openide$cookies$InstanceCookie$Of == null ? JarCreator.class$("org.openide.cookies.InstanceCookie$Of") : class$org$openide$cookies$InstanceCookie$Of)) == null || !cook.instanceOf(class$org$netbeans$modules$jarpackager$api$ExtendedPropertyFactory == null ? JarCreator.class$("org.netbeans.modules.jarpackager.api.ExtendedPropertyFactory") : class$org$netbeans$modules$jarpackager$api$ExtendedPropertyFactory)) continue;
                    try {
                        ExtendedPropertyFactory propFact = (ExtendedPropertyFactory)cook.instanceCreate();
                        map.put(propFact.getName(), propFact);
                    }
                    catch (IOException exc) {
                        ErrorManager.getDefault().notify(4096, (Throwable)exc);
                    }
                    catch (ClassNotFoundException cnfExc) {
                        ErrorManager.getDefault().notify(4096, (Throwable)cnfExc);
                    }
                }
            }
        }
        return map;
    }

    private static String pathnameWithoutExtension(FileObject fo) {
        String name = fo.getName();
        FileObject parent = fo.getParent();
        String path = "";
        if (parent != null) {
            path = parent.getPath();
        }
        return path + "/" + name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        builders = new ArrayList();
        extendedProperties = new HashMap();
    }

    static class AnnotatedEntry {
        ArchiveEntry entry;
        List controllers;

        AnnotatedEntry(ArchiveEntry entry, List controllers) {
            this.entry = entry;
            this.controllers = controllers;
        }
    }
}

