/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarDataObject;
import org.netbeans.modules.jarpackager.JarPackagerModule;
import org.netbeans.modules.jarpackager.util.JarUtils;
import org.openide.ErrorManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoader;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.SafeException;

public class JarDataLoader
extends MultiFileLoader {
    private static final long serialVersionUID = 7727866549739434470L;
    public static final String JAR_EXTENSION = "jar";
    public static final String CONTENT_EXTENSION = "jarContent";
    private String extension;
    private String archiveExt;
    static /* synthetic */ Class class$org$openide$actions$SaveAction;
    static /* synthetic */ Class class$org$openide$actions$CompileAction;
    static /* synthetic */ Class class$org$openide$actions$ExecuteAction;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$actions$MountJarAction;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$actions$RefreshJarContentAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$SaveAsTemplateAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataLoader;

    public JarDataLoader() {
        this("org.netbeans.modules.jarpackager.JarDataObject");
    }

    public JarDataLoader(String repClassName) {
        super(repClassName);
    }

    public JarDataLoader(Class repClass) {
        super(repClass);
    }

    protected SystemAction[] defaultActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$SaveAction == null ? (class$org$openide$actions$SaveAction = JarDataLoader.class$("org.openide.actions.SaveAction")) : class$org$openide$actions$SaveAction)), null, SystemAction.get((Class)(class$org$openide$actions$CompileAction == null ? (class$org$openide$actions$CompileAction = JarDataLoader.class$("org.openide.actions.CompileAction")) : class$org$openide$actions$CompileAction)), SystemAction.get((Class)(class$org$openide$actions$ExecuteAction == null ? (class$org$openide$actions$ExecuteAction = JarDataLoader.class$("org.openide.actions.ExecuteAction")) : class$org$openide$actions$ExecuteAction)), SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = JarDataLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$jarpackager$actions$MountJarAction == null ? (class$org$netbeans$modules$jarpackager$actions$MountJarAction = JarDataLoader.class$("org.netbeans.modules.jarpackager.actions.MountJarAction")) : class$org$netbeans$modules$jarpackager$actions$MountJarAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$jarpackager$actions$RefreshJarContentAction == null ? (class$org$netbeans$modules$jarpackager$actions$RefreshJarContentAction = JarDataLoader.class$("org.netbeans.modules.jarpackager.actions.RefreshJarContentAction")) : class$org$netbeans$modules$jarpackager$actions$RefreshJarContentAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = JarDataLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = JarDataLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = JarDataLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = JarDataLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = JarDataLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)), null, SystemAction.get((Class)(class$org$openide$actions$SaveAsTemplateAction == null ? (class$org$openide$actions$SaveAsTemplateAction = JarDataLoader.class$("org.openide.actions.SaveAsTemplateAction")) : class$org$openide$actions$SaveAsTemplateAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = JarDataLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = JarDataLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    protected String defaultDisplayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataLoader == null ? (class$org$netbeans$modules$jarpackager$JarDataLoader = JarDataLoader.class$("org.netbeans.modules.jarpackager.JarDataLoader")) : class$org$netbeans$modules$jarpackager$JarDataLoader)).getString("PROP_JarLoader_Name");
    }

    protected MultiDataObject createMultiObject(FileObject fo) throws IOException {
        return new JarDataObject(fo, this);
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        try {
            super.readExternal(oi);
            if (oi.available() > 0) {
                this.extension = oi.readUTF();
                this.archiveExt = oi.readUTF();
            }
        }
        catch (SafeException se) {
            String errMsg = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataLoader == null ? (class$org$netbeans$modules$jarpackager$JarDataLoader = JarDataLoader.class$("org.netbeans.modules.jarpackager.JarDataLoader")) : class$org$netbeans$modules$jarpackager$JarDataLoader)).getString("MSG_ResetDataActions");
            JarPackagerModule.err.annotate((Throwable)se, 1, errMsg, null, null, null);
            JarPackagerModule.err.notify(1, (Throwable)se);
        }
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        super.writeExternal(oo);
        oo.writeUTF(this.getExtension());
        oo.writeUTF(this.getArchiveExt());
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        String ext = fo.getExt();
        String mainExt = this.getExtension();
        if (!fo.isFolder()) {
            if (mainExt.equals(ext)) {
                return fo;
            }
            if (this.getArchiveExt().equals(ext)) {
                return FileUtil.findBrother((FileObject)fo, (String)mainExt);
            }
        }
        return null;
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        primaryFile.setImportant(true);
        return new JarContentEntry(obj, primaryFile);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
        return new JarFileEntry(obj, secondaryFile);
    }

    public String getExtension() {
        if (this.extension == null) {
            this.extension = CONTENT_EXTENSION;
        }
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getArchiveExt() {
        if (this.archiveExt == null) {
            this.archiveExt = JAR_EXTENSION;
        }
        return this.archiveExt;
    }

    public void setArchiveExt(String archiveExt) {
        this.archiveExt = archiveExt;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class JarFileEntry
    extends FileEntry {
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataLoader;

        public JarFileEntry(MultiDataObject obj, FileObject fo) {
            super(obj, fo);
        }

        public void delete() throws IOException {
            try {
                super.delete();
            }
            catch (IOException ex) {
                File jarFile = NbClassPath.toFile((FileObject)this.getFile());
                String errFmt = JarUtils.getMountedJarFS(jarFile) != null ? "FMT_JarFileMounted" : (this.isLocked() ? "FMT_JarFileLocked" : "FMT_CantDeleteJarFile");
                String fmt = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataLoader == null ? (class$org$netbeans$modules$jarpackager$JarDataLoader = JarFileEntry.class$("org.netbeans.modules.jarpackager.JarDataLoader")) : class$org$netbeans$modules$jarpackager$JarDataLoader)).getString(errFmt);
                ErrorManager em = ErrorManager.getDefault();
                em.annotate((Throwable)ex, MessageFormat.format(fmt, jarFile.getPath()));
                throw ex;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static final class JarContentEntry
    extends FileEntry {
        public JarContentEntry(MultiDataObject obj, FileObject fo) {
            super(obj, fo);
        }

        public FileObject rename(String name) throws IOException {
            JarDataObject jdo = (JarDataObject)this.getDataObject();
            boolean mustSync = jdo.usesDefaultArchiveFile();
            if (jdo.isModified()) {
                jdo.save();
            }
            FileObject result = super.rename(name);
            if (mustSync) {
                this.syncTargetFileField(jdo.getJarContent(), result);
            }
            return result;
        }

        public FileObject copy(FileObject f, String suffix) throws IOException {
            JarDataObject jdo = (JarDataObject)this.getDataObject();
            boolean mustSync = jdo.usesDefaultArchiveFile();
            if (jdo.isModified()) {
                jdo.save();
            }
            FileObject result = super.copy(f, suffix);
            if (mustSync) {
                this.syncTargetFileField(jdo.getJarContent().makeCopy(), result);
            }
            return result;
        }

        public FileObject move(FileObject f, String suffix) throws IOException {
            JarDataObject jdo = (JarDataObject)this.getDataObject();
            boolean mustSync = jdo.usesDefaultArchiveFile();
            if (jdo.isModified()) {
                jdo.save();
            }
            FileObject result = super.move(f, suffix);
            if (mustSync) {
                this.syncTargetFileField(jdo.getJarContent(), result);
            }
            return result;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public FileObject createFromTemplate(FileObject f, String name) throws IOException {
            FileLock lock;
            FileObject result;
            block5: {
                File archiveFile;
                result = super.createFromTemplate(f, name);
                JarContent jc = JarContent.readFromFile(this.getFile());
                if (jc == null) {
                    jc = new JarContent();
                }
                if ((archiveFile = JarDataObject.defaultArchiveFile(NbClassPath.toFile((FileObject)result), this.getArchiveExtension())) != null) {
                    jc.setTargetFile(archiveFile);
                }
                lock = result.lock();
                ObjectOutputStream oos = null;
                try {
                    oos = new ObjectOutputStream(result.getOutputStream(lock));
                    jc.writeContent(oos, result);
                    Object var9_8 = null;
                    if (oos == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (oos != null) {
                        oos.close();
                    }
                    lock.releaseLock();
                    throw throwable;
                }
                oos.close();
            }
            lock.releaseLock();
            return result;
        }

        void syncTargetFileField(JarContent content, FileObject source) throws IOException {
            String archiveExt = ((JarDataLoader)this.getDataObject().getLoader()).getArchiveExt();
            File origFile = NbClassPath.toFile((FileObject)source);
            if (origFile != null) {
                FileLock lock;
                block4: {
                    File newTarget = new File(origFile.getParentFile(), source.getName() + "." + archiveExt);
                    content.setTargetFile(newTarget);
                    lock = source.lock();
                    ObjectOutputStream oos = null;
                    try {
                        oos = new ObjectOutputStream(source.getOutputStream(lock));
                        content.writeContent(oos, source);
                        Object var9_8 = null;
                        if (oos == null) break block4;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        if (oos != null) {
                            oos.close();
                        }
                        lock.releaseLock();
                        throw throwable;
                    }
                    oos.close();
                }
                lock.releaseLock();
                {
                }
            }
        }

        protected Format createFormat(FileObject target, String n, String e) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("Name", n);
            MapFormat format = new MapFormat(m);
            format.setLeftBrace("__");
            format.setRightBrace("__");
            format.setExactMatch(false);
            return format;
        }

        private String getContentExtension() {
            String ext = JarDataLoader.CONTENT_EXTENSION;
            DataLoader myLoader = this.getDataObject().getLoader();
            if (myLoader instanceof JarDataLoader) {
                ext = ((JarDataLoader)myLoader).extension;
            }
            return ext;
        }

        private String getArchiveExtension() {
            String ext = JarDataLoader.JAR_EXTENSION;
            DataLoader myLoader = this.getDataObject().getLoader();
            if (myLoader instanceof JarDataLoader) {
                ext = ((JarDataLoader)myLoader).archiveExt;
            }
            return ext;
        }
    }
}

