/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.jar.Manifest;
import org.netbeans.modules.jarpackager.CompressionEditor;
import org.netbeans.modules.jarpackager.CompressionLevel;
import org.netbeans.modules.jarpackager.ContentMember;
import org.netbeans.modules.jarpackager.ContentMemberList;
import org.netbeans.modules.jarpackager.DataObjectListEditor;
import org.netbeans.modules.jarpackager.FileObjectFilter;
import org.netbeans.modules.jarpackager.FilterEditor;
import org.netbeans.modules.jarpackager.JarChildren;
import org.netbeans.modules.jarpackager.JarCompiler;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarContentChildren;
import org.netbeans.modules.jarpackager.JarCreator;
import org.netbeans.modules.jarpackager.JarDataLoader;
import org.netbeans.modules.jarpackager.JarDataObject;
import org.netbeans.modules.jarpackager.JarExecutor;
import org.netbeans.modules.jarpackager.ManifestTab;
import org.netbeans.modules.jarpackager.api.ExtendedPropertyFactory;
import org.netbeans.modules.jarpackager.options.JarPackagerOption;
import org.netbeans.modules.jarpackager.util.BadgeIconCache;
import org.netbeans.modules.jarpackager.wizard.JarContentsWizardIterator;
import org.openide.ErrorManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.cookies.CompilerCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.execution.Executor;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryAdapter;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExecutionSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;

public class JarDataObject
extends MultiDataObject
implements OpenCookie,
CompilerCookie.Compile,
CompilerCookie.Build {
    static final long serialVersionUID = 2983457824351249776L;
    static final String EA_JAR_CONTENT = "NetBeans-JarContent";
    static final String LOCATION_PROP = "TARGET_FILE_PROP";
    static final String CONTENTS_PROP = "CONTENT_LIST_PROP";
    static final String FILTER_PROP = "FILTER_PROP";
    static final String MANIFEST_PROP = "MANIFEST_PROP";
    static final String COMPRESSION_PROP = "COMPRESSION_LEVEL_PROP";
    public static final String VALID_PROP = "contents_valid";
    transient JarContent jarContent;
    private boolean needsCompile = false;
    private boolean allValid;
    private static Map dummyNodes = new WeakHashMap();
    static /* synthetic */ Class class$org$openide$loaders$TemplateWizard$Iterator;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject$Save;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataLoader;

    public JarDataObject(FileObject obj, MultiFileLoader loader) throws DataObjectExistsException {
        super(obj, loader);
        this.getCookieSet().add((Node.Cookie)new JarExecSupport(this.getPrimaryEntry()));
        boolean nc = false;
        File archive = this.findArchiveJarFile();
        if (archive != null) {
            long jarMod = archive.lastModified();
            if (jarMod == 0L) {
                nc = true;
            } else {
                FileObject fo = this.findContentFile();
                if (fo != null) {
                    Date jcMod = fo.lastModified();
                    nc = jcMod.getTime() > jarMod;
                }
            }
        }
        this.needsCompile = nc;
    }

    public Node.Cookie getCookie(Class c) {
        if (c.isAssignableFrom(class$org$openide$loaders$TemplateWizard$Iterator == null ? (class$org$openide$loaders$TemplateWizard$Iterator = JarDataObject.class$("org.openide.loaders.TemplateWizard$Iterator")) : class$org$openide$loaders$TemplateWizard$Iterator)) {
            return new JarContentsWizardIterator();
        }
        Node.Cookie retValue = super.getCookie(c);
        return retValue;
    }

    public boolean getNeedsCompile() {
        return this.needsCompile;
    }

    void setNeedsCompile(boolean value) {
        this.needsCompile = value;
        this.checkIcon();
    }

    public void checkIcon() {
        JarNode node = (JarNode)JarDataObject.safeGetNodeDelegate((DataObject)this, false);
        if (node != null) {
            node.iconChange();
        }
    }

    public void open() {
    }

    protected void handleDelete() throws IOException {
        super.handleDelete();
        this.setModified(false);
    }

    public void setModified(boolean mod, String prop) {
        CookieSet cookies = this.getCookieSet();
        Save saveCookie = (Save)cookies.getCookie(class$org$netbeans$modules$jarpackager$JarDataObject$Save == null ? (class$org$netbeans$modules$jarpackager$JarDataObject$Save = JarDataObject.class$("org.netbeans.modules.jarpackager.JarDataObject$Save")) : class$org$netbeans$modules$jarpackager$JarDataObject$Save);
        if (mod && saveCookie == null) {
            cookies.add((Node.Cookie)new Save());
        } else if (!mod && saveCookie != null) {
            cookies.remove((Node.Cookie)saveCookie);
        }
        if (mod) {
            this.firePropertyChange(prop, null, null);
        }
        super.setModified(mod);
        this.setNeedsCompile(true);
    }

    public void setModified(boolean mod) {
        this.setModified(mod, "");
    }

    public void save() throws IOException {
        this.writeJarContent(this.getJarContent());
        this.setModified(false);
    }

    public boolean isDepthSupported(Compiler.Depth depth) {
        return Compiler.DEPTH_ONE.equals(depth);
    }

    public void addToJob(CompilerJob job, Compiler.Depth depth) {
        JarContent jc = this.getJarContent();
        if (jc == null) {
            return;
        }
        File archiveFile = jc.getTargetFile();
        if (archiveFile == null) {
            String archiveExt;
            FileObject contentFo = this.findContentFile();
            FileObject fo = FileUtil.findBrother((FileObject)contentFo, (String)(archiveExt = ((JarDataLoader)this.getLoader()).getArchiveExt()));
            if (fo == null) {
                try {
                    fo = contentFo.getParent().createData(contentFo.getName(), archiveExt);
                }
                catch (IOException exc) {
                    Throwable anex = ErrorManager.getDefault().annotate((Throwable)exc, NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject == null ? (class$org$netbeans$modules$jarpackager$JarDataObject = JarDataObject.class$("org.netbeans.modules.jarpackager.JarDataObject")) : class$org$netbeans$modules$jarpackager$JarDataObject)).getString("MSG_CreateArchiveError"));
                    ErrorManager.getDefault().notify(anex);
                    return;
                }
            }
            archiveFile = NbClassPath.toFile((FileObject)fo);
            jc.setTargetFile(NbClassPath.toFile((FileObject)fo));
            this.setModified(true);
        }
        if (this.isModified()) {
            try {
                this.save();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        job.add((Compiler)new JarCompiler(jc, this));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeJarContent(JarContent jarContent) throws IOException {
        FileObject jcFile = this.findContentFile();
        FileObject pfo = this.getPrimaryFile();
        FileLock lock = null;
        try {
            if (jcFile == null) {
                jcFile = pfo.getParent().createData(pfo.getName(), JarPackagerOption.singleton().getContentExt());
            }
            lock = jcFile.lock();
            ObjectOutputStream oos = new ObjectOutputStream(jcFile.getOutputStream(lock));
            try {
                jarContent.writeContent(oos, jcFile);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                oos.close();
                throw throwable;
            }
            oos.close();
            Object var9_9 = null;
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (lock == null) throw throwable;
            lock.releaseLock();
            throw throwable;
        }
        lock.releaseLock();
    }

    public JarContent getJarContent() {
        if (this.jarContent == null) {
            FileObject jcFile = this.findContentFile();
            if (jcFile == null) {
                return null;
            }
            this.jarContent = JarContent.readFromFile(jcFile);
            this.hookJarContent(this.jarContent);
        }
        return this.jarContent;
    }

    protected FileObject findContentFile() {
        return this.getPrimaryFile();
    }

    public boolean resolveContents() {
        JarContent jc = this.getJarContent();
        if (jc != null) {
            ContentMemberList list = jc.getContentList();
            list.resolveAll();
        }
        return this.allValid();
    }

    public boolean allValid() {
        boolean validityChanged = false;
        JarDataObject jarDataObject = this;
        synchronized (jarDataObject) {
            boolean wereValid = this.allValid;
            JarContent jc = this.getJarContent();
            if (jc != null) {
                ContentMemberList list = jc.getContentList();
                this.allValid = !list.anyInvalid();
            }
            validityChanged = wereValid != this.allValid;
        }
        if (validityChanged) {
            this.checkIcon();
            this.firePropertyChange(VALID_PROP, null, null);
        }
        return this.allValid;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Node safeGetNodeDelegate(DataObject o, boolean create) {
        Node node = null;
        RuntimeException exc = null;
        try {
            try {
                if (o.isValid()) {
                    node = o.getNodeDelegate();
                }
            }
            catch (RuntimeException ex) {
                exc = ex;
                Object var6_5 = null;
                if (!o.isValid()) {
                    if (!create) return node;
                    Map map = dummyNodes;
                    synchronized (map) {
                        node = (Node)dummyNodes.get(o);
                        if (node != null) return node;
                        node = new DataNode(o, Children.LEAF);
                        dummyNodes.put(o, node);
                        return node;
                    }
                }
                if (exc == null) return node;
                throw exc;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!o.isValid()) {
                if (!create) throw throwable;
                Map map = dummyNodes;
                synchronized (map) {
                    node = (Node)dummyNodes.get(o);
                    if (node != null) throw throwable;
                    node = new DataNode(o, Children.LEAF);
                    dummyNodes.put(o, node);
                    throw throwable;
                }
            }
            if (exc == null) throw throwable;
            throw exc;
        }
        if (!o.isValid()) {
            if (!create) return node;
            Map map = dummyNodes;
            synchronized (map) {
                node = (Node)dummyNodes.get(o);
                if (node != null) return node;
                node = new DataNode(o, Children.LEAF);
                dummyNodes.put(o, node);
                return node;
            }
        }
        if (exc == null) return node;
        throw exc;
    }

    public FileObject findArchiveFile() {
        FileObject contentFo = this.findContentFile();
        return FileUtil.findBrother((FileObject)contentFo, (String)((JarDataLoader)this.getLoader()).getArchiveExt());
    }

    public File findArchiveJarFile() {
        return this.getJarContent().getTargetFile();
    }

    public File defaultArchiveFile() {
        return JarDataObject.defaultArchiveFile(NbClassPath.toFile((FileObject)this.getPrimaryFile()), ((JarDataLoader)this.getLoader()).getArchiveExt());
    }

    public static File defaultArchiveFile(File content, String extension) {
        if (content != null) {
            String jarContentName;
            try {
                jarContentName = content.getCanonicalPath();
            }
            catch (IOException ex) {
                return null;
            }
            String jarBase = jarContentName;
            JarDataLoader loader = (JarDataLoader)SharedClassObject.findObject((Class)(class$org$netbeans$modules$jarpackager$JarDataLoader == null ? (class$org$netbeans$modules$jarpackager$JarDataLoader = JarDataObject.class$("org.netbeans.modules.jarpackager.JarDataLoader")) : class$org$netbeans$modules$jarpackager$JarDataLoader));
            int ext = jarContentName.lastIndexOf("." + loader.getExtension());
            if (ext > 0) {
                jarBase = jarContentName.substring(0, ext);
            }
            return new File(jarBase + "." + extension);
        }
        return null;
    }

    public boolean usesDefaultArchiveFile() {
        File target = this.getJarContent().getTargetFile();
        File def = this.defaultArchiveFile();
        try {
            return target != null && def != null && target.getCanonicalPath().equals(def.getPath());
        }
        catch (IOException ex) {
            return false;
        }
    }

    protected Node createNodeDelegate() {
        return new JarNode((DataObject)this);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$jarpackager$JarDataObject == null ? (class$org$netbeans$modules$jarpackager$JarDataObject = JarDataObject.class$("org.netbeans.modules.jarpackager.JarDataObject")) : class$org$netbeans$modules$jarpackager$JarDataObject);
    }

    private void hookJarContent(JarContent jc) {
        jc.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JarDataObject.super.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class JarExecSupport
    extends ExecutionSupport {
        public JarExecSupport(MultiDataObject.Entry entry) {
            super(entry);
        }

        protected Executor defaultExecutor() {
            return new JarExecutor();
        }
    }

    public static class JarNode
    extends DataNode {
        private transient RepositoryListener rl;
        private static final String ICON_BASE = "org/netbeans/modules/jarpackager/resources/";
        private static final String JAR_ICON_BASE = "org/netbeans/modules/jarpackager/resources/jar_recipe";
        private static final String BADGE_NEEDS_COMPILE = "org/netbeans/modules/jarpackager/resources/needs-compile";
        private static final int BADGE_NEEDS_COMPILE_KEY = 1;
        private static final String BADGE_DATAOBJECT_INVALID = "org/netbeans/modules/jarpackager/resources/dataobject-invalid";
        private static final int BADGE_DATAOBJECT_INVALID_KEY = 2;
        private ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject == null ? (class$org$netbeans$modules$jarpackager$JarDataObject = JarNode.class$("org.netbeans.modules.jarpackager.JarDataObject")) : class$org$netbeans$modules$jarpackager$JarDataObject));
        public static final String PROP_COMPRESSION_LEVEL = "COMPRESSION_LEVEL_PROP";
        private static BadgeIconCache badgeCache;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject$JarNode;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
        static /* synthetic */ Class class$org$openide$loaders$ExecutionSupport;
        static /* synthetic */ Class class$java$io$File;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$CompressionLevel;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$FileObjectFilter;
        static /* synthetic */ Class class$java$util$jar$Manifest;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarContent;

        public JarNode(DataObject dataObject) {
            this(dataObject, (Children)new JarChildren((JarDataObject)dataObject));
        }

        public JarNode(DataObject dataObject, Children children) {
            super(dataObject, children);
            this.setIconBase(JAR_ICON_BASE);
            Class clazz = class$org$netbeans$modules$jarpackager$JarDataObject$JarNode == null ? (class$org$netbeans$modules$jarpackager$JarDataObject$JarNode = JarNode.class$("org.netbeans.modules.jarpackager.JarDataObject$JarNode")) : class$org$netbeans$modules$jarpackager$JarDataObject$JarNode;
            synchronized (clazz) {
                if (badgeCache == null) {
                    this.loadBadges();
                }
            }
            this.setDefaultAction(SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = JarNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)));
            this.rl = new ReposListener();
            RepositoryListener wl = WeakListener.repository((RepositoryListener)this.rl, (Object)((Object)this));
            Repository.getDefault().addRepositoryListener(wl);
            this.hookJarDataObject((JarDataObject)dataObject);
        }

        protected void createPasteTypes(Transferable t, List ls) {
            Node[] nds;
            final Node[] ns = NodeTransfer.nodes((Transferable)t, (int)1);
            if (ns != null) {
                ls.add(new PasteType(){
                    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$ContentMember;

                    public Transferable paste() throws IOException {
                        Node[] nue = new Node[ns.length];
                        int i = 0;
                        while (i < nue.length) {
                            if (ns[i] instanceof DataNode) {
                                this.getJarContent().addDataObject(((DataNode)ns[i]).getDataObject());
                            } else if (ns[i] instanceof JarContentChildren.ContentMemberNode) {
                                DataObject dob = ((JarContentChildren.ContentMemberNode)ns[i]).getDataObject();
                                ContentMember oldMemb = (ContentMember)ns[i].getCookie(class$org$netbeans$modules$jarpackager$ContentMember == null ? 1.class$("org.netbeans.modules.jarpackager.ContentMember") : class$org$netbeans$modules$jarpackager$ContentMember);
                                this.getJarContent().addDataObject(dob);
                                ContentMemberList list = this.getJarContent().getContentList();
                                int ind = list.findDataObject(dob);
                                if (ind >= 0) {
                                    ContentMember memb = (ContentMember)list.get(ind);
                                    memb.copyPropertiesFrom(oldMemb);
                                }
                            }
                            ++i;
                        }
                        this.setModified(true, JarDataObject.CONTENTS_PROP);
                        return null;
                    }

                    static /* synthetic */ Class class$(String x0) {
                        try {
                            return Class.forName(x0);
                        }
                        catch (ClassNotFoundException x1) {
                            throw new NoClassDefFoundError(x1.getMessage());
                        }
                    }
                });
            }
            if ((nds = NodeTransfer.nodes((Transferable)t, (int)6)) != null) {
                ls.add(new PasteType(this, nds){
                    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$ContentMember;
                    private final /* synthetic */ Node[] val$nds;
                    private final /* synthetic */ JarNode this$0;
                    {
                        this.this$0 = this$0;
                        this.val$nds = val$nds;
                    }

                    public Transferable paste() throws IOException {
                        int i = 0;
                        while (i < this.val$nds.length) {
                            if (this.val$nds[i] instanceof JarContentChildren.ContentMemberNode) {
                                DataObject dob = ((JarContentChildren.ContentMemberNode)this.val$nds[i]).getDataObject();
                                ContentMember oldMemb = (ContentMember)this.val$nds[i].getCookie(class$org$netbeans$modules$jarpackager$ContentMember == null ? 2.class$("org.netbeans.modules.jarpackager.ContentMember") : class$org$netbeans$modules$jarpackager$ContentMember);
                                this.this$0.getJarContent().addDataObject(dob);
                                ContentMemberList list = this.this$0.getJarContent().getContentList();
                                int ind = list.findDataObject(dob);
                                if (ind >= 0) {
                                    ContentMember memb = (ContentMember)list.get(ind);
                                    memb.copyPropertiesFrom(oldMemb);
                                }
                                this.val$nds[i].destroy();
                            }
                            ++i;
                        }
                        this.this$0.setModified(true, "CONTENT_LIST_PROP");
                        return null;
                    }

                    static /* synthetic */ Class class$(String x0) {
                        try {
                            return Class.forName(x0);
                        }
                        catch (ClassNotFoundException x1) {
                            throw new NoClassDefFoundError(x1.getMessage());
                        }
                    }
                });
            }
            super.createPasteTypes(t, ls);
        }

        protected int loadBadges() {
            badgeCache = new BadgeIconCache(JAR_ICON_BASE);
            badgeCache.registerBadge(BADGE_NEEDS_COMPILE, 1, 16, 0);
            badgeCache.registerBadge(BADGE_DATAOBJECT_INVALID, 2, 16, 8);
            return 8;
        }

        public void iconChange() {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public Image getIcon(int type) {
            Image base = super.getIcon(type);
            JarDataObject jdo = (JarDataObject)this.getDataObject();
            int key = 0;
            if (jdo != null) {
                if (jdo.getNeedsCompile()) {
                    key |= 1;
                }
                if (!jdo.allValid()) {
                    key |= 2;
                }
            }
            Image merged = badgeCache.getIcon(base, key);
            try {
                merged = jdo.getPrimaryFile().getFileSystem().getStatus().annotateIcon(merged, type, jdo.files());
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
            return merged;
        }

        protected Sheet createSheet() {
            Sheet sheet = super.createSheet();
            sheet.get("properties").setValue("helpID", "org.netbeans.modules.jarpackager.JarDataObject$JarNode.Properties");
            PropertySupport.ReadWrite p = (PropertySupport.ReadWrite)this.createLocationProperty();
            p.setValue("files", Boolean.TRUE);
            p.setValue("directories", Boolean.FALSE);
            sheet.get("properties").put((Node.Property)p);
            sheet.get("properties").put(this.createCompressionProperty());
            sheet.get("properties").put(this.createFilterProperty());
            sheet.get("properties").put(this.createManifestProperty());
            sheet.get("properties").put(this.createContentsProperty());
            this.addExtendedProperties(sheet);
            Sheet.Set ps = new Sheet.Set();
            ps.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject == null ? (class$org$netbeans$modules$jarpackager$JarDataObject = JarNode.class$("org.netbeans.modules.jarpackager.JarDataObject")) : class$org$netbeans$modules$jarpackager$JarDataObject)).getString("CTL_ExecutionSet"));
            ps.setDisplayName(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject$JarNode == null ? (class$org$netbeans$modules$jarpackager$JarDataObject$JarNode = JarNode.class$("org.netbeans.modules.jarpackager.JarDataObject$JarNode")) : class$org$netbeans$modules$jarpackager$JarDataObject$JarNode)).getString("PROP_executionSetName"));
            ps.setShortDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject$JarNode == null ? (class$org$netbeans$modules$jarpackager$JarDataObject$JarNode = JarNode.class$("org.netbeans.modules.jarpackager.JarDataObject$JarNode")) : class$org$netbeans$modules$jarpackager$JarDataObject$JarNode)).getString("HINT_executionSetName"));
            ps.setValue("helpID", "org.netbeans.modules.jarpackager.JarDataObject$JarNode.Execution");
            ExecutionSupport exec = (ExecutionSupport)this.getCookie(class$org$openide$loaders$ExecutionSupport == null ? (class$org$openide$loaders$ExecutionSupport = JarNode.class$("org.openide.loaders.ExecutionSupport")) : class$org$openide$loaders$ExecutionSupport);
            if (exec != null) {
                exec.addProperties(ps);
            }
            sheet.put(ps);
            return sheet;
        }

        public JarContent getJarContent() {
            return ((JarDataObject)this.getDataObject()).getJarContent();
        }

        public JarDataObject getJarDataObject() {
            return (JarDataObject)this.getDataObject();
        }

        public void setModified(boolean mod) {
            ((JarDataObject)this.getDataObject()).setModified(mod);
        }

        public void setModified(boolean mod, String prop) {
            ((JarDataObject)this.getDataObject()).setModified(mod, prop);
        }

        public FileObject getJarContentFile() {
            return this.getDataObject().getPrimaryFile();
        }

        public void addExtendedProperties(Sheet sheet) {
            Map definedProps = JarCreator.getExtendedProperties();
            if (definedProps == null) {
                return;
            }
            Iterator props = definedProps.values().iterator();
            while (props.hasNext()) {
                ExtendedPropertyFactory fact = (ExtendedPropertyFactory)props.next();
                Node.Property prop = fact.createProperty(this.getDataObject(), this.getJarContent());
                if (prop.isHidden()) continue;
                sheet.get("properties").put(prop);
            }
        }

        public Node.Property createLocationProperty() {
            return new PropertySupport.ReadWrite(this, JarDataObject.LOCATION_PROP, class$java$io$File == null ? (class$java$io$File = JarNode.class$("java.io.File")) : class$java$io$File, this.bundle.getString("PROP_Location"), this.bundle.getString("CTL_LocationTip")){
                private final /* synthetic */ JarNode this$0;
                {
                    this.this$0 = this$0;
                }

                public Object getValue() {
                    return this.this$0.getJarContent().getTargetFile();
                }

                public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(val instanceof File)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        JarContent jc = this.this$0.getJarContent();
                        File old = jc.getTargetFile();
                        jc.setTargetFile((File)val);
                        if (!val.equals(old)) {
                            this.this$0.setModified(true, "TARGET_FILE_PROP");
                        }
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException();
                    }
                }
            };
        }

        public Node.Property createCompressionProperty() {
            return new PropertySupport.ReadWrite(this, "COMPRESSION_LEVEL_PROP", class$org$netbeans$modules$jarpackager$CompressionLevel == null ? (class$org$netbeans$modules$jarpackager$CompressionLevel = JarNode.class$("org.netbeans.modules.jarpackager.CompressionLevel")) : class$org$netbeans$modules$jarpackager$CompressionLevel, this.bundle.getString("PROP_Compression"), this.bundle.getString("CTL_CompressionLevelTip")){
                private final /* synthetic */ JarNode this$0;
                {
                    this.this$0 = this$0;
                }

                public Object getValue() {
                    CompressionLevel lvl = this.this$0.getJarContent().getCompLevel();
                    return lvl;
                }

                public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(val instanceof CompressionLevel)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        JarContent jc = this.this$0.getJarContent();
                        CompressionLevel old = jc.getCompLevel();
                        jc.setCompLevel((CompressionLevel)val);
                        if (!val.equals(old)) {
                            this.this$0.setModified(true);
                        }
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException();
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    return new CompressionEditor();
                }
            };
        }

        public Node.Property createFilterProperty() {
            PropertySupport.ReadWrite filterProp = new PropertySupport.ReadWrite(this, JarDataObject.FILTER_PROP, class$org$netbeans$modules$jarpackager$FileObjectFilter == null ? (class$org$netbeans$modules$jarpackager$FileObjectFilter = JarNode.class$("org.netbeans.modules.jarpackager.FileObjectFilter")) : class$org$netbeans$modules$jarpackager$FileObjectFilter, this.bundle.getString("PROP_Filter"), this.bundle.getString("CTL_FilterTip")){
                private final /* synthetic */ JarNode this$0;
                {
                    this.this$0 = this$0;
                }

                public Object getValue() {
                    return this.this$0.getJarContent().getFilter();
                }

                public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(val instanceof FileObjectFilter)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        JarContent jc = this.this$0.getJarContent();
                        FileObjectFilter old = jc.getFilter();
                        jc.setFilter((FileObjectFilter)val);
                        if (!val.equals(old)) {
                            this.this$0.setModified(true);
                        }
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException();
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    return new FilterEditor();
                }
            };
            filterProp.setValue("canEditAsText", Boolean.FALSE);
            return filterProp;
        }

        public Node.Property createManifestProperty() {
            PropertySupport.ReadWrite manifestProp = new PropertySupport.ReadWrite(this, JarDataObject.MANIFEST_PROP, class$java$util$jar$Manifest == null ? (class$java$util$jar$Manifest = JarNode.class$("java.util.jar.Manifest")) : class$java$util$jar$Manifest, this.bundle.getString("PROP_Manifest"), this.bundle.getString("CTL_ManifestTip")){
                private final /* synthetic */ JarNode this$0;
                {
                    this.this$0 = this$0;
                }

                public Object getValue() {
                    return this.this$0.getJarContent().getManifest();
                }

                public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(val instanceof Manifest)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        JarContent jc = this.this$0.getJarContent();
                        Manifest old = jc.getManifest();
                        jc.setManifest((Manifest)val);
                        if (!val.equals(old)) {
                            this.this$0.setModified(true);
                        }
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException();
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    ManifestTab editor = new ManifestTab();
                    editor.setJarContentFile(this.this$0.getJarContentFile().getPath());
                    return editor;
                }
            };
            manifestProp.setValue("canEditAsText", Boolean.FALSE);
            return manifestProp;
        }

        public Node.Property createContentsProperty() {
            PropertySupport.ReadWrite contentsProp = new PropertySupport.ReadWrite(this, JarDataObject.CONTENTS_PROP, class$org$netbeans$modules$jarpackager$JarContent == null ? (class$org$netbeans$modules$jarpackager$JarContent = JarNode.class$("org.netbeans.modules.jarpackager.JarContent")) : class$org$netbeans$modules$jarpackager$JarContent, this.bundle.getString("PROP_Contents"), this.bundle.getString("CTL_ContentsTip")){
                private final /* synthetic */ JarNode this$0;
                {
                    this.this$0 = this$0;
                }

                public Object getValue() {
                    return this.this$0.getJarContent().makeCopy();
                }

                public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(val instanceof JarContent)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        ContentMemberList theOld = this.this$0.getJarContent().getContentList();
                        ContentMemberList theNew = ((JarContent)val).getContentList();
                        this.this$0.getJarContent().setContentList(theNew);
                        this.this$0.setModified(true, "CONTENT_LIST_PROP");
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException();
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    return new DataObjectListEditor();
                }
            };
            contentsProp.setValue("canEditAsText", Boolean.FALSE);
            return contentsProp;
        }

        private void hookJarDataObject(JarDataObject jdo) {
            JarContent jc = jdo.getJarContent();
            if (jc != null) {
                jc.addPropertyChangeListener(new ForwardEventListener());
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private class ForwardEventListener
        implements PropertyChangeListener {
            private ForwardEventListener() {
            }

            public void propertyChange(PropertyChangeEvent pce) {
                JarNode.super.firePropertyChange(pce.getPropertyName(), pce.getOldValue(), pce.getNewValue());
            }
        }

        class ReposListener
        extends RepositoryAdapter
        implements Runnable {
            public static final int DELAY = 5000;

            ReposListener() {
            }

            public void fileSystemRemoved(RepositoryEvent ev) {
                RequestProcessor.Task task = RequestProcessor.postRequest((Runnable)this, (int)5000);
            }

            public void run() {
                JarNode.this.iconChange();
            }
        }
    }

    private class Save
    implements SaveCookie {
        private Save() {
        }

        public void save() throws IOException {
            JarDataObject.this.save();
        }
    }
}

